/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.expressions;

import cml.kickass.exceptions.AsmError;
import cml.kickass.exceptions.AsmException;
import cml.kickass.expressions.ExprNode;
import cml.kickass.expressions.ExprTreeBuilder;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.sideeffect.SESymbolDeclaration;
import cml.kickass.state.EvaluationState;
import cml.kickass.state.scope.SymbolScope;
import cml.kickass.values.FunctionVariableReferenceValue;
import cml.kickass.values.NullValue;
import cml.kickass.values.ReferenceValue;
import cml.kickass.values.SymbolScopeValue;
import cml.kickass.values.Value;
import cml.kickass.values.VariableReferenceValue;

public class VariableDeclaration
extends ExprNode {
    private String name;
    private static final Value initValue = NullValue.instance;

    public VariableDeclaration(String string, DebugInfo debugInfo) {
        super(debugInfo);
        this.name = string;
    }

    @Override
    public Value evaluate(EvaluationState evaluationState) throws AsmException {
        ReferenceValue referenceValue;
        SymbolScope symbolScope = evaluationState.getCurrentScope().getSymbols();
        SymbolScopeValue symbolScopeValue = (SymbolScopeValue)symbolScope.getLocalDefinedEntities().get(this.name);
        if (symbolScopeValue != null) {
            throw new AsmError("The symbol '" + this.name + "' is already defined", this.debug);
        }
        if (evaluationState.getFunctionsMode()) {
            referenceValue = new FunctionVariableReferenceValue(initValue);
        } else {
            referenceValue = new VariableReferenceValue(initValue);
            SESymbolDeclaration sESymbolDeclaration = new SESymbolDeclaration(this.name, referenceValue, initValue);
            evaluationState.addSideEffect(sESymbolDeclaration);
        }
        symbolScope.put(this.name, referenceValue);
        return referenceValue;
    }

    public String toString() {
        return "VarDeclaration";
    }

    @Override
    public ExprTreeBuilder toNodeTreeString(ExprTreeBuilder exprTreeBuilder) {
        exprTreeBuilder.addNode("VarDec", this.name, new ExprNode[0]);
        return exprTreeBuilder;
    }
}

