/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.values;

import cml.kickass.exceptions.AsmException;
import cml.kickass.function.Function;
import cml.kickass.function.table.FunctionTable;
import cml.kickass.function.table.StdFunctionTable;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.misc.ArgTypes;
import cml.kickass.misc.Argument;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.ImmutableValue;
import cml.kickass.values.NumberValue;
import cml.kickass.values.Value;

public class AsmCommandArgumentValue
extends ImmutableValue {
    public static AsmCommandArgumentValue noArgument = new AsmCommandArgumentValue(0, new NumberValue(0.0));
    private int type;
    private Value value;
    static FunctionTable functions = new StdFunctionTable(AsmCommandArgumentValue.getStandardFunctions());

    public AsmCommandArgumentValue(int n, Value value) {
        this.type = n;
        this.value = value;
    }

    @Override
    public Object getRepresentation(int n) throws AsmException {
        if (n == Value.RP_ASMARGVALUE) {
            return new Argument(this.type, this.value);
        }
        if (n == Value.RP_STRINGVALUE) {
            if (this.isInvalid()) {
                return "<<Invalid AsmCmdArg>>";
            }
            return "Argument<" + ArgTypes.typeToString(this.type) + ">";
        }
        return null;
    }

    @Override
    public String getType() {
        return "Asm command argument";
    }

    @Override
    public FunctionTable getFunctions() {
        return functions;
    }

    @Override
    public boolean hasInvalidContent() {
        return this.value.isInvalidOrInvalidContent();
    }

    static {
        functions.add(new Function("getType", 1, NumberValue.invalid){

            @Override
            public Value execute(Value[] valueArray, EvaluationState evaluationState, DebugInfo debugInfo) {
                return new NumberValue(((AsmCommandArgumentValue)valueArray[0]).type);
            }
        });
        functions.add(new Function("getValue", 1, NumberValue.invalid){

            @Override
            public Value execute(Value[] valueArray, EvaluationState evaluationState, DebugInfo debugInfo) {
                return ((AsmCommandArgumentValue)valueArray[0]).value;
            }
        });
    }
}

