/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.NodeTreeBuilder;
import cml.kickass.asmnode.output.EmptyOutput;
import cml.kickass.directives.Label;
import cml.kickass.directives.asmmode.AsmDirective;
import cml.kickass.exceptions.AsmError;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.state.scope.SymbolScope;
import cml.kickass.values.LabelReferenceValue;
import cml.kickass.values.NumberValue;
import cml.kickass.values.SymbolScopeValue;

public class LabelDirective
extends AsmDirective
implements Label {
    private String name;

    public LabelDirective(String string, DebugInfo debugInfo) {
        super(debugInfo);
        this.name = string;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public AsmNode parse(EvaluationState evaluationState) {
        Integer n = evaluationState.getMemoryPosition();
        if (n == null) {
            return this;
        }
        SymbolScope symbolScope = evaluationState.getCurrentScope().getSymbols();
        LabelReferenceValue labelReferenceValue = (LabelReferenceValue)symbolScope.getLocalDefinedEntities().get(this.name);
        NumberValue numberValue = new NumberValue(n.intValue());
        labelReferenceValue.setResolvedLabelValue(numberValue, evaluationState, this.debug);
        evaluationState.setMadeMetaProgress();
        return EmptyOutput.instance;
    }

    @Override
    public AsmNode preParse(EvaluationState evaluationState) {
        SymbolScope symbolScope = evaluationState.getCurrentScope().getSymbols();
        SymbolScopeValue symbolScopeValue = (SymbolScopeValue)symbolScope.getLocalDefinedEntities().get(this.name);
        if (symbolScopeValue != null) {
            throw new AsmError("The symbol '" + this.name + "' is already defined", this.debug);
        }
        symbolScope.put(this.name, new LabelReferenceValue());
        return this;
    }

    @Override
    public String toString() {
        return "Label(" + this.name + ")";
    }

    @Override
    public NodeTreeBuilder toNodeTreeString(NodeTreeBuilder nodeTreeBuilder) {
        nodeTreeBuilder.addNode("Label", this.debug, this.name, new ExprNode[0]);
        return nodeTreeBuilder;
    }
}

