/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.NodeTreeBuilder;
import cml.kickass.asmnode.output.EmptyOutput;
import cml.kickass.directives.asmmode.AsmDirective;
import cml.kickass.exceptions.AsmError;
import cml.kickass.exceptions.AsmException;
import cml.kickass.exceptions.ShouldNotBeHereException;
import cml.kickass.expressions.ExprNode;
import cml.kickass.function.Function;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.StructValue;
import cml.kickass.values.Value;
import java.util.List;

public class StructDirective
extends AsmDirective {
    private String name;
    private List<String> variableNames;

    public StructDirective(String string, List<String> list, DebugInfo debugInfo) {
        super(debugInfo);
        this.name = string;
        this.variableNames = list;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode parse(EvaluationState evaluationState) {
        throw ShouldNotBeHereException.instance;
    }

    @Override
    public AsmNode preParse(EvaluationState evaluationState) {
        boolean bl = evaluationState.getFunctionTable().exist(this.name, null);
        if (bl) {
            throw new AsmError("Can't define constructor for the struct '" + this.name + "'. The function name is already used", this.debug);
        }
        StructConstructor structConstructor = new StructConstructor(this.name, this.variableNames);
        evaluationState.getFunctionTable().add(structConstructor);
        return EmptyOutput.instance;
    }

    @Override
    public NodeTreeBuilder toNodeTreeString(NodeTreeBuilder nodeTreeBuilder) {
        boolean bl = true;
        String string = "";
        for (String string2 : this.variableNames) {
            if (bl) {
                bl = false;
            } else {
                string = string + ",";
            }
            string = string + string2;
        }
        nodeTreeBuilder.addNode("Struct", this.debug, string, new ExprNode[0]);
        return nodeTreeBuilder;
    }

    private static class StructConstructor
    extends Function {
        private List<String> variableNames;

        public StructConstructor(String string, List<String> list) {
            super(string, null, null, true);
            this.variableNames = list;
        }

        @Override
        public Value execute(Value[] valueArray, EvaluationState evaluationState, DebugInfo debugInfo) throws AsmException {
            StructValue structValue = null;
            if (valueArray.length == 0) {
                structValue = new StructValue(this.getName(), this.variableNames, null);
            }
            if (valueArray.length == this.variableNames.size()) {
                structValue = new StructValue(this.getName(), this.variableNames, valueArray);
            }
            if (structValue == null) {
                throw new AsmError("Invalid number of arguments for struct constructor", debugInfo);
            }
            return structValue;
        }
    }
}

