/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.lexvalues;

import cml.kickass.state.CallStack;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;

public class DebugInfo {
    private int line;
    private int column;
    private String filename;
    private DebugInfo parrent;

    public DebugInfo(int n, int n2, String string, DebugInfo debugInfo) {
        this.line = n;
        this.column = n2;
        this.filename = string;
        this.parrent = debugInfo;
    }

    public void setColumn(int n) {
        this.column = n;
    }

    public String getInclusionTrace() {
        String string = System.getProperties().getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getPositionString());
        stringBuffer.append(string);
        if (this.parrent != null) {
            stringBuffer.append("- included " + this.parrent.getInclusionTrace());
        }
        return stringBuffer.toString();
    }

    public String getPositionString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.line >= 0) {
            stringBuffer.append("at line " + (this.line + 1));
            if (this.column >= 0) {
                stringBuffer.append(", column " + (this.column + 1) + " ");
            }
        }
        if (this.filename != null) {
            stringBuffer.append("in " + this.filename);
        }
        return stringBuffer.toString();
    }

    public String getMarkedErrorLine() {
        String string = System.getProperties().getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.removeTabs(this.getLinesInFile(this.line - 3, this.line - 1, this.filename)));
        if (this.column < 0) {
            stringBuffer.append(">>>");
        }
        stringBuffer.append(this.removeTabs(this.getLinesInFile(this.line, this.line, this.filename)));
        if (this.column >= 0) {
            for (int i = 0; i < this.column; ++i) {
                stringBuffer.append(' ');
            }
            stringBuffer.append('^' + string);
        }
        return stringBuffer.toString();
    }

    private String getLinesInFile(int n, int n2, String string) {
        String string2 = System.getProperties().getProperty("line.separator");
        try {
            int n3;
            StringBuffer stringBuffer = new StringBuffer();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
            for (n3 = 0; n3 < n; ++n3) {
                bufferedReader.readLine();
            }
            while (n3 <= n2) {
                stringBuffer.append(bufferedReader.readLine() + string2);
                ++n3;
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return "Error - End of file reached";
        }
    }

    private String removeTabs(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '\t') {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public String getFormattedErrorMessage(String string, CallStack callStack) {
        String string2 = System.getProperties().getProperty("line.separator");
        String string3 = callStack == null ? this.getInclusionTrace() : callStack.getTrace(this);
        return this.getMarkedErrorLine() + string2 + "Error: " + string + string2 + string3 + string2;
    }

    public String getFormattedErrorMessage(String string) {
        return this.getFormattedErrorMessage(string, null);
    }

    public int getLine() {
        return this.line;
    }

    public int getCollumn() {
        return this.column;
    }

    public String getFilename() {
        return this.filename;
    }
}

