/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.state;

import cml.kickass.asmnode.output.reciever.OutputStreamType;
import cml.kickass.constant.Constant;
import cml.kickass.exceptions.AsmError;
import cml.kickass.exceptions.AsmException;
import cml.kickass.function.Function;
import cml.kickass.function.table.FunctionTable;
import cml.kickass.function.table.StdFunctionTable;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.libraries.Library;
import cml.kickass.libraries.MathLibrary;
import cml.kickass.plugins.interf.IArchive;
import cml.kickass.plugins.interf.IMacro;
import cml.kickass.plugins.interf.IModifier;
import cml.kickass.sideeffect.SEIncreaseMemoryPosition;
import cml.kickass.sideeffect.SESetMemoryPosition;
import cml.kickass.sideeffect.SideEffect;
import cml.kickass.state.AssertManager;
import cml.kickass.state.CallStack;
import cml.kickass.state.FunctionSideOutput;
import cml.kickass.state.scope.Scope;
import cml.kickass.state.scope.StdScope;
import cml.kickass.values.ConstantReferenceValue;
import cml.log.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class EvaluationState {
    private static Log log = new Log("");
    public static final int defaultMemoryPosition = 8192;
    private final long initSeed = (long)(Math.random() * 1.0E7);
    private boolean dtvMode = false;
    private ArrayList<File> sourceLibraryPath;
    private FunctionTable functionTable = new StdFunctionTable();
    private int maxMemoryAddress;
    private Set<String> excludedImports = new HashSet<String>();
    private int passNo = 0;
    private boolean failOnInvalidValue;
    private boolean madeMetaProgress;
    private boolean functionMode = false;
    private boolean pseudoPcMode = false;
    private Integer currentMemoryPosition;
    private Integer currentRealMemoryPosition;
    private boolean errorDuringFunctionEvaluation;
    private boolean invalidSideEffectsDuringFunctionEvaluation;
    private FunctionSideOutput sideOutput = null;
    private Scope systemScope = new StdScope(null, false);
    private Scope scopeBeforeFunctionMode = null;
    private Scope currentScope = new StdScope(this.systemScope, true);
    private CallStack callStack = new CallStack();
    private File currentDirectory = null;
    private AssertManager assertManager = new AssertManager();

    public void prepareNewParse() {
        ++this.passNo;
        this.madeMetaProgress = false;
        MathLibrary.setSeed(this.initSeed);
        this.setMemoryPositionWithoutSideEffect(8192);
        this.currentScope.resetBeforePass();
    }

    public void setDtvMode(boolean bl) {
        this.dtvMode = bl;
    }

    public boolean getDtvMode() {
        return this.dtvMode;
    }

    public void setMaxMemoryAddress(int n) {
        this.maxMemoryAddress = n;
    }

    public int getMaxMemoryAddress() {
        return this.maxMemoryAddress;
    }

    public boolean failOnInvalidValue() {
        return this.failOnInvalidValue;
    }

    public void setFailOnInvalidValue(boolean bl) {
        this.failOnInvalidValue = bl;
    }

    public void setMadeMetaProgress() {
        this.madeMetaProgress = true;
    }

    public boolean getMadeMetaProgress() {
        return this.madeMetaProgress;
    }

    public void setPseudoPcMode(boolean bl) {
        this.pseudoPcMode = bl;
    }

    public boolean getPseudoPcMode() {
        return this.pseudoPcMode;
    }

    public void excludeFileForImport(String string) {
        this.excludedImports.add(string);
    }

    public boolean isFileExcludedForImport(String string) {
        return this.excludedImports.contains(string);
    }

    public void setSourceLibraryPath(ArrayList<File> arrayList) {
        this.sourceLibraryPath = arrayList;
    }

    public boolean getFunctionsMode() {
        return this.functionMode;
    }

    public void setFunctionMode(boolean bl) {
        this.functionMode = bl;
    }

    public AssertManager getAssertManager() {
        return this.assertManager;
    }

    public CallStack getCallStack() {
        return this.callStack;
    }

    public int getPassNo() {
        return this.passNo;
    }

    public void addPlugin(Object object) {
        Object object2;
        boolean bl = false;
        if (object instanceof IArchive) {
            object2 = (IArchive)object;
            for (Object object3 : object2.getPluginObjects()) {
                this.addPlugin(object3);
            }
            bl = true;
        }
        if (object instanceof IMacro) {
            object2 = (IMacro)object;
            this.systemScope.getMacroPlugins().put(object2.getName(), (IMacro)object2);
            bl = true;
        }
        if (object instanceof IModifier) {
            object2 = (IModifier)object;
            this.systemScope.getModifierPlugins().put(object2.getName(), (IModifier)object2);
            bl = true;
        }
        if (!bl) {
            log.println("Warning: The following object registered as a user-plugin but don't implements any plugin interfaces : " + object.getClass().getName());
        }
    }

    public void addLibrary(Library library) {
        String string = library.getClass().getSimpleName();
        for (Constant object : library.getConstants()) {
            String string2 = "Error while adding the constant '" + object.getName() + "' from the library '" + string + "'. The symbol already exist!";
            ConstantReferenceValue constantReferenceValue = new ConstantReferenceValue(object.getValue());
            this.systemScope.getSymbols().putErrorIfExist(object.getName(), constantReferenceValue, string2, null);
        }
        for (Function function : library.getFunctions()) {
            this.functionTable.add(function);
        }
    }

    public FunctionTable getFunctionTable() {
        return this.functionTable;
    }

    public void clearFunctionSideOutput() {
        this.sideOutput = null;
        this.errorDuringFunctionEvaluation = false;
        this.invalidSideEffectsDuringFunctionEvaluation = false;
    }

    public FunctionSideOutput getFunctionSideOutput() {
        return this.sideOutput;
    }

    public void addSideEffect(SideEffect sideEffect) {
        this.getOrNewFunctionSideOutput().addSideEffect(sideEffect);
    }

    public void addTextOutput(String string) {
        this.addStreamOutput(OutputStreamType.CONSOLE, null, string);
    }

    public void addStreamOutput(OutputStreamType outputStreamType, String string, Object object) {
        this.getOrNewFunctionSideOutput().addStreamOutput(outputStreamType, string, object);
    }

    private FunctionSideOutput getOrNewFunctionSideOutput() {
        if (this.sideOutput == null) {
            this.sideOutput = new FunctionSideOutput();
        }
        return this.sideOutput;
    }

    public boolean getErrorDuringFunctionEvaluation() {
        return this.errorDuringFunctionEvaluation;
    }

    public boolean getInvalidSideEffectsDuringFunctionEvaluation() {
        return this.invalidSideEffectsDuringFunctionEvaluation;
    }

    public boolean getErrorOrInvalidSideEffectsDuringFunctionEvaluation() {
        return this.getErrorDuringFunctionEvaluation() || this.getInvalidSideEffectsDuringFunctionEvaluation();
    }

    public void setErrrorDuringFunctionEvaluation(boolean bl) {
        this.errorDuringFunctionEvaluation = bl;
    }

    public void setInvalidSideEffectsDuringFunctionEvaluation() {
        this.invalidSideEffectsDuringFunctionEvaluation = true;
    }

    public Scope getCurrentScope() {
        return this.currentScope;
    }

    public void setCurrentScope(Scope scope) {
        this.currentScope = scope;
    }

    public Scope getSystemScope() {
        return this.systemScope;
    }

    public Scope getScopeBeforeFunctionMode() {
        return this.scopeBeforeFunctionMode;
    }

    public void setScopeBeforeFunctionMode(Scope scope) {
        this.scopeBeforeFunctionMode = scope;
    }

    public Integer getMemoryPosition() {
        return this.currentMemoryPosition;
    }

    public Integer getRealMemoryPosition() {
        return this.currentRealMemoryPosition;
    }

    public void setRealMemoryPosition(Integer n) {
        this.currentRealMemoryPosition = n;
    }

    public void setMemoryPosition(Integer n) {
        this.setMemoryPositionWithoutSideEffect(n);
        if (n == null) {
            this.setErrrorDuringFunctionEvaluation(true);
        } else {
            this.addSideEffect(new SESetMemoryPosition(n));
        }
    }

    public void setMemoryPositionWithoutSideEffect(Integer n) {
        this.currentMemoryPosition = n;
        this.currentRealMemoryPosition = n;
    }

    public void increaseMemoryPosition(int n) {
        this.increaseMemoryPositionWithoutSideEffect(n);
        this.addSideEffect(new SEIncreaseMemoryPosition(n));
    }

    public void increaseMemoryPositionWithoutSideEffect(int n) {
        if (this.currentMemoryPosition != null) {
            this.currentMemoryPosition = this.currentMemoryPosition + n;
        }
        if (this.currentRealMemoryPosition != null) {
            this.currentRealMemoryPosition = this.currentRealMemoryPosition + n;
        }
    }

    public File getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void setCurrentDirectory(File file) {
        this.currentDirectory = file;
    }

    public InputStream openFile(String string, DebugInfo debugInfo) throws AsmException {
        File file = this.getFile(string, debugInfo);
        try {
            return new FileInputStream(file);
        }
        catch (IOException iOException) {
            throw new AsmError("Can't open file '" + string + "'", debugInfo);
        }
    }

    public File getFile(String string, DebugInfo debugInfo) {
        File file = this.getFile(string);
        if (file == null) {
            throw new AsmError("Can't locate file '" + string + "'", debugInfo);
        }
        return file;
    }

    public File getFile(String string) {
        File file = new File(this.currentDirectory, string);
        if (file.exists()) {
            return file;
        }
        for (int i = 0; i < this.sourceLibraryPath.size(); ++i) {
            file = new File(this.sourceLibraryPath.get(i), string);
            if (!file.exists()) continue;
            return file;
        }
        file = new File(string);
        if (file.exists()) {
            return file;
        }
        return null;
    }
}

