/*
 * Decompiled with CFR 0.152.
 */
import ch.bildspur.postfx.builder.PostFX;
import com.hamoid.VideoExport;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import moonlander.library.Moonlander;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PVector;
import processing.event.MouseEvent;

public class sketch_20180101_aon_dihalt
extends PApplet {
    VideoExport _videoExport;
    PostFX fx;
    boolean SAVE_VIDEO = false;
    int FPS = 60;
    int MAX_LENGTH = this.FPS * 69;
    String tune = "alpha-c_-_aon.mp3";
    float BPM = 122.0f;
    int LAST_ROW = 224;
    int[] palette;
    float BPS = 60.0f / this.BPM;
    int SWITCH_EVERY = sketch_20180101_aon_dihalt.ceil((float)(this.BPS * (float)this.FPS));
    int lastFrameSuggestion = sketch_20180101_aon_dihalt.floor((float)(this.MAX_LENGTH / this.SWITCH_EVERY)) * this.SWITCH_EVERY;
    int frameOffset = 0;
    int frameDelta = 0;
    int LAST_FRAME = (this.lastFrameSuggestion + this.frameOffset) * sketch_20180101_aon_dihalt.max((int)1, (int)this.frameDelta);
    Moonlander _moon;
    float tickTime = 0.0f;
    float _noiseScale = 0.02f;
    float _noiseOffsetX;
    float _noiseOffsetY;
    float _previousNoiseOffsetX = 0.0f;
    float _previousNoiseOffsetY = 0.0f;
    float STEPSIZE = 30.0f;
    PImage bg;
    int W = 1920;
    int H = 1080;
    PGraphics l1;
    PGraphics l2;
    PGraphics l3;
    float currentBlendMode = 0.0f;
    int frameStart = 0;
    int[] previousPalette = new int[0];
    int[] currentPalette = new int[0];
    int _sceneID = 0;
    int IMAGES = 2;
    PImage[] images = new PImage[this.IMAGES];
    PImage black;
    float _saturation = 0.1f;
    float _vibrance = 0.1f;
    float _contrast = 1.05f;
    int _bloomStrength = 2;
    float _bloomBlur = 10.0f;
    ArrayList<Box> sponge;
    String _seedFileName = "seed.txt";
    int _seedIndex;
    ArrayList<int[]> _seeds = new ArrayList();
    int _randomSeedIndex = 0;
    ArrayList<int[]> _randomSeeds = new ArrayList();
    int NOISE_SEED = 18198460;
    int RANDOM_SEED = 33330108;
    Boolean _useRandomSeed = false;
    boolean SHOW_FPS = false;
    int frameCounter = 0;
    PImage _screen;
    PGraphics _finalScreen;
    PFont _fpsFont;
    PImage _paletteImage;

    public void setup() {
        this.frameRate(this.FPS);
        this.noiseDetail(8);
        this.initSeedManager();
        this.initUtils();
        this.palette = this.getPalette(20);
        this.l1 = this.createGraphics(this.width, this.height, "processing.opengl.PGraphics3D");
        this.l2 = this.createGraphics(this.width, this.height, "processing.opengl.PGraphics3D");
        this.l3 = this.createGraphics(this.width, this.height, "processing.opengl.PGraphics3D");
        this._finalScreen = this.createGraphics(this.width, this.height, "processing.opengl.PGraphics2D");
        this.fx = new PostFX((PApplet)this);
        this.initSponge();
        int i = 0;
        while (i < 3) {
            this.menger();
            ++i;
        }
        i = 0;
        while (i < this.IMAGES) {
            String imageName = String.valueOf(i) + ".png";
            this.images[i] = this.loadImage(imageName);
            ++i;
        }
        this.black = this.loadImage("black.png");
        this._moon = Moonlander.initWithSoundtrack((PApplet)this, (String)this.tune, (int)((int)this.BPM), (int)8);
        this._moon.start();
    }

    public void mouseWheel(MouseEvent event) {
        float e = event.getCount();
        int[] newSeed = e > 0.0f ? this.getPreviousSeed() : this.getNextSeed();
        this.NOISE_SEED = newSeed[0];
        this.RANDOM_SEED = newSeed[1];
        this.noiseSeed(this.NOISE_SEED);
        this.randomSeed(this.RANDOM_SEED);
        this.refresh(true);
    }

    public void refresh(Boolean keepSeed) {
        this.frameStart = this.frameCount;
        if (!keepSeed.booleanValue()) {
            int[] newSeed = this.getNextSeed();
            this.NOISE_SEED = newSeed[0];
            this.RANDOM_SEED = newSeed[1];
            this.noiseSeed(this.NOISE_SEED);
            this.randomSeed(this.RANDOM_SEED);
        }
        this.palette = this.getPalette(20);
    }

    public void draw() {
        this._moon.update();
        this.tickTime = 0.0f;
        int[] nArray = new int[9];
        nArray[0] = 1;
        nArray[1] = 2;
        nArray[2] = 4;
        nArray[3] = 16;
        nArray[4] = 8;
        nArray[5] = 64;
        nArray[6] = 128;
        nArray[7] = 256;
        int[] blendmodes = nArray;
        this.clear();
        this.switchScene();
        this.l1.beginDraw();
        this.image((PImage)this.l1, 0.0f, 0.0f);
        this.l1.endDraw();
        if ((int)this._moon.getValue("imgIdx") > -1) {
            this.tint(255, sketch_20180101_aon_dihalt.round((float)(255.0f * (float)this._moon.getValue("imgAlpha"))));
            this.blendMode(blendmodes[sketch_20180101_aon_dihalt.max((int)0, (int)((int)this._moon.getValue("blendImg"))) % blendmodes.length]);
            PImage img = this.images[sketch_20180101_aon_dihalt.max((int)0, (int)((int)this._moon.getValue("imgIdx"))) % this.IMAGES];
            this.image(img, 0.0f, 0.0f, this.width, this.height);
        }
        this.tint(255, sketch_20180101_aon_dihalt.round((float)(255.0f * (float)this._moon.getValue("blackFade"))));
        this.image(this.black, 0.0f, 0.0f, this.width, this.height);
        this.tint(255);
        this.fx.render().vignette(0.3f, 0.3f).saturationVibrance(this._saturation, this._vibrance).compose();
        if (this.SHOW_FPS) {
            this._finalScreen.beginDraw();
            this._finalScreen.clear();
            this._finalScreen.blendMode(128);
            this.showFPS();
            this._finalScreen.endDraw();
            this.image((PImage)this._finalScreen, 0.0f, 0.0f);
        }
        this.saveFrames();
    }

    public void switchScene() {
        this._sceneID = (int)this._moon.getValue("scene");
        this.l1.beginDraw();
        this.l1.clear();
        this.l1.endDraw();
        switch (this._sceneID) {
            case 0: {
                this.torusTunnel(this.l1);
                break;
            }
            case 1: {
                this.menger_invert(this.l1);
                break;
            }
            case 2: {
                this.ballonIntro(this.l1);
                break;
            }
            case 3: {
                this.scene_torus_tunnel_side(this.l1);
                break;
            }
            case 4: {
                this.scene_3D_gundamface(this.l1);
            }
        }
    }

    public void drawRed() {
        this.background(0xFF0000);
    }

    public void drawBlue() {
        this.background(65535);
    }

    public void mousePressed() {
        sketch_20180101_aon_dihalt.println((Object[])new Object[]{"frameCount:", this.frameCount});
    }

    public void initSponge() {
        this.sponge = new ArrayList();
        Box b = new Box(0.0f, 0.0f, 0.0f, (float)this.width / 1.2f);
        this.sponge.add(b);
    }

    public void menger() {
        ArrayList<Box> next = new ArrayList<Box>();
        for (Box b : this.sponge) {
            ArrayList<Box> newBoxes = b.generate();
            next.addAll(newBoxes);
        }
        this.sponge = next;
    }

    public void torus(PGraphics layer, float radius, float tube_radius, int cp, int ts) {
        if (tube_radius == 0.0f) {
            tube_radius = radius / 2.0f;
        }
        int circle_parts = cp;
        float circle_angle = sketch_20180101_aon_dihalt.radians((float)(360.0f / (float)circle_parts));
        int tube_segments = ts;
        float tube_angle = sketch_20180101_aon_dihalt.radians((float)(360.0f / (float)tube_segments));
        int seg = 0;
        while (seg < tube_segments) {
            layer.beginShape(18);
            int idx = 0;
            while (idx < circle_parts + 1) {
                float x1 = (radius + tube_radius * sketch_20180101_aon_dihalt.cos((float)((float)idx * circle_angle + sketch_20180101_aon_dihalt.radians((float)45.0f)))) * sketch_20180101_aon_dihalt.cos((float)((float)seg * tube_angle + sketch_20180101_aon_dihalt.radians((float)45.0f)));
                float y1 = (radius + tube_radius * sketch_20180101_aon_dihalt.cos((float)((float)idx * circle_angle + sketch_20180101_aon_dihalt.radians((float)45.0f)))) * sketch_20180101_aon_dihalt.sin((float)((float)seg * tube_angle + sketch_20180101_aon_dihalt.radians((float)45.0f)));
                float z1 = tube_radius * sketch_20180101_aon_dihalt.sin((float)((float)idx * circle_angle + sketch_20180101_aon_dihalt.radians((float)45.0f)));
                float x1Next = (radius + tube_radius * sketch_20180101_aon_dihalt.cos((float)((float)idx * circle_angle + sketch_20180101_aon_dihalt.radians((float)45.0f)))) * sketch_20180101_aon_dihalt.cos((float)(((float)(seg + 1) + sketch_20180101_aon_dihalt.radians((float)45.0f)) * tube_angle));
                float y1Next = (radius + tube_radius * sketch_20180101_aon_dihalt.cos((float)((float)idx * circle_angle + sketch_20180101_aon_dihalt.radians((float)45.0f)))) * sketch_20180101_aon_dihalt.sin((float)(((float)(seg + 1) + sketch_20180101_aon_dihalt.radians((float)45.0f)) * tube_angle));
                float z1Next = tube_radius * sketch_20180101_aon_dihalt.sin((float)((float)idx * circle_angle + sketch_20180101_aon_dihalt.radians((float)45.0f)));
                float xOff = 0.0f;
                float yOff = 0.0f;
                float zOff = 0.0f;
                layer.vertex(x1 + xOff, y1 + yOff, z1 + zOff);
                layer.vertex(x1Next + xOff, y1Next + yOff, z1Next + zOff);
                idx += 2;
            }
            layer.endShape();
            ++seg;
        }
    }

    public void cylinder(int sides, float r1, float r2, float h, PGraphics l) {
        float y;
        float x;
        float angle = 360 / sides;
        float halfHeight = h / 2.0f;
        l.beginShape();
        int i = 0;
        while (i < sides) {
            x = sketch_20180101_aon_dihalt.cos((float)sketch_20180101_aon_dihalt.radians((float)((float)i * angle))) * r1;
            y = sketch_20180101_aon_dihalt.sin((float)sketch_20180101_aon_dihalt.radians((float)((float)i * angle))) * r1;
            l.vertex(x, y, -halfHeight);
            ++i;
        }
        l.endShape(2);
        l.beginShape();
        i = 0;
        while (i < sides) {
            x = sketch_20180101_aon_dihalt.cos((float)sketch_20180101_aon_dihalt.radians((float)((float)i * angle))) * r2;
            y = sketch_20180101_aon_dihalt.sin((float)sketch_20180101_aon_dihalt.radians((float)((float)i * angle))) * r2;
            l.vertex(x, y, halfHeight);
            ++i;
        }
        l.endShape(2);
        l.beginShape(10);
        i = 0;
        while (i < sides + 1) {
            float x1 = sketch_20180101_aon_dihalt.cos((float)sketch_20180101_aon_dihalt.radians((float)((float)i * angle))) * r1;
            float y1 = sketch_20180101_aon_dihalt.sin((float)sketch_20180101_aon_dihalt.radians((float)((float)i * angle))) * r1;
            float x2 = sketch_20180101_aon_dihalt.cos((float)sketch_20180101_aon_dihalt.radians((float)((float)i * angle))) * r2;
            float y2 = sketch_20180101_aon_dihalt.sin((float)sketch_20180101_aon_dihalt.radians((float)((float)i * angle))) * r2;
            l.vertex(x1, y1, -halfHeight);
            l.vertex(x2, y2, halfHeight);
            ++i;
        }
        l.endShape(2);
    }

    public void drawCylinderElipse(float r1, float h) {
        float y;
        float x;
        float r2 = r1;
        int sides = 6;
        float angle = 360 / sides;
        float halfHeight = h / 2.0f;
        float rHeight = r1 * 3.0f;
        float offsetRot = sketch_20180101_aon_dihalt.radians((float)30.0f);
        this.beginShape();
        int i = 0;
        while (i < sides) {
            x = sketch_20180101_aon_dihalt.cos((float)(offsetRot + sketch_20180101_aon_dihalt.radians((float)((float)i * angle)))) * r1;
            y = sketch_20180101_aon_dihalt.sin((float)(offsetRot + sketch_20180101_aon_dihalt.radians((float)((float)i * angle)))) * rHeight;
            this.vertex(x, y, -halfHeight);
            ++i;
        }
        this.endShape(2);
        this.beginShape();
        i = 0;
        while (i < sides) {
            x = sketch_20180101_aon_dihalt.cos((float)(offsetRot + sketch_20180101_aon_dihalt.radians((float)((float)i * angle)))) * r2;
            y = sketch_20180101_aon_dihalt.sin((float)(offsetRot + sketch_20180101_aon_dihalt.radians((float)((float)i * angle)))) * rHeight;
            this.vertex(x, y, halfHeight);
            ++i;
        }
        this.endShape(2);
        this.beginShape(10);
        i = 0;
        while (i < sides + 1) {
            float x1 = sketch_20180101_aon_dihalt.cos((float)(offsetRot + sketch_20180101_aon_dihalt.radians((float)((float)i * angle)))) * r1;
            float y1 = sketch_20180101_aon_dihalt.sin((float)(offsetRot + sketch_20180101_aon_dihalt.radians((float)((float)i * angle)))) * rHeight;
            float x2 = sketch_20180101_aon_dihalt.cos((float)(offsetRot + sketch_20180101_aon_dihalt.radians((float)((float)i * angle)))) * r2;
            float y2 = sketch_20180101_aon_dihalt.sin((float)(offsetRot + sketch_20180101_aon_dihalt.radians((float)((float)i * angle)))) * rHeight;
            this.vertex(x1, y1, -halfHeight);
            this.vertex(x2, y2, halfHeight);
            ++i;
        }
        this.endShape(2);
    }

    public void torus(float radius, float tube_radius, PGraphics l, PImage texture) {
        if (tube_radius == 0.0f) {
            tube_radius = radius / 2.0f;
        }
        int circle_parts = 12;
        float circle_angle = sketch_20180101_aon_dihalt.radians((float)(360.0f / (float)circle_parts));
        int tube_segments = 21;
        float tube_angle = sketch_20180101_aon_dihalt.radians((float)(360.0f / (float)tube_segments));
        int seg = 0;
        while (seg < tube_segments) {
            l.beginShape(18);
            if (texture != null) {
                l.textureMode(1);
                l.texture(texture);
            }
            int idx = 0;
            while (idx < circle_parts + 1) {
                float x1 = (radius + tube_radius * sketch_20180101_aon_dihalt.cos((float)((float)idx * circle_angle + sketch_20180101_aon_dihalt.radians((float)45.0f)))) * sketch_20180101_aon_dihalt.cos((float)((float)seg * tube_angle + sketch_20180101_aon_dihalt.radians((float)45.0f)));
                float y1 = (radius + tube_radius * sketch_20180101_aon_dihalt.cos((float)((float)idx * circle_angle + sketch_20180101_aon_dihalt.radians((float)45.0f)))) * sketch_20180101_aon_dihalt.sin((float)((float)seg * tube_angle + sketch_20180101_aon_dihalt.radians((float)45.0f)));
                float z1 = tube_radius * sketch_20180101_aon_dihalt.sin((float)((float)idx * circle_angle + sketch_20180101_aon_dihalt.radians((float)45.0f)));
                float x1Next = (radius + tube_radius * sketch_20180101_aon_dihalt.cos((float)((float)idx * circle_angle + sketch_20180101_aon_dihalt.radians((float)45.0f)))) * sketch_20180101_aon_dihalt.cos((float)(((float)(seg + 1) + sketch_20180101_aon_dihalt.radians((float)45.0f)) * tube_angle));
                float y1Next = (radius + tube_radius * sketch_20180101_aon_dihalt.cos((float)((float)idx * circle_angle + sketch_20180101_aon_dihalt.radians((float)45.0f)))) * sketch_20180101_aon_dihalt.sin((float)(((float)(seg + 1) + sketch_20180101_aon_dihalt.radians((float)45.0f)) * tube_angle));
                float z1Next = tube_radius * sketch_20180101_aon_dihalt.sin((float)((float)idx * circle_angle + sketch_20180101_aon_dihalt.radians((float)45.0f)));
                float xOff = 0.0f;
                float yOff = 0.0f;
                float zOff = 0.0f;
                l.vertex(x1 + xOff, y1 + yOff, z1 + zOff);
                l.vertex(x1Next + xOff, y1Next + yOff, z1Next + zOff);
                idx += 2;
            }
            l.endShape();
            ++seg;
        }
    }

    public void icosahedron(float radius, PGraphics l) {
        float t = (1.0f + sketch_20180101_aon_dihalt.sqrt((float)radius)) / 2.0f;
        l.beginShape(18);
        l.beginShape(18);
        l.vertex(-1.0f, t, 0.0f);
        l.vertex(1.0f, t, 0.0f);
        l.vertex(-1.0f, -t, 0.0f);
        l.vertex(1.0f, -t, 0.0f);
        l.vertex(0.0f, -1.0f, t);
        l.vertex(0.0f, 1.0f, t);
        l.vertex(0.0f, -1.0f, -t);
        l.vertex(0.0f, 1.0f, -t);
        l.vertex(t, 0.0f, -1.0f);
        l.vertex(t, 0.0f, 1.0f);
        l.vertex(-t, 0.0f, -1.0f);
        l.vertex(-t, 0.0f, 1.0f);
        l.endShape();
    }

    public void torusTunnel(PGraphics layer) {
        float offsetZ = sketch_20180101_aon_dihalt.sin((float)((float)this.frameCount / 20.0f));
        float rotOffset = (float)this.frameCount / 100.0f;
        layer.beginDraw();
        layer.background(this.palette[0]);
        layer.stroke(this.palette[0]);
        layer.strokeWeight(0.0027777778f * (float)this.width);
        float FOV = (float)this._moon.getValue("FOV");
        layer.camera((float)this.width / 2.0f, (float)this.height / 2.0f, (float)this.height / 2.0f / sketch_20180101_aon_dihalt.tan((float)(94.24778f / FOV)), (float)this.width / 2.0f, (float)this.height / 2.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        float cameraZ = (float)this.height / 2.0f / sketch_20180101_aon_dihalt.tan((float)((float)Math.PI * FOV / 360.0f));
        layer.perspective(1.8479956f, (float)(this.width / this.height), cameraZ / FOV, cameraZ * FOV);
        int depth = 100;
        int z = 0;
        while (z < depth) {
            if (z % 2 == 0) {
                layer.fill(this.red(this.palette[2]), this.green(this.palette[2]), this.blue(this.palette[2]), 100.0f - 100.0f / (float)depth * (float)z);
            } else {
                layer.fill(this.red(this.palette[3]), this.green(this.palette[3]), this.blue(this.palette[3]), 100.0f - 100.0f / (float)depth * (float)z);
            }
            layer.pushMatrix();
            layer.translate((float)(this.width / 2), (float)(this.height / 2), (float)(z * 10));
            layer.rotateY(offsetZ / 500.0f);
            layer.rotateX(-offsetZ / 500.0f);
            layer.rotateZ((float)(z * 10) + rotOffset / 2.0f);
            layer.translate(0.0f, 0.0f, (float)(-z * 100));
            this.torus(layer, 300.0f, 150.0f, 12, 12);
            layer.popMatrix();
            ++z;
        }
        layer.endDraw();
    }

    public void lineSea(PGraphics layer) {
        layer.beginDraw();
        layer.background(this.palette[0]);
        float speed = (float)this.frameCount / 2.5f;
        float camZ = -speed - 0.41666666f * (float)this.width;
        layer.camera((float)this.width / 2.0f, (float)this.height / 2.0f, (float)this.height / 2.0f / sketch_20180101_aon_dihalt.tan((float)0.5890486f) + camZ, (float)this.width / 2.0f, (float)this.height / 1.4f, camZ, 0.0f, 1.0f, 0.0f);
        layer.strokeJoin(2);
        int TILES = 500;
        float dist = 0.008333334f * (float)this.width;
        float z = 0.0f;
        while (z < (float)TILES) {
            layer.pushMatrix();
            float window = 30.0f;
            float strokeWeight = sketch_20180101_aon_dihalt.max((float)0.0f, (float)sketch_20180101_aon_dihalt.min((float)1.0f, (float)(1.0f / window * (window - (z - speed / dist)))));
            float strokeWeight2 = strokeWeight * strokeWeight * strokeWeight;
            int stroke = this.lerpColor(this.palette[3], this.palette[2], strokeWeight);
            stroke = this.color(this.red(stroke), this.green(stroke), this.blue(stroke), strokeWeight / 1.0f * 150.0f);
            layer.stroke(stroke);
            int fill = this.lerpColor(this.palette[1], stroke, 1.0f - strokeWeight);
            layer.fill(this.color(this.red(fill), this.green(fill), this.blue(fill), strokeWeight / 1.0f * 255.0f));
            layer.strokeWeight(strokeWeight2 * (0.0069444445f * (float)this.width));
            layer.translate(0.20833333f * (float)this.width, 0.3472222f * (float)this.width, -z * dist);
            this.lineSea_getTile(this.l1, z);
            layer.popMatrix();
            z += 1.0f;
        }
        layer.endDraw();
    }

    public void lineSea_getTile(PGraphics layer, float y) {
        int POINTS = 200;
        float DELTA = 0.0027777778f * (float)this.width;
        float MULTIPLIER = 0.030555556f * (float)this.width;
        int HEIGHT = PApplet.parseInt((float)(0.1388889f * (float)this.width));
        float NOISE_SCALE = 0.09f;
        layer.beginShape();
        layer.vertex(0.0f, (float)HEIGHT);
        int x = 0;
        while (x < POINTS) {
            float n = this.noise((float)x * NOISE_SCALE, y * NOISE_SCALE + (float)this.frameCount / 150.0f);
            layer.vertex((float)x * DELTA, n * MULTIPLIER);
            ++x;
        }
        layer.vertex((float)(POINTS - 1) * DELTA, (float)HEIGHT);
        layer.endShape();
    }

    public void menger_invert(PGraphics layer) {
        layer.beginDraw();
        layer.background(this.palette[0]);
        float FOV = (float)this._moon.getValue("FOV");
        layer.camera((float)this.width / 2.0f, (float)this.height / 2.0f, (float)this.height / 2.0f / sketch_20180101_aon_dihalt.tan((float)(94.24778f / FOV)), (float)this.width / 2.0f, (float)this.height / 2.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        float cameraZ = (float)this.height / 2.0f / sketch_20180101_aon_dihalt.tan((float)((float)Math.PI * FOV / 360.0f));
        layer.perspective(1.8479956f, (float)(this.width / this.height), cameraZ / FOV, cameraZ * FOV);
        layer.strokeWeight(1.0f);
        layer.strokeJoin(2);
        layer.strokeCap(2);
        layer.pushMatrix();
        layer.fill(this.getPalette(1)[0]);
        layer.noStroke();
        float size = this.width;
        layer.translate((float)(this.width / 2) - size / 2.0f, (float)(this.height / 2) - size / 2.0f, -500.0f);
        layer.popMatrix();
        layer.pushMatrix();
        layer.translate((float)(this.width / 2), (float)(this.height / 2));
        layer.rotateX((float)this.frameCount / 100.0f);
        layer.rotateY((float)this.frameCount / 300.0f);
        layer.rotateZ((float)(-this.frameCount) / 400.0f);
        layer.stroke(this.palette[3], 150.0f);
        layer.strokeWeight(3.0f);
        int i = 0;
        while (i < this.sponge.size() - 1) {
            int c = i + 1;
            float dist = sketch_20180101_aon_dihalt.dist((float)this.sponge.get((int)i).pos.x, (float)this.sponge.get((int)i).pos.y, (float)this.sponge.get((int)i).pos.z, (float)this.sponge.get((int)c).pos.x, (float)this.sponge.get((int)c).pos.y, (float)this.sponge.get((int)c).pos.z);
            layer.strokeWeight(sketch_20180101_aon_dihalt.min((float)5.0f, (float)sketch_20180101_aon_dihalt.map((float)dist, (float)0.0f, (float)100.0f, (float)1.0f, (float)5.0f)));
            layer.line(this.sponge.get((int)i).pos.x, this.sponge.get((int)i).pos.y, this.sponge.get((int)i).pos.z, this.sponge.get((int)c).pos.x, this.sponge.get((int)c).pos.y, this.sponge.get((int)c).pos.z);
            ++i;
        }
        layer.strokeWeight(1.0f);
        layer.stroke(this.palette[4]);
        for (Box b : this.sponge) {
            b.show(layer);
        }
        layer.popMatrix();
        layer.endDraw();
    }

    public void ballonIntro(PGraphics layer) {
        layer.beginDraw();
        layer.background(this.palette[0]);
        float FOV = (float)this._moon.getValue("FOV");
        layer.camera((float)this.width / 2.0f, (float)this.height / 2.0f, (float)this.height / 2.0f / sketch_20180101_aon_dihalt.tan((float)(94.24778f / FOV)), (float)this.width / 2.0f, (float)this.height / 2.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        float cameraZ = (float)this.height / 2.0f / sketch_20180101_aon_dihalt.tan((float)((float)Math.PI * FOV / 360.0f));
        layer.perspective(1.8479956f, (float)(this.width / this.height), cameraZ / FOV, cameraZ * FOV);
        layer.fill(this.palette[2]);
        layer.stroke(this.palette[3], 150.0f);
        layer.strokeWeight(0.004166667f * (float)this.width);
        layer.sphereDetail(6);
        float dia = (float)this.height / 5.0f;
        int x = 0;
        while (x < 10) {
            int y = 0;
            while (y < 10) {
                layer.pushMatrix();
                layer.translate((y % 2 == 0 ? 0.0f : dia / 2.0f) + (float)x * dia, (float)y * dia);
                layer.rotateX((float)this.frameCount / 100.0f);
                layer.rotateY((float)this.frameCount / 300.0f);
                layer.rotateZ((float)(-this.frameCount) / 400.0f);
                layer.sphere(dia * 0.5f);
                layer.popMatrix();
                ++y;
            }
            ++x;
        }
        layer.endDraw();
    }

    public void scene_3D_gundamface(PGraphics l) {
        l.beginDraw();
        l.background(this.lerpColor(-8627, this.palette[0], (float)this._moon.getValue("colorFade")));
        l.strokeWeight(0.0013888889f * (float)this.width);
        float FOV = (float)this._moon.getValue("FOV");
        l.camera((float)this.width / 2.0f, (float)this.height / 2.0f, (float)this.height / 2.0f / sketch_20180101_aon_dihalt.tan((float)(94.24778f / FOV)), (float)this.width / 2.0f, (float)this.height / 2.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        float cameraZ = (float)this.height / 2.0f / sketch_20180101_aon_dihalt.tan((float)((float)Math.PI * FOV / 360.0f));
        l.perspective(1.8479956f, (float)(this.width / this.height), cameraZ / FOV, cameraZ * FOV);
        this.randomSeed((long)this._moon.getValue("seed"));
        l.rotateZ(sketch_20180101_aon_dihalt.radians((float)7.0f));
        int i = 0;
        while (i < 30) {
            int colorIndex = PApplet.parseInt((float)this.random(this.palette.length));
            int colorIndex2 = PApplet.parseInt((float)this.random(this.palette.length));
            float offsetX = this.random(this.width / 5);
            float offsetY = this.random(this.height / 3);
            float offsetZ = this.random(this.width / 3);
            float rotX = this.random(1.0f) > 0.5f ? -1 : 1;
            float rotY = this.random(1.0f) > 0.5f ? -1 : 1;
            float rotZ = this.random(1.0f) > 0.5f ? -1 : 1;
            int idx = PApplet.parseInt((float)this.random(7.0f));
            float diameter = (this.random(1.0f) * (float)this.width / 5.0f + (float)(this.width / 20)) / 2.0f;
            l.fill(this.palette[colorIndex2]);
            l.stroke(this.palette[colorIndex]);
            l.pushMatrix();
            l.translate((float)(this.width / 2) - offsetX, (float)this.height / 1.5f - offsetY, offsetZ);
            l.rotateZ(sketch_20180101_aon_dihalt.radians((float)(this.tickTime * 360.0f * rotZ + (float)(i / 10))) + sketch_20180101_aon_dihalt.radians((float)((float)this._moon.getValue("rotZ"))));
            l.rotateY(sketch_20180101_aon_dihalt.radians((float)(this.tickTime * 360.0f * rotY + (float)(i / 10))) + sketch_20180101_aon_dihalt.radians((float)((float)this._moon.getValue("rotY"))));
            l.rotateX(sketch_20180101_aon_dihalt.radians((float)(this.tickTime * 360.0f * rotX + (float)(i / 10))) + sketch_20180101_aon_dihalt.radians((float)((float)this._moon.getValue("rotX"))));
            switch (idx) {
                case 0: {
                    this.torus(diameter, diameter / 3.0f, l, null);
                    break;
                }
                case 1: {
                    l.box(diameter);
                    break;
                }
                case 2: {
                    this.cylinder(5, 0.0f, diameter, diameter * 2.0f, l);
                    break;
                }
                case 3: {
                    l.sphereDetail(8);
                    l.sphere(diameter / 2.0f);
                    break;
                }
                case 4: {
                    l.box(diameter, diameter / 3.0f, diameter * 3.0f);
                    break;
                }
                case 5: {
                    int c = 1;
                    while (c < 8) {
                        float w = diameter / 15.0f;
                        l.translate(0.0f, (float)c * w);
                        l.box(w, w, diameter * 3.0f);
                        ++c;
                    }
                    break;
                }
                case 6: {
                    int x = 0;
                    while (x < 20) {
                        int y = 0;
                        while (y < 10) {
                            l.pushMatrix();
                            float w = this.width / 50;
                            l.translate((float)x * w, (float)y * w);
                            this.cylinder(6, w / 2.0f, w / 2.0f, w / 4.0f, l);
                            l.popMatrix();
                            ++y;
                        }
                        ++x;
                    }
                    break;
                }
            }
            l.popMatrix();
            ++i;
        }
        l.blendMode(1);
        l.copy(0, 0, this.width / 2, this.height, this.width, 0, -this.width / 2, this.height);
        l.endDraw();
    }

    public void scene_torus_tunnel_side(PGraphics l) {
        l.beginDraw();
        l.fill(this.palette[this.palette.length - 1]);
        l.stroke(-857153);
        float FOV = (float)this._moon.getValue("FOV");
        l.camera(0.0f, (float)this.height / 2.0f - 100.0f, (float)this.height / 2.0f / sketch_20180101_aon_dihalt.tan((float)(282.74335f / FOV)), (float)this.width / 2.0f, (float)this.height / 2.0f + 100.0f, 0.0f, 0.0f, 1.0f, 1.0f);
        float radius = 0.3125f * (float)this.width;
        float girth = radius / 5.0f;
        int amount_x = 12;
        int amount_z = 12;
        float tOff = sketch_20180101_aon_dihalt.radians((float)(this.tickTime * 360.0f));
        int z = 0;
        while (z < amount_z) {
            int x = 0;
            while (x < amount_x) {
                float offsetZ = sketch_20180101_aon_dihalt.sin((float)((float)Math.PI * 2 / (float)amount_z * (float)z)) * girth;
                float offsetRadius = sketch_20180101_aon_dihalt.cos((float)((float)Math.PI * 2 / (float)amount_z * (float)z)) * girth;
                float rotX = sketch_20180101_aon_dihalt.sin((float)((float)Math.PI * 2 / (float)amount_x * (float)x + tOff));
                float rotY = sketch_20180101_aon_dihalt.cos((float)((float)Math.PI * 2 / (float)amount_x * (float)x + tOff));
                float offsetX = rotX * (radius + offsetRadius);
                float offsetY = rotY * (radius + offsetRadius);
                l.pushMatrix();
                l.translate((float)(this.width / 2), (float)(this.height / 2), 0.0f);
                l.translate(offsetX, offsetY, offsetZ);
                this.torus(0.015625f * (float)this.width, 0.0078125f * (float)this.width, l, null);
                l.popMatrix();
                ++x;
            }
            ++z;
        }
        l.pushMatrix();
        l.rotateX(tOff);
        l.rotateY(tOff);
        l.translate((float)(this.width / 2), (float)(this.height / 2));
        l.popMatrix();
        l.endDraw();
    }

    public void initSeedManager() {
        this._seedIndex = 0;
        this._setSeedsFromFile();
        int[] rnd = new int[]{(int)((float)this.frameCount * this.random(0.0f, 9001.0f)), (int)((float)this.frameCount * this.random(0.0f, 9001.0f))};
        this._randomSeeds.add(rnd);
    }

    public void reloadSeedManager() {
        this._seedIndex = 0;
        this._setSeedsFromFile();
    }

    public void keyPressed() {
        sketch_20180101_aon_dihalt.println((String)(String.valueOf(this.key) + ":" + this.keyCode));
        if (this.key == '+') {
            this._appendTextToFile(String.valueOf(this.NOISE_SEED) + ":" + this.RANDOM_SEED);
            sketch_20180101_aon_dihalt.println((String)("saved seed " + this.NOISE_SEED + " and " + this.RANDOM_SEED));
        } else if (this.key == '-') {
            if (!this._useRandomSeed.booleanValue()) {
                this._removeSeedFromFile(String.valueOf(this.NOISE_SEED) + ":" + this.RANDOM_SEED);
                this._loadSeedsFromFile();
                sketch_20180101_aon_dihalt.println((String)("removed seed " + this.NOISE_SEED + " and " + this.RANDOM_SEED));
            }
        } else if (this.keyCode == 23) {
            this._useRandomSeed = this._useRandomSeed == false;
            this._setSeedsFromFile();
            sketch_20180101_aon_dihalt.println((String)("set useRandomSeed to " + this._useRandomSeed));
        } else if (this.keyCode == 101) {
            this.reloadSeedManager();
            this.reloadUtils();
            sketch_20180101_aon_dihalt.println((String)"reloaded config");
        } else if (this.key == 'f') {
            sketch_20180101_aon_dihalt.println((Object[])new Object[]{"toggle FPS", !this.SHOW_FPS});
            this.SHOW_FPS = !this.SHOW_FPS;
        }
    }

    public int[] getSeed() {
        if (this._useRandomSeed.booleanValue()) {
            return this._randomSeeds.get(this._randomSeedIndex);
        }
        return this._seeds.get(this._seedIndex);
    }

    public int[] getLastSeed() {
        if (this._useRandomSeed.booleanValue()) {
            return this._getRandomLastSeed();
        }
        return this._getLastSeed();
    }

    public int[] getNextSeed() {
        if (this._useRandomSeed.booleanValue()) {
            return this._getRandomNextSeed();
        }
        return this._getNextSeed();
    }

    public int[] getPreviousSeed() {
        if (this._useRandomSeed.booleanValue()) {
            return this._getRandomPreviousSeed();
        }
        return this._getPreviousSeed();
    }

    public int[] _getNextSeed() {
        ++this._seedIndex;
        if (this._seedIndex >= this._seeds.size()) {
            this._seedIndex = 0;
        }
        sketch_20180101_aon_dihalt.println((String)("getNextSeed - " + this._seedIndex + "/" + this._seeds.size()));
        return this._seeds.get(this._seedIndex);
    }

    public int[] _getRandomNextSeed() {
        ++this._randomSeedIndex;
        if (this._randomSeedIndex >= this._randomSeeds.size()) {
            int[] rnd = new int[]{(int)((float)this.frameCount * this.random(0.0f, 9001.0f)), (int)((float)this.frameCount * this.random(0.0f, 9001.0f))};
            this._randomSeeds.add(rnd);
        }
        sketch_20180101_aon_dihalt.println((String)("getRandomNextSeed - " + this._randomSeedIndex + "/" + this._randomSeeds.size()));
        return this._randomSeeds.get(this._randomSeedIndex);
    }

    public int[] _getLastSeed() {
        return this._seeds.get(sketch_20180101_aon_dihalt.max((int)0, (int)(this._seedIndex - 1)));
    }

    public int[] _getRandomLastSeed() {
        int pntr = this._randomSeedIndex - 1;
        if (pntr < 0) {
            int[] rnd = new int[]{(int)((float)this.frameCount * this.random(0.0f, 9001.0f)), (int)((float)this.frameCount * this.random(0.0f, 9001.0f))};
            this._randomSeeds.add(0, rnd);
            pntr = 0;
            this._randomSeedIndex = 1;
        }
        return this._randomSeeds.get(pntr);
    }

    public int[] _getPreviousSeed() {
        --this._seedIndex;
        if (this._seedIndex < 0) {
            this._seedIndex = this._seeds.size() - 1;
        }
        sketch_20180101_aon_dihalt.println((String)("getPreviousSeed - " + this._seedIndex + "/" + this._seeds.size()));
        return this._seeds.get(this._seedIndex);
    }

    public int[] _getRandomPreviousSeed() {
        --this._randomSeedIndex;
        if (this._randomSeedIndex < 0) {
            int[] rnd = new int[]{(int)((float)this.frameCount * this.random(0.0f, 9001.0f)), (int)((float)this.frameCount * this.random(0.0f, 9001.0f))};
            this._randomSeeds.add(0, rnd);
            this._randomSeedIndex = 0;
        }
        sketch_20180101_aon_dihalt.println((String)("getRandomPreviousSeed - " + this._randomSeedIndex + "/" + this._randomSeeds.size()));
        return this._randomSeeds.get(this._randomSeedIndex);
    }

    public void _loadSeedsFromFile() {
        String[] lines = this.loadStrings(this._seedFileName);
        this._seeds = new ArrayList();
        sketch_20180101_aon_dihalt.println((String)("reading seeds from " + this._seedFileName));
        int i = 0;
        while (i < lines.length) {
            String[] s = lines[i].split(":");
            int noise = Integer.parseInt(s[0]);
            int random = Integer.parseInt(s[1]);
            int[] rnd = new int[]{noise, random};
            this._seeds.add(rnd);
            ++i;
        }
    }

    public void _setSeedsFromFile() {
        this._loadSeedsFromFile();
        this.NOISE_SEED = this._seeds.get(0)[0];
        this.RANDOM_SEED = this._seeds.get(0)[1];
        this.randomSeed(this.NOISE_SEED);
        this.randomSeed(this.RANDOM_SEED);
        sketch_20180101_aon_dihalt.println((String)("loaded " + this._seeds.size() + " seeds from file, setting " + this.NOISE_SEED + " and " + this.RANDOM_SEED));
    }

    public void _appendTextToFile(String text) {
        File f = new File(this.dataPath(this._seedFileName));
        if (!f.exists()) {
            this._createFile(f);
        }
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(f, true)));
            out.println(text);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void _removeSeedFromFile(String text) {
        String[] lines = this.loadStrings(this._seedFileName);
        String[] newSeedFileContents = new String[]{};
        int i = 0;
        while (i < lines.length) {
            if (!text.equals(lines[i])) {
                newSeedFileContents = sketch_20180101_aon_dihalt.append((String[])newSeedFileContents, (String)lines[i]);
            }
            ++i;
        }
        this.saveStrings("data/" + this._seedFileName, newSeedFileContents);
    }

    public void _createFile(File f) {
        File parentDir = f.getParentFile();
        try {
            parentDir.mkdirs();
            f.createNewFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initUtils() {
        this._fpsFont = this.createFont("monospace", 48.0f);
        this._paletteImage = this.loadImage("palette.png");
    }

    public void reloadUtils() {
        this._paletteImage = this.loadImage("palette.png");
    }

    public void saveFrames() {
        if (this.SAVE_VIDEO) {
            if (this.frameCount > this.frameOffset && this.frameCount <= this.LAST_FRAME) {
                this.saveFrame("frame/" + this.frameCounter++ + ".png");
            }
            if (this.frameCount > this.frameOffset && this.frameCount == this.LAST_FRAME) {
                sketch_20180101_aon_dihalt.print((String)"done");
                this.exit();
            }
        }
    }

    public void drawGrid() {
        this._screen = this.get(0, 0, this.width, this.height);
        this._finalScreen.beginDraw();
        this._finalScreen.image(this._screen, 0.0f, 0.0f);
        this._finalScreen.stroke(-16777216);
        this._finalScreen.strokeWeight(1.0f);
        this._finalScreen.blendMode(128);
        this._finalScreen.line((float)this.width / 3.0f, 0.0f, (float)this.width / 3.0f, (float)this.height);
        this._finalScreen.line((float)this.width / 3.0f * 2.0f, 0.0f, (float)this.width / 3.0f * 2.0f, (float)this.height);
        this._finalScreen.line(0.0f, (float)this.height / 3.0f, (float)this.width, (float)this.height / 3.0f);
        this._finalScreen.line(0.0f, (float)this.height / 3.0f * 2.0f, (float)this.width, (float)this.height / 3.0f * 2.0f);
        this._finalScreen.blendMode(0);
        this._finalScreen.endDraw();
        this.image((PImage)this._finalScreen, 0.0f, 0.0f);
        this.blendMode(0);
    }

    public void showFPS() {
        this._finalScreen.beginDraw();
        this._finalScreen.fill(-16777216);
        this._finalScreen.textAlign(37, 101);
        this._finalScreen.text(sketch_20180101_aon_dihalt.round((float)this.frameRate), 10.0f, 10.0f);
        this._finalScreen.text(sketch_20180101_aon_dihalt.round((float)this.frameRate), 10.0f, 10.0f);
        this._finalScreen.endDraw();
    }

    public int randomColorFromImage() {
        int c = this._paletteImage != null ? this._paletteImage.get(sketch_20180101_aon_dihalt.round((float)this.random(this._paletteImage.width)), sketch_20180101_aon_dihalt.round((float)this.random(this._paletteImage.height))) : this.color(this.random(255.0f), this.random(255.0f), this.random(255.0f));
        return c;
    }

    public PImage createGradientImage(int w, int h, int[] colors) {
        PImage img = this.createImage(w, h, 1);
        int divideColors = colors.length - 1;
        int stepSize = img.height / divideColors;
        img.loadPixels();
        int y = 0;
        while (y < img.height) {
            int cS = colors[y / stepSize];
            int cE = colors[sketch_20180101_aon_dihalt.min((int)(y / stepSize + 1), (int)divideColors)];
            float amt = (float)(y % stepSize) / (float)stepSize;
            this.lerpColor(cS, cE, amt * 1.3f);
            int x = 0;
            while (x < img.width) {
                int c1 = this.lerpColor(colors[0], colors[1], (float)x / (float)this.width / 2.0f + (float)y / (float)this.height / 2.0f);
                int index = x + y * img.width;
                img.pixels[index] = c1;
                ++x;
            }
            ++y;
        }
        img.updatePixels();
        return img;
    }

    public int[] getPalette(int amount) {
        int[] pal = new int[]{};
        int i = 0;
        while (i < amount) {
            pal = sketch_20180101_aon_dihalt.append((int[])pal, (int)this.randomColorFromImage());
            ++i;
        }
        return pal;
    }

    public int[] lerpPalette(int[] pal1, int[] pal2, float time) {
        int[] col = new int[]{};
        int i = 0;
        while (i < pal1.length) {
            col = sketch_20180101_aon_dihalt.append((int[])col, (int)this.lerpColor(pal1[i], pal2[i], time));
            ++i;
        }
        return col;
    }

    public void settings() {
        this.size(1920, 1080, "processing.opengl.PGraphics3D");
        this.smooth(4);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"--present", "--window-color=#080808", "--hide-stop", "sketch_20180101_aon_dihalt"};
        if (passedArgs != null) {
            PApplet.main((String[])sketch_20180101_aon_dihalt.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class Box {
        PVector pos;
        float r;
        int detail;

        Box(float x, float y, float z, float r_) {
            this.pos = new PVector(x, y, z);
            this.r = r_;
            this.detail = 3 + (int)sketch_20180101_aon_dihalt.this.random(3.0f);
        }

        public ArrayList<Box> generate() {
            ArrayList<Box> boxes = new ArrayList<Box>();
            int x = -2;
            while (x < 4) {
                int y = -2;
                while (y < 3) {
                    int z = -2;
                    while (z < 3) {
                        int sum = sketch_20180101_aon_dihalt.abs((int)x) + sketch_20180101_aon_dihalt.abs((int)y) + sketch_20180101_aon_dihalt.abs((int)z);
                        float newR = this.r / 3.0f;
                        if (sum < 2) {
                            Box b = new Box(this.pos.x + (float)x * newR, this.pos.y + (float)y * newR, this.pos.z + (float)z * newR, newR);
                            boxes.add(b);
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
            return boxes;
        }

        public void show(PGraphics layer) {
            sketch_20180101_aon_dihalt.this.noiseSeed(0L);
            float speed = (float)sketch_20180101_aon_dihalt.this.frameCount / 200.0f;
            layer.pushMatrix();
            float n = sketch_20180101_aon_dihalt.this.noise(this.pos.x + 0.0f, this.pos.y + 0.0f, this.pos.z + speed);
            float dia = n * this.r;
            layer.translate(this.pos.x + n * 50.0f, this.pos.y + n * 50.0f, this.pos.z + n * 50.0f);
            layer.fill(sketch_20180101_aon_dihalt.this.lerpColor(sketch_20180101_aon_dihalt.this.palette[1], sketch_20180101_aon_dihalt.this.palette[2], n));
            layer.rotateX(n * 360.0f / 80.0f);
            layer.rotateY(-n * 360.0f / 80.0f);
            layer.rotateZ(n * 360.0f / 80.0f);
            layer.sphereDetail(this.detail);
            layer.sphere(dia + (sketch_20180101_aon_dihalt.sin((float)((float)sketch_20180101_aon_dihalt.this.frameCount / 40.0f)) + 1.0f) * 3.0f);
            layer.popMatrix();
            sketch_20180101_aon_dihalt.this.noiseSeed(sketch_20180101_aon_dihalt.this.NOISE_SEED);
        }
    }
}

