#include <sys/types.h>
#include <kernel.h>
#include <libetc.h>
#include <libgte.h>
#include <libgpu.h>
#include <libgs.h>
#include <stdlib.h>
#include <stdio.h>
#include <libsn.h>
#include <libmath.h>
#include "hitmod.h"

#define OT_STARS	0

#define OTSIZE		(2)	// prim table size: 0: logo, 1: text 2: starField 3: terminator
#define OTLENGTH	2	// for shifting

#define SCREEN_WD	320
#define SCREEN_HT	256

#define	GPACK_RGBA5551(r, g, b)		((((b)>>3) << 10) & 0x7c00 | 		\
					 (((g)>>3) << 5) & 0x03e0 |		\
					 (((r)>>3) & 0x1f))

TIM_IMAGE image;		// Set Address where TIM should be in Main Address!!
RECT	rect1;

unsigned char Height[2][SCREEN_WD * SCREEN_HT];
extern unsigned char sine[256];
extern unsigned short trsi[];

unsigned short ColourTab[256];
char	count=0, countx=0;


typedef struct {
	DRAWENV		draw;			/* drawing environment */
	DISPENV		disp;			/* display environment */
	u_long		ot[OTSIZE];		/* ordering table */
	POLY_FT4	tile[2];
} DB;

/* function headers */

void InitPAL(DB *db);
void init_prim(DB *db);
void HeightBlob(int x, int y, int radius, int height, int page);
void CalcWater(int npage);
void CalculateColors();


// -----------------------

void InitPAL(DB *db)
{
	SetVideoMode(MODE_PAL);

	SetDefDrawEnv(&db[0].draw,	0,	0,	320, 256);	//Screen Start XY, Width, Height  DrawBuffer 1
	SetDefDrawEnv(&db[1].draw,	0,	256, 	320, 256);	//Screen Start XY, Width, Height  DrawBuffer 2 Has to Start BELOW DrawBUFFER1
	SetDefDispEnv(&db[0].disp,	0,	256, 	320, 256);	//Same with DispBuffer (DrawBuffer 1 = DispBuffer 0!!)
	SetDefDispEnv(&db[1].disp,	0,	0,	320, 256);
	
	db[1].disp.screen.x = db[0].disp.screen.x = 0;
	db[1].disp.screen.y = db[0].disp.screen.y = 0;
	db[1].disp.screen.h = db[0].disp.screen.h = 256;		//PAL Screen Height
	db[1].disp.screen.w = db[0].disp.screen.w = 256;
	
	db[0].disp.isinter = db[1].disp.isinter = 0; 	// not interlaced
	db[0].draw.dtd = db[1].draw.dtd = 0; 		// 

	
}


void init_prim(DB *db)
{
	OpenTIM(&trsi);		                // Prepare Main Address for TIM Writing!!
	ReadTIM(&image);			// Create TIM Header!!!

	LoadImage(image.prect, image.paddr); 	// Transfer TIM that has been Created to VRAM!

	db->draw.isbg = 1;
	setRGB0(&db->draw, 0, 0, 0);	// clear buffer to black each frame

	SetPolyFT4(&(db->tile[0]));
	setXYWH(&(db->tile[0]), 32, 0, 255, 191);
	setUVWH(&(db->tile[0]), 0, 0, 255, 191);
	setRGB0(&(db->tile[0]), 127, 127, 127);
	(db->tile[0]).tpage = GetTPage(1, 1, 640, 0);   // 0 = 4 Bit, 1 = 8 Bit, 2 = 16 Bit
	(db->tile[0]).clut = GetClut(320, 256);

	SetPolyFT4(&(db->tile[1]));
	setXYWH(&(db->tile[1]), 32, 20, 255, 150);
	setUVWH(&(db->tile[1]), 0, 0, 255, 170);
	setRGB0(&(db->tile[1]), 127, 127, 127);
	(db->tile[1]).tpage = GetTPage(2, 1, 320, 0);

}


main()
{
	DB		db[2];
	DB		*cdb;
	int	Hpage=0;
	int 	x,y=0;

	MOD_Init();
	MOD_Load((unsigned char*)0x80100000);

	ResetCallback();
	ResetGraph(0);			/* reset graphic subsystem (0:cold,1:warm) */
	
	InitPAL(db);

	init_prim(&db[0]);		/* set primitive parameters on buffer #0 */
	init_prim(&db[1]);		/* set primitive parameters on buffer #1 */

	rect1.x = 640;
	rect1.y = 0;
	rect1.w = 160;
	rect1.h = 191;
	
	CalculateColors();

	LoadClut(&ColourTab, 320,256);

	MOD_Start();

	SetDispMask(1);			/* enable to display (0:inhibit, 1:enable) == BECAUSE OF THIS SHIT I ALWAYS HAD BLACK BITCHA SCREEN!*/
	
	while (1)
	{
		cdb = (cdb==db)? db+1: db;		/* swap double buffer ID */
		ClearOTagR(cdb->ot, OTSIZE);	/* clear ordering table */

		HeightBlob(sine[count], 100, 40, 255, Hpage);
		HeightBlob(160, sine[count+64]+20, 40, 255, Hpage);
		CalcWater(!Hpage);
		count++;

		LoadImage(&rect1, &Height[Hpage][0]);
		AddPrim(cdb->ot+OT_STARS,&(cdb->tile[0]));
		AddPrim(cdb->ot+OT_STARS,&(cdb->tile[1]));

		DrawSync(0);				/* wait for end of drawing */
		VSync(0);				/* wait for the next V-BLNK */
		PutDrawEnv(&cdb->draw);			/* update drawing environment --> double buffering switch */
		PutDispEnv(&cdb->disp);			/* update display environment */
		DrawOTag(cdb->ot+OTSIZE-1);		// draw the prims added to the OT
		Hpage = !Hpage;


	}
}


void CalcWater(int npage)      // THIS IS THE ROUTINE THAT WON'T FIT IN ONE FRAME!!! SHOULD BE OPTIMIZED IN ASM!!!
{
  int newh;
  int count = SCREEN_WD + 1;
  char *newptr = &Height[npage][0];
  char *oldptr = &Height[!npage][0];

  int x, y;

for (y = SCREEN_WD*191; count < y; count += 2)
  {
    for (x = count+SCREEN_WD-2; count < x; count++)
    {

      newh          = ((oldptr[count + SCREEN_WD]
                      + oldptr[count - SCREEN_WD]
                      + oldptr[count + 1]
                      + oldptr[count - 1]
                      + oldptr[count - SCREEN_WD - 1]
                      + oldptr[count - SCREEN_WD + 1]
                      + oldptr[count + SCREEN_WD - 1]
                      + oldptr[count + SCREEN_WD + 1]
                       ) >> 2 )
                      - newptr[count];

      newptr[count] = (newh < 0) ? 0 : (newh > 255) ? 255 : newh;
    }
  }
}



void HeightBlob(int x, int y, int radius, int height, int page)
{
  int rquad;
  int cx, cy, cyq;
  int left, top, right, bottom;

  rquad = 1600;		//radius * radius;

  left=-radius; right = radius;
  top=-radius; bottom = radius;

  for(cy = top; cy < bottom; cy++)
  {
    cyq = cy*cy;
    for(cx = left; cx < right; cx++)
    {
      if(cx*cx + cyq < rquad)
        Height[page][SCREEN_WD*(cy+y) + (cx+x)] = height;
    }
  }
}


void CalculateColors (void)
{
    int index;
    char  r,g,b;


for (index=0; index<32; index++)
     {

     r = index<<3;
     g = 0;
     b = 0;
     ColourTab[index] = GPACK_RGBA5551(r, g, b);

     }

for (index=32; index<96; index++)
     {
     r = 255;
     g = (index - 32)<<2;
     b = 0;

     ColourTab[index] = GPACK_RGBA5551(r, g, b);

     }

for (index=96; index<256; index++)
     {
     r = 255;
     g = 255;
     b = (index - 96) * 1.55;

     ColourTab[index] = GPACK_RGBA5551(r, g, b);

     }

}
