#version 130
#define MAX_LIGHTS 8

attribute vec3 tangent;

varying vec3 lightDir[MAX_LIGHTS];
varying vec3 lightVec[MAX_LIGHTS];
varying vec3 eyeVec2;
varying vec4 shadowCoord[5];
varying vec3 normal, eyeVec;

uniform int  numLights;
uniform int  numSpotLights;
uniform bool textureMapped;
uniform bool normalMapped;

void main()
{
  int i;

  vec3 vertexPosition = vec3(gl_ModelViewMatrix * gl_Vertex);
  normal = normalize (gl_NormalMatrix * gl_Normal);
  eyeVec = -vertexPosition;

  if (normalMapped)
  {
	vec3 t = normalize (gl_NormalMatrix * tangent);
	vec3 b = cross(normal, t); 

	eyeVec2.x = dot(eyeVec, t);
	eyeVec2.y = dot(eyeVec, b);
	eyeVec2.z = dot(eyeVec, normal);

	for (i=0; i < numLights; i++)
	{
		vec3 ldir = gl_LightSource[i].position.xyz - vertexPosition;

		lightVec[i].x = dot(ldir, t);
		lightVec[i].y = dot(ldir, b);
		lightVec[i].z = dot(ldir, normal);
	}
  }

  if (textureMapped)
	gl_TexCoord[0] = gl_MultiTexCoord0;

  for(i=0; i < numSpotLights; i++ )
	shadowCoord[i] = gl_TextureMatrix[i] * gl_Vertex;
  
  gl_Position = ftransform();

  for (i=0; i < numLights; i++)
    lightDir[i] = vec3(gl_LightSource[i].position.xyz - vertexPosition.xyz);
}