/*
 * Decompiled with CFR 0.152.
 */
package algebra;

import algebra.Algebra;
import algebra.Base;
import algebra.Matrix4f;
import algebra.Vector3f;
import algebra.Vector4f;
import algebra.transform.Transform;
import org.junit.Assert;
import org.junit.Test;
import util.RandomVectors;

public class AlgebraTest {
    public static final float epsilon = 1.0E-4f;

    @Test
    public void vectorMath() {
        Vector4f unitv = new Vector4f(1.0f, 0.0f, 0.0f);
        Vector4f nullv = new Vector4f(0.0f, 0.0f, 0.0f);
        Vector4f av = new Vector4f(1.0f, 3.0f, 9.0f);
        Vector4f bv = new Vector4f(8.0f, 4.0f, 2.0f);
        Assert.assertEquals(1.0, (double)Algebra.dot(unitv, unitv), (double)1.0E-4f);
        Assert.assertEquals(0.0, (double)Algebra.dot(unitv, nullv), (double)1.0E-4f);
        Assert.assertEquals(0.0, (double)Algebra.dot(nullv, unitv), (double)1.0E-4f);
        Assert.assertEquals(av.x, (double)Algebra.dot(av, unitv), (double)1.0E-4f);
        Assert.assertEquals(Algebra.dot(av, bv), (double)Algebra.dot(bv, av), (double)1.0E-4f);
        Assert.assertEquals(new Vector4f(0.0f, 0.0f, 0.0f), Algebra.sum(av, Algebra.neg(av)));
        Assert.assertEquals(Algebra.sum(av, Algebra.neg(bv)), Algebra.substract(av, bv));
        Assert.assertEquals(new Vector4f(1.0f, 0.0f, 0.0f), Algebra.cross(new Vector4f(0.0f, 1.0f, 0.0f), new Vector4f(0.0f, 0.0f, 1.0f)));
        Assert.assertEquals(50.0, (double)Algebra.length(new Vector4f(0.0f, 50.0f, 0.0f)), (double)1.0E-4f);
        Assert.assertEquals(50.0, (double)Algebra.length(new Vector4f(0.0f, 40.0f, 30.0f)), (double)1.0E-4f);
        Assert.assertEquals(1.0, (double)Algebra.cosAngle(av, Algebra.scalar(av, 0.3f)), (double)1.0E-4f);
        Assert.assertEquals(0.0, (double)Algebra.cosAngle(new Vector4f(1.0f, 1.0f, 0.0f), new Vector4f(-1.0f, 1.0f, 0.0f)), (double)1.0E-4f);
        Assert.assertEquals(Math.PI, (double)Algebra.angle(av, Algebra.scalar(av, -1.3f)), (double)1.0E-4f);
        Assert.assertEquals(unitv, Algebra.unit(unitv));
        Assert.assertEquals(Algebra.cosAngle(Algebra.unit(av), bv), (double)Algebra.cosAngle(av, Algebra.unit(bv)), (double)1.0E-4f);
        Assert.assertEquals(1.0, (double)Algebra.length(Algebra.unit(bv)), (double)1.0E-4f);
        Assert.assertTrue(Algebra.isUnit(unitv));
        Assert.assertTrue(Algebra.isUnit(Algebra.neg(unitv)));
        Assert.assertTrue(Algebra.isUnit(new RandomVectors(1L).nextUnit4f()));
    }

    @Test
    public void matrixMath() {
        Matrix4f unitm = Transform.identity();
        Matrix4f nullm = Transform.empty();
        Matrix4f am = new Matrix4f(1.0f, 5.0f, 8.0f, 7.0f, 4.0f, 5.0f, 6.0f, 5.0f, 2.0f, 3.0f, 8.0f, 5.0f, 4.0f, 2.0f, 6.0f, 5.0f);
        Matrix4f bm = new Matrix4f(8.0f, 4.0f, 2.0f, 3.0f, 5.0f, 1.0f, 7.0f, 9.0f, 8.0f, 5.0f, 2.0f, 4.0f, 6.0f, 3.0f, 2.0f, 0.0f);
        Matrix4f cm = new Matrix4f(9.0f, 8.0f, 7.0f, 4.0f, 5.0f, 6.0f, 3.0f, 2.0f, 1.0f, 4.0f, 5.0f, 8.0f, 7.0f, 6.0f, 3.0f, 2.0f);
        Assert.assertEquals(unitm, Algebra.multMatrix(unitm, unitm));
        Assert.assertEquals(am, Algebra.multMatrix(am, unitm));
        Assert.assertEquals(am, Algebra.multMatrix(unitm, am));
        Assert.assertEquals(nullm, Algebra.multMatrix(am, nullm));
        Assert.assertEquals(nullm, Algebra.multMatrix(nullm, am));
        Assert.assertFalse(Algebra.multMatrix(am, bm).equals(Algebra.multMatrix(bm, am)));
        Assert.assertEquals(Algebra.multMatrix(am, Algebra.multMatrix(bm, cm)), Algebra.multMatrix(Algebra.multMatrix(am, bm), cm));
    }

    @Test
    public void mtrxvecMath() {
        Vector4f unitv = new Vector4f(1.0f, 0.0f, 0.0f);
        Vector4f nullv = new Vector4f(0.0f, 0.0f, 0.0f);
        Vector4f av = new Vector4f(1.0f, 3.0f, 9.0f);
        Matrix4f unitm = Transform.identity();
        Matrix4f nullm = Transform.empty();
        Assert.assertEquals(av, Algebra.multVector4f(unitm, av));
        Assert.assertEquals(new Vector4f(0.0f, 0.0f, 0.0f, 0.0f), Algebra.multVector4f(nullm, av));
        Assert.assertEquals(new Vector4f(3.0f, 0.0f, 0.0f), Algebra.multVector4f(Transform.scale(3.0f), unitv));
        Assert.assertEquals(new Vector4f(1.0f, 2.0f, 3.0f), Algebra.multVector4f(Transform.translate(1.0f, 2.0f, 3.0f), nullv));
    }

    @Test
    public void base() {
        Base sillyBase = new Base(Base.STANDARD.w, Base.STANDARD.v);
        Assert.assertEquals(Base.STANDARD, sillyBase);
        Base fromSkewed = new Base(new Vector3f(0.0f, 0.0f, 5.0f), new Vector3f(0.0f, 50.0f, -3.0f));
        Assert.assertEquals(Base.STANDARD, fromSkewed);
    }
}

