/*
 * Decompiled with CFR 0.152.
 */
package algebra.transform;

import algebra.Matrix4f;

public class Transform {
    public static Matrix4f empty() {
        return new Matrix4f();
    }

    public static Matrix4f identity() {
        return new Matrix4f(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, true);
    }

    public static Matrix4f translate(float x, float y, float z) {
        if (x == 0.0f && y == 0.0f && z == 0.0f) {
            return Transform.identity();
        }
        return new Matrix4f(1.0f, 0.0f, 0.0f, x, 0.0f, 1.0f, 0.0f, y, 0.0f, 0.0f, 1.0f, z, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public static Matrix4f scale(float s) {
        if (s == 1.0f) {
            return Transform.identity();
        }
        return Transform.scale(s, s, s);
    }

    public static Matrix4f scale(float x, float y, float z) {
        return new Matrix4f(x, 0.0f, 0.0f, 0.0f, 0.0f, y, 0.0f, 0.0f, 0.0f, 0.0f, z, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public static Matrix4f rotateX(float a) {
        if (a == 0.0f) {
            return Transform.identity();
        }
        float s = (float)Math.sin(a);
        float c = (float)Math.cos(a);
        return new Matrix4f(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, c, -s, 0.0f, 0.0f, s, c, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public static Matrix4f rotateY(float a) {
        if (a == 0.0f) {
            return Transform.identity();
        }
        float s = (float)Math.sin(a);
        float c = (float)Math.cos(a);
        return new Matrix4f(c, 0.0f, s, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -s, 0.0f, c, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public static Matrix4f rotateZ(float a) {
        if (a == 0.0f) {
            return Transform.identity();
        }
        float s = (float)Math.sin(a);
        float c = (float)Math.cos(a);
        return new Matrix4f(c, -s, 0.0f, 0.0f, s, c, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }
}

