/*
 * Decompiled with CFR 0.152.
 */
package geometry;

import algebra.Algebra;
import algebra.Vector3f;
import geometry.Geometry;
import geometry.Sphere;
import geometry.Triangle;
import geometry.ray.Ray;
import geometry.ray.TestRay;
import org.junit.Assert;
import org.junit.Test;

public class GeoTest {
    public static final float delta = 1.0E-4f;

    @Test
    public void sphere() {
        Sphere sphere = new Sphere(new Vector3f(0.0f, 0.0f, 20.0f), 1.0f);
        TestRay rayFull = new TestRay(Vector3f.O, new Vector3f(0.0f, 0.0f, 1.0f));
        TestRay rayTangent = new TestRay(new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f));
        TestRay rayTangentBot = new TestRay(new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f));
        TestRay rayMiss = new TestRay(new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f));
        TestRay rayWhatever = new TestRay(new Vector3f(0.5f, 0.5f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f));
        Assert.assertEquals(19.0, (double)((Geometry)sphere).intersect((Ray)rayFull).t, (double)1.0E-4f);
        Assert.assertEquals(20.0, (double)((Geometry)sphere).intersect((Ray)rayTangent).t, (double)1.0E-4f);
        Assert.assertEquals(20.0, (double)((Geometry)sphere).intersect((Ray)rayTangentBot).t, (double)1.0E-4f);
        Assert.assertEquals(null, ((Geometry)sphere).intersect(rayMiss));
        Assert.assertTrue(Algebra.isUnit(((Geometry)sphere).intersect(rayWhatever).getNormal()));
        Assert.assertEquals(sphere, ((Geometry)sphere).intersect((Ray)rayWhatever).hit);
    }

    @Test
    public void tri() {
        Triangle tri = new Triangle(Vector3f.I, Vector3f.J, Vector3f.K, Vector3f.I, Vector3f.J, Vector3f.K);
        TestRay rayFull = new TestRay(Vector3f.O, Algebra.unit(new Vector3f(1.0f, 1.0f, 1.0f)));
        TestRay rayWE = new TestRay(Vector3f.O, Algebra.unit(new Vector3f(5.0f, 3.0f, 9.0f)));
        TestRay rayMiss = new TestRay(Vector3f.O, Algebra.unit(new Vector3f(5.0f, -3.0f, 9.0f)));
        TestRay rayTanPA = new TestRay(Vector3f.O, Vector3f.I);
        TestRay rayTanPB = new TestRay(Vector3f.O, Vector3f.J);
        TestRay rayTanPC = new TestRay(Vector3f.O, Vector3f.K);
        TestRay rayTanBA = new TestRay(Vector3f.O, Algebra.unit(new Vector3f(1.0f, 1.0f, 0.0f)));
        TestRay rayTanBB = new TestRay(Vector3f.O, Algebra.unit(new Vector3f(0.0f, 1.0f, 1.0f)));
        TestRay rayTanBC = new TestRay(Vector3f.O, Algebra.unit(new Vector3f(1.0f, 0.0f, 1.0f)));
        TestRay rayTanWE = new TestRay(Vector3f.O, Algebra.unit(new Vector3f(5.0f, 0.0f, 3.0f)));
        Assert.assertEquals(Math.sqrt(0.3333333432674408), (double)((Geometry)tri).intersect((Ray)rayFull).t, (double)1.0E-4f);
        Assert.assertEquals(1.0, (double)((Geometry)tri).intersect((Ray)rayTanPA).t, (double)1.0E-4f);
        Assert.assertEquals(1.0, (double)((Geometry)tri).intersect((Ray)rayTanPB).t, (double)1.0E-4f);
        Assert.assertEquals(1.0, (double)((Geometry)tri).intersect((Ray)rayTanPC).t, (double)1.0E-4f);
        Assert.assertEquals(Math.sqrt(0.5), (double)((Geometry)tri).intersect((Ray)rayTanBA).t, (double)1.0E-4f);
        Assert.assertEquals(Math.sqrt(0.5), (double)((Geometry)tri).intersect((Ray)rayTanBB).t, (double)1.0E-4f);
        Assert.assertEquals(Math.sqrt(0.5), (double)((Geometry)tri).intersect((Ray)rayTanBC).t, (double)1.0E-4f);
        Assert.assertEquals(tri, ((Geometry)tri).intersect((Ray)rayTanWE).hit);
        Assert.assertTrue(Algebra.isUnit(((Geometry)tri).intersect(rayWE).getNormal()));
        Assert.assertEquals(null, ((Geometry)tri).intersect(rayMiss));
        Assert.assertEquals(0.5, (double)new Triangle(Vector3f.I, Vector3f.J, Vector3f.O, Vector3f.I, Vector3f.J, Vector3f.K).getArea(), (double)1.0E-4f);
    }
}

