/*
 * Decompiled with CFR 0.152.
 */
package geometry;

import algebra.Algebra;
import algebra.TexCoord2f;
import algebra.Vector3f;
import geometry.Geometry;
import geometry.ray.Ray;
import geometry.ray.RayResult;

public class Sphere
extends Geometry {
    public final Vector3f m;
    public final float r;
    private final float area;

    public Sphere(Vector3f m, float r) {
        this.m = m;
        this.r = r;
        this.area = (float)(Math.PI * 4 * (double)r * (double)r);
    }

    @Override
    public RayResult intersect(Ray ray) {
        double c;
        double a = Algebra.dot1(ray.d);
        double b = 2.0f * Algebra.dot(ray.d, Algebra.substract(ray.e, this.m));
        double discr = b * b - 4.0 * a * (c = (double)(Algebra.dot1(Algebra.substract(ray.e, this.m)) - this.r * this.r));
        if (discr < 0.0) {
            return null;
        }
        float q = (float)(-0.5 * (b - Math.signum(b) * Math.sqrt(discr)));
        float t = (float)((double)q / a);
        if (t < 0.0f) {
            t = (float)(c / (double)q);
        }
        if (t < 0.0f) {
            return null;
        }
        return new RaySphereResult(ray, t, this);
    }

    @Override
    public Vector3f getMin() {
        return Algebra.substract(this.m, new Vector3f(this.r, this.r, this.r));
    }

    @Override
    public Vector3f getMax() {
        return Algebra.sum(this.m, new Vector3f(this.r, this.r, this.r));
    }

    @Override
    public float getArea() {
        return this.area;
    }

    public class RaySphereResult
    extends RayResult {
        public RaySphereResult(Ray ray, float t, Geometry hit) {
            super(ray, t, hit);
        }

        @Override
        public Vector3f calcNormal() {
            return Algebra.unit(Algebra.substract(this.getObjectLocation(), Sphere.this.m));
        }

        @Override
        protected TexCoord2f calcTexCoord() {
            double cosTheta = (this.getObjectLocation().z - Sphere.this.m.z) / Sphere.this.r;
            double theta = Math.acos(Math.max(-1.0, Math.min(1.0, cosTheta)));
            double phi = Math.atan2(this.getObjectLocation().y - Sphere.this.m.y, this.getObjectLocation().x - Sphere.this.m.x);
            if (phi < 0.0) {
                phi += Math.PI * 2;
            }
            double invPI = 0.3183098861837907;
            double u = phi * 0.5 * 0.3183098861837907;
            double v = (Math.PI - theta) * 0.3183098861837907;
            return new TexCoord2f((float)u, (float)v);
        }
    }
}

