/*
 * Decompiled with CFR 0.152.
 */
package geometry.bounding;

import algebra.Algebra;
import algebra.Vector3f;
import geometry.Geometry;
import java.util.Arrays;
import java.util.Collection;

public abstract class BoxUtil {
    public static Vector3f minGeometries(Collection<Geometry> collection) {
        Vector3f minVec = new Vector3f(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
        for (Geometry i : collection) {
            minVec = Algebra.min(minVec, i.getMin());
        }
        return minVec;
    }

    public static Vector3f maxGeometries(Collection<Geometry> collection) {
        Vector3f maxVec = new Vector3f(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
        for (Geometry i : collection) {
            maxVec = Algebra.max(maxVec, i.getMax());
        }
        return maxVec;
    }

    public static Vector3f minGeometries(Geometry[] array) {
        return BoxUtil.minGeometries(Arrays.asList(array));
    }

    public static Vector3f maxGeometries(Geometry[] array) {
        return BoxUtil.maxGeometries(Arrays.asList(array));
    }
}

