/*
 * Decompiled with CFR 0.152.
 */
package geometry.bounding;

import algebra.Algebra;
import algebra.Vector3f;
import geometry.Geometry;
import geometry.bounding.BoxUtil;
import geometry.ray.Ray;
import geometry.ray.RayResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;

public class GridBox
implements Serializable {
    private final int density = 4;
    private final Vector3f min;
    private final Vector3f max;
    private final Vector3f mid;
    private final float[] minAr;
    private final float[] maxAr;
    private final int mx;
    private final int my;
    private final int mz;
    private final int m;
    private final float dx;
    private final float dy;
    private final float dz;
    private final int[] N;
    private final int[] C;
    private final Geometry[] L;

    public GridBox(Collection<Geometry> objects) {
        this.min = BoxUtil.minGeometries(objects);
        this.max = BoxUtil.maxGeometries(objects);
        this.mid = Algebra.scalar(Algebra.sum(this.min, this.max), 0.5f);
        this.minAr = this.min.getArray();
        this.maxAr = this.max.getArray();
        double volume = (this.max.x - this.min.x) * (this.max.y - this.min.y) * (this.max.z - this.min.z);
        double root = Math.pow((double)(4 * objects.size()) / volume, 0.3333333333333333);
        this.mx = (int)((double)(this.max.x - this.min.x) * root);
        this.my = (int)((double)(this.max.y - this.min.y) * root);
        this.mz = (int)((double)(this.max.z - this.min.z) * root);
        this.m = this.mx * this.my * this.mz;
        this.dx = (this.max.x - this.min.x) / (float)this.mx;
        this.dy = (this.max.y - this.min.y) / (float)this.my;
        this.dz = (this.max.z - this.min.z) / (float)this.mz;
        System.out.println(String.valueOf(this.mx) + " " + this.my + " " + this.mz);
        ArrayList grid = new ArrayList(this.m);
        int i = 0;
        while (i < this.m) {
            grid.add(new LinkedList());
            ++i;
        }
        int sizeL = 0;
        for (Geometry g : objects) {
            Vector3f gMin = Algebra.substract(g.getMin(), this.min);
            Vector3f gMax = Algebra.substract(g.getMax(), this.min);
            int gx = (int)(gMin.x / this.dx);
            while ((double)gx <= Math.ceil(gMax.x / this.dx)) {
                int gy = (int)(gMin.y / this.dy);
                while ((double)gy <= Math.ceil(gMax.y / this.dy)) {
                    int gz = (int)(gMin.z / this.dz);
                    while ((double)gz <= Math.ceil(gMax.z / this.dz)) {
                        ((LinkedList)grid.get((this.my * gz + gy) * this.mz + gx)).add(g);
                        ++sizeL;
                        ++gz;
                    }
                    ++gy;
                }
                ++gx;
            }
        }
        this.L = new Geometry[sizeL];
        this.N = new int[this.m];
        this.C = new int[this.m + 1];
        int iL = 0;
        int i2 = 0;
        while (i2 < grid.size()) {
            LinkedList iList = (LinkedList)grid.get(i2);
            this.N[i2] = iList.size();
            this.C[i2] = iList.size();
            for (Geometry g : iList) {
                this.L[iL++] = g;
            }
            ++i2;
        }
        i2 = 1;
        while (i2 <= this.m) {
            int n = i2;
            this.C[n] = this.C[n] + this.C[i2 - 1];
            ++i2;
        }
    }

    public RayResult intersect(Ray ray) {
        if (!this.hitBox(ray, this.minAr, this.maxAr)) {
            return null;
        }
        RayResult returnResult = null;
        int x = 0;
        while (x < this.mx) {
            int y = 0;
            while (y < this.my) {
                int z = 0;
                while (z < this.mz) {
                    float[] maxB;
                    float[] minB;
                    int i = (this.my * z + y) * this.mz + x;
                    if (this.N[i] > 0 && this.hitBox(ray, minB = new float[]{this.min.x + (float)x * this.dx, this.min.y + (float)y * this.dy, this.min.z + (float)z * this.dz}, maxB = new float[]{this.min.x + (float)(x + 1) * this.dx, this.min.y + (float)(y + 1) * this.dy, this.min.z + (float)(z + 1) * this.dz})) {
                        ray.countHit();
                        int j = this.C[i];
                        while (j < this.C[i + 1]) {
                            RayResult iResult = this.L[j].intersect(ray);
                            if (returnResult == null || iResult != null && returnResult.t > iResult.t) {
                                returnResult = iResult;
                            }
                            ++j;
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return returnResult;
    }

    public Vector3f getMin() {
        return this.min;
    }

    public Vector3f getMax() {
        return this.max;
    }

    public Vector3f getMid() {
        return this.mid;
    }

    private boolean hitBox(Ray ray, float[] minAr, float[] maxAr) {
        float near = Float.NEGATIVE_INFINITY;
        float far = Float.POSITIVE_INFINITY;
        float[] e = ray.e.getArray();
        float[] d = ray.d.getArray();
        int i = 0;
        while (i < 3) {
            float tmax;
            float tmin;
            float a = 1.0f / d[i];
            if (a >= 0.0f) {
                tmin = a * (minAr[i] - e[i]);
                tmax = a * (maxAr[i] - e[i]);
            } else {
                tmin = a * (maxAr[i] - e[i]);
                tmax = a * (minAr[i] - e[i]);
            }
            near = Math.max(near, tmin);
            far = Math.min(far, tmax);
            if (near > far) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

