/*
 * Decompiled with CFR 0.152.
 */
package geometry.bounding;

import algebra.Algebra;
import algebra.Vector3f;
import geometry.Geometry;
import geometry.bounding.BoxUtil;
import geometry.ray.Ray;
import geometry.ray.RayResult;
import java.io.Serializable;
import java.util.Collection;

public abstract class KDBox
implements Serializable {
    private final Vector3f min;
    private final Vector3f max;
    private final Vector3f mid;
    private final float[] minAr;
    private final float[] maxAr;
    private final int depth;
    final int lowerBound;

    public KDBox(Collection<Geometry> objects, int lowerBound, int depth) {
        this.depth = depth;
        this.min = BoxUtil.minGeometries(objects);
        this.max = BoxUtil.maxGeometries(objects);
        this.minAr = this.min.getArray();
        this.maxAr = this.max.getArray();
        this.mid = Algebra.scalar(Algebra.sum(this.min, this.max), 0.5f);
        this.lowerBound = lowerBound;
    }

    public boolean hitBox(Ray ray) {
        ray.countHit();
        float near = Float.NEGATIVE_INFINITY;
        float far = Float.POSITIVE_INFINITY;
        float[] e = ray.e.getArray();
        float[] d = ray.d.getArray();
        int i = 0;
        while (i < 3) {
            float tmax;
            float tmin;
            float a = 1.0f / d[i];
            if (a >= 0.0f) {
                tmin = a * (this.minAr[i] - e[i]);
                tmax = a * (this.maxAr[i] - e[i]);
            } else {
                tmin = a * (this.maxAr[i] - e[i]);
                tmax = a * (this.minAr[i] - e[i]);
            }
            near = Math.max(near, tmin);
            far = Math.min(far, tmax);
            if (near > far) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public abstract RayResult searchBox(Ray var1);

    public Vector3f getMin() {
        return this.min;
    }

    public Vector3f getMax() {
        return this.max;
    }

    public Vector3f getMid() {
        return this.mid;
    }

    public int getDepth() {
        return this.depth;
    }
}

