/*
 * Decompiled with CFR 0.152.
 */
package geometry.ray;

import algebra.Algebra;
import algebra.Color3f;
import algebra.Matrix4f;
import algebra.Vector3f;
import geometry.ray.Ray;
import geometry.ray.RayResult;
import scene.Scene;

public class ShadingRay
extends Ray {
    private final float recursionFactor;
    private final boolean isInside;

    public ShadingRay(Vector3f e, Vector3f d) {
        this(e, d, 1.0f, false);
    }

    public ShadingRay(Vector3f e, Vector3f d, float recursionFactor) {
        this(e, d, recursionFactor, false);
    }

    public ShadingRay(Vector3f e, Vector3f d, float recursionFactor, boolean isInside) {
        super(e, d);
        this.recursionFactor = recursionFactor;
        this.isInside = isInside;
    }

    public Color3f shoot(Scene scene) {
        RayResult rayResult = scene.intersect(this);
        if (rayResult != null) {
            return rayResult.getMaterial().shade(scene, rayResult);
        }
        return Color3f.BLACK;
    }

    public float getRecursionFactor() {
        return this.recursionFactor;
    }

    public boolean isInside() {
        return this.isInside;
    }

    @Override
    public Ray cloneTransformed(Matrix4f m) {
        Vector3f e = Algebra.multPoint(m, this.e);
        Vector3f d = Algebra.multArrow(m, this.d);
        return new ShadingRay(e, d, this.recursionFactor, this.isInside);
    }
}

