/*
 * Decompiled with CFR 0.152.
 */
package io.scenes;

import algebra.Algebra;
import algebra.Color3f;
import algebra.Vector3f;
import algebra.transform.Transform;
import geometry.Geometry;
import geometry.NegaSphere;
import geometry.Sphere;
import geometry.Triangle;
import io.boxIO.KDBoxIO;
import io.meshParser.MeshParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import scene.Scene;
import scene.SetScene;
import scene.SingleScene;
import scene.graph.SceneGraph;
import scene.graph.SceneGraphPart;
import scene.graph.SceneLeaf;
import scene.graph.SceneNode;
import scene.light.AmbientLight;
import scene.light.DirectionalLight;
import scene.light.GaussianLight;
import scene.light.Light;
import scene.light.PointLight;
import scene.light.SphereLight;
import scene.material.FlatMaterial;
import scene.material.LambertianMaterial;
import scene.material.Material;
import scene.material.PhongMaterial;
import scene.material.RecursiveMaterial;
import scene.material.texture.ImageTexture;
import scene.material.texture.MarbleTexture;
import scene.material.texture.MatteTexture;
import scene.material.texture.NormalTexture;
import scene.material.texture.OilTexture;
import scene.material.texture.TestTexture;
import scene.material.texture.Texture;
import scene.material.texture.combinators.TexMult;
import scene.model.KDModel;
import scene.model.SetModel;
import scene.model.SingleModel;
import tracer.camera.Camera;
import tracer.camera.DOFCamera;
import tracer.camera.PerspectiveCamera;
import util.RandomVectors;

public class Scenes {
    static Material marble = new PhongMaterial(new MarbleTexture(), new NormalTexture(), 35.0f);

    public static Scene getBunny(int w, int h) {
        ArrayList<Light> lights = new ArrayList<Light>();
        float intensity = 0.4f;
        float blur = 4.0f;
        lights.add(new SphereLight(Color3f.PINK.mult(intensity), new Vector3f(-21.0f, 23.0f, -22.0f), blur));
        lights.add(new SphereLight(Color3f.YELLOW.mult(intensity), new Vector3f(-7.0f, 21.0f, 22.0f), blur));
        lights.add(new SphereLight(Color3f.CYAN.mult(intensity), new Vector3f(22.0f, 21.0f, -7.0f), blur));
        lights.add(new SphereLight(Color3f.PINK.mult(intensity), new Vector3f(21.0f, 23.0f, 22.0f), blur));
        lights.add(new SphereLight(Color3f.YELLOW.mult(intensity), new Vector3f(7.0f, 21.0f, -22.0f), blur));
        lights.add(new SphereLight(Color3f.CYAN.mult(intensity), new Vector3f(-22.0f, 21.0f, 7.0f), blur));
        RecursiveMaterial material = new RecursiveMaterial(new MatteTexture(0.8f), new MatteTexture(0.2f), 17.0f, 0.09f, 0.2f);
        MeshParser meshParser = new MeshParser("OBJ/bunny.obj", false);
        KDModel model = new KDModel((Material)material, meshParser.getTriangles());
        RecursiveMaterial mirror = new RecursiveMaterial(new MatteTexture(0.55f), new NormalTexture(), 5.0f, 0.03f, 0.95f);
        float min = 0.15f;
        SingleModel ground = new SingleModel(mirror, new Triangle(new Vector3f(-20.0f, min, -20.0f), new Vector3f(-5.0f, min, 20.0f), new Vector3f(20.0f, min, -5.0f), Vector3f.J, Vector3f.J, Vector3f.J));
        RecursiveMaterial glass = new RecursiveMaterial(new MatteTexture(0.2f), new TexMult((Texture)new NormalTexture(), 0.6f), 10.0f, 0.03f, 0.2f, 0.9f, 1.7f);
        SingleModel ball = new SingleModel(glass, new Sphere(new Vector3f(3.0f, 5.0f, 1.0f), 1.2f));
        Vector3f lookAt = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f cameraPos = new Vector3f(10.0f, 10.0f, 10.0f);
        Vector3f d = Algebra.substract(lookAt, cameraPos);
        float fl = Algebra.length(d);
        PerspectiveCamera camera = new PerspectiveCamera(cameraPos, d, Vector3f.J, w, h, 0.0145f, fl);
        return new SetScene(lights, (Camera)camera, model, ground, ball);
    }

    public static Scene getSharpBunny(int w, int h) {
        ArrayList<Light> lights = new ArrayList<Light>();
        float intensity = 0.4f;
        float blur = 4.0f;
        lights.add(new PointLight(Color3f.PINK.mult(intensity), new Vector3f(-21.0f, 23.0f, -22.0f)));
        lights.add(new PointLight(Color3f.YELLOW.mult(intensity), new Vector3f(-7.0f, 21.0f, 22.0f)));
        lights.add(new PointLight(Color3f.CYAN.mult(intensity), new Vector3f(22.0f, 21.0f, -7.0f)));
        lights.add(new PointLight(Color3f.PINK.mult(intensity), new Vector3f(21.0f, 23.0f, 22.0f)));
        lights.add(new PointLight(Color3f.YELLOW.mult(intensity), new Vector3f(7.0f, 21.0f, -22.0f)));
        lights.add(new PointLight(Color3f.CYAN.mult(intensity), new Vector3f(-22.0f, 21.0f, 7.0f)));
        RecursiveMaterial material = new RecursiveMaterial(new MatteTexture(0.8f), new MatteTexture(0.2f), 17.0f, 0.0f, 0.2f);
        MeshParser meshParser = new MeshParser("OBJ/bunny.obj", false);
        KDModel model = new KDModel((Material)material, meshParser.getTriangles());
        RecursiveMaterial mirror = new RecursiveMaterial(new MatteTexture(0.55f), new NormalTexture(), 5.0f, 0.0f, 0.95f);
        float min = 0.15f;
        SingleModel ground = new SingleModel(mirror, new Triangle(new Vector3f(-20.0f, min, -20.0f), new Vector3f(-5.0f, min, 20.0f), new Vector3f(20.0f, min, -5.0f), Vector3f.J, Vector3f.J, Vector3f.J));
        RecursiveMaterial glass = new RecursiveMaterial(new MatteTexture(0.2f), new TexMult((Texture)new NormalTexture(), 0.6f), 10.0f, 0.0f, 0.2f, 0.9f, 1.7f);
        SingleModel ball = new SingleModel(glass, new Sphere(new Vector3f(3.0f, 5.0f, 1.0f), 1.2f));
        Vector3f lookAt = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f cameraPos = new Vector3f(10.0f, 10.0f, 10.0f);
        Vector3f d = Algebra.substract(lookAt, cameraPos);
        float fl = Algebra.length(d);
        PerspectiveCamera camera = new PerspectiveCamera(cameraPos, d, Vector3f.J, w, h, 0.0145f, fl);
        return new SetScene(lights, (Camera)camera, model, ground, ball);
    }

    public static Scene getTrip(int w, int h) {
        ArrayList<Light> lights = new ArrayList<Light>();
        RandomVectors randomVectors = new RandomVectors(97L);
        float intensity = 0.4f;
        float blur = 4.0f;
        float scalar = 50.0f;
        int i = 0;
        while (i < 1000) {
            lights.add(new PointLight(Color3f.PINK.mult(intensity), Algebra.scalar(randomVectors.nextUnit3f(), scalar)));
            lights.add(new PointLight(Color3f.YELLOW.mult(intensity), Algebra.scalar(randomVectors.nextUnit3f(), scalar)));
            lights.add(new PointLight(Color3f.CYAN.mult(intensity), Algebra.scalar(randomVectors.nextUnit3f(), scalar)));
            ++i;
        }
        PhongMaterial m = new PhongMaterial(new MatteTexture(0.0f), new MatteTexture(1.0f), 650.0f);
        float min = 0.15f;
        Triangle ground = new Triangle(new Vector3f(-20.0f, min, -20.0f), new Vector3f(-5.0f, min, 20.0f), new Vector3f(20.0f, min, -5.0f), Vector3f.J, Vector3f.J, Vector3f.J);
        Sphere sphere = new Sphere(new Vector3f(0.0f, 1.0f, 0.0f), 1.0f);
        Sphere sphere2 = new Sphere(new Vector3f(-0.5f, 2.0f, 1.0f), 0.5f);
        Sphere sphere3 = new Sphere(new Vector3f(2.0f, 0.0f, 0.0f), 0.5f);
        List<Geometry> balls = Arrays.asList(sphere, sphere2, sphere3);
        SingleModel model = new SingleModel(m, sphere);
        Vector3f lookAt = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f cameraPos = new Vector3f(10.0f, 10.0f, 10.0f);
        Vector3f d = Algebra.substract(lookAt, cameraPos);
        float fl = Algebra.length(d);
        PerspectiveCamera camera = new PerspectiveCamera(cameraPos, d, Vector3f.J, w, h, 0.0045f, fl);
        return new SingleScene(lights, camera, model);
    }

    public static Scene getTree(int w, int h, boolean parse) {
        KDModel leavesModel;
        KDModel treeModel;
        ArrayList<Light> lights = new ArrayList<Light>();
        lights.add(new GaussianLight(new Color3f(1.0f, 0.0f, 0.0f), new Vector3f(-4.0f, 6.0f, 4.0f), 0.8f));
        lights.add(new GaussianLight(new Color3f(0.0f, 1.0f, 0.0f), new Vector3f(3.0f, 6.0f, 16.0f), 1.3f));
        lights.add(new GaussianLight(new Color3f(0.0f, 0.0f, 1.0f), new Vector3f(-4.0f, 6.0f, -4.0f), 0.8f));
        LambertianMaterial treeMat = new LambertianMaterial(new NormalTexture());
        PhongMaterial leavesMat = new PhongMaterial(new MatteTexture(0.2f, 1.0f, 0.05f), new MatteTexture(new Color3f(1.0f, 0.4f, 0.2f)), 35.0f);
        Triangle ground = new Triangle(new Vector3f(-20.0f, 0.0f, -20.0f), new Vector3f(-5.0f, 0.0f, 20.0f), new Vector3f(20.0f, 0.0f, -5.0f), Vector3f.J, Vector3f.J, Vector3f.J);
        if (parse) {
            Collection<Geometry> treeMesh = new MeshParser("OBJ/tree.obj", false).getTriangles();
            Collection<Geometry> leavesMesh = new MeshParser("OBJ/leaves.obj", false).getTriangles();
            treeMesh.add(ground);
            treeModel = new KDModel((Material)treeMat, treeMesh);
            leavesModel = new KDModel((Material)leavesMat, leavesMesh);
            KDBoxIO.write(treeModel.getBox(), "OBJ/tree.mod");
            KDBoxIO.write(leavesModel.getBox(), "OBJ/leaves.mod");
        } else {
            treeModel = new KDModel((Material)treeMat, KDBoxIO.read("OBJ/tree.mod"));
            leavesModel = new KDModel((Material)leavesMat, KDBoxIO.read("OBJ/leaves.mod"));
        }
        Vector3f lookAt = new Vector3f(0.3f, 3.3f, 0.03f);
        Vector3f cameraPos = new Vector3f(20.0f, 20.0f, 20.0f);
        Vector3f d = Algebra.substract(lookAt, cameraPos);
        float fl = Algebra.length(d);
        DOFCamera camera = new DOFCamera(cameraPos, d, Vector3f.J, w, h, 0.0101499995f, fl, 0.8f);
        return new SetScene(lights, (Camera)camera, treeModel, leavesModel);
    }

    public static Scene getVenus(int w, int h, boolean parse) {
        KDModel model;
        String fileName = "OBJ/venus.mod";
        ArrayList<Light> lights = new ArrayList<Light>();
        lights.add(new GaussianLight(Color3f.VANILLE, new Vector3f(-8.0f, 12.0f, 8.0f), 1.0f));
        lights.add(new GaussianLight(Color3f.VANILLE, new Vector3f(6.0f, 12.0f, 30.0f), 1.0f));
        lights.add(new GaussianLight(Color3f.VANILLE, new Vector3f(-8.0f, 16.0f, -8.0f), 1.0f));
        PhongMaterial material = new PhongMaterial(new MarbleTexture(), new MatteTexture(Color3f.LATTE), 70.0f);
        if (parse) {
            MeshParser meshParser = new MeshParser("OBJ/venus.obj", false);
            Collection<Geometry> meshTris = meshParser.getTriangles();
            model = new KDModel((Material)material, meshTris);
            KDBoxIO.write(model.getBox(), fileName);
        } else {
            model = new KDModel((Material)material, KDBoxIO.read(fileName));
        }
        Vector3f lookAt = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f cameraPos = new Vector3f(15.0f, 15.0f, 15.0f);
        Vector3f d = Algebra.substract(lookAt, cameraPos);
        float fl = Algebra.length(d);
        PerspectiveCamera camera = new PerspectiveCamera(cameraPos, d, Vector3f.J, w, h, 0.01f, fl);
        return new SingleScene(lights, camera, model);
    }

    public static Scene getBudda(int w, int h, boolean parse) {
        KDModel budda;
        String fileName = "OBJ/123/buddatex.mod";
        ArrayList<Light> lights = new ArrayList<Light>();
        RecursiveMaterial textureMaterial = new RecursiveMaterial(new MatteTexture(0.0f), new MatteTexture(0.0f), new ImageTexture("OBJ/123/budda.jpg"), 25.0f, 2.0f, 0.8f);
        RecursiveMaterial ballMaterial = new RecursiveMaterial(new MatteTexture(0.0f), new OilTexture(), 6.0f, 0.03f, 0.3f, 0.5f, 1.27f);
        if (parse) {
            MeshParser meshParser = new MeshParser("OBJ/123/buddatex.obj", true);
            Collection<Geometry> meshTris = meshParser.getTriangles();
            budda = new KDModel((Material)textureMaterial, meshTris);
            KDBoxIO.write(budda.getBox(), fileName);
        } else {
            budda = new KDModel((Material)textureMaterial, KDBoxIO.read(fileName));
        }
        KDModel balls = new KDModel((Material)ballMaterial, new Sphere(new Vector3f(-15.0f, -15.0f, 0.0f), 5.0f), new Sphere(new Vector3f(15.0f, -15.0f, 0.0f), 5.0f), new Sphere(new Vector3f(-15.0f, 15.0f, 0.0f), 5.0f), new Sphere(new Vector3f(15.0f, 15.0f, 0.0f), 5.0f));
        SingleModel air = new SingleModel(new FlatMaterial(new TexMult((Texture)new ImageTexture("OBJ/sky4b.jpg"), 4.5f)), new NegaSphere(new Vector3f(0.0f, 0.0f, 0.0f), 118.0f));
        Vector3f lookAt = new Vector3f(0.0f, 0.15f, 10.5f);
        Vector3f cameraPos = new Vector3f(-54.0f, -88.0f, 55.0f);
        Vector3f d = Algebra.substract(lookAt, cameraPos);
        float fl = Algebra.length(d);
        DOFCamera camera = new DOFCamera(cameraPos, d, Vector3f.K, w, h, 0.06f, fl, 0.3f);
        return new SceneGraph(lights, camera, new SceneNode(Transform.identity(), new SceneNode(Transform.rotateZ(-0.81681406f), new SceneLeaf(Transform.translate(0.0f, 0.0f, 10.0f), balls), new SceneLeaf(Transform.identity(), budda)), new SceneLeaf(Transform.identity(), air)));
    }

    public static Scene getBalls(int w, int h) {
        ArrayList<Light> lights = new ArrayList<Light>();
        lights.add(new GaussianLight(new Color3f(0.0f, 0.7f, 0.0f), new Vector3f(-4.0f, 6.0f, 4.0f), 0.8f));
        lights.add(new GaussianLight(new Color3f(0.7f, 0.0f, 0.0f), new Vector3f(3.0f, 6.0f, 16.0f), 1.3f));
        lights.add(new GaussianLight(new Color3f(0.0f, 0.0f, 0.7f), new Vector3f(-4.0f, 6.0f, -4.0f), 0.8f));
        RecursiveMaterial m = new RecursiveMaterial(new MatteTexture(0.3f), new NormalTexture(), 50.0f, 3.0E-4f, 0.95f);
        Sphere sphere = new Sphere(new Vector3f(0.0f, 1.0f, 0.0f), 1.0f);
        Sphere sphere2 = new Sphere(new Vector3f(-0.5f, 2.0f, 1.0f), 0.5f);
        Sphere sphere3 = new Sphere(new Vector3f(2.0f, 0.0f, 0.0f), 0.5f);
        List<Geometry> balls = Arrays.asList(sphere, sphere2, sphere3);
        SetModel model = new SetModel((Material)m, balls);
        SingleModel air = new SingleModel(new LambertianMaterial(new NormalTexture()), new NegaSphere(new Vector3f(2.0f, 0.0f, 0.0f), 150.0f));
        Vector3f lookAt = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f cameraPos = new Vector3f(10.0f, 10.0f, 10.0f);
        PerspectiveCamera camera = new PerspectiveCamera(cameraPos, Algebra.substract(lookAt, cameraPos), Vector3f.K, w, h, 0.0075f, 20.0f);
        return new SetScene(lights, (Camera)camera, model, air);
    }

    public static Scene getDOF(int w, int h) {
        ArrayList<Light> lights = new ArrayList<Light>();
        lights.add(new AmbientLight(new Color3f(0.5f)));
        lights.add(new DirectionalLight(new Color3f(0.5f), new Vector3f(1.0f, 0.0f, 0.0f)));
        PhongMaterial m = new PhongMaterial(new ImageTexture("OBJ/earth.jpg"), new MatteTexture(0.0f, 0.0f, 0.5f), 5.0f);
        LinkedList<Geometry> balls = new LinkedList<Geometry>();
        int i = 0;
        while (i < 5000) {
            balls.add(new Sphere(new Vector3f((float)(i * i) * 0.002f, -1.0f + 1.5f * (float)i, 0.0f), 0.75f));
            ++i;
        }
        KDModel model = new KDModel((Material)m, balls);
        Vector3f lookAt = new Vector3f(0.32095563f, 3.0481687f, 0.51630294f);
        Vector3f cameraPos = new Vector3f(2.0f, 0.0f, 0.75f);
        Vector3f d = Algebra.substract(lookAt, cameraPos);
        float fl = Algebra.length(d);
        DOFCamera camera = new DOFCamera(cameraPos, d, Vector3f.K, w, h, 0.015f, fl, 0.02f);
        return new SingleScene(lights, camera, model);
    }

    public static Scene getBuste(int w, int h, boolean parse) {
        KDModel model;
        String fileName = "OBJ/buste.mod";
        ArrayList<Light> lights = new ArrayList<Light>();
        lights.add(new AmbientLight(Color3f.VANILLE.mult(1.0f)));
        PhongMaterial material = new PhongMaterial(new NormalTexture(), new NormalTexture(), 15.0f);
        if (parse) {
            MeshParser meshParser = new MeshParser("OBJ/buste.obj", true);
            Collection<Geometry> meshTris = meshParser.getTriangles();
            model = new KDModel((Material)material, meshTris);
            KDBoxIO.write(model.getBox(), fileName);
        } else {
            model = new KDModel((Material)material, KDBoxIO.read(fileName));
        }
        RecursiveMaterial mirror = new RecursiveMaterial(new MatteTexture(0.1f), new MatteTexture(1.0f), 2.0f, 0.003f, 0.25f);
        SingleModel wall = new SingleModel(mirror, new Triangle(new Vector3f(-70.0f, 0.0f, -60.0f), new Vector3f(110.0f, 0.0f, 160.0f), new Vector3f(10.0f, 200.0f, 50.0f)));
        Vector3f lookAt = new Vector3f(20.0f, 60.0f, 0.0f);
        Vector3f cameraPos = new Vector3f(500.0f, 150.0f, 250.0f);
        Vector3f d = Algebra.substract(lookAt, cameraPos);
        float fl = Algebra.length(d);
        PerspectiveCamera camera = new PerspectiveCamera(cameraPos, d, Vector3f.J, w, h, 0.13f, fl);
        System.out.println(camera.getBase());
        return new SetScene(lights, (Camera)camera, model, wall);
    }

    public static Scene getGraph(int w, int h) {
        ArrayList<Light> lights = new ArrayList<Light>();
        float intensity = 0.5f;
        float blur = 3.0f;
        lights.add(new GaussianLight(Color3f.PINK.mult(intensity), new Vector3f(-210.0f, 200.0f, -220.0f), blur));
        lights.add(new GaussianLight(Color3f.YELLOW.mult(intensity), new Vector3f(-70.0f, 200.0f, 220.0f), blur));
        lights.add(new GaussianLight(Color3f.CYAN.mult(intensity), new Vector3f(220.0f, 200.0f, -70.0f), blur));
        lights.add(new GaussianLight(Color3f.PINK.mult(intensity), new Vector3f(210.0f, 200.0f, 220.0f), blur));
        lights.add(new GaussianLight(Color3f.YELLOW.mult(intensity), new Vector3f(70.0f, 200.0f, -220.0f), blur));
        lights.add(new GaussianLight(Color3f.CYAN.mult(intensity), new Vector3f(-220.0f, 200.0f, 70.0f), blur));
        PhongMaterial material = new PhongMaterial(new MatteTexture(1.0f), new MatteTexture(0.7f), 17.0f);
        MeshParser meshParser = new MeshParser("OBJ/bunny.obj", false);
        KDModel model = new KDModel((Material)material, meshParser.getTriangles());
        Vector3f lookAt = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f cameraPos = new Vector3f(100.0f, 100.0f, 100.0f);
        Vector3f d = Algebra.substract(lookAt, cameraPos);
        float fl = Algebra.length(d);
        PerspectiveCamera camera = new PerspectiveCamera(cameraPos, d, Vector3f.J, w, h, 0.145f, fl);
        SceneLeaf leaf = new SceneLeaf(Transform.translate(50.0f, 0.0f, 0.0f), model);
        int nr = 75;
        LinkedList<SceneGraphPart> parts = new LinkedList<SceneGraphPart>();
        float TWOPI = (float)Math.PI * 2;
        int i = 0;
        while (i < 75) {
            parts.add(new SceneNode(Transform.rotateZ(0.0837758f * (float)i), leaf));
            ++i;
        }
        parts.add(new SceneLeaf(Transform.scale(10.0f), model));
        parts.add(new SceneLeaf(Transform.scale(-10.0f), model));
        return new SceneGraph(lights, camera, new SceneNode(Transform.identity(), parts));
    }

    public static Scene getAcc(int w, int h) {
        ArrayList<Light> lights = new ArrayList<Light>();
        lights.add(new AmbientLight(Color3f.VANILLE.mult(1.0f)));
        PhongMaterial material = new PhongMaterial(new NormalTexture(), new MatteTexture(1.0f), 10.0f);
        MeshParser meshParser = new MeshParser("OBJ/buste.obj", true);
        Collection<Geometry> meshTris = meshParser.getTriangles();
        System.out.println(String.valueOf(meshTris.size()) + "tris");
        KDModel model = new KDModel((Material)material, meshTris);
        Vector3f lookAt = new Vector3f(20.0f, 60.0f, 0.0f);
        Vector3f cameraPos = new Vector3f(500.0f, 150.0f, 250.0f);
        Vector3f d = Algebra.substract(lookAt, cameraPos);
        float fl = Algebra.length(d);
        PerspectiveCamera camera = new PerspectiveCamera(cameraPos, d, Vector3f.J, w, h, 0.2f, fl);
        return new SingleScene(lights, camera, model);
    }

    public static Scene getMil(int w, int h) {
        RandomVectors r = new RandomVectors(10L);
        ArrayList<Light> lights = new ArrayList<Light>();
        lights.add(new AmbientLight(Color3f.VANILLE.mult(0.1f)));
        lights.add(new PointLight(Color3f.VANILLE.mult(0.9f), new Vector3f(-10.0f, 10.0f, 10.0f)));
        LinkedList<Geometry> balls = new LinkedList<Geometry>();
        int i = 0;
        while (i < 1000) {
            balls.add(new Sphere(r.next3f(), 0.05f));
            ++i;
        }
        KDModel model = new KDModel((Material)new RecursiveMaterial(new TestTexture(), new OilTexture(), new TestTexture(), 10.0f, 0.0f, 0.3f, 0.9f, 1.37f), balls);
        Vector3f lookAt = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f cameraPos = new Vector3f(10.0f, 10.0f, 10.0f);
        Vector3f d = Algebra.substract(lookAt, cameraPos);
        float fl = Algebra.length(d);
        PerspectiveCamera camera = new PerspectiveCamera(cameraPos, d, Vector3f.J, w, h, 0.0024f, fl);
        return new SingleScene(lights, camera, model);
    }

    public static Scene getTops(int w, int h) {
        ArrayList<Light> lights = new ArrayList<Light>();
        RecursiveMaterial glass = new RecursiveMaterial(new MatteTexture(0.0f), new MatteTexture(0.0f), 6.0f, 0.0f, 0.1f, 0.9f, 1.065f);
        MeshParser meshParser = new MeshParser("OBJ/tops.obj", true);
        Collection<Geometry> meshTris = meshParser.getTriangles();
        KDModel dino = new KDModel((Material)glass, meshTris);
        SingleModel air = new SingleModel(new FlatMaterial(new TexMult((Texture)new ImageTexture("OBJ/strc.png"), 1.0f)), new NegaSphere(new Vector3f(0.0f, 0.0f, 0.0f), 30.0f));
        Vector3f lookAt = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f cameraPos = new Vector3f(10.0f, 5.0f, 10.0f);
        Vector3f d = Algebra.substract(lookAt, cameraPos);
        float fl = Algebra.length(d);
        PerspectiveCamera camera = new PerspectiveCamera(cameraPos, d, Vector3f.J, w, h, 0.015f, fl);
        return new SetScene(lights, (Camera)camera, dino, air);
    }
}

