/*
 * Decompiled with CFR 0.152.
 */
package io.scenes;

import algebra.Algebra;
import algebra.Color3f;
import algebra.Vector3f;
import algebra.transform.Transform;
import geometry.Geometry;
import geometry.Sphere;
import geometry.Triangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Random;
import scene.Scene;
import scene.graph.SceneGraph;
import scene.graph.SceneLeaf;
import scene.graph.SceneNode;
import scene.light.AmbientLight;
import scene.light.Light;
import scene.light.SphereLight;
import scene.material.LambertianMaterial;
import scene.material.Material;
import scene.material.PhongMaterial;
import scene.material.RecursiveMaterial;
import scene.material.texture.MatteTexture;
import scene.material.texture.NormalTexture;
import scene.material.texture.TestTexture;
import scene.material.texture.Texture;
import scene.material.texture.combinators.TexMult;
import scene.model.KDModel;
import scene.model.SingleModel;
import tracer.camera.PerspectiveCamera;
import util.RandomVectors;

public class XMas {
    private static RandomVectors rv = new RandomVectors(1234L);
    private static Random r = new Random(1337L);
    private static float height = 20.0f;

    public static Scene tree(int w, int h) {
        float blur = 0.5f;
        ArrayList<Light> lights = new ArrayList<Light>();
        lights.add(new AmbientLight(Color3f.VANILLE.mult(0.1f)));
        lights.add(new SphereLight(Color3f.WHITE, new Vector3f(-50.0f, -10.0f, 30.0f), blur));
        lights.add(new SphereLight(Color3f.WHITE, new Vector3f(-10.0f, -50.0f, 3.0f), blur));
        lights.add(new SphereLight(Color3f.WHITE, new Vector3f(1.0f, -5.0f, 300.0f), blur));
        lights.add(new SphereLight(new Color3f(0.8f, 0.15f, 0.05f), new Vector3f(50.0f, 10.0f, 30.0f), blur));
        LambertianMaterial branchMaterial = new LambertianMaterial(new TexMult((Texture)new TestTexture(), new Color3f(0.15f, 0.8f, 0.05f)));
        KDModel branch = new KDModel((Material)branchMaterial, XMas.branch());
        LambertianMaterial trunkMaterial = new LambertianMaterial(new MatteTexture(0.15f, 0.1f, 0.025f));
        KDModel trunk = new KDModel((Material)trunkMaterial, XMas.trunk());
        RecursiveMaterial ballMaterial = new RecursiveMaterial(new TestTexture(), new MatteTexture(1.8f), new TestTexture(), 1000.0f, 0.0f, 0.9f);
        KDModel balls = new KDModel((Material)ballMaterial, XMas.balls());
        PhongMaterial serpMaterial1 = new PhongMaterial(new TexMult((Texture)new TestTexture(), new Color3f(0.8f, 0.15f, 0.05f)), new MatteTexture(1.0f), 600.0f);
        KDModel serp1 = new KDModel((Material)serpMaterial1, XMas.serp(true, 3.0f));
        PhongMaterial serpMaterial2 = new PhongMaterial(new TexMult((Texture)new TestTexture(), new Color3f(0.8f, 0.05f, 0.15f)), new MatteTexture(1.0f), 600.0f);
        KDModel serp2 = new KDModel((Material)serpMaterial2, XMas.serp(false, 2.0f));
        RecursiveMaterial mirror = new RecursiveMaterial(new MatteTexture(0.15f), new NormalTexture(), 5.0f, 0.003f, 0.85f);
        float min = 0.05f;
        SingleModel ground = new SingleModel(mirror, new Triangle(new Vector3f(-60.0f, -60.0f, min), new Vector3f(-5.0f, 20.0f, min), new Vector3f(20.0f, -5.0f, min), Vector3f.K, Vector3f.K, Vector3f.K));
        PhongMaterial starMaterial = new PhongMaterial(new MatteTexture(Color3f.YELLOW), new MatteTexture(Color3f.YELLOW.mult(1.5f)), 20.0f);
        KDModel star = new KDModel((Material)starMaterial, XMas.star());
        Vector3f lookAt = new Vector3f(0.0f, 0.0f, 10.0f);
        Vector3f cameraPos = new Vector3f(-60.0f, -60.0f, 5.0f);
        Vector3f d = Algebra.substract(lookAt, cameraPos);
        float fl = Algebra.length(d);
        PerspectiveCamera camera = new PerspectiveCamera(cameraPos, d, Vector3f.K, w, h, 0.037f, fl);
        return new SceneGraph(lights, camera, new SceneNode(Transform.identity(), new SceneLeaf(Transform.identity(), branch, trunk, balls, serp1, serp2, ground), new SceneLeaf(Algebra.multMatrix(Transform.translate(0.0f, 0.0f, height - 1.5f), Transform.rotateZ(-0.55f)), star)));
    }

    public static Collection<Geometry> star() {
        LinkedList<Geometry> star = new LinkedList<Geometry>();
        float d = 0.5f;
        Vector3f ma = new Vector3f(0.0f, d, 0.0f);
        Vector3f mb = new Vector3f(0.0f, -d, 0.0f);
        float out = 1.75f;
        float in = 0.75f;
        int i = 0;
        while (i < 5) {
            double ta = Math.PI * 2 * ((double)i - 0.5) / 5.0;
            double tt = Math.PI * 2 * (double)i / 5.0;
            double tb = Math.PI * 2 * ((double)i + 0.5) / 5.0;
            Vector3f pa = new Vector3f((float)Math.sin(ta) * in, 0.0f, (float)Math.cos(ta) * in);
            Vector3f pt = new Vector3f((float)Math.sin(tt) * out, 0.0f, (float)Math.cos(tt) * out);
            Vector3f pb = new Vector3f((float)Math.sin(tb) * in, 0.0f, (float)Math.cos(tb) * in);
            star.add(new Triangle(pa, pt, ma));
            star.add(new Triangle(pa, pt, mb));
            star.add(new Triangle(pt, pb, ma));
            star.add(new Triangle(pt, pb, mb));
            ++i;
        }
        return star;
    }

    public static Collection<Geometry> serp(boolean counterClockWise, float numberOfPeriods) {
        LinkedList<Geometry> serp = new LinkedList<Geometry>();
        float nr = 3200.0f;
        int scalar = counterClockWise ? 1 : -1;
        float i = 0.22f;
        while (i < 0.95f) {
            float alpha = (float)((double)((float)scalar * i) * Math.PI * 2.0 * (double)numberOfPeriods);
            float delta = (float)(7.5 * Math.pow(i, 1.6));
            float r = (1.0f + (float)Math.sin(alpha * 6.0f)) * 0.125f + 0.325f;
            Vector3f m = new Vector3f((float)Math.sin(alpha) * delta, (float)Math.cos(alpha) * delta, height - i * height);
            Vector3f a = Algebra.sum(m, Algebra.scalar(rv.nextUnit3f(), r));
            Vector3f b = Algebra.sum(m, Algebra.scalar(rv.nextUnit3f(), r));
            Vector3f c = Algebra.sum(m, Algebra.scalar(rv.nextUnit3f(), r));
            serp.add(new Triangle(a, b, c));
            i += 1.0f / nr;
        }
        return serp;
    }

    public static Collection<Geometry> balls() {
        LinkedList<Geometry> balls = new LinkedList<Geometry>();
        int nr = 300;
        int i = 0;
        while (i < nr) {
            float ballHeight = r.nextFloat() * r.nextFloat() * (height - 3.0f) + 1.0f;
            Vector3f m = Algebra.sum(Algebra.scalar(rv.nextCircle3f(Vector3f.K), (height - (ballHeight + ballHeight % 3.0f)) * (r.nextFloat() * 0.1f + 0.3f)), new Vector3f(0.0f, 0.0f, ballHeight));
            balls.add(new Sphere(m, r.nextFloat() * 0.2f + 0.2f));
            ++i;
        }
        return balls;
    }

    public static Collection<Geometry> trunk() {
        LinkedList<Geometry> trunk = new LinkedList<Geometry>();
        Vector3f a = new Vector3f(1.0f, 1.0f, 0.0f);
        Vector3f b = new Vector3f(-1.0f, 1.0f, 0.0f);
        Vector3f c = new Vector3f(-1.0f, -1.0f, 0.0f);
        Vector3f d = new Vector3f(1.0f, -1.0f, 0.0f);
        Vector3f t = new Vector3f(0.0f, 0.0f, height);
        trunk.add(new Triangle(a, b, t));
        trunk.add(new Triangle(b, c, t));
        trunk.add(new Triangle(c, d, t));
        trunk.add(new Triangle(d, a, t));
        return trunk;
    }

    public static Collection<Geometry> branch() {
        LinkedList<Geometry> branch = new LinkedList<Geometry>();
        int nr = 20000;
        int i = 0;
        while (i < nr) {
            float branchHeight = r.nextFloat() * (height - 1.0f) + 1.0f;
            Vector3f l = Algebra.sum(Algebra.scalar(rv.nextUnit3f(), 1.0f - branchHeight / height), new Vector3f(0.0f, 0.0f, branchHeight));
            Vector3f r = Algebra.sum(Algebra.scalar(rv.nextUnit3f(), 1.0f - branchHeight / height), new Vector3f(0.0f, 0.0f, branchHeight));
            Vector3f p = Algebra.sum(Algebra.scalar(rv.nextCircle3f(Vector3f.K), (height - (branchHeight + branchHeight % 3.0f)) * 0.5f), new Vector3f(0.0f, 0.0f, branchHeight * 0.9f - 0.6f));
            branch.add(new Triangle(l, r, p));
            ++i;
        }
        return branch;
    }
}

