/*
 * Decompiled with CFR 0.152.
 */
package scene.graph;

import algebra.Matrix4f;
import geometry.ray.Ray;
import geometry.ray.RayResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import scene.graph.SceneGraphPart;

public class SceneNode
extends SceneGraphPart {
    private final Collection<SceneGraphPart> parts;

    public SceneNode(Matrix4f matrix, SceneGraphPart ... parts) {
        this(matrix, Arrays.asList(parts));
    }

    public SceneNode(Matrix4f matrix, Collection<SceneGraphPart> parts) {
        super(matrix);
        this.parts = new ArrayList<SceneGraphPart>(parts);
    }

    @Override
    public RayResult intersect(Ray ray) {
        Ray transRay = ray.cloneTransformed(this.matrix);
        RayResult returnResult = null;
        for (SceneGraphPart part : this.parts) {
            RayResult iResult = part.intersect(transRay);
            if (returnResult != null && (iResult == null || !(returnResult.t > iResult.t))) continue;
            returnResult = iResult;
        }
        if (returnResult != null) {
            returnResult.addMatrix(this.matrixT, this.matrixInv);
        }
        return returnResult;
    }
}

