/*
 * Decompiled with CFR 0.152.
 */
package scene.light;

import algebra.Algebra;
import algebra.Color3f;
import algebra.Vector3f;
import geometry.ray.RayResult;
import geometry.ray.ShadowRay;
import scene.Scene;
import scene.light.Light;

public class DirectionalLight
extends Light {
    private final Vector3f lightDirection;

    public DirectionalLight(Color3f intensity, Vector3f lightDirection) {
        super(intensity);
        this.lightDirection = Algebra.unit(lightDirection);
    }

    public Vector3f getLightDirection() {
        return this.lightDirection;
    }

    @Override
    public boolean visibility(RayResult from, Scene scene) {
        ShadowRay ray = new ShadowRay(Algebra.perturb(from.getWorldLocation(), this.lightDirection, 0.005f), this.lightDirection);
        return ray.isVisible(scene);
    }
}

