/*
 * Decompiled with CFR 0.152.
 */
package scene.light;

import algebra.Algebra;
import algebra.Color3f;
import algebra.Vector3f;
import geometry.ray.RayResult;
import geometry.ray.ShadowRay;
import scene.Scene;
import scene.light.Light;

public class PointLight
extends Light {
    protected final Vector3f lightPosition;

    public PointLight(Color3f intensity, Vector3f lightPosition) {
        super(intensity);
        this.lightPosition = lightPosition;
    }

    public Vector3f getLightPosition() {
        return this.lightPosition;
    }

    @Override
    public boolean visibility(RayResult from, Scene scene) {
        Vector3f line = Algebra.substract(this.lightPosition, from.getWorldLocation());
        Vector3f uline = Algebra.unit(line);
        ShadowRay ray = new ShadowRay(Algebra.perturb(from.getWorldLocation(), uline, 0.005f), uline);
        return ray.isVisible(scene, Algebra.length(line));
    }
}

