/*
 * Decompiled with CFR 0.152.
 */
package scene.light;

import algebra.Algebra;
import algebra.Color3f;
import algebra.Vector3f;
import geometry.ray.RayResult;
import geometry.ray.ShadowRay;
import scene.Scene;
import scene.light.PointLight;

public abstract class VolumeLight
extends PointLight {
    public VolumeLight(Color3f intensity, Vector3f lightPosition) {
        super(intensity, lightPosition);
    }

    @Override
    public final boolean visibility(RayResult from, Scene scene) {
        Vector3f lightPosition = this.samplePosition(from);
        Vector3f line = Algebra.substract(lightPosition, from.getWorldLocation());
        Vector3f uline = Algebra.unit(line);
        ShadowRay ray = new ShadowRay(Algebra.perturb(from.getWorldLocation(), uline, 0.005f), uline);
        return ray.isVisible(scene, Algebra.length(line));
    }

    protected abstract Vector3f samplePosition(RayResult var1);
}

