/*
 * Decompiled with CFR 0.152.
 */
package scene.material;

import algebra.Algebra;
import algebra.Color3f;
import algebra.Vector3f;
import geometry.ray.RayResult;
import geometry.ray.ShadingRay;
import scene.Scene;
import scene.light.AmbientLight;
import scene.light.DirectionalLight;
import scene.light.Light;
import scene.light.PointLight;
import scene.material.PhongMaterial;
import scene.material.texture.MatteTexture;
import scene.material.texture.Texture;
import util.RandomVectors;

public class RecursiveMaterial
extends PhongMaterial {
    private static final float perturbationEpsilon = 0.005f;
    private final float recursionFactorEpsilon = 0.01f;
    private static final RandomVectors RANDOM_VECTORS = new RandomVectors(13354L);
    private final Texture recursionTexture;
    private final float gloss;
    private final float reflectionFactor;
    private final float refractionFactor;
    private final float eta;

    public RecursiveMaterial(Texture texture, Texture phongTexture, float expPhong, float gloss, float reflectionFactor) {
        this(texture, phongTexture, new MatteTexture(1.0f), expPhong, gloss, reflectionFactor);
    }

    public RecursiveMaterial(Texture texture, Texture phongTexture, Texture recursionTexture, float expPhong, float gloss, float reflectionFactor) {
        this(texture, phongTexture, recursionTexture, expPhong, gloss, reflectionFactor, 0.0f, 0.0f);
    }

    public RecursiveMaterial(Texture texture, Texture phongTexture, float expPhong, float gloss, float reflectionFactor, float refractionFactor, float eta) {
        this(phongTexture, phongTexture, new MatteTexture(1.0f), expPhong, gloss, reflectionFactor, refractionFactor, eta);
    }

    public RecursiveMaterial(Texture texture, Texture phongTexture, Texture recursionTexture, float expPhong, float gloss, float reflectionFactor, float refractionFactor, float eta) {
        super(texture, phongTexture, expPhong);
        if (refractionFactor >= 1.0f || reflectionFactor >= 1.0f) {
            throw new IllegalArgumentException("Recursive factor > 1.");
        }
        this.recursionTexture = recursionTexture;
        this.gloss = gloss;
        this.reflectionFactor = reflectionFactor;
        this.refractionFactor = refractionFactor;
        this.eta = eta;
    }

    @Override
    public Color3f shade(Scene scene, RayResult rayResult) {
        Color3f resultColor = Color3f.BLACK;
        if (((ShadingRay)rayResult.getWorldRay()).getRecursionFactor() > 0.01f) {
            if (this.reflectionFactor > 0.0f) {
                resultColor = resultColor.sum(this.getReflection(rayResult, scene));
            }
            if (this.refractionFactor > 0.0f) {
                resultColor = resultColor.sum(this.getRefraction(rayResult, scene));
            }
        }
        resultColor = resultColor.mult(this.recursionTexture.getColor(rayResult));
        Color3f color = this.getColor(rayResult);
        Color3f phongColor = this.getPhongColor(rayResult);
        for (Light l : scene.getLights()) {
            if (!l.visibility(rayResult, scene)) continue;
            Color3f lColor = null;
            if (l instanceof AmbientLight) {
                lColor = this.light((AmbientLight)l, rayResult, color);
            } else if (l instanceof DirectionalLight) {
                lColor = this.light((DirectionalLight)l, rayResult, color, phongColor);
            } else if (l instanceof PointLight) {
                lColor = this.light((PointLight)l, rayResult, color, phongColor);
            }
            resultColor = resultColor.sum(lColor);
        }
        return resultColor;
    }

    private Color3f getReflection(RayResult rayResult, Scene scene) {
        ShadingRay ray = (ShadingRay)rayResult.getWorldRay();
        if (ray.isInside()) {
            return Color3f.BLACK;
        }
        Vector3f n = rayResult.getNormal();
        Vector3f d = Algebra.unit(Algebra.perturb(Algebra.unit(Algebra.mirror(ray.d, n)), RANDOM_VECTORS.nextGauss3f(n), this.gloss));
        ShadingRay shadingRay = new ShadingRay(Algebra.perturb(rayResult.getWorldLocation(), d, 0.005f), d, ray.getRecursionFactor() * this.reflectionFactor);
        Color3f reflectColor = shadingRay.shoot(scene);
        return reflectColor.mult(this.reflectionFactor);
    }

    private Color3f getRefraction(RayResult rayResult, Scene scene) {
        float eta;
        Vector3f n;
        ShadingRay ray = (ShadingRay)rayResult.getWorldRay();
        if (ray.isInside()) {
            n = Algebra.neg(rayResult.getNormal());
            eta = this.eta;
        } else {
            n = rayResult.getNormal();
            eta = 1.0f / this.eta;
        }
        double cos = -Algebra.cosAngle(ray.d, n);
        Vector3f d = Algebra.unit(Algebra.perturb(Algebra.unit(Algebra.sum(Algebra.scalar(ray.d, eta), Algebra.scalar(n, (float)((double)eta * cos - Math.sqrt(Math.max(0.0, 1.0 - (double)(eta * eta) * (1.0 - cos * cos))))))), RANDOM_VECTORS.nextCircle3f(n), this.gloss));
        assert (!(Float.isNaN(d.x) || Float.isNaN(d.y) || Float.isNaN(d.z))) : "NaN vector";
        ShadingRay shadingRay = new ShadingRay(Algebra.perturb(rayResult.getWorldLocation(), d, 0.005f), d, ray.getRecursionFactor() * this.refractionFactor, !ray.isInside());
        Color3f refractColor = shadingRay.shoot(scene);
        return refractColor.mult(this.refractionFactor);
    }
}

