/*
 * Decompiled with CFR 0.152.
 */
package scene.model;

import algebra.Algebra;
import algebra.Vector3f;
import geometry.Geometry;
import geometry.bounding.BoxUtil;
import geometry.ray.Ray;
import geometry.ray.RayResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import scene.material.Material;
import scene.model.Model;

public class SetModel
extends Model {
    private final ArrayList<Geometry> geometry;
    private final Vector3f min;
    private final Vector3f max;
    private final Vector3f mid;

    public SetModel(Material material, Geometry ... objects) {
        this(material, Arrays.asList(objects));
    }

    public SetModel(Material material, Collection<Geometry> objects) {
        super(material);
        this.geometry = new ArrayList<Geometry>(objects);
        this.min = BoxUtil.minGeometries(this.geometry);
        this.max = BoxUtil.maxGeometries(this.geometry);
        this.mid = Algebra.scalar(Algebra.sum(this.min, this.max), 0.5f);
    }

    @Override
    public RayResult intersect(Ray ray) {
        RayResult returnResult = null;
        for (Geometry i : this.geometry) {
            RayResult iResult = i.intersect(ray);
            if (returnResult != null && (iResult == null || !(returnResult.t > iResult.t))) continue;
            returnResult = iResult;
        }
        return returnResult;
    }

    @Override
    public Vector3f getMin() {
        return this.min;
    }

    @Override
    public Vector3f getMax() {
        return this.max;
    }

    @Override
    public Vector3f getMid() {
        return this.mid;
    }
}

