/*
 * Decompiled with CFR 0.152.
 */
package tracer.camera;

import algebra.Algebra;
import algebra.Vector3f;
import geometry.ray.ShadingRay;
import tracer.camera.Camera;

public class PerspectiveCamera
extends Camera {
    protected final float focalLength;

    public PerspectiveCamera(Vector3f e, Vector3f d, Vector3f up, int width, int height, float scale, float focalLength) {
        super(e, d, up, width, height, scale);
        this.focalLength = focalLength;
    }

    @Override
    public ShadingRay ray(float x, float y) {
        float u = this.l + this.lr * (x + 0.5f) / this.width;
        float v = this.b + this.bt * (y + 0.5f) / this.height;
        Vector3f d = Algebra.unit(Algebra.sum(Algebra.scalar(this.base.w, -this.focalLength), Algebra.sum(Algebra.scalar(this.base.u, u), Algebra.scalar(this.base.v, v))));
        return new ShadingRay(this.e, d);
    }
}

