/*
 * Decompiled with CFR 0.152.
 */
package util;

import algebra.Algebra;
import algebra.Vector3f;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import util.RandomVectors;

public class PerlinNoise {
    private static final int n = 256;
    private static final RandomVectors RANDOM_VECTORS = new RandomVectors(123L);
    private static final Vector3f[] G = PerlinNoise.makeGs(256);
    private static final int[] P = PerlinNoise.makePs(256);

    public static float turbulence(Vector3f v, int i) {
        return PerlinNoise.turbulence(v.x, v.y, v.z, i);
    }

    public static float turbulence(float x, float y, float z, int levels) {
        float result = 0.0f;
        float n = 1.0f;
        int i = 0;
        while (i < levels) {
            result += PerlinNoise.noise(n * x, n * y, n * z) / n;
            n *= 2.0f;
            ++i;
        }
        if (Float.isNaN(result)) {
            throw new IllegalStateException("Out of Perlin range.");
        }
        return result;
    }

    public static float noise(Vector3f v) {
        return PerlinNoise.noise(v.x, v.y, v.z);
    }

    public static float noise(float x, float y, float z) {
        int xf = (int)Math.floor(x);
        int yf = (int)Math.floor(y);
        int zf = (int)Math.floor(z);
        int xc = xf + 1;
        int yc = yf + 1;
        int zc = zf + 1;
        float noise = 0.0f;
        int i = xf;
        while (i <= xc) {
            int j = yf;
            while (j <= yc) {
                int k = zf;
                while (k <= zc) {
                    noise += PerlinNoise.omega(i, j, k, x - (float)i, y - (float)j, z - (float)k);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        if (Float.isNaN(noise)) {
            throw new IllegalStateException("Out of Perlin range.");
        }
        return noise;
    }

    private static float omega(int i, int j, int k, float u, float v, float w) {
        return PerlinNoise.weight(u) * PerlinNoise.weight(v) * PerlinNoise.weight(w) * Algebra.dot(PerlinNoise.gamma(i, j, k), new Vector3f(u, v, w));
    }

    private static float weight(float t) {
        float abs = Math.abs(t);
        if (abs < 1.0f) {
            return 2.0f * abs * abs * abs - 3.0f * abs * abs + 1.0f;
        }
        return 0.0f;
    }

    private static Vector3f gamma(int i, int j, int k) {
        return G[PerlinNoise.phi(i + PerlinNoise.phi(j + PerlinNoise.phi(k)))];
    }

    private static int phi(int i) {
        return P[(i % 256 + 256) % 256];
    }

    private static Vector3f[] makeGs(int n) {
        Vector3f[] G = new Vector3f[n];
        int i = 0;
        while (i < G.length) {
            G[i] = RANDOM_VECTORS.nextUnit3f();
            ++i;
        }
        return G;
    }

    private static int[] makePs(int n) {
        ArrayList<Integer> a = new ArrayList<Integer>();
        int i = 0;
        while (i < n) {
            a.add(i);
            ++i;
        }
        Collections.shuffle(a, new Random(13354L));
        int[] ints = new int[n];
        int i2 = 0;
        while (i2 < n) {
            ints[i2] = (Integer)a.get(i2);
            ++i2;
        }
        return ints;
    }
}

