#include "main.h"
#include "engine.h"
#include "loadlwo.h"
#include "util.h"

static scene_s *scene;

static int startframe, textpos, opos;
static void DoText(int y);

int Part5Init(int frame)
{
#ifdef DEBUG
  printf("part 5 init.\n");
#endif
  startframe=frame;
  scene=new scene_s;
#ifdef DEBUG
  printf("initializing scene 5\n");
#endif
  extern char M_05bck1[], M_05msk1[], M_05msk2[];
  LoadTIM(M_05bck1);
  LoadTIM(M_05msk1);
  LoadTIM(M_05msk2);
  object_s *n=new object_s;
  n->Initialize();
  n->child=new object_s*[3];
  extern char LWO_Thing3_1[], LWO_Thing3_2[];
  n->child[0]=LoadLWO(LWO_Thing3_1);
  n->child[1]=LoadLWO(LWO_Thing3_2);
  n->child[2]=0;
  scene->root=n;
  n->child[0]->scene=scene;
  n->child[1]->scene=scene;
  n->child[0]->parent=n;
  n->child[1]->parent=n;
  textpos=128*1000;
  opos=128*1000;
  return 0;
}

int Part5Frame(int frame)
{
  frame-=startframe;

  if (frame<500)
  {
    textpos*=4000;
    textpos/=4096;
  } else
  {
    textpos+=100;
    textpos*=4096;
    textpos/=4000;
    if (textpos> 100000)
      textpos=100000;

  }

  int fak=4096;

  DoText(textpos/100);
  if (frame>600)
    fak=4096-(frame-600)*20;
  if (fak<0)
    return 1;
                                 // setup light sources
  scene->l_dir.m[0][0]=2896*fak/4096;
  scene->l_dir.m[0][1]=2896*fak/4096;
  scene->l_dir.m[0][2]=0;

  scene->l_dir.m[1][0]=0;
  scene->l_dir.m[1][1]=0;
  scene->l_dir.m[1][2]=-4096;

  scene->l_dir.m[2][0]=0;
  scene->l_dir.m[2][1]=0;
  scene->l_dir.m[2][2]=0;
                                  // setup light colors
  scene->l_color.m[0][0]=4096*fak/4096;
  scene->l_color.m[1][0]=4096*fak/4096;
  scene->l_color.m[2][0]=4096*fak/4096;

  scene->l_color.m[0][1]=4096*fak/4096;
  scene->l_color.m[1][1]=4096*fak/4096;
  scene->l_color.m[2][1]=4096*fak/4096;

  scene->l_color.m[0][2]=4096*fak/4096;
  scene->l_color.m[1][2]=4096*fak/4096;
  scene->l_color.m[2][2]=4096*fak/4096;
                                  // setup ambient
  scene->l_color.t[0]=1024*fak/4096;
  scene->l_color.t[1]=1024*fak/4096;
  scene->l_color.t[2]=1024*fak/4096;
                                  // camera position
  scene->camera.pos.v.vx=0;
  scene->camera.pos.v.vy=0;
  scene->camera.pos.v.vz=-16000;
                                  // camera direction
  scene->camera.pos.r.vx=0;
  scene->camera.pos.r.vy=0;
  scene->camera.pos.r.vz=0;
  scene->camera.matval=0;
                                  // object position
  scene->root->matval=0;
  scene->root->pos.r.vx=0;
  scene->root->pos.r.vy=0;
  scene->root->pos.r.vz=440-frame;

  scene->root->pos.v.vx=0;
  scene->root->pos.v.vy=-(4096-fak)*3;
  scene->root->pos.v.vz=0;

  opos*=4000;
  opos/=4096;

  scene->root->child[0]->pos.v.vy=opos;
  scene->root->child[1]->pos.v.vy=-opos;

  scene->root->child[0]->pos.r.vx-=10;
  scene->root->child[0]->pos.r.vz=1024;
  scene->root->child[0]->matval=0;

  scene->root->child[1]->pos.r.vz=1024;
  scene->root->child[1]->pos.r.vx+=10;              // roten kltze
  scene->root->child[1]->matval=0;

  int r, g, b;

  r=g=b=fak>>6;

  int rgb=r | (g<<8) | (b<<16);

  engineRender(scene);
  introShowPicture(640, 0, getClut(0, 480), 1, rgb);
    
  return 0;
}

int Part5Close()
{
#ifdef DEBUG
  printf("closing Part5 ... SHOULD delete objects here.\n");
#endif
  scene->root->Free();
  delete scene->root;
  delete scene;
  return 0;
}

static void DoText(int x)
{
  int clut=getClut(0, 481); // 315x53
  int tpage=getTPage(0, 0, 0, 256);

  char *startp=_curdisplayp->wspace + _curdisplayp->wspacepos;
  POLY_FT4 *pft4=(POLY_FT4*)startp;
  u_long *ot=_curdisplayp->ot;

  setPolyFT4(pft4);

  pft4->r0=128;
  pft4->g0=128;
  pft4->b0=128;

  pft4->clut=clut;

  pft4->tpage=tpage;

  pft4->x0=x+2;
  pft4->y0=100;

  pft4->x1=x+2+256;
  pft4->y1=100;

  pft4->x2=x+2;
  pft4->y2=100+24;

  pft4->x3=x+2+256;
  pft4->y3=100+24;

  pft4->u0=0;
  pft4->v0=0;

  pft4->u1=255;
  pft4->v1=0;

  pft4->u2=0;
  pft4->v2=24;

  pft4->u3=255;
  pft4->v3=24;
  addPrim(ot+OTSIZE-1, pft4);
  pft4++;

  setPolyFT4(pft4);

  pft4->r0=128;
  pft4->g0=128;
  pft4->b0=128;

  pft4->clut=clut;
  pft4->tpage=getTPage(0, 0, 64, 256);

  pft4->x0=x+2+256;
  pft4->y0=100;

  pft4->x1=x+2+256+40;
  pft4->y1=100;

  pft4->x2=x+2+256;
  pft4->y2=100+24;

  pft4->x3=x+2+256+40;
  pft4->y3=100+24;

  pft4->u0=0;
  pft4->v0=0;

  pft4->u1=39;
  pft4->v1=0;

  pft4->u2=0;
  pft4->v2=24;

  pft4->u3=39;
  pft4->v3=24;
  addPrim(ot+OTSIZE-1, pft4);
  pft4++;
  x=-x;

  setPolyFT4(pft4);

  pft4->r0=128;
  pft4->g0=128;
  pft4->b0=128;

  pft4->clut=clut;

  pft4->tpage=tpage;

  pft4->x0=x+2;
  pft4->y0=200;

  pft4->x1=x+2+256;
  pft4->y1=200;

  pft4->x2=x+2;
  pft4->y2=200+43;

  pft4->x3=x+2+256;
  pft4->y3=200+43;

  pft4->u0=0;
  pft4->v0=24;

  pft4->u1=255;
  pft4->v1=24;

  pft4->u2=0;
  pft4->v2=24+43;

  pft4->u3=255;
  pft4->v3=24+43;
  addPrim(ot+OTSIZE-1, pft4);
  pft4++;

  setPolyFT4(pft4);

  pft4->r0=128;
  pft4->g0=128;
  pft4->b0=128;

  pft4->clut=clut;
  pft4->tpage=getTPage(0, 0, 64, 256);

  pft4->x0=x+2+256;
  pft4->y0=200;

  pft4->x1=x+2+256+64;
  pft4->y1=200;

  pft4->x2=x+2+256;
  pft4->y2=200+43;

  pft4->x3=x+2+256+64;
  pft4->y3=200+43;

  pft4->u0=0;
  pft4->v0=24;

  pft4->u1=64;
  pft4->v1=24;

  pft4->u2=0;
  pft4->v2=24+43;

  pft4->u3=64;
  pft4->v3=24+43;
  addPrim(ot+OTSIZE-1, pft4);
  pft4++;
  _curdisplayp->wspacepos += (char *)pft4 - startp;
  
}
