--------------------------------------------------------------------------------
-- Envolvente / Xplsv @ Euskal 14
--------------------------------------------------------------------------------

-- Blend modes
FM_ALPHABLEND    = 0;
FM_ADDITIVE      = 1;
FM_SUBTRACTIVE   = 2;
FM_INVERT        = 3;
FM_INVERTDEST    = 4;
FM_MASK          = 5;
FM_MULTIPLY      = 6;
FM_INVMULTIPLY   = 7;
FM_COLORMULTIPLY = 8;
  
-- SetVar types
SET_VAR_INT      = 0;
SET_VAR_FLOAT    = 1;
SET_VAR_BOOL     = 2;

-- For FX
EV_FX_ATTACH     = 0;
EV_FX_UNATTACH   = 1;
EV_FX_RESET      = 2;
EV_FX_SETSPEED   = 3;
EV_FX_SETALPHA   = 4;
EV_FX_SETBLEND   = 5;
EV_FX_SETTIME    = 6;
EV_FX_SETFILTER  = 7;
EV_FX_SETVAR     = 8;
-- For FF
EV_FF_SETVAR     = 9;


--------------------------------------------------------------------------------
-- Demo Init
--------------------------------------------------------------------------------
CInit     (237.0, 0.0, 33, false);
CLoadMusic("Merendero Alfacs.mp3");

I_Sunset2 = CLoadFX("DemoTr/I_Sunset2.nly");
I_B1      = CLoadFX("DemoTr/I_B1.nly");
I_B2      = CLoadFX("DemoTr/I_B2.nly");
I_F1      = CLoadFX("DemoTr/I_F1.nly");
I_F1_F    = CLoadFX("DemoTr/I_F1_F.nly");
I_F1_Sub  = CLoadFX("DemoTr/I_F1_Sub.nly");
I_R1      = CLoadFX("DemoTr/I_R1.nly");
I_R2      = CLoadFX("DemoTr/I_R2.nly");
I_R3      = CLoadFX("DemoTr/I_R3.nly");
I_R4      = CLoadFX("DemoTr/I_R4.nly");
I_V1      = CLoadFX("DemoTr/I_V1.nly");
I_V2      = CLoadFX("DemoTr/I_V2.nly");
I_V3      = CLoadFX("DemoTr/I_V3.nly");
I_V4      = CLoadFX("DemoTr/I_V4.nly");
I_Mul     = CLoadFX("DemoTr/I_Mul.nly");
I_Mul2    = CLoadFX("DemoTr/I_Mul2.nly");
I_Tit1    = CLoadFX("DemoTr/I_Tit1Add.nly");
I_Tit2    = CLoadFX("DemoTr/I_Tit2.nly");
I_End     = CLoadFX("DemoTr/I_End.nly");
BoxLogo   = CLoadFX("DemoTr/BoxLogo.nly");
SphLogo   = CLoadFX("DemoTr/SphLogo.nly");
BolaBujD  = CLoadFX("DemoTr/BolaBujD.nly");
Torus1    = CLoadFX("DemoTr/Torus.nly");
Torus2    = CLoadFX("DemoTr/Torus.nly");
Torus3    = CLoadFX("DemoTr/Torus.nly");
Hexas     = CLoadFX("DemoTr/Hexas.nly");
Star      = CLoadFX("DemoTr/Star.nly");
Pas       = CLoadFX("DemoTr/Pas.nly");
Box       = CLoadFX("DemoTr/Box.nly");
FX_SprSph = CLoadFX("DemoTr/FX_SprSph.nly");
FX_Half   = CLoadFX("DemoTr/FX_Half.nly");
FX_Color  = CLoadFX("DemoTr/FX_Colorize.nly");
FX_SobelSub = CLoadFX("DemoTr/FX_SobelSub.nly");

--------------------------------------------------------------------------------
-- Intro
--------------------------------------------------------------------------------

-- Part 1: credits y bola normal mapped
CAddEvent(EV_FX_SETALPHA,    0.00, I_V1,   0.00, 0.55, 8);
CAddEvent(EV_FX_SETALPHA,    0.00, I_V2,   0.00, 0.55, 11);
CAddEvent(EV_FX_SETALPHA,    0.00, I_V3,   0.00, 0.55, 14);
CAddEvent(EV_FX_SETALPHA,    0.00, I_V4,   0.00, 0.55, 17);
CAddEvent(EV_FX_SETALPHA,    0.00, I_Tit1, 0.00, 1.00, 6.0);
CAddEvent(EV_FX_SETALPHA,    6.00, I_Tit2, 0.00, 1.00, 6.0);
CAddEvent(EV_FX_SETALPHA,    6.00, I_Tit1, 1.00, 0.00, 6.00);
CAddEvent(EV_FX_SETALPHA,   12.00, I_Tit2, 1.00, 0.00, 6.00);
CAddEvent(EV_FX_ATTACH,      0.00, I_Tit1,    5);
CAddEvent(EV_FX_ATTACH,      6.00, I_Tit2,    6);

CAddEvent(EV_FX_UNATTACH,   12.00,     I_Tit1      );
CAddEvent(EV_FX_UNATTACH,   12.00+6.0, I_Tit2      );

CAddEvent(EV_FX_ATTACH,      0.00, I_V1,      0);
CAddEvent(EV_FX_ATTACH,      0.00, I_V2,      1);
CAddEvent(EV_FX_ATTACH,      0.00, I_V3,      2);
CAddEvent(EV_FX_ATTACH,      0.00, I_V4,      3);
CAddEvent(EV_FX_ATTACH,      0.00, I_Mul2,    4);
CAddEvent(EV_FX_ATTACH,      0.00, FX_Color,  9);

CAddEvent(EV_FX_SETALPHA,   18.85, BoxLogo, 0.0, 1.0, 1);
CAddEvent(EV_FX_ATTACH,     18.85, BoxLogo,   5);

-- Part 2 [0,1,2,3,4,5]
CAddEvent(EV_FX_ATTACH,     37.6,  SphLogo,   5);

-- Part 3 [0,1,2,3,5,9]
CAddEvent(EV_FX_ATTACH,     56.30, I_R1,      0);
CAddEvent(EV_FX_ATTACH,     56.30, I_R2,      1);
CAddEvent(EV_FX_ATTACH,     56.30, I_R3,      2);
CAddEvent(EV_FX_ATTACH,     56.30, I_R4,      3);
CAddEvent(EV_FX_ATTACH,     56.30, BolaBujD,  5);
CAddEvent(EV_FX_ATTACH,     56.30, FX_Half,   9);

CAddEvent(EV_FX_SETVAR,    ((75.00-56.30)/4)*1 + 56.30, BolaBujD, SET_VAR_INT, "", "", "Camera", 1);
CAddEvent(EV_FX_SETVAR,    ((75.00-56.30)/4)*2 + 56.30, BolaBujD, SET_VAR_INT, "", "", "Camera", 2);
CAddEvent(EV_FX_SETVAR,    ((75.00-56.30)/4)*3 + 56.30, BolaBujD, SET_VAR_INT, "", "", "Camera", 3);

-- Part 4 [0,1,2,3,4,9]
CAddEvent(EV_FX_UNATTACH,   75.00, BolaBujD    );

CAddEvent(EV_FX_ATTACH,     75.00, I_R1,      0);
CAddEvent(EV_FX_ATTACH,     75.00, I_R2,      1);
CAddEvent(EV_FX_ATTACH,     75.00, I_R3,      2);
CAddEvent(EV_FX_ATTACH,     75.00, I_F1_Sub,  3);
CAddEvent(EV_FX_ATTACH,     75.00, I_R4,      4);
CAddEvent(EV_FX_ATTACH,     75.00, FX_SprSph, 9);

CAddEvent(EV_FX_SETALPHA,   75.00, FX_SprSph, 0.5, 1.0, 1.5);
CAddEvent(EV_FF_SETVAR,     75.00, FX_SprSph, SET_VAR_FLOAT, "Max Size", 1.0, 0.3, 1.5);

for i=0,7 do
  CAddEvent(EV_FF_SETVAR,  76.50 + i*2.3622, FX_SprSph, SET_VAR_FLOAT, "Max Size", 1.0, 0.3, 0.70);
  CAddEvent(EV_FF_SETVAR,  76.95 + i*2.3622, FX_SprSph, SET_VAR_FLOAT, "Max Size", 1.0, 0.3, 0.90);
end;

-- Part 5
CAddEvent(EV_FX_ATTACH,     93.00, I_R1,        0);
CAddEvent(EV_FX_ATTACH,     93.00, I_R3,        1);
CAddEvent(EV_FX_ATTACH,     93.00, I_F1_Sub,    2);
CAddEvent(EV_FX_ATTACH,     93.00, Pas,         3);
CAddEvent(EV_FX_ATTACH,     93.00, I_R4,        5);
CAddEvent(EV_FX_ATTACH,     93.00, FX_SobelSub, 9);
CAddEvent(EV_FX_SETALPHA,   93.00, FX_SobelSub, 0.1, 0.7, 7);

CAddEvent(EV_FX_SETVAR,     93.00, Pas, SET_VAR_FLOAT, "Cameras", "0", "Fov", 1.0, 0.25, 3);
CAddEvent(EV_FX_SETVAR,     98.00, Pas, SET_VAR_FLOAT, "Objects", "Chamferbox01", "MorphY", 0.0, 0.25, 5.0);

CAddEvent(EV_FX_SETALPHA,   93.00, I_F1_Sub, 1.0, 0.9, 2.50);

for i=0,8 do
  CAddEvent(EV_FX_SETVAR,   93.00 + i*2.3622, FX_SobelSub, SET_VAR_FLOAT, "", "", "GlowIntens", 0.8, 0.0, 0.70);
  CAddEvent(EV_FX_SETVAR,   93.45 + i*2.3622, FX_SobelSub, SET_VAR_FLOAT, "", "", "GlowIntens", 0.8, 0.0, 0.90);
  CAddEvent(EV_FX_SETALPHA, 93.00 + i*2.3622, FX_SobelSub, 1.0, 0.7, 0.70);
  CAddEvent(EV_FX_SETALPHA, 93.45 + i*2.3622, FX_SobelSub, 1.0, 0.7, 0.90);
end;


---- Part 6
CAddEvent(EV_FX_ATTACH,    111.50, Box,        4);
CAddEvent(EV_FF_SETVAR,    111.50, Box, SET_VAR_FLOAT, "Intens", 0.0, 1.0, 6);

CAddEvent(EV_FX_UNATTACH,  117.50, I_R1        );
CAddEvent(EV_FX_UNATTACH,  117.50, I_R3        );
CAddEvent(EV_FX_UNATTACH,  117.50, I_F1_Sub    );
CAddEvent(EV_FX_UNATTACH,  117.50, Pas         );

for i=0,8 do
  CAddEvent(EV_FX_SETVAR,   111.95 + i*2.3622, FX_SobelSub, SET_VAR_FLOAT, "", "", "GlowIntens", 0.8, 0.0, 0.70);
  CAddEvent(EV_FX_SETVAR,   111.40 + i*2.3622, FX_SobelSub, SET_VAR_FLOAT, "", "", "GlowIntens", 0.8, 0.0, 0.90);
  CAddEvent(EV_FX_SETALPHA, 111.95 + i*2.3622, FX_SobelSub, 1.0, 0.7, 0.70);
  CAddEvent(EV_FX_SETALPHA, 112.40 + i*2.3622, FX_SobelSub, 1.0, 0.7, 0.90);
end;

---- Part 7
CAddEvent(EV_FF_SETVAR,    131.00, Box, SET_VAR_FLOAT, "Intens", 1.0, 0.0, 2);
CAddEvent(EV_FX_UNATTACH,  133.00, Box         );
CAddEvent(EV_FX_UNATTACH,  131.00, I_R4        );
CAddEvent(EV_FX_ATTACH,    131.00, I_B1,      0);
CAddEvent(EV_FX_ATTACH,    131.00, I_B2,      1);
CAddEvent(EV_FX_ATTACH,    131.00, FX_SprSph, 9);
CAddEvent(EV_FF_SETVAR,    131.00, FX_SprSph, SET_VAR_FLOAT, "Max Size", 1.0, 0.6, 2);
CAddEvent(EV_FX_SETALPHA,  131.00+0*2, FX_SprSph, 1.0, 0.4, 2);
CAddEvent(EV_FX_SETALPHA,  131.00+1*2, FX_SprSph, 0.4, 1.0, 2);
CAddEvent(EV_FX_SETALPHA,  131.00+2*2, FX_SprSph, 1.0, 0.4, 2);
CAddEvent(EV_FX_SETALPHA,  131.00+3*2, FX_SprSph, 0.4, 1.0, 2);
CAddEvent(EV_FX_SETALPHA,  131.00+4*2, FX_SprSph, 1.0, 0.4, 2);
CAddEvent(EV_FX_SETALPHA,  131.00+5*2, FX_SprSph, 0.4, 1.0, 2);
CAddEvent(EV_FX_SETALPHA,  131.00+6*2, FX_SprSph, 1.0, 0.4, 2);
CAddEvent(EV_FX_SETALPHA,  131.00+7*2, FX_SprSph, 0.4, 1.0, 2);
CAddEvent(EV_FX_SETALPHA,  131.00+8*2, FX_SprSph, 1.0, 0.4, 2);
CAddEvent(EV_FX_SETALPHA,  131.00+9*2, FX_SprSph, 0.4, 1.0, 2);

---- Part 8
CAddEvent(EV_FX_UNATTACH,  149.00, I_B1        );
CAddEvent(EV_FX_UNATTACH,  149.00, I_B2        );
CAddEvent(EV_FX_ATTACH,    150.00, I_Sunset2, 0);
CAddEvent(EV_FX_ATTACH,    150.00, I_R3,      1);
CAddEvent(EV_FX_ATTACH,    150.00, I_R4,      2);
CAddEvent(EV_FX_ATTACH,    150.00, I_F1_Sub,  3);
CAddEvent(EV_FX_ATTACH,    150.00, Star,      5);
CAddEvent(EV_FX_ATTACH,    150.00, FX_Half,   9);

---- Part 9
CAddEvent(EV_FX_UNATTACH,  169.00, I_F1_Sub    );
CAddEvent(EV_FX_UNATTACH,  169.00, I_R3        );
CAddEvent(EV_FX_UNATTACH,  169.00, I_R4        );

CAddEvent(EV_FX_SETALPHA,  169.00, FX_Color,  0.50);
CAddEvent(EV_FX_ATTACH,    169.00, FX_Color,  9);
CAddEvent(EV_FX_ATTACH,    169.00, I_Sunset2, 0);
CAddEvent(EV_FX_ATTACH,    169.00, Hexas,     5);
CAddEvent(EV_FX_SETVAR,    179.00, Hexas, SET_VAR_INT, "", "", "Camera", 0);
CAddEvent(EV_FX_SETVAR,    189.00, Hexas, SET_VAR_INT, "", "", "Camera", 1);
CAddEvent(EV_FX_SETVAR,    193.00, FX_Color,  SET_VAR_FLOAT, "", "", "GlowIntens", 0.5, 1.0, 3.0);
CAddEvent(EV_FX_SETVAR,    197.00, FX_Color,  SET_VAR_FLOAT, "", "", "GlowIntens", 1.0, 0.3, 3.0);
CAddEvent(EV_FX_SETALPHA,  193.00, FX_Color,  0.50, 1.0, 3);
CAddEvent(EV_FX_SETALPHA,  197.00, FX_Color,  1.00, 0.2, 3);

---- Part 10
CAddEvent(EV_FX_SETVAR,    197.00, Torus1, SET_VAR_INT, "", "", "Camera", 0);
CAddEvent(EV_FX_SETVAR,    197.00, Torus2, SET_VAR_INT, "", "", "Camera", 1);
CAddEvent(EV_FX_SETVAR,    197.00, Torus3, SET_VAR_INT, "", "", "Camera", 2);

CAddEvent(EV_FX_ATTACH,    197.00, Torus1,    5);
CAddEvent(EV_FX_ATTACH,    205.00, Torus2,    5);
CAddEvent(EV_FX_ATTACH,    213.00, Torus3,    5);

---- End
CAddEvent(EV_FX_ATTACH,    216.00, I_End, 8);
CAddEvent(EV_FX_SETALPHA,  216.00, I_End, 0.00, 1.0, 20);
