@ARM

		b main

;------------------------------------------------------------------------------------------
; Just initialize 240x160x15 Bit
;------------------------------------------------------------------------------------------

		yakuza	@include yakuza.asm
		pathtable @include path.asm
		blobpic	@include blob.asm
		GFXReg 	@DCD 0x04000000
		Mode	@DCD 0x0403		; Mode 3, BG 2 enable

@textarea 0x03000000

	blobende  @DCW 0
	blobway	  @DCW 0

@endarea


initGFX		ldr r0,[GFXReg]
		ldr r1,[Mode]
		str r1,[r0]
		mov r1,0x0
		mov r0,blobende
		strh r1,[r0],#2
		strh r1,[r0]

initGFX_end	mov r15,r14


;------------------------------------------------------------------------------------------
; Use eRAM as Framebuffer, copy with Showbuffer the frame to vRam and delete framebuffer
;------------------------------------------------------------------------------------------


		eRAM		@DCD 0x02000000		; Extended RAM - 256 kb, 16 Bit
		vRAM		@DCD 0x06000000		; Video - RAM - 96 kb, 16 Bit
		vsync 		@DCD 0x04000006		; VBlank = 160
		DMA3src		@DCD 0x040000D4		; Source Adress for transfer
		DMA3des		@DCD 0x040000D8		; Destination Adress for transfer
		DMA3Cnt		@DCD 0x040000DC		; Count (16 Bit)
		DMA3CR		@DCD 0x040000DE		; DMA3 Controll-register (16 Bit)

		ClearBuffer 	@DCW 0x04B00
				@DCW 0x08500		; Key to [DMA3CR]
		CopyBuffer	@DCW 0x04B00
				@DCW 0x08400		;      - " -
		
	
showbuffer	stmfd r13!,{r0-r7}			; Push registers
		
		ldr r0,[vsync]
_waitvblank	ldrh r1,[r0]
		cmp r1,160
		blt _waitVblank

_copybuffer	ldr r0,[DMA3src]
		ldr r1,[eRAM]
		str r1,[r0],#4
		ldr r3,[vRAM]
		str r3,[r0],#4
		ldr r7,[CopyBuffer]
		str r7,[r0]				; Start DMA Transfer

_clearbuffer	ldr r0,[DMA3src]
		mov r1,yakuza
		str r1,[r0],#4
		ldr r3,[eRAM]
		str r3,[r0],#4
		ldr r7,[ClearBuffer]
		str r7,[r0]

		ldmfd r13!,{r0-r7}
showbuffer_end	mov r15,r14

;------------------------------------------------------------------------------------------
; Copper-Bar, r10 - Y, r3 Nummer
;------------------------------------------------------------------------------------------

		CopyCopper	@DCW 0x0780
				@DCW 0x08400


Show_Copper	stmfd r13!,{r0-r4,r10}

		mov r1,240
		mov r1,r1,lsl#1
		ldr r2,[eRam]
		mla r4,r1,r10,r2			; DestADR
		mov r2,yakuza
		mov r3,r3,lsl#4				; CopperNr. * 16
		mla r2,r1,r3,r2

_makecopper	ldr r0,[DMA3src]
		str r2,[r0],#4
		str r4,[r0],#4
		ldr r3,[CopyCopper]
		str r3,[r0]				; Start DMA Transfer

show_copperend	ldmfd r13!,{r0-r4,r10}
		mov r15,r14		
		
;- Winkel in r0, 10 Bars ....

copper_Welle	stmfd r13!,{r0,r1,r3,r4,r10,r14}

		mov r3,9

_alle10		mov r1,sin
		and r0,r0,0xff				; 256 Winkel
		mov r4,r0,lsl#2				; winkel * 4
		add r1,r1,r4				; Sinuswert-Adresse
		ldr r4,[r1]				; r4 ist der sin ...

		mov r1,72
		mul r10,r1,r4
		mov r10,r10,asr#10			; Y Wert
		add r10,r10,72
		bl Show_copper
		add r0,r0,#12				; 1 Grad mehr ...
		sub r3,r3,#1
		cmp r3,0
		bge _alle10

Copper_Welleend	ldmfd r13!,{r0,r1,r3,r4,r10,r14}
		mov r15,r14

;------------------------------------------------------------------------------------------
; Blob ...
;------------------------------------------------------------------------------------------

		maxblobs @DCW 269
		zeilen	@DCW 456
		blue @DCW 0x5120

makepath	stmfd r13!,{ r0-r12 }

		mov r0,blobway
		ldrh r2,[r0]				; wg. Bewegungseindurck Verschiebung
		mov r1,pathtable
		add r1,r1,r2
		cmp r2,#0
		
		movne r2,#0
		moveq r2,#4
		strh r2,[r0] 

		mov r2,blobende
		ldrh r4,[r2]				; wo hre ich auf ...

		ldrh r5,[maxblobs]
		cmp r4,r5
		beq _theend
		add r4,r4,#1				; das Ende wchst
		strh r4,[r2]				; schreibe neue Werte

_theend		ldrh r2,[blue]
		ldrh r12,[zeilen]

_moreblobs	ldr r6,[r1],#8				; Lade X
		
		mov r8,blobpic
		mov r9,12

_nexta		mov r10,12
_nextb		ldrh r11,[r8],#2
		cmp r11,r2
		beq _nothi
		strh r11,[r6]
_nothi		add r6,r6,#2
		sub r10,r10,#1
		cmp r10,0
		bgt _nextb
		add r6,r6,r12

		sub r9,r9,#1
		cmp r9,#0
		bgt _nexta

		sub r4,r4,#1
		cmp r4,#0
		bne _moreblobs
		
		ldmfd r13!,{ r0-r12 }
		mov r15,r14

;------------------------------------------------------------------------------------------
; Main routine ...
;------------------------------------------------------------------------------------------

main		bl initGFX	
 
		mov r0,128


overandover	
		
		bl Copper_Welle
		bl makepath
		bl showBuffer
		add r0,r0,#4
		and r0,r0,#0xff

theend		b overandover

sin   @DCD #0x00000000
      @DCD #0x00000019,#0x00000032,#0x0000004B,#0x00000064
      @DCD #0x0000007D,#0x00000096,#0x000000AF,#0x000000C7
      @DCD #0x000000E0,#0x000000F8,#0x00000111,#0x00000129
      @DCD #0x00000141,#0x00000158,#0x00000170,#0x00000187
      @DCD #0x0000019E,#0x000001B5,#0x000001CC,#0x000001E2
      @DCD #0x000001F8,#0x0000020E,#0x00000223,#0x00000238
      @DCD #0x0000024D,#0x00000261,#0x00000275,#0x00000289
      @DCD #0x0000029C,#0x000002AF,#0x000002C2,#0x000002D4
      @DCD #0x000002E5,#0x000002F6,#0x00000307,#0x00000317
      @DCD #0x00000327,#0x00000336,#0x00000345,#0x00000353
      @DCD #0x00000361,#0x0000036E,#0x0000037A,#0x00000387
      @DCD #0x00000392,#0x0000039D,#0x000003A8,#0x000003B2
      @DCD #0x000003BB,#0x000003C4,#0x000003CC,#0x000003D3
      @DCD #0x000003DA,#0x000003E1,#0x000003E7,#0x000003EC
      @DCD #0x000003F0,#0x000003F4,#0x000003F8,#0x000003FB
      @DCD #0x000003FD,#0x000003FE,#0x000003FF,#0x000003FF
      @DCD #0x000003FF,#0x000003FE,#0x000003FD,#0x000003FB
      @DCD #0x000003F8,#0x000003F4,#0x000003F0,#0x000003EC
      @DCD #0x000003E7,#0x000003E1,#0x000003DA,#0x000003D3
      @DCD #0x000003CC,#0x000003C4,#0x000003BB,#0x000003B2
      @DCD #0x000003A8,#0x0000039D,#0x00000392,#0x00000387
      @DCD #0x0000037A,#0x0000036E,#0x00000361,#0x00000353
      @DCD #0x00000345,#0x00000336,#0x00000327,#0x00000317
      @DCD #0x00000307,#0x000002F6,#0x000002E5,#0x000002D4
      @DCD #0x000002C2,#0x000002AF,#0x0000029C,#0x00000289
      @DCD #0x00000275,#0x00000261,#0x0000024D,#0x00000238
      @DCD #0x00000223,#0x0000020E,#0x000001F8,#0x000001E2
      @DCD #0x000001CC,#0x000001B5,#0x0000019E,#0x00000187
      @DCD #0x00000170,#0x00000158,#0x00000141,#0x00000129
      @DCD #0x00000111,#0x000000F8,#0x000000E0,#0x000000C7
      @DCD #0x000000AF,#0x00000096,#0x0000007D,#0x00000064
      @DCD #0x0000004B,#0x00000032,#0x00000019,#0x00000000
      @DCD #0xFFFFFFE7,#0xFFFFFFCE,#0xFFFFFFB5,#0xFFFFFF9C
      @DCD #0xFFFFFF83,#0xFFFFFF6A,#0xFFFFFF51,#0xFFFFFF39
      @DCD #0xFFFFFF20,#0xFFFFFF08,#0xFFFFFEEF,#0xFFFFFED7
      @DCD #0xFFFFFEBF,#0xFFFFFEA8,#0xFFFFFE90,#0xFFFFFE79
      @DCD #0xFFFFFE62,#0xFFFFFE4B,#0xFFFFFE34,#0xFFFFFE1E
      @DCD #0xFFFFFE08,#0xFFFFFDF2,#0xFFFFFDDD,#0xFFFFFDC8
      @DCD #0xFFFFFDB3,#0xFFFFFD9F,#0xFFFFFD8B,#0xFFFFFD77
      @DCD #0xFFFFFD64,#0xFFFFFD51,#0xFFFFFD3E,#0xFFFFFD2C
      @DCD #0xFFFFFD1B,#0xFFFFFD0A,#0xFFFFFCF9,#0xFFFFFCE9
      @DCD #0xFFFFFCD9,#0xFFFFFCCA,#0xFFFFFCBB,#0xFFFFFCAD
      @DCD #0xFFFFFC9F,#0xFFFFFC92,#0xFFFFFC86,#0xFFFFFC79
      @DCD #0xFFFFFC6E,#0xFFFFFC63,#0xFFFFFC58,#0xFFFFFC4E
      @DCD #0xFFFFFC45,#0xFFFFFC3C,#0xFFFFFC34,#0xFFFFFC2D
      @DCD #0xFFFFFC26,#0xFFFFFC1F,#0xFFFFFC19,#0xFFFFFC14
      @DCD #0xFFFFFC10,#0xFFFFFC0C,#0xFFFFFC08,#0xFFFFFC05
      @DCD #0xFFFFFC03,#0xFFFFFC02,#0xFFFFFC01,#0xFFFFFC01
      @DCD #0xFFFFFC01,#0xFFFFFC02,#0xFFFFFC03,#0xFFFFFC05
      @DCD #0xFFFFFC08,#0xFFFFFC0C,#0xFFFFFC10,#0xFFFFFC14
      @DCD #0xFFFFFC19,#0xFFFFFC1F,#0xFFFFFC26,#0xFFFFFC2D
      @DCD #0xFFFFFC34,#0xFFFFFC3C,#0xFFFFFC45,#0xFFFFFC4E
      @DCD #0xFFFFFC58,#0xFFFFFC63,#0xFFFFFC6E,#0xFFFFFC79
      @DCD #0xFFFFFC86,#0xFFFFFC92,#0xFFFFFC9F,#0xFFFFFCAD
      @DCD #0xFFFFFCBB,#0xFFFFFCCA,#0xFFFFFCD9,#0xFFFFFCE9
      @DCD #0xFFFFFCF9,#0xFFFFFD0A,#0xFFFFFD1B,#0xFFFFFD2C
      @DCD #0xFFFFFD3E,#0xFFFFFD51,#0xFFFFFD64,#0xFFFFFD77
      @DCD #0xFFFFFD8B,#0xFFFFFD9F,#0xFFFFFDB3,#0xFFFFFDC8
      @DCD #0xFFFFFDDD,#0xFFFFFDF2,#0xFFFFFE08,#0xFFFFFE1E
      @DCD #0xFFFFFE34,#0xFFFFFE4B,#0xFFFFFE62,#0xFFFFFE79
      @DCD #0xFFFFFE90,#0xFFFFFEA8,#0xFFFFFEBF,#0xFFFFFED7
      @DCD #0xFFFFFEEF,#0xFFFFFF08,#0xFFFFFF20,#0xFFFFFF39
      @DCD #0xFFFFFF51,#0xFFFFFF6A,#0xFFFFFF83,#0xFFFFFF9C
      @DCD #0xFFFFFFB5,#0xFFFFFFCE,#0xFFFFFFE7,#0x00000000

cos   @DCD #0x000003FF
      @DCD #0x000003FF,#0x000003FE,#0x000003FD,#0x000003FB
      @DCD #0x000003F8,#0x000003F4,#0x000003F0,#0x000003EC
      @DCD #0x000003E7,#0x000003E1,#0x000003DA,#0x000003D3
      @DCD #0x000003CC,#0x000003C4,#0x000003BB,#0x000003B2
      @DCD #0x000003A8,#0x0000039D,#0x00000392,#0x00000387
      @DCD #0x0000037A,#0x0000036E,#0x00000361,#0x00000353
      @DCD #0x00000345,#0x00000336,#0x00000327,#0x00000317
      @DCD #0x00000307,#0x000002F6,#0x000002E5,#0x000002D4
      @DCD #0x000002C2,#0x000002AF,#0x0000029C,#0x00000289
      @DCD #0x00000275,#0x00000261,#0x0000024D,#0x00000238
      @DCD #0x00000223,#0x0000020E,#0x000001F8,#0x000001E2
      @DCD #0x000001CC,#0x000001B5,#0x0000019E,#0x00000187
      @DCD #0x00000170,#0x00000158,#0x00000141,#0x00000129
      @DCD #0x00000111,#0x000000F8,#0x000000E0,#0x000000C7
      @DCD #0x000000AF,#0x00000096,#0x0000007D,#0x00000064
      @DCD #0x0000004B,#0x00000032,#0x00000019,#0x00000000
      @DCD #0xFFFFFFE7,#0xFFFFFFCE,#0xFFFFFFB5,#0xFFFFFF9C
      @DCD #0xFFFFFF83,#0xFFFFFF6A,#0xFFFFFF51,#0xFFFFFF39
      @DCD #0xFFFFFF20,#0xFFFFFF08,#0xFFFFFEEF,#0xFFFFFED7
      @DCD #0xFFFFFEBF,#0xFFFFFEA8,#0xFFFFFE90,#0xFFFFFE79
      @DCD #0xFFFFFE62,#0xFFFFFE4B,#0xFFFFFE34,#0xFFFFFE1E
      @DCD #0xFFFFFE08,#0xFFFFFDF2,#0xFFFFFDDD,#0xFFFFFDC8
      @DCD #0xFFFFFDB3,#0xFFFFFD9F,#0xFFFFFD8B,#0xFFFFFD77
      @DCD #0xFFFFFD64,#0xFFFFFD51,#0xFFFFFD3E,#0xFFFFFD2C
      @DCD #0xFFFFFD1B,#0xFFFFFD0A,#0xFFFFFCF9,#0xFFFFFCE9
      @DCD #0xFFFFFCD9,#0xFFFFFCCA,#0xFFFFFCBB,#0xFFFFFCAD
      @DCD #0xFFFFFC9F,#0xFFFFFC92,#0xFFFFFC86,#0xFFFFFC79
      @DCD #0xFFFFFC6E,#0xFFFFFC63,#0xFFFFFC58,#0xFFFFFC4E
      @DCD #0xFFFFFC45,#0xFFFFFC3C,#0xFFFFFC34,#0xFFFFFC2D
      @DCD #0xFFFFFC26,#0xFFFFFC1F,#0xFFFFFC19,#0xFFFFFC14
      @DCD #0xFFFFFC10,#0xFFFFFC0C,#0xFFFFFC08,#0xFFFFFC05
      @DCD #0xFFFFFC03,#0xFFFFFC02,#0xFFFFFC01,#0xFFFFFC01
      @DCD #0xFFFFFC01,#0xFFFFFC02,#0xFFFFFC03,#0xFFFFFC05
      @DCD #0xFFFFFC08,#0xFFFFFC0C,#0xFFFFFC10,#0xFFFFFC14
      @DCD #0xFFFFFC19,#0xFFFFFC1F,#0xFFFFFC26,#0xFFFFFC2D
      @DCD #0xFFFFFC34,#0xFFFFFC3C,#0xFFFFFC45,#0xFFFFFC4E
      @DCD #0xFFFFFC58,#0xFFFFFC63,#0xFFFFFC6E,#0xFFFFFC79
      @DCD #0xFFFFFC86,#0xFFFFFC92,#0xFFFFFC9F,#0xFFFFFCAD
      @DCD #0xFFFFFCBB,#0xFFFFFCCA,#0xFFFFFCD9,#0xFFFFFCE9
      @DCD #0xFFFFFCF9,#0xFFFFFD0A,#0xFFFFFD1B,#0xFFFFFD2C
      @DCD #0xFFFFFD3E,#0xFFFFFD51,#0xFFFFFD64,#0xFFFFFD77
      @DCD #0xFFFFFD8B,#0xFFFFFD9F,#0xFFFFFDB3,#0xFFFFFDC8
      @DCD #0xFFFFFDDD,#0xFFFFFDF2,#0xFFFFFE08,#0xFFFFFE1E
      @DCD #0xFFFFFE34,#0xFFFFFE4B,#0xFFFFFE62,#0xFFFFFE79
      @DCD #0xFFFFFE90,#0xFFFFFEA8,#0xFFFFFEBF,#0xFFFFFED7
      @DCD #0xFFFFFEEF,#0xFFFFFF08,#0xFFFFFF20,#0xFFFFFF39
      @DCD #0xFFFFFF51,#0xFFFFFF6A,#0xFFFFFF83,#0xFFFFFF9C
      @DCD #0xFFFFFFB5,#0xFFFFFFCE,#0xFFFFFFE7,#0x00000000
      @DCD #0x00000019,#0x00000032,#0x0000004B,#0x00000064
      @DCD #0x0000007D,#0x00000096,#0x000000AF,#0x000000C7
      @DCD #0x000000E0,#0x000000F8,#0x00000111,#0x00000129
      @DCD #0x00000141,#0x00000158,#0x00000170,#0x00000187
      @DCD #0x0000019E,#0x000001B5,#0x000001CC,#0x000001E2
      @DCD #0x000001F8,#0x0000020E,#0x00000223,#0x00000238
      @DCD #0x0000024D,#0x00000261,#0x00000275,#0x00000289
      @DCD #0x0000029C,#0x000002AF,#0x000002C2,#0x000002D4
      @DCD #0x000002E5,#0x000002F6,#0x00000307,#0x00000317
      @DCD #0x00000327,#0x00000336,#0x00000345,#0x00000353
      @DCD #0x00000361,#0x0000036E,#0x0000037A,#0x00000387
      @DCD #0x00000392,#0x0000039D,#0x000003A8,#0x000003B2
      @DCD #0x000003BB,#0x000003C4,#0x000003CC,#0x000003D3
      @DCD #0x000003DA,#0x000003E1,#0x000003E7,#0x000003EC
      @DCD #0x000003F0,#0x000003F4,#0x000003F8,#0x000003FB
      @DCD #0x000003FD,#0x000003FE,#0x000003FF,#0x000003FF
		