{
  INHALT:
  - Movsw (wordweises Move)
  - FillWord
  - BLine (Linie nach dem Bresenham-Algorithmus)
  - KillScreen (32 Bit)
  - Markieren (Rand marieren fr FillPoly)
  - KillRand (32 Bit)
  - FillRand (FillPoly fr beliebige Figuren in RAND)
  - InterpolRand (Rand markieren mit Interpolation)
  - GouraudFill (fllt mit Interpolation der Randfarben)
}


Var
  Rand0, Rand1: Array[0..319] of Word;
  Farben0, Farben1: Array[0..319] of Byte;
  vp: Word;    {pakt*16000!}
  col: Byte;   {globale Farbvariable}


Procedure Movsd(Var source, dest; Count: Integer); Assembler;
asm
  push ds
  lds si, source
  les di, dest
  mov cx, count
  db $66
  rep movsw
  pop ds
End;


Procedure FillDWord(Var dest; Count: Integer; Value: Longint); Assembler;
asm
  les di, dest
  mov cx, count
  db $66
  mov ax, Word Ptr Value
  db $66
  rep stosw
End;


Procedure FillWord(Var dest; Count, Value: Word); Assembler;
asm
  les di, dest
  mov cx, count
  mov ax, Value
  rep stosw
End;


Procedure PlanesOn; Assembler;
asm
  mov dx, $3c4     {alle Planes selektieren...}
  mov ax, 111100000010b
  out dx, ax
End;


Procedure BLine(x1, y1, x2, y2: Integer; Farbe: Byte); Assembler;
Var
  k, deltax, deltay,
  stepx, stepy: Integer;
asm
  mov ax, $a000
  mov es, ax
  mov stepx, 1
  mov ax, x2    {dx:=(x2-x1);}
  sub ax, x1    {if dx<0 then dx:=-dx;}
  jns @deltaxOK
  neg ax
  neg stepx      {if x2>x1 then stepx:=1 else stepx:=-1;}
 @deltaxOK:
  mov stepy, 1
  mov deltax, ax
  mov bx, y2     {dy:=(y2-y1);}
  sub bx, y1
  or bx, bx      {if dy<0 then dy:=-dy;}
  jns @deltayOK
  neg bx
  neg stepy      {if y2>y1 then stepy:=1 else stepy:=-1;}
 @deltayOK:
  mov deltay, bx
  mov k, ax      {if deltax=0 then k:=0 else k:=-(deltax shr 1);}
  shr k, 1
  mov si, x1     {x:=x1;y:=y1;}
  mov bx, y1
  mov cx, si     {Point(x,y,col);}
  and cx, 3
  mov ax, 100000010b
  shl ah, cl
  mov dx, $3c4
  out dx, ax
  mov di, si
  shr di, 2
  mov ax, 80
  mul bx
  add di, ax
  add di, vp
  mov al, Farbe
  mov es:[di], al
  mov dx, k
 @Schleife:     {while not ((x=x2)and(y=y2)) do begin}
      cmp si, x2
      jne @weiter
      cmp bx, y2
      je @Ende
     @weiter:
      or dx, dx    {if (k>=0)and(y<>y2) then begin}
      jl @kleiner
      cmp bx, y2
      je @kleiner
      add bx, stepy      {y:=y+stepy;}
      sub dx, deltax     {k:=k-deltax;}
      jmp @PunktSetzen
     @kleiner:
      add si, stepx      {x:=x+stepx;}
      add dx, deltay      {k:=k+deltay;}
     @PunktSetzen:
      push dx
      mov cx, si     {Point(x,y,col);}
      and cx, 3
      mov ax, 100000010b
      shl ah, cl
      mov dx, $3c4
      out dx, ax
      mov di, si
      shr di, 2
      mov ax, 80
      mul bx
      add di, ax
      add di, vp
      mov al, Farbe
      mov es:[di], al
      pop dx
  jmp @Schleife
 @Ende:
End;


Procedure Movsw(Var source, dest; Count: Integer); Assembler;
asm
  push ds
  lds si, source
  les di, dest
  mov cx, count
  rep movsw
  pop ds
End;


Procedure KillScreen; Assembler;
{lscht die aktuelle Seite}
asm
  mov ax, 111100000010b  {alle Planes}
  mov dx, 3c4h
  out dx, ax
  mov ax, $a000
  mov es, ax
  mov di, vp
  cld                    {sicher ist sicher}
  db 66h
  xor ax, ax
  mov cx, 4000
  db 66h
  rep stosw
End;


Procedure Markieren(x1, y1, x2, y2: Integer); Assembler;
{Rand zum Fllen markiren}
asm
  mov di, x1          {i:=x1}
  mov si, x2          {deltax:=x2-x1}
  sub si, di
  or si, si
  jz @keindiv
  mov cx, y2          {deltay:=y2-y1}
  sub cx, y1
 @While:
  cmp di, x2          {While i <> x2 do...}
  je @Schluss
  jg @groesser
  inc di
  jmp @diOK
 @groesser:
  dec di
 @diOK:
  mov ax, di          {p:=y1+deltay*(i-x1) div deltax}
  sub ax, x1
  imul cx
  idiv si
  add ax, y1
  mov bx, di          {if (p<rand0[i]) or (rand0[i]=0) then rand0[i]:=p}
  shl bx, 1
  add bx, offset rand0
  cmp [bx], ax
  jg @weiter0
  cmp Word Ptr [bx], 0
  jnz @naextes0
 @weiter0:
  mov [bx], ax
 @naextes0:
  mov bx, di             {if (p>rand1[i]) or (rand1[i]=0) then rand1[i]:=p}
  shl bx, 1
  add bx, offset rand1
  cmp [bx], ax
  jl @weiter1
  cmp Word Ptr [bx], 0
  jnz @While
 @weiter1:
  mov [bx], ax
  jmp @While          {Rcksprung}
 @keindiv:
  mov bx, Offset Rand0
  mov di, x1
  shl di, 1
  mov ax, y1
  mov [bx+di], ax
  mov bx, Offset Rand1
  mov ax, y2
  mov [bx+di], ax
 @Schluss:
End;



Procedure KillRand; Assembler;
asm
  mov ax, ds
  mov es, ax
  db 66h
  xor ax, ax
  mov di, Offset rand0
  mov cx, 160
  db 66h
  rep stosw
  mov di, Offset rand1
  mov cx, 160
  db 66h
  rep stosw
End;


Procedure KillFarben; Assembler;
asm
  mov ax, ds
  mov es, ax
  db 66h
  xor ax, ax
  mov di, offset Farben0
  mov cx, 80
  db 66h
  rep stosw
  mov di, offset Farben1
  mov cx, 80
  db 66h
  rep stosw
End;



Procedure FillRand; Assembler;
asm
  mov ax, $a000        {Bildschirmstart}
  mov es, ax
  push bp              {BP sichern, da Schleifenzhler}
  mov bp, 319           {For i:=0 to 319 do...}
 @aSchleife:
  mov bx, bp           {bx mit rand1 laden}
  shl bx, 1
  add bx, offset Rand1
  mov bx, [bx]
  or bx, bx
  jz @Ruecksprung      {rand1=0: Rcksprung}
  mov di, bp           {si mit rand0 laden}
  shl di, 1
  add di, offset Rand0
  mov si, [di]
  mov cx, bp        {  Write-Plane auswhlen...  }
  and cx, 3
  mov ax, 100000010b
  shl ah, cl
  mov dx, 3c4h
  out dx, ax
  mov di, bp        {  offs:=y*80+x/4+pakt*16000}
  shr di, 2
  mov ax, 80d
  mul si
  add di, ax
  add di, vp
  mov al, col
  sub bx, si        {  count:=y2-y1}
 @vSchleife:        { vertikale Linie von y1 nach y2}
  mov es:[di], al
  add di, 80
  dec bx
  jns @vSchleife
 @Ruecksprung:      { Schleifenende}
  dec bp
  jns @aSchleife
  pop bp
End;


Procedure InterpolRand(x1,y1,x2,y2:integer; col1, col2: Integer); Assembler;
Var
  deltax, deltay, coldiff: Integer;
asm
  mov cx, y2         {deltay:=y2-y1;}
  sub cx, y1
  mov deltay, cx
  mov si, x1
  mov cx, x2         {deltax:=x2-x1;}
  sub cx, si
  mov deltax, cx
  mov ax, col2       {coldiff:=(col2-col1) shl 8 div deltax}
  sub ax, col1
  shl ax, 8
  cwd
  or cx, cx
  jz @keindiv
  idiv cx
  mov coldiff, ax
 @Schleife:
  cmp si, x2
  je @Ende
  jg @groesser
  inc si
  jmp @iOK
 @groesser:
  dec si
 @iOK:
  {p:=y1+(y2-y1)*(i-x1) div deltax;}
  mov ax, si
  sub ax, x1
  imul deltay
  idiv deltax
  add ax, y1
  mov cx, ax
  {If (p<rand0[i])or(rand0[i]=0) then rand0[i]:=p;}
  mov bx, Offset Rand0
  mov di, si
  shl di, 1
  add bx, di
  mov ax, [bx]
  cmp cx, ax
  jl @kleiner
  or ax, ax
  jnz @tunix
 @kleiner:
  mov [bx], cx
  {Farben0[i]:=col1+(col2-col1)*(i-x1) div deltax;}
  mov bx, Offset Farben0
  mov ax, si
  sub ax, x1
  imul coldiff
  sar ax, 8
  add ax, col1
  mov [bx+si], al
 @tunix:
  {If (p>rand1[i])or(rand1[i]=0) then rand1[i]:=p;}
  mov bx, Offset Rand1
  mov di, si
  shl di, 1
  add bx, di
  mov ax, [bx]
  cmp cx, ax
  jg @kleiner2
  or ax, ax
  jnz @tunix2
 @kleiner2:
  mov [bx], cx
  {Farben1[i]:=col1+(col2-col1)*(i-x1) div deltax;}
  mov bx, Offset Farben1
  mov ax, si
  sub ax, x1
  imul coldiff
  sar ax, 8
  add ax, col1
  mov [bx+si], al
 @tunix2:
  jmp @Schleife
 @keindiv:
  mov bx, Offset Rand0
  mov di, x1
  shl di, 1
  mov ax, y1
  mov [bx+di], ax
  mov bx, Offset Rand1
  mov ax, y2
  mov [bx+di], ax
  mov bx, Offset Farben0
  shr di, 1
  mov ax, col1
  mov [bx+di], al
  mov ax, col2
  mov bx, Offset Farben1
  mov [bx+di], al
 @Ende:
End;



Procedure GouraudFill; Assembler;
asm
  mov ax, $a000        {Bildschirmstart}
  mov es, ax
  push bp              {BP sichern, da Schleifenzhler}
  mov bp, 319           {For i:=0 to 319 do...}
 @aSchleife:
  mov bx, bp           {bx mit rand1 laden}
  shl bx, 1
  add bx, offset Rand1
  mov bx, [bx]
  or bx, bx
  jz @Ruecksprung      {rand1=0: Rcksprung}
  mov di, bp           {si mit rand0 laden}
  shl di, 1
  add di, offset Rand0
  mov si, [di]
  mov cx, bp        {  Write-Plane auswhlen...  }
  and cx, 3
  mov ax, 100000010b
  shl ah, cl
  mov dx, 3c4h
  out dx, ax
  mov di, bp        {  offs:=y*80+x/4+pakt*16000}
  shr di, 2
  mov ax, 80d
  mul si
  add di, ax
  add di, vp
  mov al, col
  sub bx, si             {  count:=y2-y1}
  mov cx, bx             {Zhler nach cx}
  mov bx, Offset Farben0 {Randfarbwert 0 laden}
  add bx, bp
  mov dh, [bx]          {...und nach DH ("Festkomma") }
  xor dl, dl
  mov bx, Offset Farben1 {Randfarbwert 1 laden}
  add bx, bp
  mov ah, [bx]              {und nach AH}
  xor al, al
  sub ax, dx             {Farbdifferenz bilden...}
  mov si, dx             {DX vor Division sichern}
  cwd
  or cx, cx              {...und durch Hhe<>0 dividieren}
  jz @keindiv
  idiv cx
 @keindiv:
  mov dx, si
 @pSchleife:        { vertikale Linie von y1 nach y2}
  mov es:[di], dh
  add di, 80
  add dx, ax
  dec cx
  jns @pSchleife
 @Ruecksprung:      { Schleifenende}
  dec bp
  jnl @aSchleife
  pop bp
End;

