
Procedure CopyScreen; Assembler;
asm
  call Enable4
  push ds
  mov si, 48000
  mov di, vp
  mov ax, $a000
  mov es, ax
  mov ds, ax
  mov cx, 16000
  rep movsb
  pop ds
  mov dx,3ceh
  mov ax,4005h
  out dx,ax
End;

Procedure Main;
Var
  Background: Boolean;
  Wuerfel: PPhongFigur;
  i, j, k, xstep, ystep, zstep,
  count: Integer;
  c: Char;
  texname: String;
  datei: Text;
Begin
  BackGround:=False;
  xstep:=2; ystep:=3; zstep:=2;
  {$I-}
  Assign(datei, filename);
  Reset(datei); texname:='';
  {$I+}
  If IOResult<>0 then
  Begin
    TextMode(co80);
    writeln('Die Datei gibt es nicht.');
    Halt;
  End;
  While (texname<>objname) and not eof(datei) do
  Begin
    readln(datei, texname);
    While Pos(' ', texname)<>0 do
      Delete(texname, Pos(' ', texname), 1);
    texname:=UpString(texname);
  End;
  If texname<>objname then
  Begin
    Close(datei);
    TextMode(co80);
    writeln('Dieses Objekt existiert nicht. Hast du dich vertippt?');
    Halt;
  End;
  While not (eof(datei) or (UpString(texname)='OBJEND')) do
  Begin
    Readln(datei, texname);
    While Pos(' ', texname)<>0 do
      Delete(texname, Pos(' ', texname), 1);
    texname:=UpString(texname);
      If texname='TEXTURE' then
      Begin
        readln(datei, texname);
        PrepTextures(texname, 0);
      End;
      If (texname = 'DRAHT') or
         (texname = 'FLAECHEN') or
         (texname = 'SHADE') or
         (texname = 'GOURAUD') or
         (texname = 'PHONG') then
      Begin
        readln(datei, texname);
        texname:=UpString(texname);
        PrepPal(texname);
      End;
    If texname='BACKGROUND' then
    Begin
      readln(datei, texname);
      LoadGif(texname, 0, 48000);
      Background:=True;
    End;
    If texname='WINKEL' then
    Begin
      readln(datei, xstep);
      readln(datei, ystep);
      readln(datei, zstep);
    End;
  End;
  Close(datei);
  GetMem(Wuerfel, Sizeof(tPhongFigur));
  pakt:=0;
  KillScreen;
  With Wuerfel^ do
  Begin
    Init(filename, objname);
    For i:=1 to nop do
    Begin
      uxko[i]:=round(uxko[i]*xscal div 100);
      uyko[i]:=round(uyko[i]*yscal div 100);
      uzko[i]:=round(uzko[i]*zscal div 100);
    End;
    {Hier kann der Farbverlauf gendert werden :-) }
    i:=62; j:=32; k:=30;
    Repeat
      Movsw(uxko, bxko, nop);
      Movsw(uyko, byko, nop);
      Movsw(uzko, bzko, nop);
      pakt:=1-pakt;
      vp:=pakt*16000;
      If Background then CopyScreen
      Else KillScreen;
      inc(i, xstep);
      inc(j, ystep);
      inc(k, zstep);
      if i>=360 then i:=0;
      if j>=360 then j:=0;
      if k>=360 then k:=0;
      if i<0 then i:=360;
      if j<0 then j:=360;
      if k<0 then k:=360;
      DrehenX(i);
      DrehenY(j);
      DrehenZ(k);
      Abbilden;
      If model='DRAHT' then Darstellen(Farben[1]);
      If model='FLAECHEN' then DarstFlaechen(False);
      If model='SHADE' then DarstShade(False);
      If model='TEXTURE' then DarstTextures(False);
      If model='GOURAUD' then DarstGouraud(False);
      If model='PHONG' then DarstPhong(False);
      Switch(pakt);
      WaitRetrace;
      If KeyPressed then
        Begin
          c:=Readkey;
          If c=#27 then
          Begin
            Done;
            If model='TEXTURE' then CloseTextures;
            FreeMem(Wuerfel, Sizeof(tFigur));
            TextMode(co80);
            Halt;
          End;
        End;
    Until False;
  End;
End;
