Unit Pages;
{$G+}

Interface
uses Crt,dos;

Type Tfeld=array[0..65530] of Byte;
     Pfeld=^Tfeld;
     SpriteTyp=Record
       Adr:PFeld;
       dtx,dty:Word;
     End;
     PointType = record
       x,y:integer;
     end;
     Pal256 = Array[0..255, 1..3] of Byte;
     TViereck=array[1..4] of Pointtype;

var pakt:Word;	 {   ->   aktuelle (unsichtbare) Seite }

Procedure Init_VGA;               { stellt den neuen VGA-Mode ein }
Procedure Switch(page:Word);      { stellt die sichtbare Seite ein }
Procedure CopyScreen(qpage,zpage:Word);{ Kopiert eine Seite in eine andere }
Function get_Point(x,y : integer; Page : word) : byte;  { Farbe lesen }
Procedure Point(x,y : integer; col : byte);            { Punkt setzten }
Procedure GetSprite(pg,x,y,dtx,dty:word;var zsprite:Spritetyp);{ Sprite lesen }
Procedure PutSprite(pg,x,y:Integer;qsprite:spritetyp);  { Sprite setzten }
Procedure PutTexture(pg,x,y,scale_y:Integer;qsprite:spritetyp);{ Sprite grenverndert ausgeben }
Procedure WaitRetrace; { vertikales Retrace }
Procedure LoadGif(name:String; fpos: Longint; bpos:word);{ Ldt eine 320*200*256 GIF-Grafik }
Procedure disable4;             { Alle Planes aus }
Procedure enable4;              { Alle Planes ein }

Procedure SaveSprite(dateiname:String;sprite:Spritetyp);
Procedure LoadSprite(dateiname:String;var sprite:Spritetyp);
Procedure Read_sprite(pg,x,y,dx,dy:Integer;var s:SpriteTyp);  { dto. }
Procedure PutOldSprite(pq,x,y,dx,dy:Integer;var data);   {normaler Sprite }

Procedure ChangePal(regi: Byte; r, g, b: Byte); {Palettenregister ndern}
Procedure GetPal(regi: Byte; Var r, g, b: Byte);
Procedure GetCurrentPal(Var p: pal256);
Procedure Set_Pal(p: Pal256);  {gesamte Palette ndern}
Procedure FadeIn(p: Pal256);    {einblenden}
Procedure FadeOut(p: Pal256);   {ausblenden}
Procedure FillPoly(anzahl:Byte;punkte:Tviereck;col:Byte);
Procedure Line256(x1,y1,x2,y2,col:Integer);  { Malt eine Linie }
Procedure TextXy(x,y:Word;line:String);
procedure scrl_textxy(x,y:word;line:String);
Procedure Rectangle(x1,y1,x2,y2:integer);
Procedure Bar(x1,y1,x2,y2:integer);
Function ReadXy(x,y:Word):string;
Procedure SetRgbSave(nr,r,g,b:Byte);
Procedure KillSprite(var sprite:Spritetyp);
Procedure Circle(x,y,radius:Integer);
Procedure Line(x1,y1,x2,y2:Integer);
Procedure MoveAddy(SAdd: Word); {Crtc-Startadresse verschieben}


Implementation

uses Font;



Procedure Circle(x,y,radius:Integer);
var apx,px,py,cos_phi,sin_phi:Real;
    adx,ady,dx,dy,i,till:Integer;
begin
  if radius=0 then exit;
  px:=0;
  py:=radius;
  cos_phi:=cos(1/radius);
  sin_phi:=sin(1/radius);
  till:=round(radius*pi/2);
  for i:=0 to till do begin
    adx:=dx;
    ady:=dy;
    dx:=round(px);
    dy:=round(py);
    if (dx<>adx)or(dy<>ady) then begin
      Point(x+dx,y+dy,textattr);
      Point(x-dx,y+dy,textattr);
      Point(x+dx,y-dy,textattr);
      Point(x-dx,y-dy,textattr);
    end;
    apx:=px;
    px:=cos_phi* px-sin_phi*py;
    py:=sin_phi*apx+cos_phi*py;
  end;
end;

Procedure LoadSprite(dateiname:String;var sprite:Spritetyp);
var datei:file;
begin
  assign(datei,dateiname);
  {$I-}
  reset(datei,1);
  IF IOresult<>0 then exit;
  {$I+}
    with sprite do begin
      Blockread(datei,dtx,2);
      Blockread(datei,dty,2);
      Getmem(adr,dtx*dty);
      Blockread(datei,adr^,dtx*dty);
    end;
  Close(datei);
end;

Procedure SaveSprite(dateiname:String;sprite:Spritetyp);
var datei:File;
begin
  assign(datei,dateiname);
  rewrite(datei,1);
    with sprite do begin
      Blockwrite(datei,dtx,2);
      Blockwrite(datei,dty,2);
      Blockwrite(datei,adr^,dtx*dty);
    end;
  close(datei);
end;

Procedure PutOldSprite(pq,x,y,dx,dy:Integer;var data);
var i,j:word;
begin
  pakt:=pq;
  for j:=0 to pred(dy) do
    for i:=0 to pred(dx) do
      Point(x+i,y+j,mem[seg(data):ofs(data)+i+j*dx]);
end;

Procedure SetRgbSave(nr,r,g,b:Byte);assembler;
  asm
    mov dx,$03c8
    mov al,nr
    out dx,al
    inc dx
    mov al,r
    out dx,al
    mov al,g
    out dx,al
    mov dx,$03da
    @Wait1:
      in al,dx
      test al,1
    jnz @Wait1
    @wait2:
      in al,dx
      test al,1
    jz @wait2
    mov dx,$03c9
    mov al,b
    out dx,al
  end;

Procedure Bar(x1,y1,x2,y2:integer);
var i,j:Integer;
begin
  for i:=y1 to y2 do
    for j:=x1 to x2 do
      Point(j,i,textattr);
end;

Procedure Rectangle(x1,y1,x2,y2:integer);
var i:integer;
begin
  for i:=x1 to x2 do begin
    Point(i,y1,textattr);
    Point(i,y2,textattr);
  end;
  for i:=y1 to y2 do begin
    Point(x1,i,textattr);
    Point(x2,i,textattr);
  end;
end;

Procedure TextXy(x,y:Word;line:String);
var i,j,k:Word;
    z:Byte;
begin
  if line[0]=#0 then exit;
  for i:=0 to pred(length(line)) do begin
    z:=ord(line[succ(i)]);
    for j:=0 to 7 do
      for k:=0 to 7 do
        if (schrift[z,j] and (1 shl (7-k)))>0 then
          Point(x+i shl 3+k,y+j,textattr and $F);
  end;
end;

function check_range(x:integer):byte;assembler; {Sind x und y auf'm Screen?}
asm                                            {Ja:Result=1}
mov ax,x                                       {Nein:Result=0}
cmp ax,0
jb @error
cmp ax,319d
ja @error

mov al,1
jmp @exit
@error:
mov al,0
@exit:
end;


Procedure scrl_TextXy(x,y:Word;line:String);
var i,j,k:Word;
    z:Byte;
    x1,y1:integer;
begin
  if line[0]=#0 then exit;
  for i:=1 to length(line) do begin
    z:=ord(line[i]);
    for j:=0 to 7 do
      for k:=0 to 7 do
        if (schrift[z,j] and (1 shl (7-k)))>0 then
         begin
          asm
           mov ax,i
           shl ax,3
           add ax,x
           add ax,k
           mov x1,ax
           mov ax,y
           add ax,j
           mov y1,ax
          end;
{          x1:=x+i shl 3+k;}
{          y1:=y+j;}
          if check_range(x1)=1 then Point(x1,y1,textattr and $F)
         end;
  end;
end;


Function ReadXy(x,y:Word):string;
var h:string[80];
    c:char;
    i:Byte;
begin
  h:='';
  repeat
    c:=readkey;
    case c of
      #32..#127:begin
                  textxy(x+length(h) shl 3,y,c);
                  h:=h+c;
                end;
      #8:if length(h)>0 then begin
           delete(h,length(h),1);
           i:=textattr;
           textattr:=get_point(x+7,y+7,pakt);
           bar(x+length(h) shl 3,y,x+length(h) shl 3+7,y+7);
           textattr:=i;
         end;
    end;
  until c=#13;
  readxy:=h;
end;

Procedure Line256(x1,y1,x2,y2,col:Integer);
var x,y,kriterium,dx,dy,stepx,stepy:integer;
begin
  dx:=(x2-x1);
  dy:=(y2-y1);
  if dx<0 then dx:=-dx;
  if dy<0 then dy:=-dy;
  if dx=0 then kriterium:=0 else kriterium:=round(-dx/2);
  if x2>x1 then stepx:=1 else stepx:=-1;
  if y2>y1 then stepy:=1 else stepy:=-1;
  x:=x1;y:=y1;Point(x,y,col);
  while not ((x=x2)and(y=y2)) do begin
    if (kriterium>=0)and(y<>y2) then begin
      y:=y+stepy;kriterium:=kriterium-dx;
    end else begin
      x:=x+stepx;kriterium:=kriterium+dy;
    end;
    Point(x,y,col);
  end;
end;

Procedure Line(x1,y1,x2,y2:Integer);
begin
  line256(x1,y1,x2,y2,textattr);
end;

{**********************************************************************}
Procedure FillPoly(anzahl:Byte;punkte:Tviereck;col:Byte);
var rand:array[0..199,0..1] of Word;
    i,j,delta,ppp,sx,rand_ofs,seg_start:word;

  Procedure Mark(x1,y1,x2,y2:integer);assembler;
  asm
    pop cx          { cx mit dem alten BP laden (um auf RAND zuzugreifen) }
    push cx
    mov di,y2       { di = (y2-y1) = deltaY }
    sub di,y1
    mov si,y1       { si = i : Zhlt die y-schritte fr die tabelle }
    @while:
      cmp si,y2      { keine reihe mehr: ende }
      je @finito
      mov ax,si      { ax=i : untenstehende Formel berechnen }
      sub ax,y1        { i-y1 }
      mov bx,x2       { (x2-x1) }
      sub bx,x1
      imul bx        { (i-y1)*(x2-x1) }
      idiv di        { (i-y1)*(x2-x1) div deltay }
      add ax,x1      { ax=x1+(i-y1)*(x2-x1) div deltay  }
      {------------}
      xchg cx,bp           { CX <-> BP Werte : alter BP }
      mov bx,si            { BX=zeiger auf rand[i,0] }
      shl bx,2
      add bx,rand_ofs
      xchg bp,cx           { CX <-> BP Werte : neuer BP }
      cmp ax,[ss:bx]         { p<rand[i,0] ? -> schreiben }
      jl @m1
      cmp word ptr [ss:bx],0   { rand[i,0]=0 ? -> schreiben }
      jne @naechtes1
    @m1:
      mov [ss:bx],ax         { rand[i,0]=i }
    @naechtes1:
      add bx,2              { bx auf rand[i,1] }
      cmp ax,[ss:bx]         { p>rand[i,1] ? -> schreiben }
      jg @m2
      cmp word ptr [ss:bx],0   { rand[i,1]=0 ? -> schreiben }
      jne @naechstes2
    @m2:
      mov [ss:bx],ax         { rand[i,0]=i }
    @naechstes2:
      {------------}
      cmp si,y2      { if i<y2 then inc i else dec i }
      jl @hoeher             { weitersetzten des zhlers }
      je @finito
      dec si
      jmp @while
    @hoeher:
      inc si
      jmp @while
  @finito:         { ende des markierens }
  end;

begin
  asm cli end;            { zeitkritisch }
  rand_ofs:=ofs(rand);
  fillchar(rand[0],sizeof(rand),0);
  mark(punkte[1].x,punkte[1].y,punkte[2].x,punkte[2].y);
  mark(punkte[2].x,punkte[2].y,punkte[3].x,punkte[3].y);
  mark(punkte[3].x,punkte[3].y,punkte[4].x,punkte[4].y);
  mark(punkte[4].x,punkte[4].y,punkte[1].x,punkte[1].y);
  for i:=0 to 199 do begin
    delta:=rand[i,1]-rand[i,0];
    if delta<>0 then
    Begin
      ppp:=delta and 3;
      delta:=delta shr 2;
      sx:=rand[i,0];
      seg_start:=$a000+pakt*1000+i*5;
      for j:=0 to 3 do
        asm
          cld
          mov cx,sx  {portw[$3c4]:=2+(1 shl ((sx+j) and 3)) shl 8;  { Planes }
          add cx,j
          and cx,3
          mov ah,1
          shl ah,cl
          mov al,2
          mov dx,$3c4
          out dx,ax
          mov ax,seg_start      { seg }{fillchar(mem[$a000+pakt*1000+i*5 :}
          mov es,ax             {(rand[i,0]+j) shr 2],delta+ord(j<=ppp),col);}
          mov di,sx                { ofs }
          add di,j
          shr di,2
          mov cx,delta            { count }
          mov ax,j
          sub ax,ppp
          jns @nicht
          inc cx
         @nicht:
          mov al,col               { fllen }
          mov ah,al
          shr cx,1                    { words }
          jnc @nicht_ungerade       { ungerades byte }
          stosb
         @nicht_ungerade:
          rep stosw
        end;
    end;
  End;
  asm sti end;
end;

Procedure Read_sprite(pg,x,y,dx,dy:Integer;var s:SpriteTyp);
type Tfeld=array[0..65500] of Byte;
var i,j,z:Word;
    plane:Byte;
    h:Pfeld;
begin
  with s do begin
    getmem(adr,dx*dy);
    dtx:=dx;
    dty:=dy;
    h:=adr;
    z:=0;
    for plane:=0 to 3 do
      for j:=1 to dty do begin
        i:=plane;
        while i<dtx do begin
          h^[z]:=get_Point(x+i,y+j-1,pg);
          inc(z);
          inc(i,4);
        end;
      end;
  end;
end;

Procedure KillSprite(var sprite:Spritetyp);
begin
  if sprite.adr=NIL then exit;
  with sprite do Freemem(adr,dtx*dty);
  sprite.adr:=NIL;
end;

{***************************************}

function get_Point(x,y : integer; Page : word) : byte;
var plane : byte;
    offs  : word;
begin;
 offs  := y*80+(x shr 2);
 plane := x and 3;
 port[$3ce] := 4;
 port[$3cf] := plane;
 offs := offs + page*16000;
 get_Point := mem[$A000:offs];
end;

procedure Point(x,y : integer; col : byte); assembler;
asm
  mov cx,x       { Plane des Punktes in AH bestimmen }
  and cx,3
  mov ah,1
  shl ah,cl
  mov dx,$3c4     { und Plane einschalten }
  mov al,2
  out dx,ax

  mov ax,80
  mul y
  mov di,ax  { y * 80 }
  shr x,2
  add di,x  { + x DIV 4}
  mov ax,16000
  mul pakt      { <- PAKT ! }
  add di,ax  { + 16000 * Pakt}

  mov si,$A000  { Punkt Adressieren & Setzen }
  mov es,si
  mov al,col
  stosb
end;

Procedure Init_VGA;assembler;
asm
  mov ax,0013h     { Den normalen Mode 13h setzen }
  int 10h

  mov dx,3c4h      { Verknpfung aufheben, Einzelzugriff }
  mov al,4         { ermglichen                         }
  out dx,al
  inc dx
  in al,dx
  and al,0f7h
  or al,4h
  out dx,al
  dec dx
  mov ax,0f02h
  out dx,ax

  mov ax,0a000h    { Bildschirmspeicher lschen }
  mov es,ax
  xor di,di
  xor ax,ax
  mov cx,8000h
  cld
  rep stosw

  mov dx,3d4h
  mov al,14h
  out dx,al
  inc dx
  in al,dx
  and al,0bfh
  out dx,al
  dec dx
  mov al,17h
  out dx,al
  inc dx
  in al,dx
  or al,40h
  out dx,al
End;

Procedure enable4;assembler;
asm
  mov dx,3c4h
  mov ax,0f02h
  out dx,ax

  mov dx,3ceh
  mov ax,4105h
  out dx,ax
End;

procedure disable4; assembler;
asm;
  mov dx,3c4h
  mov ax,0f02h
  out dx,ax

  mov dx,3ceh
  mov ax,4005h
  out dx,ax
end;

Procedure Switch(page:Word);assembler;
asm
  mov ax,16000          {Startadresse der Page ausrechnen}
  mul page
  mov dx,3d4h 		{Port des Memory Controllers}
  mov cl,al									{Low-Byte der Startadresse sichern}
  mov al,0ch		{Register 0ch erhlt High-Byte}
  out dx,ax
  mov ah,cl									{gesichertes Low-Byte zurck}
  mov al,0dh		{und auf Register 0dh}
  out dx,ax
End;

Procedure CopyScreen(qpage,zpage:Word);assembler;
asm
  mov dx,3c4h       { enable 4 }
  mov ax,0f02h
  out dx,ax
  mov dx,3ceh
  mov ax,4105h
  out dx,ax

	push ds
  mov ax,16000
  mul qpage
  mov si,ax
  mov ax,16000
  mul zpage
  mov di,ax
  mov ax,0a000h
  mov es,ax
  mov ds,ax
  mov cx,16000
  rep movsb
	pop ds

  mov dx,3ceh
  mov ax,4005h
  out dx,ax
End;

Procedure GetSprite(pg,x,y,dtx,dty:word;var zsprite:Spritetyp);
var plane:Byte;         {aktuelle Bit-Plane}
    planeindex:Byte;    {Zhler der bereits kopierten Planes}
    ofs:Word;
    Anzahl:Byte;        {Anzahl zu kopierender Bytes in einer Zeile}
    Skip:word;          {Anzahl bei Zeilenwechsel zu berspringender Bytes}
    ppp:Array[0..3] of Byte;
Begin
	GetMem(zsprite.adr,dtx*dty);
  ofs:=16000*pg+80*y+(x div 4);
  Anzahl:=dtx div 4;
  Plane:=x mod 4;
  Skip:=0;
  zsprite.dtx:=dtx;
  zsprite.dty:=dty;
asm
  call disable4
	push ds
  mov dx,03ceh              {Lesemodus 1 setzen}
  mov ax,4105h
  out dx,ax
  mov di,word ptr zsprite   {Zieladresse laden in es:di}

  mov ax,word ptr ds:[di+2]
  mov di,word ptr ds:[di]
  mov es,ax

  mov ax,dtx
  shr ax,2
  mov byte ptr ppp[0],al    {ppp-Register initialisieren}
  mov byte ptr ppp[1],al		{auf Anzahl mindestens zu kopierender Bytes pro}
  mov byte ptr ppp[2],al		{Plane}
  mov byte ptr ppp[3],al
  mov cx,dtx                {"berstehende" Pixel in ppp eintragen}
  and cx,3
  je @nodbl
  mov al,plane							{ah enthlt hier garantiert 0}
  mov si,ax
@mark_double_planes:
	inc byte ptr ppp[si]
  inc si
  and si,3									{berlauf vorbeugen}
  loop @mark_double_planes
@nodbl:

	mov planeindex,4
  mov ax,0a000h             {Quellsegment nach ds}
  mov ds,ax
@lplane:
  mov cl,plane							{ch garantiert 0}
  mov si,cx									{si wird erst weiter unten wieder geraucht}
  mov cl,byte ptr ppp[si]   {x-Zhler (cx) laden mit zugehriger ppp-Nummer}
  mov anzahl,cl
  mov al,80
  stc
  sub al,cl
  mov byte ptr skip,al
  mov si,ofs                {Quelloffset nach si}
  mov ah,plane							{Plane auswhlen}
  mov al,04h
  out dx,ax
	mov bx,dty                {y-Zhler (bx) laden}
@lcopy:
	rep movsb									{Copy-Schleife}
  add si,Skip               {Anfang nchste Zeile}
  mov cl,Anzahl             {cx neu laden}
  dec bx                    {y-Zhler dekrementieren}
  jne @lcopy
  inc plane									{nchste Plane anwhlen}
  and plane,03h
  mov cl,plane
  mov ax,1
  shr al,cl
  add ofs,ax
	dec planeindex
  jne @lplane
  pop ds
End; {asm}
End;

Procedure PutSprite(pg,x,y:Integer;qsprite:spritetyp);
var planeindex,
		planemask:Byte;
    Skip,ofs,plane,
		Anzahl,dty:Word;
    quelle:Pointer;
    clip_lt,
    clip_rt:integer;
    clipakt_lt,
    clipakt_rt,
    clipall_lt,
    clipall_rt:Word;
    clip_dn,
    clip_up:Word;
    ppp:Array[0..3] of Byte;
    cpp:Array[0..3] of Byte;	{Skip pro Plane}
Begin
  if (x > 319) or (x+qsprite.dtx <= 0)           {Darstellung berflssig ?}
	or (y > 199) or (y+qsprite.dty <= 0) then exit;
  clip_rt:=0;
  clip_lt:=0;
  clip_dn:=0;
  clip_up:=0;
  clipall_rt:=0;
  clipall_lt:=0;
  clipakt_rt:=0;
  clipakt_lt:=0;
  with qsprite do begin
    if y+dty > 200 then begin
      clip_dn:=(y+dty-200);
    	dty:=200-y;
    End;
    if y<0 then begin
    	clip_up:=-y;
      dty:=dty+y;
      y:=0;
  	End;
  	if x+dtx > 320 then begin
    	clip_rt:=x+dtx-320;
      clipall_rt:=clip_rt shr 2;
			dtx:=320-x;
    End;
    if x<0 then begin
      clip_lt:=-x;
      clipall_lt:=clip_lt shr 2;
      plane:=4-(clip_lt mod 4);
      plane:=plane and 3;
      ofs:=16000*pg+80*y+((x+1) div 4) - 1;
    	x:=0;
    End Else Begin
	  	plane:=x mod 4;
		  ofs:=16000*pg+80*y+(x div 4);
    End;
  End;
	dty:=qsprite.dty;
  Anzahl:=0;
  Skip:=0;
  Quelle:=qsprite.adr;

  cpp[0]:=0;cpp[1]:=0;
  cpp[2]:=0;cpp[3]:=0;
asm
	push ds
  call disable4
	mov dx,3c4h               {Portadresse laden}
  mov ax,0a000h             {Zieladresse nach es:di}
  mov es,ax

  mov ax,qsprite.dtx
  shr ax,2
  mov byte ptr ppp[0],al    {ppp-Register initialisieren}
  mov byte ptr ppp[1],al		{auf Anzahl mindestens zu kopierender Bytes pro}
  mov byte ptr ppp[2],al		{Plane}
  mov byte ptr ppp[3],al
  mov cx,qsprite.dtx        {"berstehende" Pixel in ppp eintragen}
  and cx,3
  je @nodbl
  mov al,byte ptr plane			{ah enthlt hier garantiert 0}
  mov si,ax
@mark_double_planes:
	inc byte ptr ppp[si]
  inc si
  and si,3									{berlauf vorbeugen}
  loop @mark_double_planes
@nodbl:

	mov cl,byte ptr clip_rt						{Anzahl abzuschneidender Pixel holen}
  and cl,03h                {(fr rechten Rand)}
  je @nocpp
  xor si,si									{in cpp-Tabelle eintragen}
@lcpp:
  inc byte ptr cpp[si]
  inc si
  loop @lcpp
  jmp @nocpp_lt							{wenn rechts Clipping, kann links keins sein}
@nocpp:
  mov cl,byte ptr clip_lt						{das gleiche fr den linken Rand}
  and cl,3h
  je @nocpp_lt
  mov si,3
@lcpp_lt:
	inc byte ptr cpp[si]
  dec si
  loop @lcpp_lt
@nocpp_lt:
  lds si,quelle             {Quelle nach ds:si}
  mov cx,plane              {Plane - Maske erstellen}
  mov ax,1
  shl ax,cl
  mov planemask,al
  shl al,4       						{auch in oberes Nibble eintragen}
  or planemask,al
  mov planeindex,4					{4 Planes zu kopieren}
@lplane:
  mov cl,byte ptr plane			{ch garantiert 0}
  mov di,cx									{di wird erst weiter unten wieder gebraucht}
  mov cl,byte ptr ppp[di]   {x-Zhler (cx) laden mit zugehriger ppp-Nummer}
  mov byte ptr anzahl,cl		{Skip jeweils neu ausrechnen}
  mov ax,80
  sub al,cl
  mov byte ptr skip,al

  mov al,byte ptr cpp[di]
  cmp clip_lt,0
  je @rechts
  add ax,clipall_lt					{clipall als Basis}
  mov clipakt_lt,ax
  sub anzahl,ax    					{Anzahl zu kopierender Bytes reduzieren}
  jmp @clip_rdy
@rechts:
  add ax,clipall_rt					{das gleiche fr rechts}
  mov clipakt_rt,ax
@clip_rdy:
  mov ax,anzahl
  add ax,clipakt_rt
  add ax,clipakt_lt
  mul clip_up
  add si,ax									{neuen Start bei oberem Clipping festlegen}

  mov cx,anzahl
  or cl,cl									{Breite 0, dann Plane fertig}
  je @plane_fertig

  mov di,ofs 								{Zieloffset nach di}
  mov ah,planemask          {planemask auf bit [0..3] reduzieren und setzen}
  and ah,0fh
  mov al,02h
  mov dx,3c4h
  out dx,ax
  mov bx,dty      					{x- und y-Zhler initialisieren}
@lcopy_y:
	add si,clipakt_lt
  add di,clipakt_lt
@lcopy:
	lodsb                     {Byte holen, wenn 0 berspringen}
  or al,al
  je @Wert0
  stosb       							{ansonsten: setzen}
@entry:
  loop @lcopy

	add si,clipakt_rt

  dec bx
  je @plane_fertig					{y-Zhler = 0, dann nchste Plane}
  add di,skip               {sonst auf nchsten Zeilenanfang springen}
  mov cx,Anzahl             {x-Zhler reinitialisieren,}
  jmp @lcopy_y
@wert0:
	inc di										{Sprite-Wert 0 : Zielbyte berspringen}
  jmp @entry
@plane_fertig:
	mov ax,anzahl							{abgeschnittene Zeilen berspringen}
  add ax,clipakt_rt
  add ax,clipakt_lt
  mul clip_dn
  add si,ax
	rol planemask,1           {nchste Plane maskieren}
  mov cl,planemask					{plane 0 selektiert ?}
  and cx,1                  {(Bit 1 gesetzt), dann}
  add ofs,cx                {Zieloffset erhhen um 1 (Bit 1 !)}
  inc plane
  and plane,3
  dec planeindex						{schon 4 Planes kopiert ?, dann Ende}
  jne @lplane
  pop ds
End;{asm}
End;

Procedure PutTexture(pg,x,y,scale_y:Integer;qsprite:spritetyp);
var planeindex,
		planemask:Byte;
    Skip,ofs,plane,
		Anzahl,dty:Word;
    quelle:Pointer;
    ppp:Array[0..3] of Byte;
    rel_y,                  {Nachkommateil (2 Stellen) der rel. y-Position}
    add_y:Word;             {Nachkommawert der Addition}
    direction:Integer;
Begin
	rel_y:=0;
  if (x + qsprite.dtx > 319) or (x < 0)
	or (y + qsprite.dty > 199) or (y < 0) then exit;
  add_y:=100-abs(scale_y);
  if scale_y < 0 then direction:=-80 else direction:=80;
	dty:=qsprite.dty;
 	plane:=x mod 4;
	ofs:=16000*pg+80*y+(x div 4);
  Anzahl:=0;
  Skip:=0;
  Quelle:=qsprite.adr;

asm
	push ds
  call disable4
	mov dx,3c4h               {Portadresse laden}
  mov ax,0a000h             {Zieladresse nach es:di}
  mov es,ax

  mov ax,qsprite.dtx
  shr ax,2
  mov byte ptr ppp[0],al    {ppp-Register initialisieren}
  mov byte ptr ppp[1],al		{auf Anzahl mindestens zu kopierender Bytes pro}
  mov byte ptr ppp[2],al		{Plane}
  mov byte ptr ppp[3],al
  mov cx,qsprite.dtx        {"berstehende" Pixel in ppp eintragen}
  and cx,3
  je @nodbl
  mov al,byte ptr plane			{ah enthlt hier garantiert 0}
  mov si,ax
@mark_double_planes:
	inc byte ptr ppp[si]
  inc si
  and si,3									{berlauf vorbeugen}
  loop @mark_double_planes
@nodbl:

  lds si,quelle             {Quelle nach ds:si}
  mov cx,plane              {Plane - Maske erstellen}
  mov ax,1
  shl ax,cl
  mov planemask,al
  shl al,4       						{auch in oberes Nibble eintragen}
  or planemask,al
  mov planeindex,4					{4 Planes zu kopieren}
@lplane:
  mov cl,byte ptr plane			{ch garantiert 0}
  mov di,cx									{di wird erst weiter unten wieder gebraucht}
  mov cl,byte ptr ppp[di]   {x-Zhler (cx) laden mit zugehriger ppp-Nummer}
  mov byte ptr anzahl,cl
  mov ax,direction
  sub ax,cx
  mov skip,ax

  mov rel_y,0								{start wieder bei y=0}

  mov cx,anzahl
  or cl,cl									{Breite 0, dann Plane fertig}
  je @plane_fertig

  mov di,ofs 								{Zieloffset nach di}
  mov ah,planemask          {planemask auf bit [0..3] reduzieren und setzen}
  and ah,0fh
  mov al,02h
  mov dx,3c4h
  out dx,ax
  mov bx,dty      					{x- und y-Zhler initialisieren}
@lcopy_y:
@lcopy:
	lodsb                     {Byte holen, wenn 0 berspringen}
  or al,al
  je @Wert0
  stosb       							{ansonsten: setzen}
@entry:
  loop @lcopy

	mov ax,rel_y							{Nachkommateil weiter}
  add ax,add_y
  cmp ax,100                {berlauf ?}
  jb @noaddovfl
  sub ax,100								{fr auf den Kopf gestellte Texturen}
	sub di,direction
@noaddovfl:
  mov rel_y,ax

  dec bx
  je @plane_fertig					{y-Zhler = 0, dann nchste Plane}
  add di,skip               {sonst auf nchsten Zeilenanfang springen}
  mov cx,Anzahl             {x-Zhler reinitialisieren,}
  jmp @lcopy_y
@wert0:
	inc di										{Sprite-Wert 0 : Zielbyte berspringen}
  jmp @entry
@plane_fertig:

	rol planemask,1           {nchste Plane maskieren}
  mov cl,planemask					{plane 0 selektiert ?}
  and cx,1                  {(Bit 1 gesetzt), dann}
  add ofs,cx                {Zieloffset erhhen um 1 (Bit 1 !)}
  inc plane
  and plane,3
  dec planeindex						{schon 4 Planes kopiert ?, dann Ende}
  jne @lplane
  pop ds
End;{asm}
End;

Procedure WaitRetrace;assembler;
asm
  mov dx,3dah
@l1:
    in al,dx
    and al,8h
  jnz @l1
@l2:
    in al,dx
    and al,8h
  jz @l2
End;


Procedure ChangePal(regi: Byte; r, g, b: Byte); Assembler;
{ohne Retrace, manchmal ntig}
asm
  mov dx, $3c8
  mov al, regi
  mov ah, r
  out dx, ax
  inc dx
  mov al, g
  out dx, al
  mov al, b
  out dx, al
End;


Procedure GetPal(regi: Byte; Var r, g, b: byte);
Var
  reg: Registers;
Begin
  Port[$3c7]:=regi;
  r:=Port[$3c9];
  g:=Port[$3c9];
  b:=Port[$3c9];
End;


Procedure GetCurrentPal(Var p: Pal256);
Var
  i: Integer;
Begin
  For i:=0 to 255 do
    GetPal(i, p[i,1], p[i,2], p[i,3]);
End;

Procedure Set_Pal(p: Pal256);
Var
  i: Integer;
Begin
  For i:=0 to 255 do
    ChangePal(i, p[i,1], p[i,2], p[i,3]);
End;


Procedure FadeIn(p: Pal256);
Var
  hlp: Pal256;
  i, j, k: word;
Begin
  FillChar(hlp, 768, 0);
  For i:=0 to 63 do
  Begin
    For j:=0 to 255 do
    Begin
      For k:=1 to 3 do
        If hlp[j,k]<p[j,k] then
          inc(hlp[j,k]);
      ChangePal(j, hlp[j,1], hlp[j,2], hlp[j,3]);
    End;
    WaitRetrace;
  End;
End;


Procedure FadeOut(p: Pal256);
Var
  hlp: Pal256;
  i, j, k: word;
Begin
  FillChar(hlp, 768, 0);
  For i:=0 to 63 do
  Begin
    For j:=0 to 255 do
    Begin
      For k:=1 to 3 do
        If p[j,k] > 0 then
          dec(p[j,k]);
      ChangePal(j, p[j,1], p[j,2], p[j,3]);
    End;
    WaitRetrace;
  End;
End;


Procedure MoveAddy(SAdd: Word);
Var
  ScrAd: Word absolute $0:$044e;
Begin
  Port[$3d4]:=$0c;
  Port[$3d5]:=Hi(SAdd);
  Port[$3d4]:=$0d;
  Port[$3d5]:=Lo(SAdd);
  ScrAd:=SAdd;
End;


{******************************************************************}
var Handle:Word;
    Puf,palette:Array[0..767] of Byte;
    PufInd:Word;
    Stack:Array[0..1280] of byte;
    ab_prfx,ab_tail:Array[0..4096] of word;
    free,breite,max,stackp,restbits,restbyte,sonderfall,
    code,old_code,readbyt,bits,bits2get:Word;
    lbyte:Word;
    mask:Word;
    zseg,zofs,
    GifName:String[15];
    temppic:Pointer;

Procedure SetPal;assembler;
asm
  push ds
  pop es
  mov dx,offset palette
	mov ax,1012h
  xor bx,bx
  mov cx,0100h
  int 10h
End;

Procedure GifOpen;assembler;
asm
  mov ax,03d00h
  lea dx,gifname + 1
  int 21h
  mov handle,ax
End;
Procedure GifRead(n:Word);assembler;
asm
  mov ax,03f00h
  mov bx,handle
  mov cx,n
  lea dx,puf
	int 21h
end;
Procedure GifSeekdelta(delta:Longint);assembler;
asm
  mov ax,04200h
  mov bx,handle
  mov cx,word ptr delta + 2
  mov dx,word ptr delta
  int 21h
End;
Procedure GifClose;Assembler;
asm
  mov ax,03e00h
  mov bx,handle
  int 21h
End;
Procedure ShiftPal;assembler;
asm
  push ds
  pop es
  mov si,offset Puf
  mov di,offset Palette
  mov cx,768
@l1:
	lodsb
  shr al,2
  stosb
  loop @l1
End;
Procedure FillPuf;
Begin
  GifRead(1);
  restbyte:=puf[0];
  GifRead(restbyte);
End;

Function GetPhysByte:Byte;assembler;
asm
	push bx
	cmp restbyte,0
  ja @restda
  pusha
  call fillpuf
  popa
	mov pufind,0
@restda:
  mov bx,PufInd
  mov al,byte ptr Puf[bx]
  inc pufind
  pop bx
End;

Function GetLogByte:Word;assembler;
asm
  push si
	mov ax,breite
	mov si,ax
  mov dx,restbits
  mov cx,8
  sub cx,dx
  mov ax,lByte
  shr ax,cl
  mov code,ax
  sub si,dx
@nextbyte:
  call getphysbyte
  xor ah,ah
  mov lByte,ax
  dec restbyte

  mov bx,1
  mov cx,si
  shl bx,cl
  dec bx
  and ax,bx

  mov cx,dx
  shl ax,cl
  add code,ax

  sbb dx,breite
  add dx,8
  jns @positiv
  add dx,8
@positiv:
  sub si,8
  jle @fertig       { <= 0 }
	add dx,breite
  sub dx,8
  jmp @nextbyte
@fertig:
	mov restbits,dx
  mov ax,code
	pop si
End;

Procedure LoadGif(name:String; fpos: Longint; bpos:word);
const clr=256;              {gif}
      eof=257;
Var ziel,
    quelle,qseg:Word;
		pic_size,pic_height,pic_width:word;
 		x_count:Word;
    plane_pos:Array[0..3] of Pointer;
    plane_pos_i:Word;
    Plane:Byte;
Begin
  gifName:=Name+#0;
 	getMem(temppic,64000);
	GifOpen;
	gifseekdelta(fpos+13);
	gifread(768);
  Shiftpal;
 	SetPal;
	gifread(1);
  While Puf[0] = $21 do Begin  {Erw - Block berlesen}
    gifread(2);
    gifread(puf[1]+1);
  End;
  GifRead(10);
  pic_width:=puf[4]+puf[5]*256;
  pic_height:=puf[6]+puf[7]*256;
  pic_size:=pic_width div 4 * pic_height;
  If Puf[8] and 128 = 128 Then Begin
    gifread(768);
  	Shiftpal;
	  SetPal;
  End;
  Plane_pos[0]:=temppic;
  Plane_pos[1]:=Ptr(Seg(temppic^)+pic_size div 16,  0);
  Plane_pos[2]:=Ptr(Seg(temppic^)+pic_size div  8,  0);
  Plane_pos[3]:=Ptr(Seg(temppic^)+(pic_size div 16)*3, 0);
  Plane_pos_i:=6;
  Plane:=1;
  lByte:=0;
	asm
    les di,temppic

    mov free,258        {1. freie Posit in Alphabet}
    mov breite,9        {Zeichenbreite in bit}
    mov max,511         {maximaler darstellbarer Wert bei akt breite}
    mov stackp,0
    mov restbits,0
    mov restbyte,0
  	xor si,si           {aktuelle Plane (fr Zieladdressierung)}
  @mainloop:
    call getlogByte
		cmp ax,eof
    je @abbruch
    cmp ax,clr
    je @clear
  	mov readbyt,ax
    cmp ax,free
    jb @code_in_ab
    mov ax,old_code
    mov code,ax
    mov bx,stackp
    mov cx,sonderfall
    mov word ptr stack[bx],cx
    inc stackp
  @code_in_ab:
  	cmp ax,clr
  	jb @konkret
  @fillstack_loop:
    mov bx,code
    shl bx,1
    push bx
    mov ax,word ptr ab_tail[bx]
    mov bx,stackp
    shl bx,1
    mov word ptr stack[bx],ax
    inc stackp
    pop bx
    mov ax,word ptr ab_prfx[bx]
    mov code,ax
    cmp ax,clr
    ja @fillstack_loop
  @konkret:
  	mov bx,stackp
    shl bx,1
    mov word ptr stack[bx],ax
    mov sonderfall,ax
    inc stackp
    mov bx,stackp
    dec bx
    shl bx,1
  @readstack_loop:
  	mov ax,word ptr stack[bx]


		mov di,word ptr plane_pos[si] + 2
    mov es,di
    mov di,word ptr plane_pos[si]
		stosb
    inc word ptr plane_pos[si]
    add si,4
    and si,12
    or di,di
    jne @rsnc
    mov ax,es
    add ax,1000h
    mov es,ax
	@rsnc:
		dec bx
    dec bx
    jns @readstack_loop
    mov stackp,0
    mov bx,free
    shl bx,1
    mov ax,old_code
    mov word ptr ab_prfx[bx],ax
    mov ax,code
    mov word ptr ab_tail[bx],ax
    mov ax,readbyt
    mov old_code,ax
    inc free
    mov ax,free
    cmp ax,max
    jbe @mainloop
    cmp byte ptr breite,12
    jae @mainloop
    inc breite
    mov cl,byte ptr breite
    mov ax,1
    shl ax,cl
    dec ax
    mov max,ax
    jmp @mainloop
  @clear:
    mov breite,9
    mov max,511
    mov free,258
    call getlogbyte
    mov sonderfall,ax
    mov old_code,ax

		mov di,word ptr plane_pos[si] + 2
    mov es,di
    mov di,word ptr plane_pos[si]
		stosb
    inc word ptr plane_pos[si]
    add si,4
    and si,12

    or di,di
    jne @mainloop
    mov ax,es
    add ax,1000h
    mov es,ax

    jmp @mainloop
  @abbruch:
  End;
  gifclose;
  asm
    push ds
    lds si,temppic
    mov ax,0a000h
    mov es,ax
    mov di,bpos
    mov ziel,di
    mov cx,pic_size
@lpplane:
    mov al,02h
    mov ah,plane
    mov dx,3c4h
    out dx,ax

	@lp1:
    rep movsb
    mov di,ziel
    mov si,plane_pos_i
    mov si,word ptr plane_pos[si]
    add plane_pos_i,4
    mov ds,si
    xor si,si
    mov cx,pic_size
    shl plane,1
    cmp plane,10h
    jne @lpplane

    pop ds
  End;
  Freemem(temppic,64000);
End;

begin
  pakt:=0;
End.