
Type
  PnfFeld   = ^nfFeld;
  nfFeld    = Array[1..maxFaces,1..3] of Integer;
  PnpFeld   = ^npFeld;
  npFeld    = Array[1..maxPoints,1..3] of Integer;
  PsqrtFeld = ^sqrtFeld;
  sqrtFeld  = Array[0..32000] of Integer;
  PRandNormFeld = ^RandNormFeld;
  RandNormFeld  = Array[0..319,1..3] of Integer;

Var
  NormFaces: PnfFeld;
  NormPoints: PnpFeld;
  WurzelTab: PsqrtFeld;
  RandNorm0, RandNorm1: PRandNormFeld;
  norm0seg, norm1seg, norm0ofs, norm1ofs,
  sqrtseg, sqrtofs: Word;

Type
  PPhongFigur = ^TPhongFigur;
  TPhongFigur = Object(TFigur)
                  Procedure Init(Filename, ObjName: String);
                  Procedure DarstPhong(alle: Boolean);
                  Procedure Done;
                End;



Procedure MarkPhong(x1, y1, x2, y2, xn1, yn1, zn1, xn2, yn2, zn2: Integer);
Assembler;
Var
  deltay, xdiff, ydiff, zdiff: Integer;
asm
  mov si, x1
  mov cx, x2         {deltax:=x2-x1;}
  sub cx, si
  or cx, cx
  jnz @markieren
  {Rand0[x1]:=y1;}
    mov di, x1
    shl di, 1
    add di, Offset Rand0
    mov ax, y1
    mov [di], ax
  {Rand1[x1]:=y2;}
    sub di, Offset Rand0
    add di, Offset Rand1
    mov ax, y2
    mov [di], ax
  {RandNorm0^[x1,1]:=xn1;}
    mov es, norm0seg
    mov di, x1
    db $6b, $ff, $06  {imul di, 6}
    mov dx, di
    add di, norm0ofs
    mov ax, xn1
    mov es:[di], ax
  {RandNorm0^[x1,2]:=yn1;}
    add di, 2
    mov ax, yn1
    mov es:[di], ax
  {RandNorm0^[x1,3]:=zn1;}
    add di, 2
    mov ax, zn1
    mov es:[di], ax
  {RandNorm1^[x1,1]:=xn2;}
    mov es, norm1seg
    mov di, dx
    add di, norm1ofs
    mov ax, xn2
    mov es:[di], ax
  {RandNorm1^[x1,2]:=yn2;}
    add di, 2
    mov ax, yn2
    mov es:[di], ax
  {RandNorm1^[x1,3]:=zn2;}
    add di, 2
    mov ax, zn2
    mov es:[di], ax
    mov di, dx
  jmp @Ende
 @markieren:
    mov di, cx
    mov ax, norm0seg
    mov es, ax
    mov ax, norm1seg
    db $8e, $e8        {mov gs, ax}
    mov cx, y2         {deltay:=y2-y1;}
    sub cx, y1
    mov deltay, cx
    mov ax, xn2       {xdiff:=(xn2-xn1)}
    sub ax, xn1
    mov xdiff, ax
    mov ax, yn2       {ydiff:=(yn2-yn1)}
    sub ax, yn1
    mov ydiff, ax
    mov ax, zn2       {zdiff:=(zn2-zn1)}
    sub ax, zn1
    mov zdiff, ax
   @Schleife:
      cmp si, x2
      je @Ende
      jg @groesser
      inc si
      jmp @iOK
     @groesser:
      dec si
     @iOK:
    {p:=y1+(y2-y1)*(i-x1) div deltax;}
      mov ax, si
      sub ax, x1
      imul deltay
      idiv di
      add ax, y1
      mov cx, ax
    {If (p<rand0[i])or(rand0[i]=0) then rand0[i]:=p;}
      mov bx, Offset Rand0
      mov dx, si
      shl dx, 1
      add bx, dx
      mov ax, [bx]
      cmp cx, ax
      jl @kleiner
      or ax, ax
      jnz @tunix
     @kleiner:
      mov [bx], cx
    {RandNorm0[i,1]^:=xn1+(xn2-xn1)*(i-x1) div deltax;}
      mov bx, si
      db $6b, $db, $06    {imul bx, 6}
      add bx, norm0ofs
      mov ax, si
      sub ax, x1
      imul xdiff
      idiv di
      add ax, xn1
      mov es:[bx], ax
    {RandNorm0[i,2]^:=yn1+(yn2-yn1)*(i-x1) div deltax;}
      add bx, 2
      mov ax, si
      sub ax, x1
      imul ydiff
      idiv di
      add ax, yn1
      mov es:[bx], ax
    {RandNorm0[i,3]^:=zn1+(zn2-zn1)*(i-x1) div deltax;}
      add bx, 2
      mov ax, si
      sub ax, x1
      imul zdiff
      idiv di
      add ax, zn1
      mov es:[bx], ax
     @tunix:
    {If (p>rand1[i])or(rand1[i]=0) then rand1[i]:=p;}
      mov bx, Offset Rand1
      mov dx, si
      shl dx, 1
      add bx, dx
      mov ax, [bx]
      cmp cx, ax
      jg @kleiner2
      or ax, ax
      jnz @tunix2
     @kleiner2:
      mov [bx], cx
    {RandNorm1[i,1]^:=xn1+(xn2-xn1)*(i-x1) div deltax;}
      mov bx, si
      db $6b, $db, $06    {imul bx, 6}
      add bx, norm1ofs
      mov ax, si
      sub ax, x1
      imul xdiff
      idiv di
      add ax, xn1
      db $65            {GS}
      mov [bx], ax
    {RandNorm1[i,2]^:=yn1+(yn2-yn1)*(i-x1) div deltax;}
      add bx, 2
      mov ax, si
      sub ax, x1
      imul ydiff
      idiv di
      add ax, yn1
      db $65            {GS}
      mov [bx], ax
    {RandNorm1[i,3]^:=zn1+(zn2-zn1)*(i-x1) div deltax;}
      add bx, 2
      mov ax, si
      sub ax, x1
      imul zdiff
      idiv di
      add ax, zn1
      db $65            {GS}
      mov [bx], ax
     @tunix2:
  jmp @Schleife
 @Ende:
End;



Procedure FillPhongPoly; Assembler;
Var
  i, k: Integer;
  xadd, yadd, zadd,
  xc, yc, zc: Longint;
asm
  mov ax, $A000         {Bildschirmsegment}
  db $8e, $e8        {mov gs, ax}
  mov ax, sqrtseg
  db $8e, $e0        {mov fs, ax}
  mov i, 319
 @Outer_Loop:
    {r0:=Rand0[i];}
      mov di, i
      mov cx, di
      shl di, 1
      mov si, di
      add di, Offset Rand0
      mov dx, [di]
    {r1:=Rand1[i];}
      add si, Offset Rand1
      mov ax, [si]
      sub ax, dx
      jle @vergisses
      mov k, ax
    {yoffset:=r0*80+vp+i div 4;  in BX}
      mov bx, cx
      mov di, cx
      shr bx, 2
      mov ax, 80
      mul dx
      add ax, vp
      add bx, ax
    {Plane bestimmen und einschalten}
      and cx, 3
      mov ax, 100000010b
      shl ah, cl
      mov dx, $3c4
      out dx, ax
    {xn1:=RandNorm0^[i,1];}
      mov es, norm0seg
      db $6b, $ff, $06  {imul di, 6}
      mov si, di
      add di, norm0ofs
      mov ax, es:[di]
      db $66
      cbw
    {xc:=xn1 shl 8;}
      db $66
      sal ax, 8
      db $66
      mov Word Ptr xc, ax
    {yn1:=RandNorm0^[i,2];}
      add di, 2
      mov ax, es:[di]
      db $66
      cbw
    {yc:=yn1 shl 8;}
      db $66
      sal ax, 8
      db $66
      mov Word Ptr yc, ax
    {zn1:=RandNorm0^[i,3];}
      add di, 2
      mov ax, es:[di]
      db $66
      cbw
    {zc:=zn1 shl 8;}
      db $66
      sal ax, 8
      db $66
      mov Word Ptr zc, ax
    {rdiff:=Longint(k);}
      mov ax, k
      db $66
      cbw
      db $66
      mov cx, ax
    {xadd:=(RandNorm1^[i,1]-xn1) shl 8 div rdiff;}
      mov es, norm1seg
      add si, norm1ofs
      mov ax, es:[si]
      db $66
      cbw
      db $66
      sal ax, 8
      db $66
      sub ax, Word Ptr xc
      db $66
      cwd
      db $66
      idiv cx
      db $66
      mov Word Ptr xadd, ax
    {yadd:=(RandNorm1^[i,2]-yn1) shl 8 div rdiff;}
      add si, 2
      mov ax, es:[si]
      db $66
      cbw
      db $66
      sal ax, 8
      db $66
      sub ax, Word Ptr yc
      db $66
      cwd
      db $66
      idiv cx
      db $66
      mov Word Ptr yadd, ax
    {zadd:=(RandNorm1^[i,3]-zn1) shl 8 div rdiff;}
      add si, 2
      mov ax, es:[si]
      db $66
      cbw
      db $66
      sal ax, 8
      db $66
      sub ax, Word Ptr zc
      db $66
      cwd
      db $66
      idiv cx
      db $66
      mov Word Ptr zadd, ax
     @Inner_Loop:
        {xakt:=xc shr 8;}
          db $66
          mov dx, Word Ptr xc
          db $66
          mov si, dx
          db $66
          sar si, 8
        {xc:=xc+xadd;}
          db $66
          add dx, Word Ptr xadd
          db $66
          mov Word Ptr xc, dx
        {yakt:=yc shr 8;}
          db $66
          mov dx, Word Ptr yc
          db $66
          mov di, dx
          db $66
          sar di, 8
        {yc:=yc+xadd;}
          db $66
          add dx, Word Ptr yadd
          db $66
          mov Word Ptr yc, dx
        {zakt:=zc shr 8;}
          db $66
          mov dx, Word Ptr zc
          db $66
          mov cx, dx
        {zc:=zc+zadd;}
          db $66
          add cx, Word Ptr zadd
          db $66
          mov Word Ptr zc, cx
        {tmp:=(xakt shl 2 + yakt shl 3 + zakt shl 8) shl 6;}
          db $66
          mov cx, dx
          db $66
          mov ax, si        {xakt shl 2}
          db $66
          sal ax, 2
          db $66
          add dx, ax
          db $66
          mov ax, di        {yakt shl 3}
          db $66
          sal ax, 3
          db $66
          add ax, dx        {zakt shl 8}
          db $66
          sal ax, 6
          db $66
          sar cx, 8
        {tmp:=abs(tmp div WurzelTab[xakt*xakt+yakt*yakt+zakt*zakt]);}
          db $0f, $af, $f6    {imul si, si}
          db $0f, $af, $ff    {imul di, di}
          db $0f, $af, $c9    {imul cx, cx}
          add si, cx
          add si, di
          shl si, 1
          add si, sqrtofs
          db $64         {FS}
          mov cx, [si]
          db $66
          cwd
          db $66
          idiv cx
          add al, 60        {Farbe}
          db $65          {GS}
          mov [bx], al
          add bx, 80
          dec k
     jns @Inner_Loop
 @vergisses:
  dec i
  jns @Outer_Loop
End;


  Procedure TPhongFigur.Init(Filename, ObjName: String);
  Var
    i: Integer;
  Begin
    GetMem(NormFaces, SizeOf(nfFeld));
    GetMem(NormPoints, SizeOf(npFeld));
    GetMem(WurzelTab, SizeOf(sqrtFeld));
    GetMem(RandNorm0, SizeOf(RandNormFeld));
    GetMem(RandNorm1, SizeOf(RandNormFeld));
    TFigur.Init(Filename, ObjName);
    For i:=0 to 32000 do
      WurzelTab^[i]:=Heron(i)*li;
  norm0seg:=Seg(RandNorm0^);
  norm1seg:=Seg(RandNorm1^);
  norm0ofs:=Ofs(RandNorm0^);
  norm1ofs:=Ofs(RandNorm1^);
  sqrtseg:=seg(WurzelTab^);
  sqrtofs:=ofs(WurzelTab^);

  End;


  Procedure TPhongFigur.DarstPhong(alle: Boolean);
  Var
    i, k, a1, a2, a3, d1, d2,
    b1, b2, b3, c1, c2, c3: Integer;
    v: TVektor;
    tmp, b: Longint;
  Begin
    For i:=1 to nof do
    Begin
      c3:=bzko[Flaechen[i,2]];
      d1:=bzko[Flaechen[i,1]];
      d2:=bzko[Flaechen[i,3]];
      zsum[i]:=d1+c3+d2+bzko[Flaechen[i,4]];
      RF[i]:=i;
      {Farben[i]:=85+zsum[i] div 6;}
      c1:=bxko[Flaechen[i,2]];
      c2:=byko[Flaechen[i,2]];
      a1:=bxko[Flaechen[i,1]]-c1;
      a2:=byko[Flaechen[i,1]]-c2;
      a3:=d1-c3;
      b1:=bxko[Flaechen[i,3]]-c1;
      b2:=byko[Flaechen[i,3]]-c2;
      b3:=d2-c3;
      KreuzProd(a1, a2, a3, b1, b2, b3, v);
      tmp:=SkalProd(v[1], v[2], v[3], l[1], l[2], l[3]);
      Normalen[i]:=tmp;
      b:=Betrag(v);
      tmp:=abs(tmp shl 6 div (li*b));
      {Flche mu im Uhrzeigersinn orientiert sein!}
      NormFaces^[i,1]:=v[1] shl 7 div b;
      NormFaces^[i,2]:=v[2] shl 7 div b;
      NormFaces^[i,3]:=v[3] shl 7 div b;
    End;
    FillDWord(NormPoints^, nop*3 shr 1, 0);
    FillDWord(EckfarbenCount, nop shr 1, 0);
    For i:=1 to nof do
      For k:=1 to 4 do
      Begin
        Inc(NormPoints^[Flaechen[i,k],1], NormFaces^[i,1]);
        Inc(NormPoints^[Flaechen[i,k],2], NormFaces^[i,2]);
        Inc(NormPoints^[Flaechen[i,k],3], NormFaces^[i,3]);
        Inc(EckfarbenCount[Flaechen[i,k]]);
      End;
    For i:=1 to nop do
    Begin
      k:=EckfarbenCount[i];
      NormPoints^[i,1]:=NormPoints^[i,1] div k;
      NormPoints^[i,2]:=NormPoints^[i,2] div k;
      NormPoints^[i,3]:=NormPoints^[i,3] div k;
    End;
    Quicksort(1, nof);
    For i:=1 to nof do
    Begin
      k:=RF[i];
      If alle or (Normalen[k]>=0) then
      Begin
        KillRand;
        MarkPhong(xb[Flaechen[k,1]], yb[Flaechen[k,1]], xb[Flaechen[k,2]],
                  yb[Flaechen[k,2]], NormPoints^[Flaechen[k,1],1],
                  NormPoints^[Flaechen[k,1],2], NormPoints^[Flaechen[k,1],3],
                  NormPoints^[Flaechen[k,2],1], NormPoints^[Flaechen[k,2],2],
                  NormPoints^[Flaechen[k,2],3]);
        MarkPhong(xb[Flaechen[k,2]], yb[Flaechen[k,2]], xb[Flaechen[k,3]],
                  yb[Flaechen[k,3]], NormPoints^[Flaechen[k,2],1],
                  NormPoints^[Flaechen[k,2],2], NormPoints^[Flaechen[k,2],3],
                  NormPoints^[Flaechen[k,3],1], NormPoints^[Flaechen[k,3],2],
                  NormPoints^[Flaechen[k,3],3]);
        MarkPhong(xb[Flaechen[k,3]], yb[Flaechen[k,3]], xb[Flaechen[k,4]],
                  yb[Flaechen[k,4]], NormPoints^[Flaechen[k,3],1],
                  NormPoints^[Flaechen[k,3],2], NormPoints^[Flaechen[k,3],3],
                  NormPoints^[Flaechen[k,4],1], NormPoints^[Flaechen[k,4],2],
                  NormPoints^[Flaechen[k,4],3]);
        If (xb[Flaechen[k,4]]<>xb[Flaechen[k,1]]) or
           (yb[Flaechen[k,4]]<>yb[Flaechen[k,1]]) then
        MarkPhong(xb[Flaechen[k,4]], yb[Flaechen[k,4]], xb[Flaechen[k,1]],
                  yb[Flaechen[k,1]], NormPoints^[Flaechen[k,4],1],
                  NormPoints^[Flaechen[k,4],2], NormPoints^[Flaechen[k,4],3],
                  NormPoints^[Flaechen[k,1],1], NormPoints^[Flaechen[k,1],2],
                  NormPoints^[Flaechen[k,1],3]);
        FillPhongPoly;
      End;
    End;
  End;


  Procedure TPhongFigur.Done;
  Var
    i: Integer;
  Begin
    FreeMem(NormFaces, SizeOf(nfFeld));
    FreeMem(NormPoints, SizeOf(npFeld));
    FreeMem(WurzelTab, SizeOf(sqrtFeld));
    FreeMem(RandNorm0, SizeOf(RandNormFeld));
    FreeMem(RandNorm1, SizeOf(RandNormFeld));
  End;

