{******************************************************************

                           Programmiererecke

Von Trader stammt diese Unit zur Programmierung der VGA-Karte in Turbo-
Pascal. Damit werden einige Modi untersttzt, von denen viele gar nicht
wissen, da es sie gibt. Kopiert einfach diese Datei  (VGASTAR.PAS)  in
Euer Turbo-Verzeichnis und compiliert sie zu einer TPU-Datei.

          VGASTAR (VGA STandard's Augmention of Resolution)
	
	   von C in Turbo Pascal von Alexis Pimenidis '92

256 Farben in vier erweiterten Auflsungen:
  320x240 (3 Seiten)
  320x400 (2 Seiten)
  360x480 (1 Seite)
  640x400 (1 Seite) (*)

(*) der 640x400 Modus funktioniert nicht auf allen VGA-Karten (wenn er
sich auch (anscheinend) fehlerlos installieren lt. Wenn er nicht
luft merkt man es daran, da die Pixel viel zu gro sind und un-
proportional.
*******************************************************************}

unit VgaStar;

Interface

uses Crt,Dos;

const  R320x240=1;  { Die drei Funktionsmodi Aufruf z.B. SetMode(R320x400); }
       R320x400=2;
       R360x480=3;
       R640x400=4;

  var max_x,max_y:word;     { In diesem Variablen wird nach dem Functions-}
			    { aufruf die maximalen X und Y Werte gespeichert}
			    { (siehe Unit Graph : GetMaxX und GetMaxY ) }

  Function readmode:word;               { Liest einen Screenmode }
  Procedure oldmode(oldmod:word);       { Setzt einen Screenmode }

  Procedure SetMode(resolution:word);     { Setzt den VGA Modus }
  Procedure Paint(resolution,side:word);  { Whlt die aktive Mal-Seite aus }
					  { (SetActivePage) }
  Procedure Show(resolution, side:word);  { Whlt die sichtbare Seite aus }
					  { (SetVisualPage) }
  Procedure PutPix(x, y, color:word);   { Setzt einen Punkt an der Koordinate}
					{ X/Y mit der Farbe Color }
  Function Getcol(x, y:word):word;      { Liefert die Farbe des Pixels an }
					{ Der Koordinate X/Y zurck }

Implementation

var cpureg:registers;               { Die Register }
    videoram:pointer;               { Ein Zeiger auf den Bildschirmspeicher }
    zb4:word;                       { Ein viertel der Bytes pro Zeile }

Function readmode:word;
begin
 cpureg.ah:=$0f;
 intr($10,cpureg);
 readmode:=cpureg.al;
end;

Procedure oldmode(oldmod:word);
begin
 cpureg.ah:=$0f;
 cpureg.al:=oldmod;
 intr($10,cpureg);
end;

Procedure SetMode(resolution:word);
 const
 crtregval320x240:array[0..$17] of word =
  ($5f,$4f,$50,$82,$54,$80,$0d,$3e,$00,$41,$00,$00,
   $00,$00,$00,$00,$ea,$ac,$df,$28,$00,$e7,$06,$e3);
 crtregval320x400:array[0..$17] of word =
  ($5f,$4f,$50,$82,$54,$80,$bf,$1f,$00,$40,$00,$00,
   $00,$00,$00,$00,$9c,$8e,$8f,$28,$00,$96,$b9,$e3);
 crtregval360x480:array[0..$17] of word =
  ($6b,$59,$5a,$8e,$5e,$8a,$0d,$3e,$00,$40,$00,$00,
   $00,$00,$00,$00,$ea,$ac,$df,$2d,$00,$e7,$06,$e3);
 crtregval640x400:array[0..$17] of word =
  ($5f,$4f,$50,$82,$54,$80,$bf,$1f,$00,$40,$00,$00,
   $00,$00,$00,$00,$9c,$8e,$8f,$28,$00,$96,$b9,$a3);
var read,regnumber:word;

begin

 cpureg.ah:=0;
 cpureg.al:=$12;
 intr($10,cpureg);
 cpureg.ah:=0;
 cpureg.al:=$13;
 intr($10,cpureg);
 port[$3c4]:=4;
 port[$3c5]:=6;
 port[$3d4]:=$11;
 read:=port[$3d5] and $7f;
 port[$3d5]:=read;
 case  resolution of
   R320x240:begin
     port[$3c4]:=0;
     port[$3c5]:=1;
     port[$3c2]:=$0e3;
     port[$3c4]:=0;
     port[$3c5]:=3;
     for regnumber:=0 to $17 do
     begin
       port[$3d4]:=regnumber;
       port[$3d5]:=crtregval320x240[regnumber];
     end;
     zb4:=80;
     max_x:=319;max_y:=239;
   end;
   R320x400:begin
     for regnumber:=0 to $17 do
     begin
       port[$3d4]:=regnumber;
       port[$3d5]:=crtregval320x400[regnumber];
     end;
     zb4:=80;max_x:=319;max_y:=399;
   end;
   R360x480:begin
     port[$3c4]:=0;
     port[$3c5]:=1;
     port[$3c2]:=$0e7;
     port[$3c4]:=0;
     port[$3c5]:=3;
     for regnumber:=0 to $17 do
     begin
       port[$3d4]:=regnumber;
       port[$3d5]:=crtregval360x480[regnumber];
     end;
     zb4:=90;max_x:=359;max_y:=479;
   end;
   R640x400:begin
     for regnumber:=0 to $17 do
     begin
       port[$3d4]:=regnumber;
       port[$3d5]:=crtregval640x400[regnumber];
     end;
     zb4:=160;max_x:=639;max_y:=399;
   end;
 end;
 videoram:=ptr($a000,0);
end;

Procedure paint(resolution,side:word);
begin
  case resolution of
    R320x240:begin
      case side of
	1:videoram:=Ptr($a000,0);
	2:videoram:=ptr($a4b0,0);
	3:videoram:=ptr($a960,0);
	else
	  videoram:=ptr($a000,0);
      end;
    end;
    R320x400:begin
      case side of
       1:videoram:=Ptr($a000,0);
       2:videoram:=Ptr($a800,0);
	      else
	  videoram:=Ptr($a000,0);
      end;
    end;
    R360x480:begin end;
    R640x400:begin end;
    else
      videoram:=Ptr($a000,0);
  end;
end;

Procedure show(resolution, side:word);
var start:word;
begin
  case resolution of
    R320x240:begin
      case side of
	      1:start:=$00;
	      2:start:=$4b;
	      3:start:=$96;
	else
	  start:=$00;
      end;
    end;
    R320x400:begin
      case side of
	1:start:=$00;
	2:start:=$80;
	else
	  start:=$00;
      end;
    end;
    else start:=$00;
  end;
  port[$3d4]:=$0c;
  port[$3d5]:=start;
end;

Procedure putpix(x, y, color:word);
var offset:word;
begin
  offset:=y*zb4+(x shr 2);
  port[$3c4]:=2;
  port[$3c5]:=1 shl (x and 3);
  mem[seg(videoram^):ofs(videoram^)+offset]:=color;
end;

Function getcol(x, y:word):word;
var offset:word;
begin
  offset := y*zb4+(x shr 2);
  port[$3ce]:=4;
  port[$3cf]:=x and 3;
  getcol:=mem[seg(videoram^):ofs(videoram^)+offset];
end;

end.
