'TRIGFIX.BAS
'Berechnet Winkelfunktionstabellen nach zwei verschiedenen Methoden

'Aufruf: TRIGFIX[.EXE]

'Public Domain
'------------------------------------------------------------------
DECLARE SUB CalcTrig (Min!, Max!, Delta!, Mode%)

CLS
PRINT " Zeitbedarf fr 5000 Winkelfunktionen mit COS und SIN:   (Bitte warten)"
t = TIMER
FOR i = 0 TO 10 STEP .002
    dummyC = COS(i)
    dummyS = SIN(i)
NEXT i
LOCATE 1, 58: PRINT TIMER - t; "sec"; TAB(80); " "
PRINT " Letzte Ergebnisse: "; dummyC; dummyS

PRINT " Zeitbedarf fr 5000 Winkelfunktionen mit Add.-Theorem:  (Bitte warten)"
t = TIMER
CALL CalcTrig(0, 10, .002, 1)
LOCATE 3, 58: PRINT TIMER - t; "sec"; TAB(80); " "
PRINT " Letzte Ergebnisse: "; lastC; lastS
PRINT "                    -------------------"
PRINT " Abweichung:        ";
PRINT USING "##.##^^^^ "; lastC - dummyC; lastS - dummyS

SYSTEM

SUB CalcTrig (Min, Max, Delta, Mode%)
'** Berechnet trigonometrische Tabelle
'** bei Mode% = 0 mit Gradma, sonst mit Bogenma fr Min, Max und Delta

    m% = (Max - Min) / Delta
    REDIM C(m%), S(m%)

    IF Mode% THEN k = 1 ELSE k = ATN(1) / 45
    dphi = Delta * k
    PhiMin = Min * k
   
    C(0) = COS(PhiMin): dC = COS(dphi)
    S(0) = SIN(PhiMin): dS = SIN(dphi)
 
    FOR i% = 1 TO m%
        C(i%) = C(i% - 1) * dC - S(i% - 1) * dS 'nur Additionen und Multipli-
        S(i%) = S(i% - 1) * dC + C(i% - 1) * dS 'kationen, keine Winkelfunkt.
    NEXT i%
   
    SHARED lastC, lastS
    lastC = C(i% - 1)
    lastS = S(i% - 1)

END SUB

