//ਬ    3d tutorial'a
#include <conio.h>
#include "3d_tutor.h"

char edge[ne];

void drawvertexs();
void drawedges_fixedpoint();
void drawedges_antialiasing();
void drawfaces_antialiasing();
void fixedpoint_line(long x1,long y1,long x2,long y2);
void bresenhame_line(long x1,long y1,long x2,long y2);
void antialiasing_line(long x1,long y1,long x2,long y2);

void main()
{
        char n=0;
        initobj();
        setsincostable();
        setgrmode(0x13);
        setcolortable();
        while(!kbhit())
        {
                clearvirtualscreen();
                rotate(n,n,n);
                drawvertexs();
                copyvirtualscreen();
                n++;
        }
        getch();
        while(!kbhit())
        {
                clearvirtualscreen();
                rotate(n,n,n);
                drawedges_fixedpoint();
                copyvirtualscreen();
                n++;
        }
        getch();
        while(!kbhit())
        {
                clearvirtualscreen();
                rotate(n,n,n);
                drawedges_antialiasing();
                copyvirtualscreen();
                n++;
        }
        getch();
        while(!kbhit())
        {
                clearvirtualscreen();
                rotate(n,n,n);
                drawfaces_antialiasing();
                copyvirtualscreen();
                n++;
        }
        getch();

        setgrmode(0x3);
}

void drawvertexs()
{
        long x,y;
        for(long v=0;v<nv;v++)
        {
                x=promvertex[v][0]>>8;
                y=promvertex[v][1]>>8;
                screen[x+(y<<6)+(y<<8)]=63;
        }
}

void drawedges_fixedpoint()
{
        for(long n=0;n<ne;n++)
                fixedpoint_line(promvertex[edges[n][0]][0]>>8,promvertex[edges[n][0]][1]>>8,
                                promvertex[edges[n][1]][0]>>8,promvertex[edges[n][1]][1]>>8);
}

void drawedges_antialiasing()
{
        for(long n=0;n<ne;n++)
                antialiasing_line(promvertex[edges[n][0]][0]>>8,promvertex[edges[n][0]][1]>>8,
                                  promvertex[edges[n][1]][0]>>8,promvertex[edges[n][1]][1]>>8);
}

void drawfaces_antialiasing()
{
        long e;
        for(long n=0;n<nf5;n++)
        {
                if(((promvertex[facesv5[n][2]][0]-promvertex[facesv5[n][1]][0])
                   *(promvertex[facesv5[n][1]][1]-promvertex[facesv5[n][0]][1])
                   -(promvertex[facesv5[n][2]][1]-promvertex[facesv5[n][1]][1])
                   *(promvertex[facesv5[n][1]][0]-promvertex[facesv5[n][0]][0]))<0)
                {
                        for(long k=0;k<5;k++)
                        {
                                e=facese5[n][k];
                                if(edge[e])
                                {
                                        antialiasing_line(promvertex[edges[e][0]][0]>>8,
                                                          promvertex[edges[e][0]][1]>>8,
                                                          promvertex[edges[e][1]][0]>>8,
                                                          promvertex[edges[e][1]][1]>>8);
                                        edge[e]=0;
                                }
                        }
                }
        }
        for(e=0;e<ne;e++)
                edge[e]=1;
}

void fixedpoint_line(long x1,long y1,long x2,long y2)
{
        long x,y,dx,dy,sx,sy,ax,ay,bx,by,c,s;
        bx=x2-x1;
        by=y2-y1;
        if(bx>0) {ax=bx;sx=1;} else {ax=-bx;sx=-1;}
        if(by>0) {ay=by;sy=1;} else {ay=-by;sy=-1;}
        if(ax>ay)
        {
                if(ax!=0) dy=(by<<16)/ax; else dy=0;
                y=y1<<16;
                for(x=x1;x!=x2+sx;x+=sx)
                {
                        s=y>>16;
                        s=x+(s<<6)+(s<<8);
                        screen[s]=63;
                        y+=dy;
                }
        }
        else
        {
                if(ay!=0) dx=(bx<<16)/ay; else dx=0;
                x=x1<<16;
                for(y=y1;y!=y2+sy;y+=sy)
                {
                        s=(x>>16)+(y<<8)+(y<<6);
                        screen[s]=63;
                        x+=dx;
                }
        }
}

void bresenhame_line(long x1,long y1,long x2,long y2)
{
        long dx=x2-x1;
        long dy=y2-y1;
        if(dx<0) dx=-dx;
        if(dy<0) dy=-dy;
        long sx;
        long sy;
        if(x2>x1) sx=1; else sx=-1;
        if(y2>y1) sy=1; else sy=-1;
        if(dy<=dx)
        {
                long d=(dy<<1)-dx;
                long d1=dy<<1;
                long d2=(dy-dx)<<1;
                screen[x1+(y1<<6)+(y1<<8)]=63;
                for(long x=x1+sx,y=y1,i=1;i<=dx;i++,x+=sx)
                {
                        if(d>0)
                        {
                                d+=d2;
                                y+=sy;
                        }
                        else
                        {
                                d+=d1;
                        }
                        screen[x+(y<<6)+(y<<8)]=63;
                }
        }
        else
        {
                long d=(dx<<1)-dy;
                long d1=dx<<1;
                long d2=(dx-dy)<<1;
                screen[x1+(y1<<6)+(y1<<8)]=63;
                for(long y=y1+sy,x=x1,i=1;i<=dy;i++,y+=sy)
                {
                        if(d>0)
                        {
                                d+=d2;
                                x+=sx;
                        }
                        else
                        {
                                d+=d1;
                        }
                        screen[x+(y<<6)+(y<<8)]=63;
                }
        }
}

void antialiasing_line(long x1,long y1,long x2,long y2)
{
        long x,y,dx,dy,sx,sy,ax,ay,bx,by,c,s,t;
        bx=x2-x1;
        by=y2-y1;
        if(bx>0) {ax=bx;sx=1;} else {ax=-bx;sx=-1;}
        if(by>0) {ay=by;sy=1;} else {ay=-by;sy=-1;}
        if(ax>ay)
        {
                if(ax!=0) dy=(by<<16)/ax; else dy=0;
                y=y1<<16;
                for(x=x1;x!=x2+sx;x+=sx)
                {
                        c=(y&0xFC00)>>10;
                        s=x+((y>>16)<<8)+((y>>16)<<6);
                        if(screen[s+320]+c>63) screen[s+320]=63; else screen[s+320]+=c;
                        c^=0x3F;
                        if(screen[s]+c>63) screen[s]=63; else screen[s]+=c;
                        y+=dy;
                }
        }
        else
        {
                if(ay!=0) dx=(bx<<16)/ay; else dx=0;
                x=x1<<16;
                for(y=y1;y!=y2+sy;y+=sy)
                {
                        c=(x&0xFC00)>>10;
                        s=(x>>16)+(y<<8)+(y<<6);
                        if(screen[s+1]+c>63) screen[s+1]=63; else screen[s+1]+=c;
                        c^=0x3F;
                        if(screen[s]+c>63) screen[s]=63; else screen[s]+=c;
                        x+=dx;
                }
        }
}