'
'============================================================================
'Programm:  "SCHLEIFE", demonstriert ein Sprite mit der DRAW-Anweisung
'Sprache:   QBasic
'Autor(c):  Roland Heer
'Stand:     28.2.95
'============================================================================
'
DEFINT A-Z
DECLARE SUB Fliegen (Obj$, Vol)
DECLARE SUB Form (Obj$, Vol)
DECLARE SUB Himmel ()
DIM SHARED m, v
   
	CLS
	LOCATE 8, 30: PRINT "Abbrechen mit <ESC>"
	LOCATE 10, 20: INPUT "Sprite-Gre (4 ... 8) oder Leereingabe : ", m
	LOCATE 11, 20: INPUT "Geschwindigkeit (1 oder 2) oder Leereingabe : ", v
	IF m < 4 THEN m = 4
	IF m > 8 THEN m = 8
	IF v < 1 THEN v = 1
	IF v > 2 THEN v = 2
   
	SCREEN 9
	CALL Himmel
	CALL Form(Obj$, Vol)
	CALL Fliegen(Obj$, Vol)
   
	SLEEP
	SCREEN 0, , 0, 0
   
SYSTEM

'____________________________________________________________________________
'
SUB Fliegen (Obj$, Vol)
'** S=Gre, TA=Winkel fr DRAW-Funktion

	DIM pict(1561, 1), altX(1), altY(1)
 
	PCOPY 0, 1                                          'Himmel kopieren
	wi = 0: wiPTR$ = VARPTR$(wi)
	gr = m: grPTR$ = VARPTR$(gr)
	dx = CINT(gr * Vol / 8)
	dy = CINT(.7 * dx)
	ddx = 2 * dx
	ddy = 2 * dy
	vis = 0                                         'sichtbare Bildschirmseite
	hid = 1                                         'unsichtbare   "    "
	X = 350: Y = 310
	altX(vis) = X: altX(hid) = X                        'alte Koordinaten
	altY(vis) = Y: altY(hid) = Y                        'fr 2 BS-Seiten
	GET (X - dx, Y - dy)-STEP(ddx, ddy), pict(0, 0)     'alter Untergrund
	GET (X - dx, Y - dy)-STEP(ddx, ddy), pict(0, 1)     'alter Untergrund
	SCREEN , , hid, vis
	PSET (X, Y), 0                                      'Anfangszentrum
	DRAW "S=" + grPTR$ + "TA=" + wiPTR$ + Obj$          'Bild zeichnen
	PCOPY 1, 0                                          'und in BS 0 kopieren
	t! = TIMER
	FOR i = 0 TO 220 STEP v                             '1. Bogen
		X = CINT(350 * COS(i / 220))
		Y = CINT(310 * (1 - SIN(i / 220)))
		IF (i MOD 4) = 0 THEN
			wi = wi + 1
		END IF
		GOSUB fliege
	NEXT i
	x0 = 151
	y0 = 39
	FOR i = 124 TO 550 STEP 2 * v                       '2. Bogen
		X = x0 + CINT(70 * COS(i / 120))
		Y = y0 + CINT(62 * (1 - SIN(i / 120)))
		wi = wi + v
		GOSUB fliege
	NEXT i
	x0 = X
	y0 = Y - 310
	FOR i = 2 TO 200 STEP v                             '3. Bogen
		X = x0 + CINT(350 * SIN(i / 220))
		Y = y0 + CINT(310 * COS(i / 220))
		IF (i MOD 4) = 0 THEN
			wi = wi + 1
		END IF
		GOSUB fliege
	NEXT i
	SCREEN , , vis, vis
	PUT (altX(hid) - dx, altY(hid) - dy), pict(0, hid), PSET 'alter Untergrund
	PRINT "Bewegungen/sec:"; n / (TIMER - t!);

EXIT SUB

fliege:
	DO: LOOP UNTIL INP(&H3DA) AND 8                     'Bildwechsel abwarten
	DO: LOOP WHILE INP(&H3DA) AND 8
	PUT (altX(hid) - dx, altY(hid) - dy), pict(0, hid), PSET 'alter Untergrund
	GET (X - dx, Y - dy)-STEP(ddx, ddy), pict(0, hid)   'neuer Untergrund
	PSET (X, Y), 0                                      'neues Zentrum setzen
	DRAW "TA=" + wiPTR$ + Obj$                          'neues Bild zeichnen
	altX(hid) = X
	altY(hid) = Y
	hid = 1 - hid: vis = 1 - vis                        'Screen wechseln
	SCREEN , , hid, vis
	n = n + 1
	IF LEN(INKEY$) THEN EXIT SUB
RETURN
  
END SUB

'____________________________________________________________________________
'
SUB Form (Obj$, Vol)
'** Makro fr DRAW-Funktion definieren

	Vol = 37                                        'ohne Kondensstreifen
	'Vol = 30                                        'mit Kondensstreifen
	Obj$ = "C15 BU12 D2 L1 R2 F2 D1 G1 D1 R2 F3 D1 F3 R1 F1"
	Obj$ = Obj$ + "R3 U2 E1 F1 D3 G1 L2 D1 L2 G2 L5 H2 L6"
	Obj$ = Obj$ + "G2 L5 H2 L2 U1 L2 H1 U3 E1 F1 D2 R3 E1"
	Obj$ = Obj$ + "R1 E3 U1 E3 R2 U1 H1 U1 E2 R2 BD10 P8,15"

END SUB

'____________________________________________________________________________
'
SUB Himmel
   
	RANDOMIZE TIMER
  
	Stern$ = "C14 BL4 R8 BG4 BU1 U6 BU1 BF2 G4 BR4 H4 BF1 R2 D2 L2 U2"
   
	FOR i = 8 TO 344 STEP 8                                 'kleine Sterne
		FOR j = 8 TO 632 STEP 8
			IF RND < .015 THEN
				LINE (j, i)-STEP(4, 0), 14      'Farbe 15 wird nicht verdeckt!
				LINE (j + 2, i + 2)-STEP(0, -4), 14
			END IF
		NEXT j
	NEXT i
	FOR i = 14 TO 336 STEP 14                               'mittlere Sterne
		FOR j = 14 TO 630 STEP 14
			IF RND < .015 THEN
				PSET (j, i), 0
				DRAW (Stern$)
			END IF
		NEXT j
	NEXT i
	FOR i = 14 TO 336 STEP 14                               'groe Sterne
		FOR j = 14 TO 630 STEP 14
			IF RND < .01 THEN
				PSET (j, i), 0
				DRAW ("S6 " + Stern$)
			END IF
		NEXT j
	NEXT i

	c! = ATN(1) / 45                                        'Mond
	phi = -30
	X = 300: Y = 146
	a = 28: b = 15
	CIRCLE (X, Y), 37, 1                                    'blauer Kreis
	PAINT (X, Y), 8, 1                                      'Sterne lschen
	PAINT (X, Y), 0, 1                                      'im Mondbereich
	CIRCLE (X, Y), 37, 14, (95 + phi) * c!, (285 + phi) * c!'gelber Halbkreis
	ds! = SIN(phi * c!)
	dc! = COS(phi * c!)
	PSET (X + ds! * a, Y + dc! * a), 0
	FOR i! = 0 TO 180 * c! STEP 2 * c!                      'gelbe Halbellipse
		xi! = a * COS(i!)                                   'geneigt
		yi! = b * SIN(i!)
		LINE -(X - dc! * yi! + ds! * xi!, Y + dc! * xi! + ds! * yi!), 14
	NEXT i!
	PAINT (X - 25, Y), 14                                   'gelb fllen

END SUB

