'
'============================================================================
'Programm:  "JAGD", demonstriert Sprites mit PUT-Anweisungen
'Sprache:   QBasic
'Autor(c):  Roland Heer
'Stand:     28.2.95
'============================================================================
'
DEFINT A-Z
DECLARE SUB DoExplosion (Ex, Ey, vis)
DECLARE SUB MaleFlieger ()
DECLARE SUB MaleHimmel ()
DECLARE SUB MaleMeteor ()
DECLARE SUB Move ()
DIM SHARED FX, FY, MX, MY, k, MCode(1 TO 9)
DIM SHARED dx1, dy1, dx2, dy2
DIM SHARED Mond(1141), MondX, MondY
DIM SHARED U1(201, 1), Objekt1(201), Schatten1(201)
DIM SHARED U2(1123, 1), Objekt2(1123), Schatten2(1123)
CONST ScrXmax = 639                                     'x-Bildschirmbereich
CONST ScrYmax = 349                                     'y-Bildschirmbereich
   
	CLS
	LOCATE 8, 30: PRINT "Abbrechen mit <ESC>"
	LOCATE 10, 20: INPUT "Sprite-Gre (4 ... 8) oder Leereingabe: ", k
	IF k < 4 THEN k = 4
	IF k > 8 THEN k = 8
   
	RESTORE CodeData                                    'Make-Codes speichern
	FOR i = 1 TO 9
		READ MCode(i)
	NEXT i
   
	SCREEN 9
	CLS
	CALL MaleHimmel
	CALL MaleMeteor
	CALL MaleFlieger
	CALL Move
   
	SCREEN , , 0, 0
	LOCATE 25, 1: PRINT STRING$(80, " ");
	SLEEP
	SCREEN 0
   
SYSTEM

CodeData:
	DATA 79,80,81:  '1 2 3
	DATA 75,76,77:  '4 5 6
	DATA 71,72,73:  '7 8 9  auf dem num. Tastenblock

'____________________________________________________________________________
'
SUB DoExplosion (Ex, Ey, vis)

	PLAY "MBO0L32EFGEFDC"                                   'Krach
	PLAY "MBO0L16EFGEFDC"

	SCREEN , , vis, vis
	Radius = 10 * k
   
	FOR c = 1 TO Radius                                     'Feuerball
		CIRCLE (Ex, Ey), c, 15                              'zunehmend
	NEXT c
	FOR c = Radius TO 0 STEP -1                             'Feuerball
		CIRCLE (Ex, Ey), c, 0                               'abnehmend
		t! = TIMER
		DO: LOOP UNTIL TIMER - t! > .05
	NEXT c
   
	PUT (MondX, MondY), Mond, PSET                          'Mond reparieren
															'falls beschdigt
	LOCATE 25, 1: PRINT STRING$(80, " ");
	SLEEP
	SCREEN 0, , 0, 0

SYSTEM

END SUB

'____________________________________________________________________________
'
SUB MaleFlieger
'** S=Gre, TA=Winkel fr DRAW-Funktion
   
	Vol = 34
	Obj$ = "C15 BU13 D2 L1 R2 F2 D1 G1 D1 R2 F3 D1 F3 R1 F1"
	Obj$ = Obj$ + "R3 U2 E1 F1 D3 G1 L2 D1 L2 G2 L5 H2 L6"
	Obj$ = Obj$ + "G2 L5 H2 L2 U1 L2 H1 U3 E1 F1 D2 R3 E1"
	Obj$ = Obj$ + "R1 E3 U1 E3 R2 U1 H1 U1 E2 R2 BD10"
	Neg$ = Obj$ + "P15,15"                              'Schatten invertiert
	Obj$ = Obj$ + "P8,15"                               'Flugzeug
  
	wi = 35: wiPTR$ = VARPTR$(wi)                       'Achse 35 Grad
	gr = k: grPTR$ = VARPTR$(gr)                        'Gre k
	dx2 = CINT(gr * Vol / 8)
	dy2 = CINT(.6 * dx2)
	ddx = 2 * dx2                                       'Breite und Hhe des
	ddy = 2 * dy2                                       'umschlied. Rechtecks
   
	CLS
	x = 350                                             'Anfangsposition
	y = 280
	FX = x - dx2
	FY = y - dy2
   
	PSET (x, y), 0
	DRAW "S=" + grPTR$ + "TA=" + wiPTR$ + Obj$          'Flugzeug zeichnen
	GET (FX, FY)-STEP(ddx, ddy), Objekt2                'speichern
	PSET (x, y), 0
	DRAW "S=" + grPTR$ + "TA=" + wiPTR$ + Neg$          'Schattenbild zeichnen
	GET (FX, FY)-STEP(ddx, ddy), Schatten2              'speichern
	PUT (FX, FY), Schatten2, PRESET                     'Schattenbild invert.
	GET (FX, FY)-STEP(ddx, ddy), Schatten2              'speichern

END SUB

'____________________________________________________________________________
'
SUB MaleHimmel
  
	RANDOMIZE TIMER
 
	COLOR 14
	Stern$ = "C14 BL4 R8 BG4 BU1 U6 BU1 BF2 G4 BR4 H4 BF1 R2 D2 L2 U2"
  
	FOR i = 8 TO 344 STEP 8                                 'kleine Sterne
		FOR j = 8 TO 632 STEP 8
			IF RND < .015 THEN
				LINE (j, i)-STEP(4, 0)
				LINE (j + 2, i + 2)-STEP(0, -4)
			END IF
		NEXT j
	NEXT i
	FOR i = 14 TO 336 STEP 14                               'mittlere Sterne
		FOR j = 14 TO 630 STEP 14
			IF RND < .015 THEN
				PSET (j, i), 0
				DRAW (Stern$)
			END IF
		NEXT j
	NEXT i
	FOR i = 14 TO 336 STEP 14                               'groe Sterne
		FOR j = 14 TO 630 STEP 14
			IF RND < .01 THEN
				PSET (j, i), 0
				DRAW ("S6 " + Stern$)
			END IF
		NEXT j
	NEXT i

	c! = ATN(1) / 45                                        'Mond
	phi = -30
	x = 250: y = 146
	a = 28: b = 15
	CIRCLE (x, y), 37, 1                                    'blauer Kreis
	PAINT (x, y), 8, 1                                      'Sterne lschen
	PAINT (x, y), 0, 1                                      'im Mondbereich
	CIRCLE (x, y), 37, , (95 + phi) * c!, (285 + phi) * c!  'gelber Halbkreis
	ds! = SIN(phi * c!)
	dc! = COS(phi * c!)
	PSET (x + ds! * a, y + dc! * a), 0
	FOR i! = 0 TO 180 * c! STEP 2 * c!                      'gelbe Halbellipse
		xi! = a * COS(i!)                                   'geneigt
		yi! = b * SIN(i!)
		LINE -(x - dc! * yi! + ds! * xi!, y + dc! * xi! + ds! * yi!)
	NEXT i!
	PAINT (x - 25, y)                                       'gelb fllen
	GET (x - 37, y - 28)-STEP(74, 56), Mond
	MondX = x - 37: MondY = y - 28
   
	LOCATE 25, 2
	PRINT "Meteor mit den Pfeiltasten (auch diagonal: 1,3,7,9) bewegen";

END SUB

'____________________________________________________________________________
'
SUB MaleMeteor
   
	SCREEN , , 1, 0                                         'auf 1 schreiben
	CLS                                                     '0 anzeigen
   
	Radius = 6
	dx1 = CINT(Radius * k / 4)
	dy1 = CINT(.78 * dx1)
	ddx = 2 * dx1: ddy = 2 * dy1                        'Breite und Hhe des
														'umschlied. Rechtecks
	x = 320
	y = 175
	MX = x - dx1
	MY = y - dy1
   
	CIRCLE (x, y), Radius * k \ 4, 4
	PAINT (x, y), 3, 4
	GET (MX, MY)-STEP(ddx, ddy), Objekt1                    'speichern
	CIRCLE (x, y), Radius * k \ 4, 15
	PAINT (x, y), 15, 15
	GET (MX, MY)-STEP(ddx, ddy), Schatten1                  'speichern
	PUT (MX, MY), Schatten1, PRESET                         'Schatten invert.
	GET (MX, MY)-STEP(ddx, ddy), Schatten1                  'speichern

END SUB

'____________________________________________________________________________
'
SUB Move
'** Sprites bewegen
   
	DIM MaX(1), MaY(1), FaX(1), FaY(1)                      'alte Koordinaten
															'fr 2 BS-Seiten
	hid = 1                                                 'versteckte BSeite
	vis = 0                                                 'sichtbare BSeite
	PCOPY vis, hid                                          'Himmel kopieren
   
	vF = 1                                                  'Geschwdkt. Flieger
	vM = vF + 1                                             'Geschwdkt. Meteor
	ddx1 = 2 * dx1: ddx2 = 2 * dx2                          'Breite Objekt 1+2
	ddy1 = 2 * dy1: ddy2 = 2 * dy2                          'Hhe Objekt 1+2
   
	MaX(hid) = MX: FaX(hid) = FX                            'alte Werte =
	MaY(hid) = MY: FaY(hid) = FY                            'aktuelle Werte
	MaX(vis) = MX: FaX(vis) = FX
	MaY(vis) = MY: FaY(vis) = FY
   
	GET (MX, MY)-STEP(ddx1, ddy1), U1(0, 0)                 'Untergrunde fr
	GET (MX, MY)-STEP(ddx1, ddy1), U1(0, 1)                 'Objekt1 retten
	GET (FX, FY)-STEP(ddx2, ddy2), U2(0, 0)                 'Untergrunde fr
	GET (FX, FY)-STEP(ddx2, ddy2), U2(0, 1)                 'Objekt2 retten
	PUT (MX, MY), Schatten1, AND                            'Objekt1 darstellen
	PUT (MX, MY), Objekt1, OR
	PUT (FX, FY), Schatten2, AND                            'Objekt2 darstellen
	PUT (FX, FY), Objekt2, OR
	PCOPY hid, vis
   
	MBerX = ScrXmax - ddx1                                  'Bildrandgrenzen
	MBerY = ScrYmax - ddy1                                  'f. Meteorbewegung

	tF! = TIMER                                             'f. Flieger+Meteor
	DO
		Code = INP(&H60)                                    'Port 60h abfragen
		SELECT CASE Code                                    'Taste auswerten
		CASE MCode(1)                                       'links unten
			IF MX > vM THEN MX = MX - vM
			IF MY < MBerY - vM THEN MY = MY + vM
		CASE MCode(2)                                       'unten
			IF MY < MBerY - vM THEN MY = MY + vM
		CASE MCode(3)                                       'rechts unten
			IF MX < MBerX - vM THEN MX = MX + vM
			IF MY < MBerY - vM THEN MY = MY + vM
		CASE MCode(4)                                       'links
			IF MX > vM THEN MX = MX - vM
		CASE MCode(6)                                       'rechts
			IF MX < MBerX - vM THEN MX = MX + vM
		CASE MCode(7)                                       'links oben
			IF MX > vM THEN MX = MX - vM
			IF MY > vM THEN MY = MY - vM
		CASE MCode(8)                                       'oben
			IF MY > vM THEN MY = MY - vM
		CASE MCode(9)                                       'rechts oben
			IF MX < MBerX - vM THEN MX = MX + vM
			IF MY > vM THEN MY = MY - vM
		END SELECT
	   
		IF MX < FX + ddx2 AND FX < MX + ddx1 THEN           'Kollision prfen
			IF MY < FY + ddy2 AND FY < MY + ddy1 THEN
				CALL DoExplosion(FX + dx2, FY + dy2, vis)
			END IF
		END IF
	   
		DO: LOOP UNTIL INP(&H3DA) AND 8                     'Bildwechsel abwarten
		DO: LOOP WHILE INP(&H3DA) AND 8
	   
		PUT (MaX(hid), MaY(hid)), U1(0, hid), PSET          'alter Untergrund
		GET (MX, MY)-STEP(ddx1, ddy1), U1(0, hid)           'neuer Untergrd.
		PUT (MX, MY), Schatten1, AND                        'Objekt1 darstellen
		PUT (MX, MY), Objekt1, OR
		MaX(hid) = MX
		MaY(hid) = MY
	   
		IF FY <= 1 THEN                                     'Bildrand erreicht
			IF letzt < 2 THEN
				PUT (FaX(hid), FaY(hid)), U2(0, hid), PSET  'alter Untgr.
				IF letzt = 1 THEN
					LOCATE 1, 1
					PRINT USING "Flugbewegungen/sec: ###.#"; n / (TIMER - tF!);
					PCOPY hid, vis
					tM! = TIMER                             'fr Meteor solo
					n = 0
					FX = -ddx2: FY = -ddy2                  'weitere Kollision
				END IF                                      'verhindern
				letzt = letzt + 1
			END IF
			n = n + 1
			IF n MOD 100 = 0 THEN
				LOCATE 2, 1
				PRINT USING "Meteorbewegungen/sec: ###.#"; n / (TIMER - tM!);
				IF n MOD 10000 = 0 THEN                     'berlauf verhind.
					tM! = TIMER
					n = 0
				END IF
			END IF
			GOTO ScreenWechsel
		END IF
	   
		FX = FX - vF                                        'neue Position
		FY = FY - vF                                        'fr Flieger
	   
		PUT (FaX(hid), FaY(hid)), U2(0, hid), PSET          'alter Untergrund
		GET (FX, FY)-STEP(ddx2, ddy2), U2(0, hid)           'neuer Untergrund
		PUT (FX, FY), Schatten2, AND                        'Objekt2 darstellen
		PUT (FX, FY), Objekt2, OR
		FaX(hid) = FX
		FaY(hid) = FY
		n = n + 1
ScreenWechsel:
		hid = 1 - hid: vis = 1 - vis
		SCREEN , , hid, vis
		IF INKEY$ = CHR$(27) THEN EXIT SUB
	LOOP

END SUB

