program zahlenraetsel;

uses crt,dos;

var zahl : array [1..4] of string [1];          {Zahlen}
    operat : array [1..4] of string [1];        {Operatoren}
    klam : array [1..3] of string [1];          {Klammern}
    ausdruck : string;                           {Ausdruck}
    muster : array [1..11] of string;           {Legale Klammersetzung}
    zielergebnis : string;                      {Ergebnis, das gesucht ist}
    loesung : array [1..200] of string;         {Lsungen}
    anzloesung : byte;                          {Anzahl der Lsungen}
    ch : char;

{----------------------------------------------------------------------------}
{globale Variablen initialisieren}
procedure globalinit;

begin;
  anzloesung:=0;
  operat [1]:='+';operat [2]:='-';operat [3]:='*';operat [4]:='/';
  klam [1]:='';klam [2]:='(';klam [3]:=')';
  muster [1]:='(___)_(___)';
  muster [2]:='(___)____';
  muster [3]:='____(___)';
  muster [4]:='((___)__)__';
  muster [5]:='__(__(___))';
  muster [6]:='(__(___))__';
  muster [7]:='__((___)__)';
  muster [8]:='__(___)__';
  muster [9]:='(_____)__';
  muster[10]:='__(_____)';
  muster[11]:='_______';
end;

{----------------------------------------------------------------------------}
{Cursor an- und ausschalten}
procedure cursoff (befehl : boolean);
var cpu : registers;                         {Prozessorregister fr Cursorunterdrckung}

begin;
  if befehl then begin
    cpu.ah:=$01;
    cpu.ch:=$01;
    cpu.cl:=$00;
    intr ($10,cpu);
  end
  else begin
    cpu.ah:=$01;
    cpu.ch:=$0f;
    cpu.cl:=$0d;
    intr ($10,cpu);
  end;
end;

{----------------------------------------------------------------------------}
{Text zentrieren}
procedure centext (y : byte;text : string);
begin;
  gotoxy ((80-length (text)) div 2,y);
  writeln (text);
end;

{----------------------------------------------------------------------------}
{Box zeichnen}
procedure box (xs,ys,xe,ye,tc,tb,art : byte;text : string);
{bergebene Variablen:}
{           xs,ys   > Koordinaten linke,obere Ecke der Box}
{           xe,ye   > Koordinaten rechte,untere Ecke der Box}
{           tc,tb   > Vordergrundfarbe,Hintergrundfarbe}
{           art     > 1 = einfach, 2 = doppelt}
{           text    > berschrift der Box}

var i,j : byte;

begin;
  textcolor (tc);
  textbackground (tb);

  for i:=ys+1 to ye-1 do begin;
    gotoxy (xs,i);
    if art = 1 then writeln ('');
    if art = 2 then writeln ('');
    for j:=xs+1 to xe-1 do begin;
      gotoxy (j,i);
      writeln (' ');
    end;
    gotoxy (xe,i);
    if art = 1 then writeln ('');
    if art = 2 then writeln ('');
  end;

  for i:=xs+1 to xe-1 do begin;
    gotoxy (i,ys);
    if art = 1 then writeln ('');
    if art = 2 then writeln ('');
    gotoxy (i,ye);
    if art = 1 then writeln ('');
    if art = 2 then writeln ('');
  end;

  gotoxy (xs,ys);
  if art = 1 then writeln ('');
  if art = 2 then writeln ('');
  gotoxy (xs,ye);
  if art = 1 then writeln ('');
  if art = 2 then writeln ('');
  gotoxy (xe,ys);
  if art = 1 then writeln ('');
  if art = 2 then writeln ('');
  gotoxy (xe,ye);
  if art = 1 then writeln ('');
  if art = 2 then writeln ('');

  gotoxy (xs+1+((xe-xs-length (text)) div 2),ys);
  writeln (text);
end;

{----------------------------------------------------------------------------}
procedure txtent (xpos,ypos,maxlng,bcol,tcol : integer;zeichen : string;var ergebnis : string);
{bergebene Parameter :}
{zeichen : Eingabezeichen}
{xpos : X-Position Eingabefeld}
{ypos : Y-Position Eingabefeld}
{maxlng : Lnge Eingabefeld}
{bcol : Farbe Eingabefeld}
{tcol : Farbe Eingabetext}

var cont : string;
    cpos : integer;
    ch : string [1];
    i : integer;
    marker : integer;

begin;
  cursoff (false);
  textbackground (bcol);
  cpos:=0;
  gotoxy(xpos,ypos);
  textcolor (tcol);
  for i:=1 to maxlng do write (' ');
  textcolor(0); textbackground(0); write (' ');
  textcolor(tcol);textbackground(bcol);
  gotoxy(xpos,ypos);

  cont:=('');
  marker:=0;
  repeat;
    gotoxy(xpos,ypos);writeln (cont);
    gotoxy((xpos+cpos),ypos);
    ch:=readkey;
    if (pos (ch,zeichen) <> 0) and (length (cont) < maxlng) then begin;
      cont:=cont+ch;
      cpos:=cpos+1;
    end; {von if}
    if (ch[1]=chr(8)) and (cpos>0) then begin
      cpos:=cpos-1;
      cont:=copy (cont,1,cpos);
      gotoxy(xpos,ypos);
      for i:=1 to maxlng do write (' ');
    end; {von if}
    if ch[1]=chr(13) then marker:=2;
  until marker = 2;
  ergebnis:=cont;
  cursoff (true);
end;

{----------------------------------------------------------------------------}
{Zahlen potenzieren}
function pot (basis,exponent : extended) : extended;

begin;
  pot:=exp(exponent*ln(basis));
end;

{----------------------------------------------------------------------------}
{Formelstring bereinigen}
procedure clean (var formel : string);
var i:integer;
    left,right : string;

begin;

  i:=1;
  while i<length(formel) do begin;

   {aufeinanderfolgendes - vermeiden}
   if (copy (formel,i,1)='-') and (copy (formel,i+1,1)='-') then begin;
     left:=copy (formel,1,i-1);
     right:=copy (formel,i+1,length(formel)-i);
     formel:=left+right;
   end;

   {- folgend auf + vermeiden}
   if (copy (formel,i,1)='+') and (copy (formel,i+1,1)='-') then begin;
     left:=copy (formel,1,i-1);
     right:=copy (formel,i+1,length(formel)-i);
     formel:=left+right;
   end;

   {Vorzeichenkorrektur bei minus mal minus bzw minus durch minus}
   if (copy (formel,i,1)='-') and (copy (formel,i+1,1)='+') then begin;
     left:=copy (formel,1,i-1);
     right:=copy (formel,i+1,length(formel)-i);
     formel:=left+right;
   end;
  i:=i+1;
  end;

  {Pluszeichen am Anfang der Formel abschneiden}
  if (copy(formel,1,1)='+') then begin;
    formel:=copy (formel,2,length(formel)-1);
  end;

end;

{----------------------------------------------------------------------------}
{Formel nach Operator '-' durchsuchen}
function search (formel : string) : integer;
var i : integer;

begin;
  i:=2;
  search:=0;
  repeat
    if copy (formel,i,1) = '-' then begin;
      search:=i; exit;
    end;
    search:=0;
    i:=i+1
  until i>length (formel);
end;

{----------------------------------------------------------------------------}
{Formelteil vereinfachen}
procedure simplif (var formel : string; smark,operation : integer);


var lform,rform,result : string;
    lmark,rmark,code,i,id : integer;
    zwr,zwl,res : extended;
begin;

  {linken Berechnungsteilstring erstellen}
  lform:=('');
  lmark:=smark-1;
  id:=1;
  while id=1 do begin;
    lform:=copy (formel,lmark,1) + lform;
    lmark:=lmark - 1;
    id:=0;
    if (copy(formel,lmark,1)>='0') and (copy(formel,lmark,1)<='9') and (lmark>0) then id:=1;
    if copy(formel,lmark,1)='.' then id:=1;
  end;
  if copy(formel,lmark,1)='-' then lform:='-' + lform;

  {rechten Berechnungsteilstring erstellen}
  rform:=('');
  rmark:=smark+1;
  if (copy(formel,rmark-1,1)='*') and (copy(formel,rmark,1)='-') then begin;
    rform:=rform + '-';
    rmark:=rmark + 1;
  end;
  if (copy(formel,rmark-1,1)='/') and (copy(formel,rmark,1)='-') then begin;
    rform:=rform + '-';
    rmark:=rmark + 1;
  end;
  id:=1;
  while id=1 do begin;
    rform:=rform + copy (formel,rmark,1);
    rmark:=rmark + 1;
    id:=0;
    if (copy(formel,rmark,1)>='0') and (copy(formel,rmark,1)<='9') and (rmark<=length(formel)) then id:=1;
    if copy(formel,rmark,1)='.' then id:=1;
  end;

  {Teilergebnis berechnen}
  val (rform,zwr,code);
  val (lform,zwl,code);

  if operation = 5 then res:=pot (zwl,zwr);
  if operation = 4 then begin;
    if zwr = 0 then zwr:=99999;
    res:=zwl/zwr;
  end;
  if operation = 3 then res:=zwl*zwr;
  if operation = 2 then res:=zwl+zwr;
  if operation = 1 then res:=zwl-zwr;
  str (res:19:19,result);

  {Teilergebnis auf richtige Gre und richtiges Format formatieren}
  while copy(result,length(result),1)='0' do begin;
    result:=copy(result,1,length(result)-1);
  end;
  if copy(result,length(result),1)='.' then  result:=copy(result,1,length(result)-1);
  while copy (result,1,1)=' ' do begin
    result:=copy (result,2,length(result)-1);
  end;
  if (copy(formel,lmark,1)='-') and (operation = 4) then begin;
    result:='+'+result;
    lmark:=lmark-1;
  end;
  if (copy(formel,lmark,1)='-') and (operation = 3) then begin;
    result:='+'+result;
    lmark:=lmark-1;
  end;

  {neue Formel erstellen}
  formel:=copy (formel,1,lmark)+result+copy(formel,rmark,length(formel)-rmark+1);

  {beim ersten Glied negatives Vorzeichen abschneiden, wenn positiv}
  if (lmark=1) and (copy(formel,1,1) = '-') and (res >= 0) then formel:=copy (formel,2,length(formel)-1);
  clean (formel);

end;

{----------------------------------------------------------------------------}
{Formelteil vereinfachen}
procedure vereinfache (var formel : string);
label alpha,beta;
begin;

  clean (formel);

  {Punkt am Anfang der Formel vermeiden}
  if copy(formel,1,1)='.' then formel:='0'+formel;

  {Formelteile potenzieren}
  while (pos('^',formel) <> 0) do begin;
    simplif (formel,pos('^',formel),5);
  end;
  alpha:

  {Formelteile dividieren}
  while (pos('/',formel) <> 0) do begin;
    simplif (formel,pos('/',formel),4);
  end;

  {Formelteile multiplizieren}
  while (pos('*',formel) <> 0) do begin;
    simplif (formel,pos('*',formel),3);
  end;

  if copy (formel,pos('-',formel)-1,1) = '^' then goto beta;
  {Formelteile subtrahieren}
  while (search (formel) <> 0) do begin;
    simplif (formel,search (formel),1);
  end;
  beta:

  {Formelteile addieren}
  while (pos('+',formel) <> 0) do begin;
    simplif (formel,pos('+',formel),2);
  end;

end;

{----------------------------------------------------------------------------}
{Klammern aufloesen}
procedure aufloese (var aformel : string);
var posi,lpos,rpos,jumper,index,count,i : integer;
    formel : string;
label alpha,beta;

begin;


  {Klammern zur Auflsung vorbereiten}
  count:=0;
  repeat;
    count:=count+1;
    posi:=2;index:=0;i:=1-count;
    repeat;
      if (copy (aformel,posi-1,2)='-(') and (i=0) then begin;
        i:=i+1;index:=1;
        aformel:=copy (aformel,1,posi-2) + '+' + copy (aformel,posi,length (aformel));
        aformel:=copy (aformel,1,posi) + '-' + copy (aformel,posi+1,length (aformel)-posi);
        posi:=posi+2;
      end;
      if copy (aformel,posi-1,2)='-(' then i:=i+1;
      if copy (aformel,posi,1)=')' then i:=i-1;
      if i=1 then begin;
        jumper:=0;
        if (copy (aformel,posi,1)='*') or (copy (aformel,posi,1)='/') then begin;
          aformel:=copy (aformel,1,posi) + '-' +  copy (aformel,posi+1,length (aformel)-posi);
          jumper:=1;
        end;
        if copy (aformel,posi,1)='+' then begin;
          aformel:=copy (aformel,1,posi-1) + '-' + copy (aformel,posi+1,length (aformel)-posi);
          jumper:=1;
        end;
        if (copy (aformel,posi,1)='-') and (jumper=0) then begin;
          aformel:=copy (aformel,1,posi-1) + '+' + copy (aformel,posi+1,length (aformel)-posi);
        end;
      end;
      posi:=posi+1;
    until posi>length (aformel);
  until index=0;

  {einzelne Klammern auflsen}
  repeat;
    posi:=1;lpos:=0;rpos:=0;
    alpha:;
      if copy (aformel,posi,1)='(' then begin;
        formel:='';lpos:=posi;
        beta:;
        posi:=posi+1;
        if copy (aformel,posi,1) =  '(' then goto alpha;
        if copy (aformel,posi,1) <> ')' then begin;
          formel:=formel + copy (aformel,posi,1);
        end;
        if copy (aformel,posi,1) <> ')' then goto beta;
        rpos:=posi;
        vereinfache (formel);
        aformel:=copy (aformel,1,lpos-1)+formel+copy(aformel,rpos+1,length (aformel)-rpos);
      end;
    if (lpos=0) and (rpos=0) and (posi<=length(aformel)) then begin;
      posi:=posi+1;
      goto alpha;
    end;
    jumper:=0;
    for i:=1 to length (aformel) do begin;
      if copy (aformel,i,1)='(' then jumper:=1;
    end;
  until jumper=0;
  vereinfache (aformel);
  vereinfache (aformel);
end;

{----------------------------------------------------------------------------}
{Prfung, ob Ausdruck mathmatisch korrekt}
function pruefe (formel : string) : boolean;
var legal : boolean;                        {Marker, ob Klammersetzung korrekt}
    structure : string;                     {eingelesene Klammernstruktur}
    i : byte;

begin;
  legal:=false;
  structure:='';
  for i:=1 to length (formel) do begin;
    if copy (formel,i,1) = '(' then structure:=structure + '(';
    if copy (formel,i,1) = ')' then structure:=structure + ')';
    if (copy (formel,i,1) <> '(') and (copy (formel,i,1) <> ')') then structure:=structure + '_';
  end;
  for i:=1 to 11 do begin;
    if structure = muster [i] then begin;
      legal:=true;
      i:=11;
    end;
  end;
  pruefe:=legal;
end;

{--------------------------------------------------------------------------}
{Operatoren ermitteln}
procedure inop (var k1,k2,k3,k4,k5,k6,k7,k8,k9,ka,kb,kc,kd,ke,i,j,k,l : byte);
var m,n,o : byte;                               {Operatorenindizes}
    uebergebe : string;                         {An Formelinterpreter bergebener Ausdruck}
    lind : byte;                                {Indexnummer Lsung}
    double : boolean;                           {Marker, ob Lsung doppelt}

begin;
  for m:=1 to 4 do begin;
    for n:=1 to 4 do begin;
      for o:=1 to 4 do begin;
        ausdruck:='';
        ausdruck:=ausdruck + klam [k1] + klam [k2] + zahl [i] + operat [m];
        ausdruck:=ausdruck + klam [k3] + klam [k4] + zahl [j] + klam [k5] + klam [k6] + operat [n];
        ausdruck:=ausdruck + klam [k7] + klam [k8] + zahl [k] + klam [k9] + klam [ka] + operat [o];
        ausdruck:=ausdruck + klam [kb] + klam [kc] + zahl [l] + klam [kd] + klam [ke];
       if pruefe (ausdruck) = false then begin
          i:=4;j:=4;k:=4;l:=4;
          m:=4;n:=4;o:=4;
        end
        else begin
          uebergebe:=ausdruck;
          aufloese (uebergebe);
          if uebergebe = zielergebnis then begin;
            double:=false;
            for lind:=1 to anzloesung do begin;
              if ausdruck = loesung [lind] then double:=true;
            end;
            if (not double) and (anzloesung <= 200) then begin;
              anzloesung:=anzloesung + 1;
              loesung [anzloesung]:=ausdruck;
            end;
          end;
        end;
      end;
    end;
  end;
end;

{----------------------------------------------------------------------------}
{Ausdruck erstellen}
procedure inzahl (var k1,k2,k3,k4,k5,k6,k7,k8,k9,ka,kb,kc,kd,ke : byte);

var i,j,k,l : byte;                             {Zahlenindizes}
begin;
  for i:=1 to 4 do begin;
    for j:=1 to 4 do begin;
      for k:=1 to 4 do begin;
        for l:=1 to 4 do begin;
          if i <> j then begin;
            if i <> k then begin;
              if i <> l then begin;
                if j <> k then begin;
                  if j <> l then begin;
                    if k <> l then begin;
                      inop (k1,k2,k3,k4,k5,k6,k7,k8,k9,ka,kb,kc,kd,ke,i,j,k,l);
                    end;
                  end;
                end;
              end;
            end;
          end;
        end;
      end;
    end;
  end;
end;

{----------------------------------------------------------------------------}
{Klammersetzung ermitteln}
procedure maketerm;
var k1,k2,k3,k4,k5,k6,k7,k8,k9,ka,kb,kc,kd,ke : byte;

begin;
  clrscr;
  box (30,10,48,12,7,0,1,'');
  centext (11,'proceeding...   ');

  for k1:=1 to 3 do begin; 
   for k2:=1 to 3 do begin;
    for k3:=1 to 3 do begin;
     for k4:=1 to 3 do begin;
      for k5:=1 to 3 do begin;
       for k6:=1 to 3 do begin;
        for k7:=1 to 3 do begin;
        for k8:=1 to 3 do begin;
          for k9:=1 to 3 do begin;
           for ka:=1 to 3 do begin;
            for kb:=1 to 3 do begin;
             for kc:=1 to 3 do begin;
              for kd:=1 to 3 do begin;
               for ke:=1 to 3 do begin;
                 gotoxy (46,11);
                 case k7 of
                   1 : writeln ('*');
                   2 : writeln ('$');
                   3 : writeln ('%');
                 end;
                 if (k1 <> 3) and (k2 <> 3) then begin;
                   if (k3 <> 3) and (k4 <> 3) then begin;
                     if (kb <> 2) and (kc <> 2) then begin;
                       if (kd <> 2) and (ke <> 2) then begin;
                         inzahl (k1,k2,k3,k4,k5,k6,k7,k8,k9,ka,kb,kc,kd,ke);
                       end;
                     end;
                   end;
                 end;

               end;
              end;
             end;
            end;
           end;
          end;
         end;
        end;
       end;
      end;
     end;
    end;
   end;
  end;
end;

{----------------------------------------------------------------------------}
{Lsungen ausgeben}
procedure outsolutions;
var i,j,k : integer;
    start : integer;
    ausgabe : string;
    gebl : boolean;

begin;
  clrscr;
  box (1,1,80,20,7,0,1,'Lsungen:');
  if anzloesung > 0 then begin;
    start:=1;
    box (1,21,80,23,7,0,1,'');
    centext (22,'< Pg Up > = rckwrts  *  < Pg Down > = vorwrts  *  < ESC > = verlassen');
    repeat;
      for i:=0 to 16 do begin;
        gotoxy (2,3+i);writeln ('                                                                            ');
      end;
      i:=start;k:=3;
      repeat;
        gotoxy (5,k);
        if i <= anzloesung then begin;
          ausgabe:=loesung [i] + '=' + zielergebnis;
          write (ausgabe:19,'        ');
        end;
        if i + 1 <= anzloesung then begin;
          ausgabe:=loesung [i+1] + '=' + zielergebnis;
          write (ausgabe:19,'        ');
        end;
        if i + 2 <= anzloesung then begin;
          ausgabe:=loesung [i+2] + '=' + zielergebnis;
          write (ausgabe:19);
        end;
        i:=i+3;k:=k+1;
      until i >= start + 50;
      repeat;
        repeat;
          ch:=readkey;
          gebl:=false;
          if ch = #81 then begin;
            if start + 51 < anzloesung then begin;
                                       start:=start + 51;
                                       gebl:=true;
            end;
          end;
          if ch = #73 then begin;
            if start - 51 > 0 then begin;
                                   start:=start - 51;
                                   gebl:=true;
            end;
          end;
          if ch= #27 then gebl:=true;
        until gebl=true;
      until (ch = #81) or (ch=#73) or (ch=#27);
    until ch=chr (27);
  end;

  if anzloesung = 0 then begin;
    centext (3,' Es wurden keine Lsungen gefunden !');
    box (1,21,80,23,7,0,1,'');
    centext (22,'Drcken Sie eine beliebige Taste, um fortzufahren !');
    ch:=readkey;
  end;

end;

{----------------------------------------------------------------------------}
{Parameter eingeben}
procedure parenter;
var i : byte;
    param : string;

begin;
  repeat;
    clrscr;
    box (1,1,80,3,7,0,2,'');
    centext (2,'Zahlenrtsel V1.0  *  By Heiko Nolte in November 1995');
    box (1,4,80,23,7,0,1,'Parametereingabe:');
    for i:=1 to 4 do begin;
      gotoxy (33,4+i*2);
      textcolor (7);textbackground (0);
      writeln ('Parameter ',i,' ->');
      repeat;
        txtent (49,4+i*2,1,0,7,'1234567890',param);
      until param <> '';
      zahl [i]:=param;
    end;
    gotoxy (33,14);
    textcolor (7);textbackground (0);
    writeln ('Ergebnis    ->');
    repeat;
      txtent (49,14,4,0,7,'1234567890',param);
    until (param <> '');
    
    zielergebnis:=param;
    centext (17,'   Es sollen alle Ausdrcke gefunden werden, die');
    gotoxy (19,18);writeln('aus den Zahlen '+zahl [1]+','+zahl [2]+','+zahl [3]+','+zahl [4]+' die '+zielergebnis+' ergeben.');
    centext (19,'   Die 4 Grundrechenarten und eine beliebige    ');
    centext (20,'   Klammersetzung ist erlaubt.                  ');
    centext (22,'Eingaben korrekt < j / n > ?');
    repeat;
      ch:=readkey;
    until ch in ['j','n'];
  until ch = 'j'
end;

{----------------------------------------------------------------------------}
{main}
begin;
  repeat;
    cursoff (true);
    parenter;
    globalinit;
    maketerm;
    outsolutions;
    clrscr;
    box (09,10,70,12,7,0,1,'');
    centext (11,'Wollen Sie eine weitere Berechnung durchfhren < j / n > ?');
    ch:=' ';
    ch:=readkey;
  until ch='n';
  clrscr;
  writeln ('Farewell...');
end.
