program vesaview;

uses dos,emmunit,cd_unit5,midas, mplayer, modp;

const seek_start=0;
      seek_akt=1;
      seek_ende=2;

const fkt_nothing       =0;
      fkt_exit          =1;
      player_power_off  =0;
      player_stopped    =1;
      player_drive_open =2;
      player_playing    =3;
      player_paused     =4;
      player_mp_stopped =10;
      player_mp_playing =11;

      timer_reset_num        =0;
      timer_clear_line0      =1;
      timer_clear_line1      =2;
      timer_clear_line2      =3;
      timer_clear_line3      =4;
      timer_show_anz         =5;
      timer_show_time        =6;
      timer_show_mod_infos   =7;
      timer_nothing        =$ff;

      typ_scroll_field  =0;
      typ_but_field     =1;

type farben=array[0..999]of byte;
     vesainfo_datablock0=record
       signa:array[0..3] of byte;major_v,minor_v:byte;hersteller:pointer;l_flag:array[0..1]of word;modis:pointer;
      end;
     vesainfo_freeblock0=array[0..255]of byte;
     vesainfo_datablock1=record
       modusflag:word;
       f_win1,f_win2:byte;
       granu,winsize,segm1,segm2:word;
       far_rout:pointer;
       byte_per_line,x_points,y_points:word;
       breit_matrix,hoehe_matrix,bit_planes,bit_per_point,anz_bloecke,speichermodell,groesse_bloecke:byte;
      end;
     list_entry=record name:string[12];addr,size:longint;end;
     sd_rec=record
       tempoPoll,configBits : word;
       port : word;
       IRQ,DMA : byte;
       cardType,numCardTypes,status,mode : word;
       ID,cardNames : pointer;
       numPortAddresses : word;
       portAddresses : pointer;
       detectptr:pointer;
       leer:array[0..(7*4)-1]of byte;
       muteptr:pointer;
       pauseptr:pointer;
       setmvolptr:pointer;  {sdSetMasterVolume = function(masterVolume : byte) : integer;}
       getmvolptr:pointer;  {sdGetMasterVolume = function(masterVolume : Pbyte) : integer;}
      end;

     but_field=record
       header:string[30];
       headerx,headery:word;
       headercol:byte;
       list_typ:byte;
       listx,listy,listw,lista:word;
       listcol,list_anz,list_idx,list_next:byte;
       list:array[0..9]of string[30];
      end;
     player_butfield=record
       x1,y1,x2,y2:word;
       col_norm,col_avail,col_active:byte;
       akt_col,last_col:byte;
      end;
     cfg=record
       player_used:byte;
       soundcard:record
         card:byte;
         port:word;
         irq,dma:byte;
         rate:word;
        end;
      end;
     player_field=record
       playbut:array[0..60]of player_butfield;
       modlist:record
                anz,index,list_start:byte;
                akttrack:byte;
                akttrackname:string[8];
                track:array[1..99]of byte;
                trackname:array[1..99]of string[8];
                trackdesc:array[1..99]of string[26];
               end;
       mod_dir,play_dir:string;
       dir_info:record anz,list_start:byte;name:array[1..255]of string[12];end;
       dir_field_handle:emshandle;
       player_status:string[15];
       player_stb:byte;
       initialized:boolean;
       timer_fkt1,timer_fkt2:byte;
       res_track:byte;
       sync_count:byte;
       direct_avail:boolean;
       direct_value:byte;
       track,min,sec:byte;
       length_on:boolean;
       line_used:array[0..3]of byte;
       module:pmpmodule;
      end;
     save_field=record
       player_cfg:cfg;
       module:record
         mod_select:string[8];
         mod_dir:string[255];
         mod_status:byte;
        end;
       cd:record
         tracks:array[1..99]of trackinfo;
         playlist:record mode:byte;anz:byte;track:array[1..99]of byte;end;
         shuffle_on:boolean;
         program_on:boolean;
         introscan_on:boolean;
         introscan_art:byte;
         repeat_mode:byte;
         index:byte;
        end;

      end;


var regs:registers;
    i,x,y,handle,start:word;
    header:farben;
    p_aktwin_byte,p_neuwin_byte,p_granu_diff,status:^byte;
    p_aktwin_diff:^longint;
    aktpal,storepal,zielpal,origpal:farben;
    modi_nr:byte;
    pb:^byte;
    datenbl:^vesainfo_datablock0;
    datenbl2:vesainfo_datablock1;
    p_datenblock:vesainfo_freeblock0;
    modi_liste:array[0..40] of word;
      {mouse-vars}
    mousebut,mousex,mousey,mouseset,altmbut,altmx,altmy,event_status,mousemoved:word;
    mouse_shape,backmouse:array[0..143]of byte;
    mouse:record altmx,altmy,mousex,mousey,mset:word;end;
      {packer-vars}
    packstring1,packstring2:string;
    lastpixel,aktpixel,aktwin_depack:byte;
    d_offset,d_segment:word;
    depack_ptr:pointer;
    fileseg,fileofs,packed_read:word;
    file_ptr:pointer;
    pixel_set,packed_size:longint;
      {loader-vars}
    liste:file of list_entry;
    fileoffset:longint;
    entry:list_entry;
    filegroesse:longint;
    datafilehandle:word;
    datafilename:string[100];
      {font-vars}
    cutx,cuty:word;
    font1:array[0..52,0..4,0..6]of byte;
    font2:array[0..67,0..11,0..14]of byte;
    font1table,font2table:array[0..255]of byte;
    font1idx,font2idx:byte;
      {setup-vars}
    updo_but:array[0..337]of byte;
    setup_cfg:cfg;
    sb_sd,gus_sd,auto_sd:^sd_rec;
    button:array[0..5]of but_field;
    but_parts:array[0..2,0..51]of byte;
    pbutton:^but_field;
    scroll_frame:array[0..3]of emshandle;
    scroll_seg:word;
    control_fkt:byte;
    taste:char;
      {player-vars}
    player:player_field;
    midas_error_text:string;
    player_font1:array[0..10,0..8,0..11]of byte;
    player_font2:record
       font:array[0..50,0..12,0..11]of byte;
       table:array[0..255]of byte;
      end;
    save_info:save_field;
    f_save_info:file of save_field;

procedure aktwin_byte;external;
procedure granu_diff;external;
procedure aktwin_diff;external;
procedure winstat;external;
procedure two_pages;external;

procedure setgranu_faktor(granu:word);external;
procedure moveaktwin(hw:word);external;
function  getwinbyte(x,y:word):byte;external;
procedure vputpixel(x,y,f:word);external;
function  vgetpixel(x,y:word):byte;external;
procedure vputpixel_woc(x,y,f:word);external;
function  vgetpixel_woc(x,y:word):byte;external;
procedure vputpixel_virt(x,y,f,segm:word);external;
function  vgetpixel_virt(x,y,segm:word):byte;external;
procedure vputblock(start,anz,segm,offs:word);external;
procedure vgetblock(start,anz,segm,offs:word);external;
procedure vputvirtblock(x,y,anz,segm,offs:word);external;
procedure vgetvirtblock(x,y,anz,segm,offs:word);external;
procedure vcopy_woc(anz_dw,seg1,ofs1,seg2,ofs2:word);external;
procedure vcopy_screen_2_mem(anz_lines,ofs1,seg2,ofs2:word);external;
procedure vcopy_mem_2_screen(anz_lines,seg1,ofs1,ofs2:word);external;
procedure vcopy_mem_2_mem(anz_lines,seg1,ofs1,seg2,ofs2:word);external;
procedure vcopy_mem(anz_bytes,seg1,ofs1,seg2,ofs2:word);external;
procedure vcopy_s_and(anz_lines,seg1,ofs1,ofs2,ofs_m:word);external;
procedure vcopy_s_bkg(anz_lines,ofs1:word;col_dw:longint);external;
procedure vputmouse(x,y,mp_seg,mp_ofs,bp_seg,bp_ofs:word);external;
procedure vclearmouse(x,y,bp_seg,bp_ofs:word);external;
procedure vscroll_mem(seg,ofs,anz,rot:word);external;

{$l vesaview.obj}


procedure cd_sync_player_controller;forward;
procedure control_cd(but:word);forward;
procedure control_mp(but:word);forward;
procedure autodetect_hardware;forward;
procedure set_fields(dev:byte);forward;
procedure mp_track_infos;forward;
procedure mp_show_mod_infos;forward;
procedure control_timer_function(timer:byte);forward;
procedure putstring_bkg(x1,y1:word;text:string;farbe,bkgcol,font:byte);forward;

procedure change_akt_path(path:string;po:pointer);forward;
function get_akt_drive:string;forward;
function get_akt_path:string;forward;
function get_higher_path(s:string):string;forward;
function check_path(path:string):boolean;forward;

function getfilesize(name:string):longint;
var f:file of byte;
begin
 assign(f,name);
 {$i-}
 reset(f);
 {i+}
 if ioresult>0 then begin getfilesize:=0;exit;end;
 getfilesize:=filesize(f);
 close(f);
end;

function openfile(name:string):word;
begin
 name:=name+chr(0);
 regs.ax:=$3d02;regs.ds:=seg(name[1]);regs.dx:=ofs(name[1]);intr($21,regs);
 if (regs.flags and fcarry)=0 then openfile:=regs.ax else openfile:=$ffff;
end;

function createfile(name:string):word;
begin
 name:=name+chr(0);
 regs.ax:=$3c00;regs.cx:=0;regs.ds:=seg(name[1]);regs.dx:=ofs(name[1]);intr($21,regs);
 if (regs.flags and fcarry)=0 then createfile:=regs.ax else createfile:=$ffff;
end;

procedure closefile(handle:word);
begin
 regs.ax:=$3e00;regs.bx:=handle;intr($21,regs);
end;

procedure readfile(handle,anz:word;po:pointer);
begin
 regs.ax:=$3f00;regs.bx:=handle;regs.cx:=anz;regs.ds:=seg(po^);regs.dx:=ofs(po^);intr($21,regs);
end;

procedure writefile(handle,anz:word;po:pointer);
begin
 regs.ax:=$4000;regs.bx:=handle;regs.cx:=anz;regs.ds:=seg(po^);regs.dx:=ofs(po^);intr($21,regs);
end;

procedure deletefile(name:String);
begin
 name:=name+chr(0);regs.ax:=$4100;regs.ds:=seg(name[1]);regs.dx:=ofs(name[1]);intr($21,regs);
end;

procedure seekfile(handle:word;seek_opt:byte;offs:longint);
begin
 regs.ah:=$42;regs.al:=seek_opt;regs.bx:=handle;regs.cx:=offs div 65536;regs.dx:=offs mod 65536;intr($21,regs);
end;


procedure save_all_infos;
begin
 with save_info do
  begin
   player_cfg:=setup_cfg;
   if player.player_stb=player_mp_playing then
    begin
     module.mod_select:=player.modlist.akttrackname;
     module.mod_status:=player.modlist.akttrack;
    end
   else
    begin
     module.mod_select:=player.modlist.trackname[player.modlist.index];
     module.mod_status:=player.modlist.track[player.modlist.index];
    end;
   move(cd_rom.tracks,cd.tracks,sizeof(cd_rom.tracks));
   move(cd_rom.playlist,cd.playlist,sizeof(cd_rom.playlist));
   cd.shuffle_on:=cd_rom.shuffle_on;
   cd.program_on:=cd_rom.program_on;
   cd.introscan_on:=cd_rom.introscan_on;
   cd.introscan_art:=cd_rom.introscan_art;
   cd.repeat_mode:=cd_rom.repeat_mode;
   if cd_rom.shuffle_on=false then cd.index:=cd_rom.player.index else cd.index:=1;
   if player.player_stb=player_mp_playing then module.mod_dir:=player.play_dir else module.mod_dir:=player.mod_dir;
  end;
 assign(f_save_info,'player.cfg');
 rewrite(f_save_info);
 write(f_save_info,save_info);
 close(f_save_info);
end;
procedure load_all_infos;
begin
 assign(f_save_info,'player.cfg');
 {$i-}reset(f_save_info);{$i+}
 player.mod_dir:='';
 if ioresult=0 then
  begin
   read(f_save_info,save_info);
   close(f_save_info);
   with save_info do
    begin
     player.mod_dir:=module.mod_dir;
     if not(check_path(player.mod_dir)) then player.mod_dir:='';
    end;
  end;
 if player.mod_dir='' then
  begin
   player.mod_dir:='';
   save_info.cd.program_on:=false;
   save_info.cd.shuffle_on:=false;
   save_info.cd.introscan_on:=false;
   save_info.cd.introscan_art:=0;
   save_info.cd.repeat_mode:=0;
  end;
end;

{$f+}
procedure mp_sync_player_controller;interrupt;
begin
 asm cli;end;
 cd_set_cdrom_adress;
 asm
  pushf
  call cd_rom.user_oldint
 end;
 if cd_rom.user_timer1_on then begin if cd_rom.user_timer1>0 then dec(cd_rom.user_timer1) else
  begin cd_rom.user_timer1_click:=true;cd_rom.user_timer1_on:=false;end;end;
 if cd_rom.user_timer2_on then begin if cd_rom.user_timer2>0 then dec(cd_rom.user_timer2) else
  begin cd_rom.user_timer2_click:=true;cd_rom.user_timer2_on:=false;end;end;
 cd_set_old_adress;
 port[$20]:=$20;
 asm sti;end;
end;
{$f-}

procedure myown_init;
begin
 if player.initialized=false then
  begin
   my_error_string:=addr(midas_error_text);midas_error_text:='';
   midasinit;player.initialized:=true;
   all_init_timer_kernel(addr(mp_sync_player_controller));
  end;
end;
procedure myown_deinit;
begin
 if player.initialized=true then
  begin
   my_error_string:=addr(midas_error_text);midas_error_text:='';
   midasclose;player.initialized:=false;
  end;
end;

procedure init_scroll_frames;
var locptr:pointer;
begin
 scroll_seg:=emsframeseg;
 scroll_frame[0]:=emsalloc(2);scroll_frame[1]:=emsalloc(2);scroll_frame[2]:=emsalloc(2);scroll_frame[3]:=emsalloc(2);
end;
procedure deinit_scroll_frames;
begin
 emsdealloc(scroll_frame[0]);emsdealloc(scroll_frame[1]);emsdealloc(scroll_frame[2]);emsdealloc(scroll_frame[3]);
end;


procedure initdatafile(name:string);
begin
 datafilename:=name;
 datafilehandle:=openfile(name+'.dat');
end;
procedure deinitdatafile;
begin
 closefile(datafilehandle);
end;
procedure getoffset(name:string);
begin
 assign(liste,datafilename+'.idx');reset(liste);
 repeat
  read(liste,entry);
 until entry.name=name;
 fileoffset:=entry.addr;
 filegroesse:=entry.size;
 close(liste);
end;
procedure v_openfile(name:string);
begin
 initdatafile('data');
 getoffset(name);
 seekfile(datafilehandle,0,fileoffset);
end;
procedure v_closefile;
begin
 deinitdatafile;
end;
procedure v_readfile(anz:word;po:pointer);
begin
 readfile(datafilehandle,anz,po);
end;
procedure v_readfile_p1(anz:word;po:pointer);
var locptr:pointer;
begin
 readfile(datafilehandle,anz,po);
 locptr:=ptr(seg(po^),ofs(po^)+anz);
 readfile(datafilehandle,1,locptr);
end;
procedure v_seekfile(pos:longint);
begin
 seekfile(datafilehandle,0,fileoffset+pos);
end;
function v_getfilesize(name:string):longint;
begin
 assign(liste,'data.idx');reset(liste);
 repeat read(liste,entry);until entry.name=name;
 v_getfilesize:=entry.size;close(liste);
end;

procedure get_modi(po:pointer);
var count:byte;pw:^word;
begin count:=0;repeat pw:=ptr(seg(po^),ofs(po^)+count);modi_liste[count div 2]:=pw^;inc(count,2);until pw^=$ffff;
 modi_nr:=count div 2;
end;
function get_granu_faktor(granu_kb:byte):byte;
var granu:word;count:byte;
begin
 if granu_kb=64 then get_granu_faktor:=16
 else
  begin
   granu:=granu_kb*1024;count:=0;
   if granu>1 then
    begin
     repeat asm shr granu,1;inc count;end;until granu=1;get_granu_faktor:=count;
    end else get_granu_faktor:=1;
  end;
end;

procedure get_Vesa_info;
begin
 datenbl:=addr(p_datenblock);regs.ah:=$4f;regs.al:=0;regs.es:=seg(p_datenblock);regs.di:=ofs(p_datenblock);intr($10,regs);
end;
procedure get_modi_info(modus:word);
begin
 regs.ah:=$4f;regs.al:=1;regs.cx:=modus;regs.es:=seg(datenbl2);regs.di:=ofs(datenbl2);intr($10,regs);
end;

function vesa_info1:boolean;
const liste:string[4]='VESA';
begin
 get_vesa_info;for i:=0 to 3 do if (chr(datenbl^.signa[i]))<>liste[i+1] then begin vesa_info1:=false;exit;end;
 get_modi(datenbl^.modis);vesa_info1:=true;
end;

procedure setwritemode(mode:byte);assembler;
asm
 mov dx,$3ce;mov ax,$0005;out dx,al;inc dx;in al,dx;
 mov ah,al;and ah,252;mov cl,mode;and cl,3;add ah,cl;dec dx;mov al,$05;out dx,ax;
end;
procedure setreadmode(mode:byte);assembler;
asm
 mov dx,$3ce;mov ax,$0005;out dx,al;inc dx;in al,dx;
 mov ah,al;and ah,247;mov cl,mode;and cl,1;shl cl,4;or ah,cl;dec dx;mov al,$05;out dx,ax;
end;

function check4vesa:boolean;
var du:boolean;po:^byte;
begin
 du:=false;po:=addr(two_pages);
 if vesa_info1 then
  begin
   for i:=0 to modi_nr do
    if modi_liste[i]=$101 then begin get_modi_info($101);du:=true;
    if datenbl2.f_win2>0 then po^:=1 else po^:=0;
   end;
  end;
 check4vesa:=du;
end;


procedure initvesamode;
begin
 if vesa_info1 then
  begin for i:=0 to modi_nr do if modi_liste[i]=$101 then get_modi_info($101);end
 else begin writeln('Keine VESA-Karte gefunden!');halt;end;
 regs.ax:=$4f02;regs.bx:=$101;intr($10,regs);
 p_aktwin_byte:=addr(aktwin_byte);
 p_granu_diff:=addr(granu_diff);p_granu_diff^:=get_granu_faktor(datenbl2.granu);
 p_aktwin_diff:=addr(aktwin_diff);
 status:=addr(winstat);
end;

procedure vbl;assembler;
asm
 mov dx,$3da
 @wait1:in al,dx;test al,$8;jnz @wait1
 @wait2:in al, dx;test al,$8;jz @wait2
end;

{mouse-routs}
{Beginn der Mausroutinen}
{$f+}
procedure new_event_handler;assembler;
asm
 pusha
 push ds
 push ax
 mov ax,seg mousebut
 mov ds,ax
 cmp event_status,2
 je @aktiv
 shl event_status,1
 mov mousex,cx
 mov mousey,dx
 mov mousebut,bx
 mov mousemoved,1
 shr event_status,1
 @aktiv:
 pop ax
 pop ds
 popa
end;
{$f-}

function get_event_adress:pointer;
begin
 get_event_adress:=addr(new_event_handler);
end;

procedure init_new_event_handler(addy:pointer);assembler;
asm
 pusha
 les dx,addy
 mov ax,$000c
 mov cx,127
 int $33
 popa
end;
procedure mouse_setpos(mx,my:word);assembler;
asm
 mov ax,4
 mov cx,mx
 mov dx,my
 int $33
 mov cx,mx
 mov mousex,cx
 mov cx,my
 mov mousey,cx
end;
procedure mouse_getpos;assembler;
asm
 mov ax,3
 int $33
 mov mousex,cx
 mov mousey,dx
end;

procedure plotmouse;
var x,y:word;b:byte;
begin
 if mouseset=1 then exit;
 mouseset:=1;
 altmx:=mousex;altmy:=mousey;
 if getwinbyte(altmx,altmy)=getwinbyte(altmx+11,altmy+11) then
  vputmouse(altmx,altmy,seg(mouse_shape),ofs(mouse_shape),seg(backmouse),ofs(backmouse))
 else
  begin
   for y:=altmy to altmy+11 do for x:=altmx to altmx+11 do
    begin
     backmouse[(y-altmy)*12+(x-altmx)]:=vgetpixel(x,y);
     b:=mouse_shape[(y-altmy)*12+(x-altmx)];if b>0 then vputpixel(x,y,b);
    end;
  end;
end;
procedure clearmouse;
var x,y:word;
begin
 if mouseset=0 then exit;
 mouseset:=0;
 if getwinbyte(altmx,altmy)=getwinbyte(altmx+11,altmy+11) then
  vclearmouse(altmx,altmy,seg(backmouse),ofs(backmouse))
 else
  for y:=altmy to altmy+11 do for x:=altmx to altmx+11 do vputpixel(x,y,backmouse[(y-altmy)*12+(x-altmx)]);
end;


procedure movemouse;assembler;
asm
 cmp mousemoved,0
 je @exitmovemouse
 mov cx,mousebut
 mov altmbut,cx
 mov mousemoved,0
 call vbl
 call clearmouse
 call plotmouse
 @exitmovemouse:
 cmp player.sync_count,0
 jne @noch_warten
 cmp player.player_stb,0
 je @exit
 mov player.sync_count,4
 call cd_sync_player_controller;
 jmp @exit
 @noch_warten:
 dec player.sync_count
 @exit:
end;

procedure initmouse;assembler;
asm
 mov ax,0
 int $33
 mov ax,7
 mov cx,0
 mov dx,628
 int $33
 mov ax,8
 mov cx,0
 mov dx,467
 int $33
 mov mousebut,0
 mov altmbut,0
 mov mouseset,0
 mov mousemoved,0
end;
procedure read_pointer_data;
begin
 v_openfile('pfeil2.new');
 v_readfile(144,addr(mouse_shape));
 v_closefile;
end;

procedure initmousesys;
begin
 initmouse;initmouse;read_pointer_data;
 init_new_event_handler(get_event_adress);
 mouse_getpos;
end;

procedure secmousepos;
begin
 mouse.altmx:=altmx;
 mouse.altmy:=altmy;
 mouse.mousex:=mousex;
 mouse.mousey:=mousey;
end;
procedure resmousepos;
begin
 altmx:=mouse.altmx;
 altmy:=mouse.altmy;
 mousex:=mouse.mousex;
 mousey:=mouse.mousey;
 mouse.mset:=1;
 mouse_setpos(mouse.mousex,mouse.mousey);
end;


{ende der mouse-routs}

procedure setorigpal;
begin
 move(header,aktpal,1000);move(aktpal,origpal,1000);
 regs.ax:=$1012;regs.bx:=0;regs.cx:=256;regs.es:=seg(header[0]);regs.dx:=ofs(header[0]);intr($10,regs);
end;
procedure setblack;
begin
 move(aktpal,storepal,1000);fillchar(aktpal,1000,0);
 regs.ax:=$1012;regs.bx:=0;regs.cx:=256;regs.es:=seg(aktpal);regs.dx:=ofs(aktpal);intr($10,regs);
end;

procedure setpal;assembler;
asm
 cli;mov cx,768;push si;lea si,aktpal;mov dx,$3c8;xor al,al;out dx,al;inc dx;rep outsb;pop si;sti;
end;
procedure setpal_z;assembler;
asm
 cli;mov cx,768;push si;lea si,zielpal;mov dx,$3c8;xor al,al;out dx,al;inc dx;rep outsb;pop si;sti;
end;

procedure fade_to_step1(zielpalofs:word);assembler;
asm
 @next_frame:
  mov di,zielpalofs;lea si,aktpal;mov cx,768
 @weiter:
  mov al,[si];mov ah,[di];mov bl,ah;sub bl,al;cmp bl,2;jg @rauf;neg bl;cmp bl,2;jg @runter;mov al,ah
 @schreiben:
  dec cx;je @fertig;mov [si],al;inc si;inc di;jmp @weiter
 @runter:
  dec al;dec al;jmp @schreiben
 @rauf:
  inc al;inc al;jmp @schreiben
 @fertig:
  call vbl;call setpal
end;
procedure fade_to_all(zielpalofs:word;schritt:byte);assembler;
var fade_groesste:word;
asm
  mov ax,63;div schritt;xor ah,ah;mov fade_groesste,ax
 @next_frame:
  mov di,zielpalofs;lea si,aktpal;mov cx,768
 @weiter:
  mov al,[si];mov ah,[di];mov bl,ah;sub bl,al;cmp bl,schritt;jg @rauf;neg bl;cmp bl,schritt;jg @runter;mov al,ah
 @schreiben:
  dec cx;je @fertig;mov [si],al;inc si;inc di;jmp @weiter
 @runter:
  sub al,schritt;jmp @schreiben
 @rauf:
  add al,schritt;jmp @schreiben
 @fertig:
  call vbl;call setpal;dec fade_groesste;jne @next_frame
end;

procedure init_fadeout(start,ende:byte);
begin
 move(aktpal,storepal,768);move(aktpal,zielpal,768);
 fillchar(zielpal[start*3],(ende-start+1)*3,0);
end;
procedure init_fadeto(start,ende,r,g,b:byte);
var i:byte;
begin
 move(aktpal,storepal,768);move(aktpal,zielpal,768);
 for i:=start to ende do
  begin
   zielpal[i*3+0]:=r;zielpal[i*3+1]:=g;zielpal[i*3+2]:=b;
  end;
end;
{player-routs}
procedure player_cutten1(i:byte;po:pointer;cutx:word);
type bu=array[0..8,0..87]of byte;
var pu:^bu;x,y:word;f:byte;
begin
 pu:=po;
 for y:=0 to 8 do
  for x:=cutx to cutx+7 do
  begin
   f:=pu^[y,x];player_font1[i,y,x-cutx]:=f;
  end;
end;
procedure player_cutten2(idx,i:byte;po:pointer;cutx:word);
type bu=array[0..12,0..639]of byte;
var pu:^bu;x,y:word;f:byte;
begin
 pu:=po;
 for y:=0 to 12 do
  for x:=cutx to cutx+11 do
  begin
   f:=pu^[y,x];player_font2.font[idx,y,x-cutx]:=f;
  end;
 player_font2.table[i]:=idx;
end;

procedure player_initfont1;
var buffer:array[0..8,0..87]of byte;
begin
 for i:=0 to 8 do begin v_seekfile(48768+(i*640));v_readfile(88,addr(buffer[i,0]));end;
 for i:=0 to 10 do player_cutten1(i,addr(buffer[0,0]),i*8);
end;
procedure player_initfont2;
var buffer:array[0..12,0..639]of byte;
begin
 for i:=0 to 255 do player_font2.table[i]:=36;
 v_seekfile(55808);v_readfile(8320,addr(buffer[0,0]));
 for i:=0 to 25 do player_cutten2(i,i+65,addr(buffer[0,0]),i*12);
 for i:=26 to 35 do player_cutten2(i,i+48-26,addr(buffer[0,0]),i*12);
 player_cutten2(36,32,addr(buffer[0,0]),432);
 player_cutten2(37,58,addr(buffer[0,0]),444);
 player_cutten2(38,43,addr(buffer[0,0]),456);
 player_cutten2(39,45,addr(buffer[0,0]),468);
 player_cutten2(40,46,addr(buffer[0,0]),480);
 player_cutten2(41,33,addr(buffer[0,0]),492);
 player_cutten2(42,63,addr(buffer[0,0]),504);
 player_cutten2(43,42,addr(buffer[0,0]),516);
 player_cutten2(44,95,addr(buffer[0,0]),528);
 player_cutten2(45,92,addr(buffer[0,0]),540);
 player_cutten2(46,40,addr(buffer[0,0]),552);
 player_cutten2(47,41,addr(buffer[0,0]),564);
end;
procedure player_putchar(font,i:byte;x1,y1:word);
var x,y:word;
begin
 if font=1 then
  begin
   for y:=y1 to y1+8 do
    for x:=x1 to x1+7 do
     vputpixel(x,y,player_font1[i,y-y1,x-x1]);
  end
 else
  begin
   for y:=y1 to y1+12 do
    for x:=x1 to x1+11 do
     vputpixel(x,y,player_font2.font[player_font2.table[i],y-y1,x-x1]);
  end;
end;
procedure put_text_f1(vh,vl:byte);
var m:byte;
begin
 m:=mouseset;clearmouse;
 if vh<11 then player_putchar(1,vh,509,450);
 if vl<11 then player_putchar(1,vl,517,450);
 if m>0 then plotmouse;
end;
procedure put_text_f2(zeile,spalte:byte;text:string);
var x,y:word;i,m:byte;
begin
 if length(text)=0 then exit;
 m:=mouseset;clearmouse;
 player.line_used[zeile]:=1;
 y:=388+(zeile*15);
 x:=172+(spalte*12);
 for i:=0 to length(text)-1 do player_putchar(2,ord(upcase(text[i+1])),x+(i*12),y);
 if m>0 then plotmouse;
end;

procedure init_timer_function(timer:byte;length:word;fkt:byte);forward;

procedure colorize_buffer(po:pointer;anz,col:byte);assembler;
asm
 push es
 les di,po
 xor cx,cx
 mov cl,anz
 mov ah,col
 @colbut1:
  mov al,es:[di]
  and al,240
  cmp al,16
  jne @falsche_farbe
  mov al,ah
  stosb
  jmp @gesetzt
  @falsche_farbe:
  inc di
  @gesetzt:
 loop @colbut1
 pop es
end;
function button_status(but,status:byte):boolean;
var col:byte;x,y:word;
begin
 if status=0 then col:=player.playbut[but].col_norm;
 if status=1 then col:=player.playbut[but].col_avail;
 if status=2 then col:=player.playbut[but].col_active;
 with player.playbut[but] do
  for y:=y1 to y2 do
   for x:=x1 to x2 do
    if vgetpixel(x,y)=col then begin button_status:=true;exit;end;
 button_status:=false;
end;

procedure colorize_but(but,mode:byte);
var x,y:word;b,col,m:byte;buffer:array[0..100]of byte;anz:byte;offs:word;
begin
 m:=mouseset;
 clearmouse;
 with player.playbut[but] do
  begin
   last_col:=akt_col;
   if mode=0 then col:=col_norm;if mode=1 then col:=col_avail;if mode=2 then col:=col_active;
   if y1<409 then
    begin for y:=y1 to y2 do for x:=x1 to x2 do begin b:=vgetpixel(x,y);if (b>15) and (b<32)then vputpixel(x,y,col);end;end
   else
    begin
     moveaktwin(4);anz:=x2-x1+1;
     offs:=word((longint(y1)*640+longint(x1)) and 65535);
     for y:=y1 to y2 do
      begin
       vcopy_mem(anz,$a000,offs,seg(buffer),ofs(buffer));
       colorize_buffer(addr(buffer),anz,col);
       vcopy_mem(anz,seg(buffer),ofs(buffer),$a000,offs);
       inc(offs,640);
      end;
    end;
   akt_col:=mode;
  end;
 if m>0 then plotmouse;
end;
procedure colorize_poss_but(but,mode:byte);
var x,y:word;b,col,m:byte;buffer:array[0..100]of byte;anz:byte;offs:word;
begin
 m:=mouseset;
 clearmouse;
 with player.playbut[but] do
  begin
   last_col:=akt_col;
   if mode=0 then col:=col_norm;if mode=1 then col:=col_avail;if mode=2 then col:=col_active;
   if y1<409 then
    begin
     for y:=y1+1 to y2-1 do for x:=x1+1 to x2-1 do begin b:=vgetpixel(x,y);if (b>15) and (b<32)then vputpixel(x,y,col);end;
    end
   else
    begin
     moveaktwin(4);anz:=(x2-1)-(x1+1)+1;
     offs:=word((longint(y1+1)*640+longint(x1+1)) and 65535);
     for y:=y1+1 to y2-1 do
      begin
       vcopy_mem(anz,$a000,offs,seg(buffer),ofs(buffer));
       colorize_buffer(addr(buffer),anz,col);
       vcopy_mem(anz,seg(buffer),ofs(buffer),$a000,offs);
       inc(offs,640);
      end;
    end;
   akt_col:=mode;
  end;
 if m>0 then plotmouse;
end;

procedure show_all_posbuts;
begin
 for i:=1 to 20 do
  if cd_rom.tracks[i].audio then colorize_poss_but(i+20,1);
end;

procedure showavail(status:byte);
begin
 if status=player_power_off then
  begin
   colorize_but(0,0);colorize_but(1,0);colorize_but(2,0);
   colorize_but(3,0);colorize_but(4,0);colorize_but(5,0);
   colorize_but(6,0);
   colorize_but(7,0);colorize_but(8,0);colorize_but(9,0);colorize_but(10,0);
   player.player_stb:=status;exit;
  end;
 if status=player_stopped then
  begin
   colorize_but(0,1);colorize_but(1,1);colorize_but(2,1);
   colorize_but(3,0);
   if cd_rom.shuffle_on then begin colorize_but(4,0);colorize_but(5,0);end else begin colorize_but(4,1);colorize_but(5,1);end;
   colorize_but(6,1);
   colorize_but(7,1);colorize_but(8,1);colorize_but(9,1);colorize_but(10,1);
   player.player_stb:=status;exit;
  end;
 if status=player_drive_open then
  begin
   colorize_but(0,0);colorize_but(1,0);colorize_but(2,0);
   colorize_but(3,0);colorize_but(4,0);colorize_but(5,0);colorize_but(6,1);
   player.player_stb:=status;exit;
  end;
 if status=player_playing then
  begin
   colorize_but(0,1);colorize_but(1,1);colorize_but(2,2);
   colorize_but(3,1);
   if cd_rom.shuffle_on then colorize_but(4,0) else colorize_but(4,1);
   colorize_but(5,1);
   colorize_but(6,1);
   colorize_but(7,1);colorize_but(8,1);colorize_but(9,1);colorize_but(10,1);
   player.player_stb:=status;exit;
  end;
 if status=player_paused then
  begin
   colorize_but(0,1);colorize_but(1,1);colorize_but(2,1);
   colorize_but(3,2);
   colorize_but(4,1);
   if cd_rom.shuffle_on then colorize_but(4,0) else colorize_but(4,1);
   colorize_but(6,1);
   colorize_but(7,1);colorize_but(8,1);colorize_but(9,1);colorize_but(10,1);
   player.player_stb:=status;exit;
  end;
 if status=player_mp_stopped then
  begin
   colorize_but(0,1);colorize_but(1,1);colorize_but(2,1);
   colorize_but(3,0);
   colorize_but(4,1);colorize_but(5,1);
   colorize_but(6,0);
   colorize_but(7,0);colorize_but(8,0);colorize_but(9,0);colorize_but(10,0);
   player.player_stb:=status;exit;
  end;
 if status=player_mp_playing then
  begin
   colorize_but(0,1);colorize_but(1,1);colorize_but(2,2);
   colorize_but(3,0);
   player.player_stb:=status;exit;
  end;
end;
procedure hide_track(tr:byte);
begin
 if tr>20 then begin colorize_but(41,0);player.direct_avail:=false;exit;end
 else colorize_but(tr+20,0);
 if (cd_rom.program_on=true) and (cd_rom.tracks[tr].audio)
  then colorize_poss_but(tr+20,1);
end;
procedure show_track(tr:byte);
begin
 if tr>20 then begin colorize_but(41,1);player.direct_avail:=true;exit;end
 else colorize_but(tr+20,1);
end;
procedure mark_track(tr:byte);
begin
 if tr>20 then begin colorize_but(41,2);player.direct_avail:=true;exit;end
 else colorize_but(tr+20,2);
end;

procedure hide_tracks_all;
var i:byte;
begin
 for i:=1 to 20 do hide_track(i);hide_track(255);
end;
procedure hide_akt_track;
var dum:byte;
begin
 dum:=0;
 if cd_rom.shuffle_on=false then
  begin
   if cd_rom.playlist.track[cd_rom.player.index]<21 then hide_track(cd_rom.playlist.track[cd_rom.player.index]) else dum:=100;
  end
 else
  begin
   if cd_rom.shufflelist.track[cd_rom.shufflelist.index]<21 then hide_track(cd_rom.shufflelist.track[cd_rom.shufflelist.index])
     else dum:=100;
  end;
 if dum=100 then hide_track(255);
end;
procedure hide_res_track;
begin
 if player.res_track<21 then hide_track(player.res_track);
end;
procedure res_akt_track;
begin
 if cd_rom.shuffle_on=false then player.res_track:=cd_rom.playlist.track[cd_rom.player.index]
 else player.res_track:=cd_rom.shufflelist.track[cd_rom.shufflelist.index];
end;
procedure show_akt_track;
begin
 if cd_rom.shuffle_on=false then
  begin
   if cd_rom.playlist.track[cd_rom.player.index]<21 then mark_track(cd_rom.playlist.track[cd_rom.player.index]);
  end
 else
  begin
   if cd_rom.shufflelist.track[cd_rom.shufflelist.index]<21 then
    mark_track(cd_rom.shufflelist.track[cd_rom.shufflelist.index]);
  end;
end;

procedure show_tracks_all;
var i,dum:byte;
begin
 dum:=0;
 if cd_rom.shuffle_on=false then
  begin
   for i:=cd_rom.player.index to cd_rom.playlist.anz do
     if cd_rom.playlist.track[i]<21 then
      begin
       if cd_rom.tracks[cd_rom.playlist.track[i]].audio then show_track(cd_rom.playlist.track[i]);
      end else if cd_rom.tracks[cd_rom.playlist.track[i]].audio then dum:=100;
  end
 else
  begin
   for i:=cd_rom.shufflelist.index to cd_rom.shufflelist.anz do
     if cd_rom.shufflelist.track[i]<21 then
      begin
       if cd_rom.tracks[cd_rom.shufflelist.track[i]].audio then show_track(cd_rom.shufflelist.track[i]);
      end  else if cd_rom.tracks[cd_rom.shufflelist.track[i]].audio then dum:=100;
  end;
 if dum=100 then show_track(255);
 if cd_is_playing then show_akt_track;
end;


procedure show_player_config_all;
begin
 if cd_rom.introscan_on=false then colorize_but(11,1)
  else
   begin if cd_rom.introscan_art=0 then colorize_but(12,1);if cd_rom.introscan_art=1 then colorize_but(13,1);end;
 if cd_rom.repeat_mode=0 then colorize_but(14,1);
 if cd_rom.repeat_mode=1 then colorize_but(15,1);
 if cd_rom.repeat_mode=2 then colorize_but(16,1);
 if cd_rom.program_on=false then colorize_but(17,1);
 if cd_rom.program_on=true  then colorize_but(18,1);
 if cd_rom.shuffle_on=false then colorize_but(19,1);
 if cd_rom.shuffle_on=true  then colorize_but(20,1);
end;
procedure show_player_config_one(num:byte);
begin
 if num=0 then begin
  if cd_rom.introscan_on=false then colorize_but(11,1)
   else begin if cd_rom.introscan_art=0 then colorize_but(12,1);if cd_rom.introscan_art=1 then colorize_but(13,1);end;
  end;
 if num=1 then begin
  if cd_rom.repeat_mode=0 then colorize_but(14,1);
  if cd_rom.repeat_mode=1 then colorize_but(15,1);
  if cd_rom.repeat_mode=2 then colorize_but(16,1);
 end;
 if num=2 then begin
  if cd_rom.program_on=false then colorize_but(17,1);
  if cd_rom.program_on=true  then colorize_but(18,1);
 end;
 if num=3 then begin
  if cd_rom.shuffle_on=false then colorize_but(19,1);
  if cd_rom.shuffle_on=true  then colorize_but(20,1);
 end;
end;
procedure hide_player_config_all;
begin
 if cd_rom.introscan_on=false then colorize_but(11,0)
  else
   begin if cd_rom.introscan_art=0 then colorize_but(12,0);if cd_rom.introscan_art=1 then colorize_but(13,0);end;
 if cd_rom.repeat_mode=0 then colorize_but(14,0);
 if cd_rom.repeat_mode=1 then colorize_but(15,0);
 if cd_rom.repeat_mode=2 then colorize_but(16,0);
 if cd_rom.program_on=false then colorize_but(17,0);
 if cd_rom.program_on=true  then colorize_but(18,0);
 if cd_rom.shuffle_on=false then colorize_but(19,0);
 if cd_rom.shuffle_on=true  then colorize_but(20,0);
end;
procedure hide_player_config_one(num:byte);
begin
 if num=0 then begin
  if cd_rom.introscan_on=false then colorize_but(11,0)
   else begin if cd_rom.introscan_art=0 then colorize_but(12,0);if cd_rom.introscan_art=1 then colorize_but(13,0);end;
  end;
 if num=1 then begin
  if cd_rom.repeat_mode=0 then colorize_but(14,0);
  if cd_rom.repeat_mode=1 then colorize_but(15,0);
  if cd_rom.repeat_mode=2 then colorize_but(16,0);
 end;
 if num=2 then begin
  if cd_rom.program_on=false then colorize_but(17,0);
  if cd_rom.program_on=true  then colorize_but(18,0);
 end;
 if num=3 then begin
  if cd_rom.shuffle_on=false then colorize_but(19,0);
  if cd_rom.shuffle_on=true  then colorize_but(20,0);
 end;
end;

procedure player_init;
begin
 cd_stop_user_timer(1);
 cd_stop_user_timer(2);
 player.player_stb:=player_power_off;
 player.sync_count:=4;
 player.direct_avail:=false;
 player.direct_value:=$aa;
 player.track:=0;player.min:=0;player.sec:=0;
 player.length_on:=false;
 setup_cfg.player_used:=0;
 player.modlist.anz:=1;player.modlist.index:=1;player.modlist.track[1]:=0;player.modlist.trackname[1]:='2010';
 load_all_infos;if player.mod_dir='' then player.mod_dir:=get_akt_path;
 player.play_dir:=player.mod_dir;
 mp_track_infos;
 showavail(0);
end;







function var2str(v,l,m:byte):string;
var st:string;
begin
 str(v,st);
 while length(st)<l do if m=1 then st:='0'+st else st:=' '+st;
 var2str:=st;
end;
procedure hide_line(line:byte);
var str:string[30];
begin
 if player.line_used[line]=0 then exit;
 str:='                         ';
 put_text_f2(line,0,str);
 player.line_used[line]:=0;
end;
procedure show_insert_cd;
begin
 hide_line(0);
 put_text_f2(0,2,'BITTE CD EINLEGEN');
 init_timer_function(2,30,timer_clear_line0);
end;
procedure show_time_imm;
var str:string;
begin
 cd_play_info;
 player.track:=cd_rom.akt_track;str:='TRACK:'+var2str(player.track,2,2);
 str:=str+'    ZEIT: ';
 player.min:=cd_rom.akt_title_time.min;str:=str+var2str(player.min,2,2);
 str:=str+':';
 player.sec:=cd_rom.akt_title_time.sec;str:=str+var2str(player.sec,2,1);put_text_f2(3,1,str);
 player.length_on:=false;
end;
procedure show_track_anz(timer:byte);
var str:string;
begin
 if setup_cfg.player_used=2 then
  begin
   str:=var2str(cd_count_tracks,2,2);
   put_text_f2(1,1,'Anzahl Audiotracks:  '+str);
   if timer=1 then init_timer_function(1,200,timer_show_time);
   if timer=2 then init_timer_function(2,200,timer_show_time);
  end;
end;
procedure show_track_times(timer:byte);
var str:string;rb:red_book;lo:longint;
begin
 if setup_cfg.player_used=2 then
  begin
   lo:=cd_count_tracks_time;
   rb.min:=byte((lo div 4500));
   rb.sec:=byte(((lo mod 4500) div 75));
   if cd_rom.program_on=false then
    if (rb.min=0)and(rb.sec=0)then begin init_timer_function(1,200,timer_show_time);exit;end;
   str:=var2str(rb.min,2,2)+':'+var2str(rb.sec,2,1);
   put_text_f2(1,1,'Spieldauer:       '+str+' ');
   if timer=1 then init_timer_function(1,200,timer_show_anz);
   if timer=2 then init_timer_function(2,200,timer_show_anz);
  end;
end;
procedure show_track_length_1;
var str:string;tr:byte;
begin
 cd_stop_user_timer(1);
 str:='Wiedergabeende:   ';
 str:=str+var2str(cd_rom.play_finished.min,2,2)+':';
 str:=str+var2str(cd_rom.play_finished.sec,2,1);put_text_f2(1,1,str);
end;

procedure show_track_length;
var str:string;tr,anz:byte;
begin
 player.length_on:=true;
 if cd_rom.shuffle_on then begin hide_line(3);exit;end else tr:=cd_rom.playlist.track[cd_rom.player.index];
 anz:=cd_rom.playlist.anz;
 if cd_rom.tracks[tr].audio=false then
  begin cd_searchfirsttrack;if cd_rom.shuffle_on=false then tr:=cd_rom.player.index else tr:=cd_rom.shufflelist.index;end;
 if (cd_rom.tracks[tr].audio=false)or(anz=0) then
  begin
   hide_line(3);
   exit;
  end;
 str:='TRACK:'+var2str(tr,2,2)+'  LAENGE: ';
 str:=str+var2str(cd_rom.tracks[tr].zeit.min,2,2)+':';
 str:=str+var2str(cd_rom.tracks[tr].zeit.sec,2,1);put_text_f2(3,1,str);
end;
procedure show_time_chg;
var str:string;
begin
 if player.player_stb=player_paused then exit;
 if (cd_rom.player.modus=mode_play)and(cd_is_playing) then cd_play_info else exit;
  if cd_rom.akt_title_time.sec<>player.sec then
   begin
    player.sec:=cd_rom.akt_title_time.sec;
    str:=var2str(player.sec,2,1);
    put_text_f2(3,22,str);
    if (cd_rom.akt_title_time.min<>player.min) then
     begin
      player.min:=cd_rom.akt_title_time.min;
      str:=var2str(player.min,2,2);
      put_text_f2(3,19,str);
     end;
   end;
  if (cd_rom.akt_track<>player.track) then
   begin
    player.track:=cd_rom.akt_track;
    str:=var2str(player.track,2,2);
    put_text_f2(3,7,str);
   end;
end;
function check_if_equal(po1,po2:pointer;size:word):boolean;assembler;
asm
 push es
 push ds
 mov cx,size
 les di,po2
 lds si,po1
 repe cmpsb
 jne @unterschiede
 mov ax,1
 jmp @ende
 @unterschiede:
 mov ax,0
 @ende:
 pop ds
 pop es
end;

procedure cd_power_on;
begin
 secmousepos;
 control_timer_function(1);control_timer_function(2);
 if not(cd_init) then exit;
 if not(cd_getdrivename) then exit;
 cd_openhandle;cd_init_timer_kernel;
 cd_getchanneldat;
 cd_drivestatus;if not(cd_rom.audio_avail) then exit;
 if cd_rom.cd_in_drive and cd_rom.door_closed then
  begin
   cd_audio_info;
   cd_track_infos;
   cd_searchfirsttrack;
   cd_init_player_functions;
   player.length_on:=false;
   cd_rom.player.modus:=mode_nothing;cd_rom.player.action:=act_nothing;
   cd_rom.program_on:=false;cd_rom.shuffle_on:=false;
   cd_rom.introscan_on:=false;cd_rom.introscan_art:=0;cd_rom.repeat_mode:=0;
   if check_if_equal(addr(save_info.cd.tracks),addr(cd_rom.tracks),sizeof(save_info.cd.tracks))
      then
       begin
        cd_rom.program_on:=save_info.cd.program_on;
        cd_rom.repeat_mode:=save_info.cd.repeat_mode;
        cd_rom.shuffle_on:=save_info.cd.shuffle_on;
        cd_rom.introscan_on:=save_info.cd.introscan_on;
        cd_rom.introscan_art:=save_info.cd.introscan_art;
       end;
   if check_if_equal(addr(save_info.cd.tracks),addr(cd_rom.tracks),sizeof(save_info.cd.tracks))
      then move(save_info.cd.playlist,cd_rom.playlist,sizeof(save_info.cd.playlist));
   if cd_rom.shuffle_on then cd_create_playlist_shuffle;
   vbl;showavail(1);if cd_rom.program_on then show_all_posbuts;
   show_player_config_all;show_tracks_all;show_track_anz(1);
  end
 else
  begin
   control_cd(6);
   showavail(player_drive_open);
  end;
 put_text_f2(0,1,'Power: ON   MODE: CD');
 init_timer_function(2,30,timer_clear_line0);
 asm
  mov ax,7
  mov cx,0
  mov dx,628
  int $33
  mov ax,8
  mov cx,370
  mov dx,468
  int $33
 end;
 mouse_setpos(320,410);
end;
procedure cd_power_off(mode:byte);
begin
 control_timer_function(1);control_timer_function(2);
 if mode=1 then begin command_kernel(cmd_stop);end;
 cd_deinit_timer_kernel;
 save_all_infos;
 cd_unlockdrive;
 cd_closehandle;
 vbl;
 showavail(0);
 hide_player_config_all;
 if cd_rom.program_on then begin cd_rom.program_on:=false;hide_tracks_all;cd_rom.program_on:=true;end
  else hide_tracks_all;
 put_text_f1($a,$a);
 hide_line(0);hide_line(1);hide_line(2);hide_line(3);
 asm
  mov ax,7
  mov cx,0
  mov dx,628
  int $33
  mov ax,8
  mov cx,0
  mov dx,468
  int $33
 end;
 if mouseset>0 then clearmouse;
 resmousepos;
end;
procedure control_timer_function(timer:byte);
var fkt:byte;
begin
 cd_stop_user_timer(timer);
 if timer=1 then
  begin
   fkt:=player.timer_fkt1;player.timer_fkt1:=timer_nothing;
   if fkt=timer_reset_num then begin put_text_f1(10,10);player.direct_value:=$aa;end;
   if fkt=timer_clear_line0 then begin hide_line(0);end;
   if fkt=timer_clear_line1 then begin hide_line(1);end;
   if fkt=timer_clear_line2 then begin hide_line(2);end;
   if fkt=timer_clear_line3 then begin hide_line(3);end;
   if fkt=timer_show_anz then show_track_anz(1);
   if fkt=timer_show_time then show_track_times(1);
   if fkt=timer_show_mod_infos then mp_show_mod_infos;
  end
 else
  begin
   fkt:=player.timer_fkt2;player.timer_fkt2:=timer_nothing;
   if fkt=timer_reset_num then begin put_text_f1(10,10);player.direct_value:=$aa;end;
   if fkt=timer_clear_line0 then begin hide_line(0);end;
   if fkt=timer_clear_line1 then begin hide_line(1);end;
   if fkt=timer_clear_line2 then begin hide_line(2);end;
   if fkt=timer_clear_line3 then begin hide_line(3);end;
   if fkt=timer_show_mod_infos then mp_show_mod_infos;
  end;
end;
procedure init_timer_function(timer:byte;length:word;fkt:byte);
begin
 if timer=1 then
  begin
   if cd_rom.user_timer1_on then control_timer_function(1);
   player.timer_fkt1:=fkt;cd_start_user_timer(1,length);end
 else
  begin
   if cd_rom.user_timer2_on then control_timer_function(2);
   player.timer_fkt2:=fkt;cd_start_user_timer(2,length);end;
end;


procedure cd_sync_player_controller;
var str:string;
begin
 if (setup_cfg.player_used=2)and(player.player_stb>0) then
  begin
   if (player.player_stb=player_playing)or(player.player_stb=player_paused) then
    begin
     if not(cd_rom.timer_request) then show_time_chg else player_kernel_timer;
    end
   else
   if (player.player_stb>0)and(player.player_stb<>player_drive_open) then if player.length_on=false then show_track_length;
   if cd_rom.cd_changed then
    begin
     cd_rom.door_closed:=false;control_cd(6);
     cd_rom.cd_changed:=false;
     show_player_config_all;show_tracks_all;show_track_length;
     showavail(player_stopped);show_track_anz(1);
    end;
   if cd_rom.title_changed then
    begin
     show_time_chg;cd_rom.title_changed:=false;
     if not(cd_is_playing) then
      begin command_kernel(cmd_stop);cd_rom.player.index:=1;cd_rom.shufflelist.index:=1;show_tracks_all;showavail(1);
         show_track_anz(1);end
     else
      begin cd_rom.title_changed:=false;hide_res_track;show_tracks_all;res_akt_track;show_track_length_1;end;
     if player.player_stb>0 then
      if not(cd_is_playing) then
       begin
        if player.length_on then player.length_on:=false;show_track_length;
       end;
    end;
  end;
 {
 else if (setup_cfg.player_used=1)and(player.player_stb>0) then
  begin
   mp_sync_player_controller;
  end;}
 if cd_get_user_timer(1)=true then control_timer_function(1);
 if cd_get_user_timer(2)=true then control_timer_function(2);
end;

procedure dotti(p,q,f:byte);
var m:byte;
begin
 m:=mouseset;if m>0 then clearmouse;
 moveaktwin(0);
 mem[$a000:(2+(q*4))*640+10+(p*4)]:=f;
 mem[$a000:(2+(q*4))*640+11+(p*4)]:=f;
 mem[$a000:(3+(q*4))*640+10+(p*4)]:=f;
 mem[$a000:(3+(q*4))*640+11+(p*4)]:=f;
 if m>0 then plotmouse;
end;
procedure control_cd(but:word);
var altindex,value:byte;
begin
 if (but and $ff)=0 then if player.player_stb>0 then
  begin
   if (but shr 8)=0 then command_kernel(cmd_vol_up) else
    command_kernel(cmd_vol_down);
  end;
 but:=but and $ff;
 if but=255 then if player.player_stb=0 then cd_power_on else cd_power_off(1);
 if but=1 then if player.player_stb>0 then
    begin
     if cd_is_playing then
      begin command_kernel(cmd_stop);cd_rom.player.index:=1;cd_rom.shufflelist.index:=1;show_tracks_all;showavail(1);
         show_track_anz(1);end
     else
      begin
       if cd_rom.program_on then
        begin
         cd_create_playlist_program;
         if cd_rom.shuffle_on then cd_create_playlist_shuffle;
         hide_tracks_all;show_all_posbuts;
         if player.timer_fkt1=timer_show_anz then show_track_times(0);
         if player.timer_fkt1=timer_show_time then show_track_anz(0);
        end;
      end;
    end;
 if but=2 then if player.player_stb>0 then
    begin
     if cd_rom.tracks_avail then
      begin
       if cd_rom.shuffle_on and not(cd_is_playing)then cd_create_playlist_shuffle;
       cd_rom.cmd_ok:=false;command_kernel(cmd_play);
      end else cd_rom.cmd_ok:=false;
     if cd_rom.cmd_ok then
      begin
       dotti(1,0,15);
       show_akt_track;dotti(2,0,15);
       res_akt_track;dotti(3,0,15);
       showavail(3);dotti(4,0,15);
       show_time_imm;dotti(5,0,15);
       show_track_length_1;dotti(6,0,15);
      end;
    end;
 if but=3 then if (player.player_stb=player_playing)or(player.player_stb=player_paused) then
    begin
     if cd_rom.pausestatus=false then
      begin command_kernel(cmd_pause);showavail(4); end
     else
      begin command_kernel(cmd_resume);showavail(3);end;
    end;
 if but=4 then if player.player_stb>0 then
    begin
     if cd_rom.shuffle_on then exit;
     command_kernel(cmd_prev);show_tracks_all;res_akt_track;
     if cd_is_playing then show_track_length_1;
     if player.player_stb=player_stopped then begin player.length_on:=false;show_track_length;end;
     if cd_rom.pausestatus then showavail(3);
    end;
 if but=5 then if player.player_stb>0 then
    begin
     if (player.player_stb=player_stopped) and cd_rom.shuffle_on then exit;
     res_akt_track;command_kernel(cmd_next);hide_res_track;res_akt_track;show_tracks_all;
     if cd_is_playing then show_track_length_1;
     if player.player_stb=player_stopped then begin player.length_on:=false;show_track_length;end;
     if cd_rom.pausestatus then showavail(3);
    end;
 if but=6 then if player.player_stb>0 then
  begin
   if cd_rom.door_closed then
     begin showavail(player_drive_open);command_kernel(cmd_drive_open);hide_line(3);
      if cd_rom.program_on=false then hide_tracks_all else begin
       cd_rom.program_on:=false;hide_tracks_all;cd_rom.program_on:=true;end;
      show_insert_cd;cd_stop_user_timer(1);hide_line(1);end
    else
     begin hide_player_config_all;
      command_kernel(cmd_drive_close);cd_control_player_imm;
      if not(cd_rom.cd_in_drive) then show_insert_cd;
     end;
  end;
 if but=7 then if player.player_stb>0 then
  begin
   hide_player_config_one(0);
   with cd_rom do
    begin
     if introscan_on=false then begin introscan_on:=true;introscan_art:=0;end
     else
      begin
       if introscan_art=0 then introscan_art:=1 else introscan_on:=false;
      end;
    end;
   show_player_config_one(0);
  end;
 if but=8 then if player.player_stb>0 then
  begin
   hide_player_config_one(1);
   with cd_rom do
    begin
     if repeat_mode=0 then begin repeat_mode:=1;end else
     if repeat_mode=1 then begin repeat_mode:=2;end else
     if repeat_mode=2 then begin repeat_mode:=0;end
    end;
   show_player_config_one(1);
  end;
 if but=9 then if player.player_stb=1 then
  begin
   if cd_rom.program_on then
    begin
     hide_player_config_one(2);hide_tracks_all;
     cd_rom.program_on:=false;cd_create_playlist_play;
     if cd_rom.shuffle_on then cd_create_playlist_shuffle;
     show_player_config_one(2);show_tracks_all;show_track_length;
     if player.timer_fkt1=timer_show_anz then show_track_times(0);
     if player.timer_fkt1=timer_show_time then show_track_anz(0);
    end
   else
    begin
     hide_player_config_one(2);hide_tracks_all;
     cd_rom.program_on:=true;cd_create_playlist_program;
     if cd_rom.shuffle_on then cd_create_playlist_shuffle;
     show_player_config_one(2);show_all_posbuts;show_track_length;
     if player.timer_fkt1=timer_show_anz then show_track_times(0);
     if player.timer_fkt1=timer_show_time then show_track_anz(0);
    end;
  end;
 if but=10 then if player.player_stb>0 then
  begin
   if cd_is_playing then control_cd(1);
   hide_player_config_one(3);
   with cd_rom do
    begin
     if shuffle_on=false then begin shuffle_on:=true;end
      else begin shuffle_on:=false;end;
    end;
   show_player_config_one(3);
   if cd_rom.program_on=false then show_tracks_all;
   show_track_length;showavail(1);
  end;
 if (but>=21) and (but<41)then
  begin
   value:=but-20;
   if player.direct_avail then
    if (player.direct_value shr 4)<$a then
     if but-20<11 then
      begin
       if but-20<10 then
        player.direct_value:=(player.direct_value and $f0)+(but-20)
       else player.direct_value:=(player.direct_value and $f0);
       value:=(player.direct_value shr 4)*10+(player.direct_value and $0f);
       put_text_f1(player.direct_value shr 4,player.direct_value and $0f);
       init_timer_function(2,30,timer_reset_num);
       player.direct_value:=$aa;
      end;
   if player.player_stb>=player_stopped then
    begin
     if (cd_rom.shuffle_on=false)and(cd_rom.program_on=false)then
      if cd_rom.tracks[value].audio then
       begin
        altindex:=cd_rom.player.index;
        command_kernel(cmd_stop);cd_rom.player.index:=value;control_cd(2);
        if (cd_rom.player.index>20)and(altindex<20) then begin for i:=altindex to 20 do hide_track(i);show_akt_track;end
         else begin
          if altindex>cd_rom.player.index then
           begin for i:=cd_rom.player.index to altindex do show_track(i);show_akt_track;end;
          if altindex<cd_rom.player.index then
           begin for i:=altindex to cd_rom.player.index do hide_track(i);show_akt_track;end;
          if altindex=cd_rom.player.index then
           begin show_akt_track;end;
         end;
       end;
     if (cd_rom.program_on=true)then
      begin
       if cd_rom.tracks[value].audio then
        begin
         cd_create_playlist_program_add(value);
         if cd_rom.shuffle_on then cd_create_playlist_shuffle;
         show_track(value);
         if player.timer_fkt1=timer_show_anz then show_track_times(0);
         if player.timer_fkt1=timer_show_time then show_track_anz(0);
        end;
      end;
    end;
  end;
 if but=41 then if (player.player_stb>0)and(player.direct_avail) then
  begin
   if (player.direct_value shr 4)<(cd_rom.lasttrack div 10) then
    begin
     inc(player.direct_value,16);
     cd_rom.user_timer2_on:=false;init_timer_function(2,50,timer_reset_num);
     put_text_f1(player.direct_value shr 4,player.direct_value and $0f);
    end
   else if (player.direct_value shr 4)=(cd_rom.lasttrack div 10) then
    begin
     player.direct_value:=$aa;
     cd_rom.user_timer2_on:=false;init_timer_function(2,50,timer_reset_num);
     put_text_f1(player.direct_value shr 4,player.direct_value and $0f);
    end
   else
    begin
     player.direct_value:=$2a;
     init_timer_function(2,50,timer_reset_num);
     put_text_f1(player.direct_value shr 4,player.direct_value and $0f);
    end;
  end;
end;
{ende cd-routs}

{beginn mp-routs}
procedure myown_savemidasconfig;forward;
procedure setdta(po:pointer);
begin
 regs.ah:=$1a;regs.ds:=seg(po^);regs.dx:=ofs(po^);intr($21,regs);
end;
function my_findfirst(name:string;attrib:word):boolean;
begin
 name:=name+#0;
 regs.ah:=$4e;
 regs.cx:=attrib;
 regs.ds:=seg(name[1]);
 regs.dx:=ofs(name[1]);
 intr($21,regs);
 my_findfirst:=((regs.flags and 1)=0);
end;
function my_findnext:boolean;
begin
 regs.ah:=$4f;
 intr($21,regs);
 my_findnext:=((regs.flags and 1)=0);
end;

function get_akt_drive:string;
begin
 regs.ax:=$1900;intr($21,regs);
 get_akt_drive:=chr(regs.al+ord('A'))+':\';
end;

function get_akt_path:string;
var locpath:string;aktpath:array[0..300]of char;i:word;
begin
 locpath:=get_akt_drive;
 regs.ax:=$4700;regs.dl:=0;regs.ds:=seg(aktpath[0]);regs.si:=ofs(aktpath[0]);intr($21,regs);
 i:=0;while aktpath[i]>#0 do begin locpath:=locpath+aktpath[i];inc(i);end;
 get_akt_path:=locpath;
end;
function check_path(path:string):boolean;
var oldpath:string;
begin
 oldpath:=get_akt_path;oldpath:=oldpath+#0;
 path:=path+#0;
 regs.ah:=$3b;regs.ds:=seg(path[1]);regs.dx:=ofs(path[1]);intr($21,regs);
 if (regs.flags and fcarry)=0 then check_path:=true else check_path:=false;
 regs.ah:=$3b;regs.ds:=seg(oldpath[1]);regs.dx:=ofs(oldpath[1]);intr($21,regs);
end;
function get_higher_path(s:string):string;
var co:word;
begin
 co:=length(s);if co=3 then begin get_higher_path:=s;exit;end;
 while s[co]<>'\' do dec(co);
 get_higher_path:=copy(s,1,co-1);
end;

procedure change_akt_path(path:string;po:pointer);
var aktpath:^string;
begin
 aktpath:=po;
 if path='..'then begin aktpath^:=get_higher_path(aktpath^);end
 else if (path[1]='[')and(path[6]=']') then begin aktpath^:=path[3]+':';end
 else begin aktpath^:=aktpath^+'\'+path;end;
end;

procedure mp_get_dir_info;
type dta_type=record
       leer:array[0..20]of byte;
       attrib:byte;
       lastmod_time:word;
       lastmod_date:word;
       filesize:longint;
       name:array[0..12]of byte;
      end;
var tstname,dum:string;my_dta:dta_type;co:byte;str:string;i,j:byte;
begin
 setdta(addr(my_dta));
 for i:=1 to 255 do player.dir_info.name[i]:='';player.dir_info.anz:=0;player.dir_info.list_start:=1;
 str:=player.mod_dir+'\*.*';
 if my_findfirst(str,$3f) then
  begin
   if (my_dta.attrib and $10)=$10 then
    begin
     tstname:='';co:=0;
     repeat if my_dta.name[co]>0 then tstname:=tstname+chr(my_dta.name[co]);inc(co);until my_dta.name[co]=0;
     if tstname<>'.' then
      begin
       player.dir_info.name[player.dir_info.anz+1]:=copy(tstname,1,length(tstname));
       inc(player.dir_info.anz);
      end;
    end;
   while (my_findnext)and(player.dir_info.anz<255) do
    begin
     if (my_dta.attrib and $10)=$10 then
      begin
       tstname:='';co:=0;
       repeat if my_dta.name[co]>0 then tstname:=tstname+chr(my_dta.name[co]);inc(co);until my_dta.name[co]=0;
       if tstname<>'.' then
        begin
         player.dir_info.name[player.dir_info.anz+1]:=copy(tstname,1,length(tstname));
         inc(player.dir_info.anz);
        end;
      end;
    end;
  end;
 for i:=3 to 26 do
  begin
   regs.ah:=$47;regs.dl:=i;regs.ds:=seg(tstname[1]);regs.si:=ofs(tstname[1]);intr($21,regs);
   if (regs.flags and fcarry)=0 then
    begin
     tstname:='[ '+chr(i-1+ord('A'))+': ]';
     player.dir_info.name[player.dir_info.anz+1]:=copy(tstname,1,length(tstname));
     inc(player.dir_info.anz);
    end;
  end;
 for i:=1 to player.dir_info.anz-1 do
  for j:=i+1 to player.dir_info.anz do
   if player.dir_info.name[i]>player.dir_info.name[j] then
    begin
     dum:=player.dir_info.name[i];
     player.dir_info.name[i]:=player.dir_info.name[j];
     player.dir_info.name[j]:=dum;
    end;
end;

function mp_getmodname(name:string):string;
var attr,handle:word;locstr:string;tststr:array[0..23]of byte;co:byte;f:text;
begin
 assign(f,player.mod_dir+'\'+name+'.mod');
 getfattr(f,attr);if (attr and readonly)=readonly then setfattr(f,archive);
 handle:=openfile(player.mod_dir+'\'+name+'.mod');
 seekfile(handle,0,0);
 readfile(handle,24,addr(tststr[0]));
 closefile(handle);
 co:=0;locstr:='';
 repeat
  if tststr[co]<>0 then locstr:=locstr+chr(tststr[co]);
  inc(co);
 until (co=24)or(tststr[co-1]=0);
 mp_getmodname:=locstr;
 if (attr and readonly)=readonly then setfattr(f,attr);
end;
function mp_getvirtmodname(name:string):string;
var handle:word;locstr:string;tststr:array[0..23]of byte;co:byte;
begin
 v_openfile(name+'.mod');
 v_seekfile(0);
 v_readfile(24,addr(tststr[0]));
 v_closefile;
 co:=0;locstr:='';
 repeat
  if tststr[co]<>0 then locstr:=locstr+chr(tststr[co]);
  inc(co);
 until (co=24)or(tststr[co-1]=0);
 mp_getvirtmodname:=locstr;
end;

procedure mp_track_infos;
type dta_type=record
       leer:array[0..20]of byte;
       atrib:byte;
       lastmod_time:word;
       lastmod_date:word;
       filesize:longint;
       name:array[0..12]of byte;
      end;
var tstname:string;my_dta:dta_type;co,i,j:byte;path,dum1,dum2:string;
begin
 for i:=2 to 99 do begin player.modlist.track[i]:=$ff;player.modlist.trackname[i]:='';player.modlist.trackdesc[i]:='';end;
 player.modlist.anz:=1;
 player.modlist.index:=1;
 player.modlist.trackdesc[1]:=mp_getvirtmodname(player.modlist.trackname[1]);
 player.modlist.list_start:=1;
 setdta(addr(my_dta));
 path:=player.mod_dir+'\*.mod';
 if my_findfirst(path,archive) then
  begin
   player.modlist.track[player.modlist.anz+1]:=1;
   tstname:='';co:=0;
   repeat if my_dta.name[co]>0 then tstname:=tstname+chr(my_dta.name[co]);inc(co);until my_dta.name[co]=0;
   player.modlist.trackname[player.modlist.anz+1]:=copy(tstname,1,length(tstname)-4);
   player.modlist.trackdesc[player.modlist.anz+1]:=mp_getmodname(player.modlist.trackname[player.modlist.anz+1]);
   inc(player.modlist.anz);
   while (my_findnext)and(player.modlist.anz<99) do
    begin
     player.modlist.track[player.modlist.anz+1]:=1;
     tstname:='';co:=0;
     repeat if my_dta.name[co]>0 then tstname:=tstname+chr(my_dta.name[co]);inc(co);until my_dta.name[co]=0;
     player.modlist.trackname[player.modlist.anz+1]:=copy(tstname,1,length(tstname)-4);
     player.modlist.trackdesc[player.modlist.anz+1]:=mp_getmodname(player.modlist.trackname[player.modlist.anz+1]);
     inc(player.modlist.anz);
    end;
  end;
 if player.modlist.anz>20 then player.direct_avail:=true else player.direct_avail:=false;
 if player.modlist.anz>2 then
  for i:=2 to player.modlist.anz-1 do
   for j:=i+1 to player.modlist.anz do
    begin
     if player.modlist.trackname[i]>player.modlist.trackname[j] then
      begin
       dum1:=player.modlist.trackname[i];
       dum2:=player.modlist.trackdesc[i];
       player.modlist.trackname[i]:=player.modlist.trackname[j];
       player.modlist.trackdesc[i]:=player.modlist.trackdesc[j];
       player.modlist.trackname[j]:=dum1;
       player.modlist.trackdesc[j]:=dum2;
      end;
    end;
  for i:=1 to player.modlist.anz do if player.modlist.trackname[i]=save_info.module.mod_select then player.modlist.index:=i;
end;
procedure mp_show_tracks_all;
var i,dum:byte;
begin
 for i:=1 to 20 do
  begin
   if player.modlist.track[i]<$ff then show_track(i);
  end;
 dum:=$ff;
 for i:=21 to 99 do
  begin
   if player.modlist.track[i]<$ff then dum:=0;
  end;
 if dum=0 then show_track(255);
end;
procedure mp_show_tracks_diff;
var i,dum,m:byte;
begin
 m:=mouseset;if m>0 then clearmouse;
 for i:=1 to 20 do
  begin
   if player.modlist.track[i]<$ff then if not(button_status(i+20,1)) then show_track(i);
   if player.modlist.track[i]=$ff then if not(button_status(i+20,0)) then hide_track(i);
  end;
 dum:=$ff;
 for i:=21 to 99 do
  begin
   if player.modlist.track[i]<$ff then dum:=0;
  end;
 if dum=0  then if not(button_status(41,1)) then show_track(255);
 if dum=$ff then if not(button_status(41,0)) then hide_track(255);
 if m>0 then plotmouse;
end;
procedure mp_hide_tracks_all;
var i,dum:byte;
begin
 for i:=1 to 20 do
  begin
   if player.modlist.track[i]<$ff then hide_track(i);
  end;
 hide_track(255);
end;
function lengthen_string(text:string;le:byte):string;
var locstr:string;
begin
 if le=length(text) then begin lengthen_string:=text;exit;end;
 if le>length(text) then
  begin
   locstr:=text;while length(locstr)<le do locstr:=locstr+' ';lengthen_string:=locstr;exit;
  end;
 if le<length(text) then
  begin
   locstr:=copy(text,1,le);lengthen_string:=locstr;exit;
  end;
end;
function search4char(s:string;char,anz:byte):byte;
var c,l:byte;
begin
 c:=0;l:=1;
 repeat
  if ord(s[l])=char then inc(c);
  inc(l);
 until (c=anz);
 search4char:=l-1;
end;
function bsearch4char(s:string;char,anz:byte):byte;
var c,l:byte;
begin
 c:=0;l:=length(s);
 repeat
  if ord(s[l])=char then inc(c);
  dec(l);
 until (c=anz);
 bsearch4char:=l+1;
end;

procedure mp_show_akt_path;
var str,str2:string;m,anz,anzc,oldanz:byte;
begin
 m:=mouseset;if m>0 then clearmouse;
 str:=player.mod_dir+'\';
 if length(str)>50 then
  begin
   str2:=copy(str,1,search4char(str,ord('\'),2));
   str2:=str2+'...';
   anz:=0;anzc:=2;
   while length(str2)+anz<=50 do
    begin
     oldanz:=anz;
     anz:=length(str)-bsearch4char(str,ord('\'),anzc)+1;
     inc(anzc);
    end;
   anz:=oldanz;
   str2:=str2+copy(str,length(str)-anz+1,anz);
  end
 else str2:=str;
 putstring_bkg(324,350,lengthen_string(str2,50),31,0,1);
 if m>0 then plotmouse;
end;
procedure mp_show_dir_info(mo:byte);
var i,m:byte;
begin
 if mo=1 then begin m:=mouseset;if m>0 then clearmouse;end;
 if player.dir_info.anz<=6 then player.dir_info.list_start:=1;
 for i:=player.dir_info.list_start to player.dir_info.list_start+5 do
  begin
   if i<=player.dir_info.anz then
    begin
     putstring_bkg(328,294+((i-player.dir_info.list_start)*9),lengthen_string(player.dir_info.name[i],12),24,0,1);
    end
   else
    begin
     putstring_bkg(328,294+((i-player.dir_info.list_start)*9),lengthen_string(' ',12),24,0,1);
    end;
  end;
 if mo=1 then begin if m>0 then plotmouse;end;
end;

procedure mp_show_mod_info(mo:byte);
var i,m:byte;s:string;
begin
 if mo=1 then begin m:=mouseset;if m>0 then clearmouse;end;
 if player.modlist.anz<=6 then player.modlist.list_start:=1;
 for i:=player.modlist.list_start to player.modlist.list_start+5 do
  begin
   if i<=player.modlist.anz then
    begin
     str(i:2,s);
     s:=s+'.'+lengthen_string(player.modlist.trackname[i],8)+' :'+lengthen_string(player.modlist.trackdesc[i],18);
     putstring_bkg(418,294+((i-player.modlist.list_start)*9),s,24,0,1);
    end
   else
    begin
     putstring_bkg(418,294+((i-player.modlist.list_start)*9),lengthen_string(' ',31),24,0,1);
    end;
  end;
 if mo=1 then begin if m>0 then plotmouse;end;
end;

procedure mp_extrude_mod(name:string);
var newhandle:word;po:emshandle;size:longint;segm:word;stri:string;
begin
 stri:=name+'.mod';
 po:=emsalloc(4);emssavemap(po);emsmap4(po,0,1,2,3);
 v_openfile(stri);size:=filegroesse;segm:=emsframeseg;
 newhandle:=createfile(stri);
 repeat
   if size>65530 then begin v_readfile(65530,ptr(segm,0));writefile(newhandle,65530,ptr(segm,0));dec(size,65530);end
   else begin v_readfile(size,ptr(segm,0));writefile(newhandle,size,ptr(segm,0));dec(size,size);end;
 until size=0;
 v_closefile;
 closefile(newhandle);
end;
procedure mp_delete_mod(name:string);
var str:string;
begin
 str:=name+'.mod';
 deletefile(str);
end;
procedure mp_show_mod_infos;
var str,str2:string;modname:string[13];
begin
 modname:=player.modlist.trackname[player.modlist.index];
 str:='** Aktuelles Mod :  '+var2str(player.modlist.index,2,2)+' **';
 put_text_f2(0,0, str);
 str:='Filename:            .MOD';
 move(modname[1],str[14],length(modname));
 put_text_f2(1,0,str);
 put_text_f2(2,0,'     ** MOD-INFO: **     ');
 str2:='                        ';
 str:=player.modlist.trackdesc[player.modlist.index];
 move(str[1],str2[(26-length(str))div 2+1],length(str));
 put_text_f2(3,0,str2);
end;
procedure mp_arrange_timer(oldcl,newcl:word);
begin
 if cd_rom.user_timer1_on then
  begin
   if newcl>oldcl then cd_rom.user_timer1:=longint(cd_rom.user_timer1*(newcl div oldcl)+1);
   if newcl<oldcl then cd_rom.user_timer1:=longint(cd_rom.user_timer1 div (oldcl div newcl)+1);
  end;
 if cd_rom.user_timer2_on then
  begin
   if newcl>oldcl then cd_rom.user_timer2:=longint(cd_rom.user_timer2*(newcl div oldcl)+1);
   if newcl<oldcl then cd_rom.user_timer2:=longint(cd_rom.user_timer2 div (oldcl div newcl)+1);
  end;
end;
procedure mp_loadmod(name:string);
var f:text;attr:word;loadname:array[0..255]of char;
begin
 fillchar(loadname,255,0);
 move(name[1],loadname,length(name));
 assign(f,name);getfattr(f,attr);
 if (attr and readonly)=readonly then setfattr(f,archive);
 player.module:=midasloadmodule(loadname,@mpMOD,NIL);
 if (attr and readonly)=readonly then setfattr(f,attr);
end;
function cutten_string(s:string):string;
var i:byte;
begin
 i:=1;
 while ord(s[i])<>0 do inc(i);
 cutten_string:=copy(s,1,i-1);
end;

function mp_analyze_error(error:string):byte;
begin
 error:=cutten_string(error);
 if error='MIDAS Error: Out of conventional memory' then begin mp_analyze_error:=0;exit;end;
 if error='MIDAS Error: Invalid module file' then        begin mp_analyze_error:=1;exit;end;
 if error='MIDAS Error: Out of EMS memory' then          begin mp_analyze_error:=2;exit;end;
 mp_analyze_error:=$ff;
end;


procedure mp_startmodule;
var modname,name,s:string;
begin
 modname:=player.modlist.trackname[player.modlist.index];
 if player.modlist.track[player.modlist.index]=0 then mp_extrude_mod(modname);
 if player.modlist.track[player.modlist.index]=$ff then exit;
 if player.timer_fkt2=timer_clear_line0 then control_timer_function(2);

 name:=modname+'.MOD';if player.modlist.track[player.modlist.index]=1 then name:=player.mod_dir+'\'+name;

 myown_deinit;myown_init;
 mp_loadmod(name);

 if length(midas_error_text)>0 then
  begin
   put_text_f2(0,0,lengthen_string('ACHTUNG! LADEHEMMUNG!',25));
   if mp_analyze_error(midas_error_text)=0 then put_text_f2(1,0,lengthen_string('Modul zu gross!',25));
   if mp_analyze_error(midas_error_text)=1 then put_text_f2(1,0,lengthen_string('Falsches MOD-Format',25));
   if mp_analyze_error(midas_error_text)=2 then put_text_f2(1,0,lengthen_string('Zu wenig EMS-Speicher!',25));
   if mp_analyze_error(midas_error_text)=$ff then put_text_f2(1,0,lengthen_string('Allgem. Ladefehler',25));
   hide_line(2);hide_line(3);
   midasclose;midasinit;
   if player.modlist.index<21 then show_track(player.modlist.index) else show_track(255);
  end
 else
  begin
   mp_show_mod_infos;
   player.modlist.akttrack:=player.modlist.track[player.modlist.index];
   player.modlist.akttrackname:=player.modlist.trackname[player.modlist.index];
   player.play_dir:=player.mod_dir;
   showavail(player_mp_playing);
   midasplaymodule(player.module,0);
   {mp_arrange_timer(18,setup_cfg.soundcard.rate);}
   player.player_stb:=player_mp_playing;
  end;
 if player.modlist.track[player.modlist.index]=0 then mp_delete_mod(modname);
end;
procedure mp_stopmodule;
begin
 if player.player_stb<>player_mp_playing then exit;
 midasstopmodule(player.module);
 {mp_arrange_timer(setup_cfg.soundcard.rate,18);}
 midasfreemodule(player.module);
 myown_deinit;myown_init;
 player.player_stb:=player_mp_stopped;
 showavail(player_mp_stopped);
 player.play_dir:=player.mod_dir;
 player.modlist.akttrack:=0;player.modlist.akttrackname:='2010';
end;
procedure add_2_pixel(po:pointer;anz:word;dif:byte);assembler;
asm
 push es
 les di,po
 mov cx,anz
 mov bl,dif
 @jumpin:
  mov al,es:[di]
  add al,bl
  mov es:[di],al
  inc di
 loop @jumpin
 pop es
end;
procedure sub_2_pixel(po:pointer;anz:word;dif:byte);assembler;
asm
 push es
 les di,po
 mov cx,anz
 mov bl,dif
 @jumpin:
  mov al,es:[di]
  sub al,bl
  mov es:[di],al
  inc di
 loop @jumpin
 pop es
end;

procedure show_dir_field;
var y,x,segm:word;buffer:array[0..639]of byte;m:byte;lochandle:emshandle;
begin
 m:=mouseset;clearmouse;
 moveaktwin(2);
 for y:=269 to 306 do
  begin vgetvirtblock(309,y,323,seg(buffer),ofs(buffer));add_2_pixel(addr(buffer),323,64);
        vputvirtblock(309,y,323,seg(buffer),ofs(buffer));end;
 moveaktwin(3);
 for y:=307 to 369 do
  begin vgetvirtblock(309,y,323,seg(buffer),ofs(buffer));add_2_pixel(addr(buffer),323,64);
        vputvirtblock(309,y,323,seg(buffer),ofs(buffer));end;

 player.dir_field_handle:=emsalloc(4);emsmap4(player.dir_field_handle,0,1,2,3);
 moveaktwin(2);
 segm:=emsframeseg;
 for y:=269 to 306 do vgetvirtblock(0,y,640,segm,(y-269)*640);
 vgetvirtblock(0,307,128,segm,(38)*640);moveaktwin(3);vgetvirtblock(128,307,512,segm,(38)*640+128);
 for y:=308 to 369 do vgetvirtblock(0,y,640,segm,(y-269)*640);

 init_fadeto(192,255,40,40,40);fade_to_all(ofs(zielpal),2);

 lochandle:=emsalloc(4);emsmap4(lochandle,0,1,2,3);segm:=emsframeseg;
 v_openfile('setupdat.new');v_seekfile(83968);v_readfile(65040,ptr(segm,0));v_closefile;

 moveaktwin(2);
 for y:=269 to 306 do begin vputvirtblock(309,y,323,segm,(y-269)*640+316);end;
 moveaktwin(3);
 for y:=307 to 347 do begin vputvirtblock(309,y,323,segm,(y-269)*640+316);end;
 for y:=348 to 369 do begin vputvirtblock(309,y,323,segm,(y-269)*640+316);end;
 emsdealloc(lochandle);

 putstring_bkg(328,282,'VERZEICHNIS:',31,0,1);
 putstring_bkg(423,282,'MODULE IM VERZEICHNIS:',31,0,1);
 mp_show_akt_path;
 mp_get_dir_info;
 mp_show_dir_info(1);mp_show_mod_info(1);
 if m>0 then plotmouse;
end;

procedure del_dir_field;
var y,x,segm:word;buffer:array[0..639]of byte;m:byte;
begin
 m:=mouseset;clearmouse;
 emsmap4(player.dir_field_handle,0,1,2,3);
 moveaktwin(2);
 segm:=emsframeseg;
 for y:=269 to 306 do vputvirtblock(0,y,640,segm,(y-269)*640);
 vputvirtblock(0,307,128,segm,(38)*640);
 moveaktwin(3);
 vputvirtblock(128,307,512,segm,(38)*640+128);
 for y:=308 to 369 do vputvirtblock(0,y,640,segm,(y-269)*640);
 emsdealloc(player.dir_field_handle);

 move(storepal,zielpal,sizeof(storepal));fade_to_all(ofs(zielpal),2);

 moveaktwin(2);
 for y:=269 to 306 do
  begin vgetvirtblock(309,y,323,seg(buffer),ofs(buffer));sub_2_pixel(addr(buffer),323,64);
        vputvirtblock(309,y,323,seg(buffer),ofs(buffer));end;
 moveaktwin(3);
 for y:=307 to 369 do
  begin vgetvirtblock(309,y,323,seg(buffer),ofs(buffer));sub_2_pixel(addr(buffer),323,64);
        vputvirtblock(309,y,323,seg(buffer),ofs(buffer));end;
 if m>0 then plotmouse;
end;

procedure mp_power_on;
var str:string;
begin
 secmousepos;
 control_timer_function(1);
 control_timer_function(2);
 {player.mod_dir:=get_akt_path;}
 mp_track_infos;
 show_dir_field;
 midassetdefaults;
 myown_savemidasconfig;
 myown_init;
 vbl;showavail(player_mp_stopped);mp_show_tracks_all;
 player.player_stb:=player_mp_stopped;

 put_text_f2(0,1,'Power: ON   MODE: MOD');
 init_timer_function(2,100,timer_show_mod_infos);
 asm
  mov ax,7
  mov cx,0
  mov dx,628
  int $33
  mov ax,8
  mov cx,261
  mov dx,468
  int $33
 end;
 mouse_setpos(320,410);
end;
procedure mp_power_off;
begin
 save_all_infos;
 control_timer_function(1);control_timer_function(2);
 all_deinit_timer_kernel;
 if player.player_stb=player_mp_playing then mp_stopmodule;myown_deinit;
 vbl;showavail(0);
 hide_line(0);hide_line(1);hide_line(2);hide_line(3);mp_hide_tracks_all;put_text_f1($a,$a);
 player.player_stb:=player_power_off;
 asm
  mov ax,7
  mov cx,0
  mov dx,628
  int $33
  mov ax,8
  mov cx,0
  mov dx,468
  int $33
 end;
 if mouseset>0 then clearmouse;
 resmousepos;
 del_dir_field;
end;
procedure mp_vol_up;
type getvol_type=function(masterVolume : pointer) : integer;
     setvol_type=function(masterVolume : byte) : integer;
var getvol_fkt:^getvol_type;
    setvol_fkt:^setvol_type;
    po:pointer;vol:byte;erg:integer;wvol:word;
begin
 po:=addr(vol);
 if setup_cfg.soundcard.card=0 then
  begin
   getvol_fkt:=gus_sd^.getmvolptr;asm les di,po;push es;push di;call getvol_fkt;pop erg;end;
   wvol:=vol;if wvol<64 then inc(wvol) else exit;
   setvol_fkt:=gus_sd^.setmvolptr;asm push wvol;call setvol_fkt;pop erg;end;
   vbl;
  end
 else if setup_cfg.soundcard.card<4 then
  begin
   getvol_fkt:=sb_sd^.getmvolptr;asm les di,po;push es;push di;call getvol_fkt;pop erg;end;
   wvol:=vol;if wvol<64 then inc(wvol) else exit;
   setvol_fkt:=sb_sd^.setmvolptr;asm push wvol;call setvol_fkt;pop erg;end;
   vbl;
  end;
end;
procedure mp_vol_down;
type getvol_type=function(masterVolume : pointer) : integer;
     setvol_type=function(masterVolume : byte) : integer;
var getvol_fkt:^getvol_type;
    setvol_fkt:^setvol_type;
    po:pointer;vol:byte;erg:integer;wvol:word;
begin
 po:=addr(vol);
 if setup_cfg.soundcard.card=0 then
  begin
   getvol_fkt:=gus_sd^.getmvolptr;asm les di,po;push es;push di;call getvol_fkt;pop erg;end;
   wvol:=vol;if wvol>10 then dec(wvol) else exit;
   setvol_fkt:=gus_sd^.setmvolptr;asm push wvol;call setvol_fkt;pop erg;end;
   vbl;
  end
 else if setup_cfg.soundcard.card<4 then
  begin
   getvol_fkt:=sb_sd^.getmvolptr;asm les di,po;push es;push di;call getvol_fkt;pop erg;end;
   wvol:=vol;if wvol>10 then dec(wvol) else exit;
   setvol_fkt:=sb_sd^.setmvolptr;asm push wvol;call setvol_fkt;pop erg;end;
   vbl;
  end;
end;

procedure control_mp(but:word);
var dum:word;value:byte;
begin
 if (but and $ff)=0 then if player.player_stb>0 then
  begin
   if (but shr 8)=0 then mp_vol_up else mp_vol_down;
   exit;
  end;
 but:=but and $ff;
 if but=255 then
  begin
   if player.player_stb=player_power_off then mp_power_on else mp_power_off;
  end;
 if but=1 then
  begin
   if player.player_stb=player_power_off then exit;
   if player.player_stb=player_mp_stopped then exit;
   if player.timer_fkt1<>timer_reset_num then player.timer_fkt1:=timer_nothing;
   if player.timer_fkt2<>timer_reset_num then player.timer_fkt2:=timer_nothing;
   if player.player_stb=player_mp_playing then mp_stopmodule;
   mp_show_mod_infos;
   if player.modlist.index<21 then show_track(player.modlist.index) else show_track(255);
  end;
 if but=2 then
  begin
   if player.player_stb=player_power_off then exit;
   if player.timer_fkt1<>timer_reset_num then player.timer_fkt1:=timer_nothing;
   if player.timer_fkt2<>timer_reset_num then player.timer_fkt2:=timer_nothing;
   if player.player_stb=player_mp_playing then mp_stopmodule;
   if player.modlist.index<21 then mark_track(player.modlist.index) else mark_track(255);
   mp_startmodule;
  end;
 if but=3 then begin end;
 if but=4 then
  begin
   if player.player_stb=player_power_off then exit;
   player.timer_fkt1:=timer_nothing;player.timer_fkt2:=timer_nothing;
   if player.modlist.index>1 then
    begin
     dum:=player.player_stb;
     if dum=player_mp_playing then begin control_mp(1);end;
     dec(player.modlist.index);
     if dum=player_mp_playing then begin control_mp(2);end else mp_show_mod_infos;
    end;
  end;
 if but=5 then
  begin
   if player.player_stb=player_power_off then exit;
   player.timer_fkt1:=timer_nothing;player.timer_fkt2:=timer_nothing;
   if player.modlist.index<player.modlist.anz then
    begin
     dum:=player.player_stb;
     if dum=player_mp_playing then
      begin
       if player.player_stb=player_mp_playing then mp_stopmodule;
       if player.modlist.index<21 then show_track(player.modlist.index);
      end;
     inc(player.modlist.index);
     if dum=player_mp_playing then begin control_mp(2);end else mp_show_mod_infos;
    end;
  end;
 if (but>=21) and (but<41)then
  begin
   value:=but-20;
   if player.direct_avail and (player.direct_value<>$aa) then
    if value<=10 then
     begin
      if value=10 then value:=0;value:=((player.direct_value shr 4)*10)+value;
      control_timer_function(1);
      init_timer_function(1,150,timer_reset_num);
      put_text_f1(value div 10,value mod 10);
     end;
   if player.player_stb>=player_mp_stopped then
    begin
     if player.modlist.track[value]<$ff then
      begin
       if (player.direct_value<>$aa)and(value<21) then put_text_f1(10,10);
       control_mp(1);player.modlist.index:=value;control_mp(2);
      end;
    end;
  end;
 if but=41 then if (player.player_stb>0)and(player.direct_avail) then
  begin
   if (player.direct_value shr 4)<(player.modlist.anz div 10) then
    begin
     inc(player.direct_value,16);
     if cd_rom.user_timer1_on then control_timer_function(1);
     init_timer_function(1,150,timer_reset_num);
     put_text_f1(player.direct_value shr 4,player.direct_value and $0f);
    end
   else if (player.direct_value shr 4)=(player.modlist.anz div 10) then
    begin
     player.direct_value:=$aa;
     if cd_rom.user_timer1_on then control_timer_function(1);
     init_timer_function(1,150,timer_reset_num);
     put_text_f1(player.direct_value shr 4,player.direct_value and $0f);
    end
   else
    begin
     player.direct_value:=$2a;
     if cd_rom.user_timer1_on then control_timer_function(1);
     init_timer_function(1,150,timer_reset_num);
     put_text_f1(player.direct_value shr 4,player.direct_value and $0f);
    end;
  end;
 if but=42 then
  begin
   if player.dir_info.list_start>1 then
    begin dec(player.dir_info.list_start);mp_show_dir_info(0);end;
  end;
 if but=43 then
  begin
   if player.dir_info.list_start<player.dir_info.anz then
    begin inc(player.dir_info.list_start);mp_show_dir_info(0);end;
  end;
 if but=44 then
  begin
   if player.modlist.list_start>1 then
    begin dec(player.modlist.list_start);mp_show_mod_info(0);end;
  end;
 if but=45 then
  begin
   if player.modlist.list_start<player.modlist.anz then
    begin inc(player.modlist.list_start);mp_show_mod_info(0);end;
  end;
 if (but>45)and(but<52) then
  begin
   value:=but-46;
   if value+player.dir_info.list_start<=player.dir_info.anz then
    begin
     change_akt_path(player.dir_info.name[value+player.dir_info.list_start],addr(player.mod_dir));
     mp_get_dir_info;mp_show_dir_info(1);
     mp_show_akt_path;mp_track_infos;mp_show_mod_info(1);mp_show_tracks_diff;
    end;
  end;
 if (but>51)and(but<58) then
  begin
   value:=but-52;
   if value+player.modlist.list_start<=player.modlist.anz then
    begin
     control_mp(1);
     player.modlist.index:=value+player.modlist.list_start;
     control_mp(2);
    end;
  end;
end;


{setup-routs}
procedure cutten1(i:byte;po:pointer);
type bu=array[0..6,0..639]of byte;
var pu:^bu;x,y:word;f:byte;
begin
 pu:=po;
 for y:=0 to 6 do for x:=cutx to cutx+4 do
  begin
   f:=pu^[y,x];if f=6 then f:=0;font1[font1idx,x-cutx,y]:=f;
  end;
 inc(cutx,6);font1table[i]:=font1idx;inc(font1idx);
end;
procedure cutten2(i:byte;po:pointer);
type bu=array[0..14,0..639]of byte;
var pu:^bu;x,y:word;f:byte;
begin
 pu:=po;
 for y:=0 to 14 do for x:=cutx to cutx+10 do
  begin
   f:=pu^[y,x];if f=6 then f:=0;font2[font2idx,x-cutx,y]:=f;
  end;
 inc(cutx,11);font2table[i]:=font2idx;inc(font2idx);
end;

procedure initfont1;
var buffer:array[0..6,0..639]of byte;i:byte;
begin
 font1idx:=0;fillchar(font1table,255,26);
 cutx:=6;cuty:=0;
 v_seekfile(15488);v_readfile(4480,addr(buffer));
 for i:=65 to 90 do cutten1(i,addr(buffer));
 cutten1(32,addr(buffer));
 for i:=48 to 57 do cutten1(i,addr(buffer));
 cutten1(45,addr(buffer));cutten1(43,addr(buffer));cutten1(42,addr(buffer));cutten1(47,addr(buffer));cutten1(58,addr(buffer));
 cutten1(92,addr(buffer));cutten1(46,addr(buffer));cutten1(91,addr(buffer));cutten1(93,addr(buffer));
 cutten1(33,addr(buffer));cutten1(95,addr(buffer));cutten1(40,addr(buffer));cutten1(41,addr(buffer));
end;
procedure initfont2;
var buffer:array[0..14,0..639]of byte;i:byte;
begin
 font2idx:=0;fillchar(font2table,255,62);
 cutx:=4;cuty:=0;v_seekfile(25088);v_readfile(9600,addr(buffer));
 for i:=65 to 90 do cutten2(i,addr(buffer));
 for i:=48 to 57 do cutten2(i,addr(buffer));
 cutx:=4;cuty:=0;v_seekfile(35968);v_readfile(9600,addr(buffer));
 for i:=97 to 122 do cutten2(i,addr(buffer));
 cutten2(32,addr(buffer));cutten2(43,addr(buffer));cutten2(45,addr(buffer));
 cutten2(42,addr(buffer));cutten2(47,addr(buffer));cutten2(58,addr(buffer));
end;

procedure putchar_nt(x1,y1:word;i,farbe,font:byte);
var x,y:word;f:byte;
begin
 if font=1 then
  for y:=y1 to y1+6 do for x:=x1 to x1+4 do begin f:=font1[font1table[i],x-x1,y-y1];if f>0 then f:=farbe;vputpixel(x,y,f);end;
 if font=2 then
 for y:=y1 to y1+14 do for x:=x1 to x1+10 do begin f:=font2[font2table[i],x-x1,y-y1];if f>0 then f:=farbe;vputpixel(x,y,f);end;
end;
procedure putchar_ems(x1,y1,w,offs:word;i,farbe:byte);
var x,y:word;f:byte;
begin
 for y:=y1 to y1+6 do
  for x:=x1 to x1+4 do
   begin f:=font1[font1table[i],x-x1,y-y1];if f>0 then f:=farbe;mem[scroll_seg:(y*w)+x+offs]:=f;end;
end;
procedure putchar(x1,y1:word;i,farbe,font:byte);
var x,y:word;f:byte;
begin
 if font=1 then
  for y:=y1 to y1+6 do for x:=x1 to x1+4 do begin f:=font1[font1table[i],x-x1,y-y1];if f>0 then vputpixel(x,y,farbe);end;
 if font=2 then
  for y:=y1 to y1+14 do for x:=x1 to x1+10 do begin f:=font2[font2table[i],x-x1,y-y1];if f>0 then vputpixel(x,y,farbe);end;
end;
procedure putchar_bkg(x1,y1:word;i,farbe,bkgcol,font:byte);
var x,y:word;f:byte;
begin
 if font=1 then
  for y:=y1 to y1+6 do for x:=x1 to x1+4 do begin f:=font1[font1table[i],x-x1,y-y1];if f>0 then vputpixel(x,y,farbe) else
    vputpixel(x,y,bkgcol);end;
 if font=2 then
  for y:=y1 to y1+14 do for x:=x1 to x1+10 do begin f:=font2[font2table[i],x-x1,y-y1];if f>0 then vputpixel(x,y,farbe) else
    vputpixel(x,y,bkgcol);end;
end;
procedure putstring_nt(x1,y1:word;text:string;farbe,font:byte);
var x,y:word;i:byte;
begin
 if font=1 then for i:=1 to length(text) do putchar_nt(x1+((i-1)*6),y1,ord(text[i]),farbe,1);
 if font=2 then for i:=1 to length(text) do putchar_nt(x1+((i-1)*11),y1,ord(text[i]),farbe,2);
end;
procedure clearstring_ems(x1,y1,w,offs:word);
var x,y:word;
begin
 dec(y1);dec(x1);
 for y:=y1 to y1+8 do for x:=x1 to x1+w do mem[scroll_seg:(y*w)+x+offs]:=0;
end;
procedure putstring_ems(x1,y1,w,offs:word;text:string;farbe:byte);
var x,y:word;i:byte;
begin
 for i:=1 to length(text) do putchar_ems(x1+((i-1)*6),y1,w,offs,ord(text[i]),farbe);
end;
procedure putstring(x1,y1:word;text:string;farbe,font:byte);
var x,y:word;i:byte;
begin
 if font=1 then for i:=1 to length(text) do putchar(x1+((i-1)*6),y1,ord(text[i]),farbe,1);
 if font=2 then for i:=1 to length(text) do putchar(x1+((i-1)*11),y1,ord(text[i]),farbe,2);
end;
procedure putstring_bkg(x1,y1:word;text:string;farbe,bkgcol,font:byte);
var x,y:word;i:byte;
begin
 if font=1 then for i:=1 to length(text) do putchar_bkg(x1+((i-1)*6),y1,ord(upcase(text[i])),farbe,bkgcol,1);
 if font=2 then for i:=1 to length(text) do putchar_bkg(x1+((i-1)*11),y1,ord(upcase(text[i])),farbe,bkgcol,2);
end;
procedure plot_field_bkg(x1,y1,xw:word);
var x,y:word;
begin
 for y:=y1 to y1+8 do for x:=x1 to x1+xw-1 do vputpixel(x,y,0);
 dec(y1,2);
 for y:=y1 to y1+12 do for x:=x1+xw to x1+xw+25 do vputpixel(x,y,updo_but[(y-y1)*26+(x-x1-xw)]);
end;
procedure plot_but_bkg(x1,y1,xw:word);
var x,lx,y:word;i:byte;
begin
 lx:=x1;
 for y:=y1 to y1+12 do for x:=lx to lx+3 do vputpixel(x,y,but_parts[0,(y-y1)*4+(x-lx)]);
 inc(lx,4);
 for i:=0 to xw-1 do
  for y:=y1 to y1+12 do for x:=lx+(i*4) to lx+3+(i*4) do vputpixel(x,y,but_parts[1,(y-y1)*4+(x-(lx+(i*4)))]);
 inc(lx,(xw-1)*4);
 for y:=y1 to y1+12 do for x:=lx to lx+3 do vputpixel(x,y,but_parts[2,(y-y1)*4+(x-lx)]);
end;
procedure initfields;
begin
 with player.playbut[0] do begin x1:=6;x2:=21;y1:=399;y2:=446;col_norm:=22;col_avail:=26;col_active:=31;end;
 with player.playbut[1] do begin x1:=180;x2:=217;y1:=462;y2:=472;col_norm:=22;col_avail:=26;col_active:=31;end;
 with player.playbut[2] do begin x1:=229;x2:=265;y1:=462;y2:=472;col_norm:=22;col_avail:=26;col_active:=31;end;
 with player.playbut[3] do begin x1:=278;x2:=314;y1:=462;y2:=472;col_norm:=22;col_avail:=26;col_active:=31;end;
 with player.playbut[4] do begin x1:=327;x2:=363;y1:=462;y2:=472;col_norm:=22;col_avail:=26;col_active:=31;end;
 with player.playbut[5] do begin x1:=376;x2:=412;y1:=462;y2:=472;col_norm:=22;col_avail:=26;col_active:=31;end;
 with player.playbut[6] do begin x1:=425;x2:=461;y1:=462;y2:=472;col_norm:=22;col_avail:=26;col_active:=31;end;

 with player.playbut[7] do begin x1:=30;x2:=84;y1:=388;y2:=400;col_norm:=20;col_avail:=25;col_active:=31;end;
 with player.playbut[8] do begin x1:=30;x2:=84;y1:=403;y2:=415;col_norm:=20;col_avail:=25;col_active:=31;end;
 with player.playbut[9] do begin x1:=30;x2:=84;y1:=418;y2:=430;col_norm:=20;col_avail:=25;col_active:=31;end;
 with player.playbut[10] do begin x1:=30;x2:=84;y1:=433;y2:=445;col_norm:=20;col_avail:=25;col_active:=31;end;

 with player.playbut[11] do begin x1:=88 ;x2:=112;y1:=388;y2:=400;col_norm:=20;col_avail:=25;col_active:=31;end;
 with player.playbut[12] do begin x1:=114;x2:=138;y1:=388;y2:=400;col_norm:=20;col_avail:=25;col_active:=31;end;
 with player.playbut[13] do begin x1:=140;x2:=164;y1:=388;y2:=400;col_norm:=20;col_avail:=25;col_active:=31;end;
 with player.playbut[14] do begin x1:=88 ;x2:=112;y1:=403;y2:=415;col_norm:=20;col_avail:=25;col_active:=31;end;
 with player.playbut[15] do begin x1:=114;x2:=138;y1:=403;y2:=415;col_norm:=20;col_avail:=25;col_active:=31;end;
 with player.playbut[16] do begin x1:=140;x2:=164;y1:=403;y2:=415;col_norm:=20;col_avail:=25;col_active:=31;end;
 with player.playbut[17] do begin x1:=88 ;x2:=112;y1:=418;y2:=430;col_norm:=20;col_avail:=25;col_active:=31;end;
 with player.playbut[18] do begin x1:=114;x2:=138;y1:=418;y2:=430;col_norm:=20;col_avail:=25;col_active:=31;end;
 with player.playbut[19] do begin x1:=88 ;x2:=112;y1:=433;y2:=445;col_norm:=20;col_avail:=25;col_active:=31;end;
 with player.playbut[20] do begin x1:=114;x2:=138;y1:=433;y2:=445;col_norm:=20;col_avail:=25;col_active:=31;end;

 with player.playbut[21] do begin x1:=479;x2:=500;y1:=388;y2:=400;col_norm:=20;col_avail:=25;col_active:=31;end;
 with player.playbut[22] do begin x1:=505;x2:=526;y1:=388;y2:=400;col_norm:=20;col_avail:=25;col_active:=31;end;
 with player.playbut[23] do begin x1:=531;x2:=552;y1:=388;y2:=400;col_norm:=20;col_avail:=25;col_active:=31;end;
 with player.playbut[24] do begin x1:=557;x2:=578;y1:=388;y2:=400;col_norm:=20;col_avail:=25;col_active:=31;end;
 with player.playbut[25] do begin x1:=583;x2:=604;y1:=388;y2:=400;col_norm:=20;col_avail:=25;col_active:=31;end;
 with player.playbut[26] do begin x1:=479;x2:=500;y1:=403;y2:=415;col_norm:=20;col_avail:=25;col_active:=31;end;
 with player.playbut[27] do begin x1:=505;x2:=526;y1:=403;y2:=415;col_norm:=20;col_avail:=25;col_active:=31;end;
 with player.playbut[28] do begin x1:=531;x2:=552;y1:=403;y2:=415;col_norm:=20;col_avail:=25;col_active:=31;end;
 with player.playbut[29] do begin x1:=557;x2:=578;y1:=403;y2:=415;col_norm:=20;col_avail:=25;col_active:=31;end;
 with player.playbut[30] do begin x1:=583;x2:=604;y1:=403;y2:=415;col_norm:=20;col_avail:=25;col_active:=31;end;
 with player.playbut[31] do begin x1:=479;x2:=500;y1:=418;y2:=430;col_norm:=20;col_avail:=25;col_active:=31;end;
 with player.playbut[32] do begin x1:=505;x2:=526;y1:=418;y2:=430;col_norm:=20;col_avail:=25;col_active:=31;end;
 with player.playbut[33] do begin x1:=531;x2:=552;y1:=418;y2:=430;col_norm:=20;col_avail:=25;col_active:=31;end;
 with player.playbut[34] do begin x1:=557;x2:=578;y1:=418;y2:=430;col_norm:=20;col_avail:=25;col_active:=31;end;
 with player.playbut[35] do begin x1:=583;x2:=604;y1:=418;y2:=430;col_norm:=20;col_avail:=25;col_active:=31;end;
 with player.playbut[36] do begin x1:=479;x2:=500;y1:=433;y2:=445;col_norm:=20;col_avail:=25;col_active:=31;end;
 with player.playbut[37] do begin x1:=505;x2:=526;y1:=433;y2:=445;col_norm:=20;col_avail:=25;col_active:=31;end;
 with player.playbut[38] do begin x1:=531;x2:=552;y1:=433;y2:=445;col_norm:=20;col_avail:=25;col_active:=31;end;
 with player.playbut[39] do begin x1:=557;x2:=578;y1:=433;y2:=445;col_norm:=20;col_avail:=25;col_active:=31;end;
 with player.playbut[40] do begin x1:=583;x2:=604;y1:=433;y2:=445;col_norm:=20;col_avail:=25;col_active:=31;end;
 with player.playbut[41] do begin x1:=479;x2:=500;y1:=448;y2:=460;col_norm:=20;col_avail:=25;col_active:=31;end;

 with player.playbut[42] do begin x1:=404;x2:=416;y1:=292;y2:=304;col_norm:=20;col_avail:=25;col_active:=31;end;
 with player.playbut[43] do begin x1:=404;x2:=416;y1:=335;y2:=347;col_norm:=20;col_avail:=25;col_active:=31;end;
 with player.playbut[44] do begin x1:=612;x2:=624;y1:=292;y2:=304;col_norm:=20;col_avail:=25;col_active:=31;end;
 with player.playbut[45] do begin x1:=612;x2:=624;y1:=335;y2:=347;col_norm:=20;col_avail:=25;col_active:=31;end;

 with player.playbut[46] do begin x1:=323;x2:=403;y1:=293;y2:=301;col_norm:=20;col_avail:=25;col_active:=31;end;
 with player.playbut[47] do begin x1:=323;x2:=403;y1:=302;y2:=310;col_norm:=20;col_avail:=25;col_active:=31;end;
 with player.playbut[48] do begin x1:=323;x2:=403;y1:=311;y2:=319;col_norm:=20;col_avail:=25;col_active:=31;end;
 with player.playbut[49] do begin x1:=323;x2:=403;y1:=320;y2:=328;col_norm:=20;col_avail:=25;col_active:=31;end;
 with player.playbut[50] do begin x1:=323;x2:=403;y1:=329;y2:=337;col_norm:=20;col_avail:=25;col_active:=31;end;
 with player.playbut[51] do begin x1:=323;x2:=403;y1:=338;y2:=346;col_norm:=20;col_avail:=25;col_active:=31;end;

 with player.playbut[52] do begin x1:=417;x2:=611;y1:=293;y2:=301;col_norm:=20;col_avail:=25;col_active:=31;end;
 with player.playbut[53] do begin x1:=417;x2:=611;y1:=302;y2:=310;col_norm:=20;col_avail:=25;col_active:=31;end;
 with player.playbut[54] do begin x1:=417;x2:=611;y1:=311;y2:=319;col_norm:=20;col_avail:=25;col_active:=31;end;
 with player.playbut[55] do begin x1:=417;x2:=611;y1:=320;y2:=328;col_norm:=20;col_avail:=25;col_active:=31;end;
 with player.playbut[56] do begin x1:=417;x2:=611;y1:=329;y2:=337;col_norm:=20;col_avail:=25;col_active:=31;end;
 with player.playbut[57] do begin x1:=417;x2:=611;y1:=338;y2:=346;col_norm:=20;col_avail:=25;col_active:=31;end;

 with button[0] do
  begin
   list_typ:=typ_but_field;
   header:='Soundplayer:';headercol:=15;headerx:=10;headery:=100;listx:=150;listy:=105;listw:=80;lista:=20;
   list_anz:=4;listcol:=8;list_idx:=0;list_next:=list_idx;
   list[0]:='KEIN PLAYER';list[1]:='MOD-PLAYER ';list[2]:='CD-PLAYER  ';list[3]:='PLAYER TESTEN';
   setup_cfg.player_used:=list_idx;
  end;
 with button[1] do
  begin
   list_typ:=typ_scroll_field;
   header:='Typ:';headercol:=10;headerx:=150;headery:=130;listx:=150;listy:=150;listw:=100;
   list_anz:=6;listcol:=15;list_idx:=1;list_next:=list_idx;
   list[0]:='';
   list[1]:='KEINE';list[2]:='SOUNDBLASTER 2';list[3]:='SOUNDBLASTER PRO';list[4]:='SOUNDBLASTER 16';
   list[5]:='GRAVIS USND ';
  end;
 with button[2] do
  begin
   list_typ:=typ_scroll_field;
   header:='Port:';headercol:=10;headerx:=280;headery:=130;listx:=280;listy:=150;listw:=32;
   list_anz:=9;listcol:=15;list_idx:=0;list_next:=list_idx;
   list[0]:='';list[1]:='210';list[2]:='220';list[3]:='230';list[4]:='240';list[5]:='250';list[6]:='260';list[7]:='270';
   list[8]:='280';
  end;
 with button[3] do
  begin
   list_typ:=typ_scroll_field;
   header:='IRQ:';headercol:=10;headerx:=342;headery:=130;listx:=342;listy:=150;listw:=21;
   list_anz:=4;listcol:=15;list_idx:=0;list_next:=list_idx;
   list[0]:='';list[1]:='5';list[2]:='7';list[3]:='10';
  end;
 with button[4] do
  begin
   list_typ:=typ_scroll_field;
   header:='DMA:';headercol:=10;headerx:=393;headery:=130;listx:=393;listy:=150;listw:=21;
   list_anz:=4;listcol:=15;list_idx:=0;list_next:=list_idx;
   list[0]:='';list[1]:='0';list[2]:='1';list[3]:='3';
  end;
 with button[5] do
  begin
   list_typ:=typ_scroll_field;
   header:='Rate:';headercol:=10;headerx:=444;headery:=130;listx:=444;listy:=150;listw:=41;
   list_anz:=4;listcol:=15;list_idx:=0;list_next:=list_idx;
   list[0]:='';list[1]:='11 KHZ';list[2]:='22 KHZ';list[3]:='44 KHZ';
  end;
end;
procedure myown_savemidasconfig;
type configstruc=record
      Device, Cardtype, IO, IRQ, DMA, RATE, MODE:word;
     end;
var fc:file of configstruc;
    co:configstruc;
begin
 if (setup_cfg.soundcard.card<>0)and(setup_cfg.soundcard.card<>1) then
  begin
   autodetect_hardware;
   if gus_sd^.port>0 then set_fields(0);
   if sb_sd^.port>0 then set_fields(3);
  end;
 if setup_cfg.soundcard.card=0 then begin midassdnumber:=0;midassdcard:=0;end else
 if setup_cfg.soundcard.card=1 then begin midassdnumber:=3;midassdcard:=2;end;
 if setup_cfg.soundcard.card=2 then begin midassdnumber:=3;midassdcard:=3;end;
 if setup_cfg.soundcard.card=3 then begin midassdnumber:=3;midassdcard:=3;end;
 midassdport:=setup_cfg.soundcard.port;
 midassdirq:=setup_cfg.soundcard.irq;
 midassddma:=setup_cfg.soundcard.dma;
 midasmixrate:=setup_cfg.soundcard.rate;
 midasoutputmode:=0;

 {if setup_cfg.soundcard.card=0 then begin co.device:=0;co.cardtype:=0;end else
 if setup_cfg.soundcard.card=1 then begin co.device:=3;co.cardtype:=3;end;
 co.io:=setup_cfg.soundcard.port;
 co.irq:=setup_cfg.soundcard.irq;
 co.dma:=setup_cfg.soundcard.dma;
 co.rate:=setup_cfg.soundcard.rate;
 co.mode:=0;
 assign(fc,'midas.cfg');
 rewrite(fc);write(fc,co);close(fc);}
end;




procedure get_low_dma;
var txt:string;co,dummy:byte;
begin
 txt:=getenv('BLASTER');
 co:=1;dummy:=$ff;
 repeat
  if (txt[co]='d')or (txt[co]='D') then dummy:=ord(txt[co+1])-ord('0') else inc(co);
 until (co=length(txt)+1) or (dummy<$ff);
 sb_sd^.dma:=dummy;
end;

procedure autodetect_hardware;
var pdev:pointer;
    error:byte;
    perror:^byte;
    callptr:pointer;
    cardtype:byte;
begin
 midasdetectsd;auto_sd:=midassd;cardtype:=auto_sd^.cardtype;

 pdev:=midasSoundDevices[0];gus_sd:=pdev;
 gus_sd^.port:=0;gus_sd^.irq:=0;gus_sd^.dma:=0;gus_sd^.cardtype:=$ff;perror:=addr(error);error:=1;
 callptr:=gus_sd^.detectptr;asm les di,perror;push es;push di;call callptr;end;

 pdev:=midasSoundDevices[3];sb_sd:=pdev;
 sb_sd^.port:=0;sb_sd^.irq:=0;sb_sd^.dma:=0;sb_sd^.cardtype:=$ff;perror:=addr(error);error:=1;
 if gus_sd^.port=0 then
  begin
   callptr:=sb_sd^.detectptr;asm les di,perror;push es;push di;call callptr;end;
   if sb_sd^.dma>3 then get_low_dma;
   if sb_sd^.port>0 then sb_sd^.cardtype:=cardtype;
  end;
end;

procedure set_fields(dev:byte);
begin
 if dev=0 then
  begin
   setup_cfg.soundcard.card:=0;
   setup_cfg.soundcard.port:=gus_sd^.port;
   setup_cfg.soundcard.irq:=gus_sd^.irq;
   setup_cfg.soundcard.dma:=gus_sd^.dma;
   setup_cfg.soundcard.rate:=44000;
  end;
 if dev=3 then
  begin
   if sb_sd^.cardtype= 3 then setup_cfg.soundcard.card:=1;
   if sb_sd^.cardtype= 4 then setup_cfg.soundcard.card:=2;
   if sb_sd^.cardtype= 5 then setup_cfg.soundcard.card:=3;
   setup_cfg.soundcard.port:=sb_sd^.port;
   setup_cfg.soundcard.irq:=sb_sd^.irq;
   setup_cfg.soundcard.dma:=sb_sd^.dma;
   setup_cfg.soundcard.rate:=22000;
  end;
end;
procedure set_scroll_fields_next;
begin
 if setup_cfg.soundcard.card=0 then button[1].list_next:=5 else
 if setup_cfg.soundcard.card=1 then button[1].list_next:=2 else
 if setup_cfg.soundcard.card=2 then button[1].list_next:=3 else
 if setup_cfg.soundcard.card=3 then button[1].list_next:=4;

 if setup_cfg.soundcard.port=$210 then button[2].list_next:=1 else
 if setup_cfg.soundcard.port=$220 then button[2].list_next:=2 else
 if setup_cfg.soundcard.port=$230 then button[2].list_next:=3 else
 if setup_cfg.soundcard.port=$240 then button[2].list_next:=4 else
 if setup_cfg.soundcard.port=$250 then button[2].list_next:=5 else
 if setup_cfg.soundcard.port=$260 then button[2].list_next:=6 else
 if setup_cfg.soundcard.port=$270 then button[2].list_next:=7 else
 if setup_cfg.soundcard.port=$280 then button[2].list_next:=8;

 if setup_cfg.soundcard.irq=5 then button[3].list_next:=1 else
 if setup_cfg.soundcard.irq=7 then button[3].list_next:=2 else
 if setup_cfg.soundcard.irq=10 then button[3].list_next:=3;

 if setup_cfg.soundcard.dma=0 then button[4].list_next:=1 else
 if setup_cfg.soundcard.dma=1 then button[4].list_next:=2 else
 if setup_cfg.soundcard.dma=3 then button[4].list_next:=3;

 if setup_cfg.soundcard.rate=11000 then button[5].list_next:=1 else
 if setup_cfg.soundcard.rate=22000 then button[5].list_next:=2 else
 if setup_cfg.soundcard.rate=44000 then button[5].list_next:=3;
end;
procedure set_scroll_fields_idx;
begin
 if setup_cfg.soundcard.card=0 then button[1].list_idx:=5 else
 if setup_cfg.soundcard.card=1 then button[1].list_idx:=2 else
 if setup_cfg.soundcard.card=2 then button[1].list_idx:=3 else
 if setup_cfg.soundcard.card=3 then button[1].list_idx:=4;

 if setup_cfg.soundcard.port=$210 then button[2].list_idx:=1 else
 if setup_cfg.soundcard.port=$220 then button[2].list_idx:=2 else
 if setup_cfg.soundcard.port=$230 then button[2].list_idx:=3 else
 if setup_cfg.soundcard.port=$240 then button[2].list_idx:=4 else
 if setup_cfg.soundcard.port=$250 then button[2].list_idx:=5 else
 if setup_cfg.soundcard.port=$260 then button[2].list_idx:=6 else
 if setup_cfg.soundcard.port=$270 then button[2].list_idx:=7 else
 if setup_cfg.soundcard.port=$280 then button[2].list_idx:=8;

 if setup_cfg.soundcard.irq=5 then button[3].list_idx:=1 else
 if setup_cfg.soundcard.irq=7 then button[3].list_idx:=2 else
 if setup_cfg.soundcard.irq=10 then button[3].list_idx:=3;

 if setup_cfg.soundcard.dma=0 then button[4].list_idx:=1 else
 if setup_cfg.soundcard.dma=1 then button[4].list_idx:=2 else
 if setup_cfg.soundcard.dma=3 then button[4].list_idx:=3;

 if setup_cfg.soundcard.rate=11000 then button[5].list_idx:=1 else
 if setup_cfg.soundcard.rate=22000 then button[5].list_idx:=2 else
 if setup_cfg.soundcard.rate=44000 then button[5].list_idx:=3;
end;

procedure plot_field_def(t:but_field);
begin
 with t do
  begin
   if list_typ=typ_scroll_field then
    begin
     putstring(headerx,headery,header,headercol,2);
     plot_field_bkg(listx,listy,listw);
     putstring(listx+1,listy+1,list[list_idx],listcol,1);
    end;
   if list_typ=typ_but_field then
    begin
     putstring(headerx,headery,header,headercol,2);
     for i:=1 to list_anz do
      begin
       plot_but_bkg(listx+((i-1)*(listw+lista)),listy,listw shr 2);
       if list[i-1]='PLAYER TESTEN' then putstring(listx+((i-1)*(listw+lista))+5,listy+3,list[i-1],11,1)
       else putstring(listx+((i-1)*(listw+lista))+5,listy+3,list[i-1],listcol,1);
      end;
     putstring(listx+((list_idx)*(listw+lista))+5,listy+3,list[list_idx],listcol-5,1);
    end;
  end;
end;
procedure mark_but(t:but_field);
var m:byte;
begin
 m:=mouseset;clearmouse;
 with t do
  begin
   if list_typ=typ_scroll_field then begin exit;end;
   if list_typ=typ_but_field then
    begin
     m:=mouseset;clearmouse;
     if list_idx<>list_next then putstring(listx+((list_next)*(listw+lista))+5,listy+3,list[list_next],listcol-5,1);
     if m>0 then plotmouse;
    end;
  end;
end;
procedure unmark_but(t:but_field);
var m:byte;
begin
 with t do
  begin
   if list_typ=typ_scroll_field then begin exit;end;
   if list_typ=typ_but_field then
    begin
     m:=mouseset;clearmouse;
     if list_idx<>list_next then putstring(listx+((list_idx)*(listw+lista))+5,listy+3,list[list_idx],listcol,1);
     if m>0 then plotmouse;
    end;
  end;
end;
procedure col_but(t:but_field;col,but:byte);
var m:byte;
begin
 with t do
  begin
   if list_typ=typ_scroll_field then begin exit;end;
   if list_typ=typ_but_field then
    begin
     m:=mouseset;clearmouse;
     putstring(listx+((but)*(listw+lista))+5,listy+3,list[but],col,1);
     if m>0 then plotmouse;
    end;
  end;
end;

procedure create_scroll_field_up(p,frame:byte;handle:emshandle);
begin
 pbutton:=addr(button[p]);emsmap(handle,0,frame);
 with button[p] do
  begin
   clearstring_ems(1,1,320,emsframeofs[frame]);putstring_ems(1,1,320,emsframeofs[frame],list[list_idx],listcol);
   clearstring_ems(1,10,320,emsframeofs[frame]);putstring_ems(1,10,320,emsframeofs[frame],list[list_next],listcol);
  end;
end;
procedure create_scroll_field_do(p,frame:byte;handle:emshandle);
begin
 pbutton:=addr(button[p]);emsmap(handle,0,frame);
 with button[p] do
  begin
   clearstring_ems(1,1,320,emsframeofs[frame]);putstring_ems(1,1,320,emsframeofs[frame],list[list_next],listcol);
   clearstring_ems(1,10,320,emsframeofs[frame]);putstring_ems(1,10,320,emsframeofs[frame],list[list_idx],listcol);
  end;
end;
procedure copy_scroll_field(p,frame,y_ofs:byte);
var y:word;
begin
 pbutton:=addr(button[p]);
 with pbutton^do
  begin
   if getwinbyte(listx,listy)=getwinbyte(listx+listw,listy+8) then
    begin
     moveaktwin(getwinbyte(listx,listy));
     for y:=listy to listy+8 do
      vputvirtblock(listx,y,listw-1,scroll_seg,emsframeofs[frame]+(y-listy+y_ofs)*320);
    end;
  end;
end;

procedure scroll_field_up(p:byte);
var i:byte;
begin
 if button[p].list_idx=button[p].list_next then exit;
 emssavemap(scroll_frame[0]);
 create_scroll_field_up(p,0,scroll_frame[0]);
 with pbutton^ do
  begin
   for i:=1 to 9 do begin vbl;copy_scroll_field(p,0,i);end;
   list_idx:=list_next;
  end;
 emsrestoremap(scroll_frame[0]);
end;
procedure scroll_field_up4(p1,p2,p3,p4:byte);
var i:byte;
begin
 if p1<255 then with button[p1] do if list_idx=list_next then p1:=255;
 if p2<255 then with button[p2] do if list_idx=list_next then p2:=255;
 if p3<255 then with button[p3] do if list_idx=list_next then p3:=255;
 if p4<255 then with button[p4] do if list_idx=list_next then p4:=255;

 emssavemap(scroll_frame[0]);
 if p1<255 then create_scroll_field_up(p1,0,scroll_frame[0]);
 if p2<255 then create_scroll_field_up(p2,1,scroll_frame[1]);
 if p3<255 then create_scroll_field_up(p3,2,scroll_frame[2]);
 if p4<255 then create_scroll_field_up(p4,3,scroll_frame[3]);
 for i:=1 to 9 do
  begin
   vbl;
   if p1<255 then with button[p1] do copy_scroll_field(p1,0,i);
   if p2<255 then with button[p2] do copy_scroll_field(p2,1,i);
   if p3<255 then with button[p3] do copy_scroll_field(p3,2,i);
   if p4<255 then with button[p4] do copy_scroll_field(p4,3,i);
  end;
 if p1<255 then with button[p1] do list_idx:=list_next;
 if p2<255 then with button[p2] do list_idx:=list_next;
 if p3<255 then with button[p3] do list_idx:=list_next;
 if p4<255 then with button[p4] do list_idx:=list_next;
 emsrestoremap(scroll_frame[0]);
end;
procedure scroll_field_do(p:byte);
begin
 if button[p].list_idx=button[p].list_next then exit;
 emssavemap(scroll_frame[0]);
 create_scroll_field_do(p,0,scroll_frame[0]);
 with pbutton^ do
  begin
   for i:=8 downto 0 do begin vbl;copy_scroll_field(p,0,i);end;
   list_idx:=list_next;
  end;
 emsrestoremap(scroll_frame[0]);
end;
procedure scroll_field_do4(p1,p2,p3,p4:byte);
var i:byte;
begin
 if p1<255 then with button[p1] do if list_idx=list_next then p1:=255;
 if p2<255 then with button[p2] do if list_idx=list_next then p2:=255;
 if p3<255 then with button[p3] do if list_idx=list_next then p3:=255;
 if p4<255 then with button[p4] do if list_idx=list_next then p4:=255;

 emssavemap(scroll_frame[0]);
 if p1<255 then create_scroll_field_do(p1,0,scroll_frame[0]);
 if p2<255 then create_scroll_field_do(p2,1,scroll_frame[1]);
 if p3<255 then create_scroll_field_do(p3,2,scroll_frame[2]);
 if p4<255 then create_scroll_field_do(p4,3,scroll_frame[3]);
 for i:=8 downto 0 do
  begin
   vbl;
   if p1<255 then with button[p1] do copy_scroll_field(p1,0,i);
   if p2<255 then with button[p2] do copy_scroll_field(p2,1,i);
   if p3<255 then with button[p3] do copy_scroll_field(p3,2,i);
   if p4<255 then with button[p4] do copy_scroll_field(p4,3,i);
  end;
 if p1<255 then with button[p1] do list_idx:=list_next;
 if p2<255 then with button[p2] do list_idx:=list_next;
 if p3<255 then with button[p3] do list_idx:=list_next;
 if p4<255 then with button[p4] do list_idx:=list_next;
 emsrestoremap(scroll_frame[0]);
end;
procedure set_field(p,w:byte);
begin
 pbutton:=addr(button[p]);
 with pbutton^ do if (w>=list_anz)or(w<=0) then list_next:=0 else list_next:=w;
end;
procedure inc_field(p:byte);
begin
 pbutton:=addr(button[p]);
 with pbutton^ do if list_idx+1>=list_anz then list_next:=1 else list_next:=list_idx+1;
end;
procedure dec_field(p:byte);
begin
 pbutton:=addr(button[p]);
 with pbutton^ do if list_idx-1<1 then list_next:=list_anz-1 else list_next:=list_idx-1;
end;
function scan_but(x1,y1:word):word;
var i,i2:byte;dum:word;
begin
 dum:=$FFFF;
 for i:=0 to 5 do
  with button[i] do
   begin
    if list_typ=typ_scroll_field then
     begin
      if (y1>listy-2)and(y1<listy+10)then
       begin
        if (x1>=listx+listw)and(x1<=listx+listw+12)then dum:=i*256+0;
        if (x1>=listx+listw+13)and(x1<=listx+listw+26)then dum:=i*256+1;
       end;
     end;
    if list_typ=typ_but_field then
     begin
      if (y1>listy-2)and(y1<listy+10)then
       for i2:=1 to list_anz do
        if (x1>=(listx+((i2-1)*(listw+lista))))and(x1<(listx+((i2)*(listw+lista))))then
         dum:=i*256+(i2-1);
     end;
   end;
 if dum<>$ffff then begin scan_but:=dum;exit;end;

 if (x1>player.playbut[0].x1)and(x1<player.playbut[0].x2)then
  begin
   if (y1>player.playbut[0].y1)and(y1<player.playbut[0].y1+21) then dum:=$cd*256+250;
   if (y1>player.playbut[0].y1+21)and(y1<player.playbut[0].y2) then dum:=$cd*256+251;
  end;
 if dum<>$ffff then begin scan_but:=dum;exit;end;
 for i:=1 to 10 do
  if (y1>player.playbut[i].y1)and(y1<player.playbut[i].y2)then
   if (x1>player.playbut[i].x1)and(x1<player.playbut[i].x2) then dum:=$cd*256+i;
 if dum<>$ffff then begin scan_but:=dum;exit;end;
 for i:=21 to 41 do
  if (y1>player.playbut[i].y1)and(y1<player.playbut[i].y2)then
   if (x1>player.playbut[i].x1)and(x1<player.playbut[i].x2) then dum:=$cd*256+i;
 if dum<>$ffff then begin scan_but:=dum;exit;end;
 if setup_cfg.player_used=1 then
  begin
   for i:=42 to 45 do
    if (y1>player.playbut[i].y1)and(y1<player.playbut[i].y2)then
     if (x1>player.playbut[i].x1)and(x1<player.playbut[i].x2) then dum:=$cd*256+i;
  end;
 if dum<>$ffff then begin scan_but:=dum;exit;end;
 if setup_cfg.player_used=1 then
  begin
   for i:=46 to 57 do
    if (y1>player.playbut[i].y1)and(y1<player.playbut[i].y2)then
     if (x1>player.playbut[i].x1)and(x1<player.playbut[i].x2) then dum:=$cd*256+i;
  end;
 scan_but:=dum;
end;
procedure set_cfg_values;
begin
 if button[1].list_idx=1 then setup_cfg.soundcard.card:=0 else
    if button[1].list_idx=2 then setup_cfg.soundcard.card:=1 else
    if button[1].list_idx=3 then setup_cfg.soundcard.card:=2 else
    if button[1].list_idx=4 then setup_cfg.soundcard.card:=3;
 if button[2].list_idx=1 then setup_cfg.soundcard.port:=$210 else
    if button[2].list_idx=2 then setup_cfg.soundcard.port:=$220 else
    if button[2].list_idx=3 then setup_cfg.soundcard.port:=$230 else
    if button[2].list_idx=4 then setup_cfg.soundcard.port:=$240 else
    if button[2].list_idx=5 then setup_cfg.soundcard.port:=$250 else
    if button[2].list_idx=6 then setup_cfg.soundcard.port:=$260 else
    if button[2].list_idx=7 then setup_cfg.soundcard.port:=$270 else
    if button[2].list_idx=8 then setup_cfg.soundcard.port:=$280;
 if button[3].list_idx=1 then setup_cfg.soundcard.irq:=5 else
    if button[3].list_idx=2 then setup_cfg.soundcard.irq:=7 else
    if button[3].list_idx=3 then setup_cfg.soundcard.irq:=10;
 if button[4].list_idx=1 then setup_cfg.soundcard.dma:=0 else
    if button[4].list_idx=2 then setup_cfg.soundcard.dma:=1 else
    if button[4].list_idx=3 then setup_cfg.soundcard.dma:=3;
 if button[5].list_idx=1 then setup_cfg.soundcard.rate:=11000 else
    if button[5].list_idx=2 then setup_cfg.soundcard.rate:=22000 else
    if button[5].list_idx=3 then setup_cfg.soundcard.rate:=44000;
end;

procedure control_fields(field,direct:byte);
begin
 if field=0 then
  begin
   if direct=button[0].list_idx then exit;
   if direct=0 then
    begin set_field(0,0);unmark_but(button[0]);mark_but(button[0]);button[0].list_idx:=0;col_but(button[0],11,3);end;
   if direct=1 then
    begin set_field(0,1);unmark_but(button[0]);mark_but(button[0]);button[0].list_idx:=1;col_but(button[0],3,3);end;
   if direct=2 then
    begin set_field(0,2);unmark_but(button[0]);mark_but(button[0]);button[0].list_idx:=2;col_but(button[0],3,3);end;
   if direct=3 then
    begin
     if setup_cfg.player_used=1 then begin control_mp(255);end
     else if setup_cfg.player_used=2 then begin control_cd(255);end;
    end;
   setup_cfg.player_used:=button[0].list_idx;
  end;
 if field=1 then
  begin
   if direct=0 then begin inc_field(1);scroll_field_do(1);end;
   if direct=1 then begin dec_field(1);scroll_field_up(1);end;
   if button[1].list_idx=1 then
    begin
     button[2].list_next:=0;button[3].list_next:=0;button[4].list_next:=0;button[5].list_next:=0;
     if direct=0 then scroll_field_do4(2,3,4,5);
     if direct=1 then scroll_field_up4(2,3,4,5);
    end
   else if (button[1].list_idx>1)and(button[1].list_idx<5) then
    begin
     if sb_sd^.port>0 then begin set_fields(3);set_scroll_fields_next;end
     else begin button[2].list_next:=2;button[3].list_next:=2;button[4].list_next:=2;button[5].list_next:=1;end;
     if direct=0 then scroll_field_do4(2,3,4,5);
     if direct=1 then scroll_field_up4(2,3,4,5);
    end
   else if button[1].list_idx=5 then
    begin
     if gus_sd^.port>0 then begin set_fields(0);set_scroll_fields_next;end
     else begin button[2].list_next:=2;button[3].list_next:=3;button[4].list_next:=2;button[5].list_next:=3;end;
     if direct=0 then scroll_field_do4(2,3,4,5);
     if direct=1 then scroll_field_up4(2,3,4,5);
    end;
  end;
 if field=2 then
  begin
   if button[1].list_idx<>1 then begin
    if direct=0 then begin inc_field(2);scroll_field_do(2);end;
    if direct=1 then begin dec_field(2);scroll_field_up(2);end;
    if button[2].list_idx=1 then setup_cfg.soundcard.port:=$210 else
    if button[2].list_idx=2 then setup_cfg.soundcard.port:=$220 else
    if button[2].list_idx=3 then setup_cfg.soundcard.port:=$230 else
    if button[2].list_idx=4 then setup_cfg.soundcard.port:=$240 else
    if button[2].list_idx=5 then setup_cfg.soundcard.port:=$250 else
    if button[2].list_idx=6 then setup_cfg.soundcard.port:=$260 else
    if button[2].list_idx=7 then setup_cfg.soundcard.port:=$270 else
    if button[2].list_idx=8 then setup_cfg.soundcard.port:=$280;
    end;
  end;
 if field=3 then
  begin
   if button[1].list_idx<>1 then begin
    if direct=0 then begin inc_field(3);scroll_field_do(3);end;
    if direct=1 then begin dec_field(3);scroll_field_up(3);end;
    if button[3].list_idx=1 then setup_cfg.soundcard.irq:=5 else
    if button[3].list_idx=2 then setup_cfg.soundcard.irq:=7 else
    if button[3].list_idx=3 then setup_cfg.soundcard.irq:=10;
    end;
  end;
 if field=4 then
  begin
   if button[1].list_idx<>1 then begin
    if direct=0 then begin inc_field(4);scroll_field_do(4);end;
    if direct=1 then begin dec_field(4);scroll_field_up(4);end;
    if button[4].list_idx=1 then setup_cfg.soundcard.dma:=0 else
    if button[4].list_idx=2 then setup_cfg.soundcard.dma:=1 else
    if button[4].list_idx=3 then setup_cfg.soundcard.dma:=3;
    end;
  end;
 if field=5 then
  begin
   if (button[1].list_idx=2) then
    begin
     if setup_cfg.soundcard.rate=11000 then set_field(5,2);
     if setup_cfg.soundcard.rate=22000 then set_field(5,1);
     if direct=0 then begin scroll_field_do(5);end;
     if direct=1 then begin scroll_field_up(5);end;
    end;
   if (button[1].list_idx>2) then
    begin
     if direct=0 then begin inc_field(5);scroll_field_do(5);end;
     if direct=1 then begin dec_field(5);scroll_field_up(5);end;
    end;
   if button[5].list_idx=1 then setup_cfg.soundcard.rate:=11000 else
   if button[5].list_idx=2 then setup_cfg.soundcard.rate:=22000 else
   if button[5].list_idx=3 then setup_cfg.soundcard.rate:=44000;
  end;
 set_cfg_values;
end;

procedure control_mouse;
var w,i,j:word;m:byte;
begin
 if mousebut>1 then
  begin
   if (altmbut>0)then exit;
   if player.player_stb>0 then
    begin
     if setup_cfg.player_used=1 then control_mp(255) else
     if setup_cfg.player_used=2 then control_cd(255);
    end else control_fkt:=fkt_exit;
   exit;
  end;
 w:=scan_but(altmx,altmy);
 if w=$ffff then exit;
 if (w shr 8)=$cd then
  begin
   if (w and $ff)=250 then
    begin
     if setup_cfg.player_used=1 then control_mp($0000) else
     if setup_cfg.player_used=2 then control_cd($0000);
     exit;
    end;
   if (w and $ff)=251 then
    begin
     if setup_cfg.player_used=1 then control_mp($0100) else
     if setup_cfg.player_used=2 then control_cd($0100);
     exit;
    end;
   if ((w and $ff)>41)and((w and $ff)<46) then
    begin
     for j:=0 to 2 do for i:=0 to 60000 do;
     if setup_cfg.player_used=1 then control_mp(w and 255) else
     if setup_cfg.player_used=2 then control_cd(w and 255);
     exit;
    end;
   if (altmbut>0)then exit;
   if setup_cfg.player_used=1 then control_mp(w and 255) else
   if setup_cfg.player_used=2 then control_cd(w and 255);
  end
 else control_fields(w shr 8,w and 255);
end;
function readkey:char;
begin
 regs.ah:=0;intr($16,regs);
 if regs.al=0 then readkey:=chr(regs.ah) else readkey:=chr(regs.al);
end;
function keypressed:boolean;
begin
 regs.ah:=1;intr($16,regs);
 if (regs.flags and fzero)=0 then keypressed:=true else keypressed:=false;
end;
procedure control_keyboard;
var taste:char;m:byte;
begin
 taste:=readkey;
 if taste<>'q' then
  begin
   exit;
   vbl;inc_field(0);inc_field(1);
   m:=mouseset;clearmouse;scroll_field_up4(0,1,255,255);if m>0 then plotmouse;
  end
 else control_fkt:=fkt_exit;
end;
procedure put_default_buts;
begin
 plot_field_Def(button[0]);
 putstring(10,130,'Soundkarte :',15,2);
 plot_field_Def(button[1]);
 plot_field_Def(button[2]);
 plot_field_Def(button[3]);
 plot_field_Def(button[4]);
 plot_field_Def(button[5]);
end;
procedure options_kernel;
begin
 put_default_buts;while keypressed do taste:=readkey;
 repeat
  repeat movemouse; until keypressed or (mousebut>0);
  if keypressed then control_keyboard else control_mouse;
 until control_fkt=fkt_exit;
end;

procedure plot_background(mode_activate:byte);
var i:byte;y:word;po:^byte;
begin
 if mode_activate=1 then initvesamode;
 v_openfile('setup.new');
  v_readfile_p1(767,addr(header[0]));setblack;
  moveaktwin(0);v_readfile_p1(65535,ptr($a000,0));
  moveaktwin(1);v_readfile_p1(65535,ptr($a000,0));
  moveaktwin(2);v_readfile_p1(65535,ptr($a000,0));
  moveaktwin(3);v_readfile_p1(65535,ptr($a000,0));
  moveaktwin(4);v_readfile(45056,ptr($a000,0));
 v_closefile;
 v_openfile('setupdat.new');
  v_seekfile(2048);v_readfile(338,addr(updo_but));
  v_seekfile(5890);v_readfile(52,addr(but_parts[0]));
  v_seekfile(7170);v_readfile(52,addr(but_parts[1]));
  v_seekfile(8450);v_readfile(52,addr(but_parts[2]));
  initfont1;initfont2;initfields;
  player_initfont1;player_initfont2;
 v_closefile;
 move(header[128*3],header[192*3],64*3);
end;

function check4hd:boolean;
begin
 regs.ah:=$19;intr($21,regs);if regs.al>1 then check4hd:=true else check4hd:=false;
end;
function getfreeram:word;
begin
 regs.ax:=$4800;regs.bx:=$ffff;intr($21,regs);
 getfreeram:=regs.bx;
end;
procedure init_options;
begin
 {writeln('Freier RAM:',getfreeram*16,' Bytes');halt;}
 if not(check4hd) then
  begin
   writeln('Bitte von HD starten!');
   halt;
  end;
 if not(check4vesa) then
  begin
   writeln('Keine VESA-Karte gefunden! Bitte UNIVBE installieren und erneut versuchen!');
   halt;
  end;
 if not(emsisinstalled) then
  begin
   writeln('Bitte EMM386 installieren!');
   halt;
  end;
 if emsfreepages<40 then
  begin
   writeln('Keinen freien EMS-Speicher gefunden!');
   halt;
  end;
 init_scroll_frames;
 plot_background(1);initmousesys;
 setorigpal;
 player.initialized:=false;
 control_fkt:=fkt_nothing;
 mousemoved:=1;
 autodetect_hardware;
 if (sb_sd^.port>0) then begin set_fields(3);set_scroll_fields_idx;end else
 if (gus_sd^.port>0) then begin set_fields(0);set_scroll_fields_idx;end else
  begin
   setup_cfg.player_used:=0;setup_cfg.soundcard.card:=0;
   setup_cfg.soundcard.port:=0;setup_cfg.soundcard.irq :=0;setup_cfg.soundcard.dma :=0;
  end;
 player_init;
end;
procedure deinit_options;
begin
 if player.player_stb>player_power_off then
  begin
   if setup_cfg.player_used=2 then control_cd(255) else
   if setup_cfg.player_used=1 then control_mp(255);
  end;
 regs.ax:=$0003;intr($10,regs);
 save_all_infos;
 deinit_scroll_frames;
end;

begin
 init_options;
 options_kernel;
 deinit_options;
end.

