program vector_intro;

uses crt,dos;

type vertex=record
       x,y,z:longint;
       xr,yr,zr:longint;
       xs,ys:longint;
       rotated:boolean;
      end;
     face=record
       normal:vertex;
       visible:boolean;
       p:array[1..4]of word;
      end;


var punkte:array[0..3]of vertex;
    view:vertex;
    sinus_t:array[0..449]of word;
    rota1,rota2,i,v:integer;
    plane:face;
    w1,w2,w3,w4,ps1,ps2,ps3,ps4,pc1,pc2,pc3,pc4,psc,pcs,pcc,pss:integer;



procedure setgfxmode;
begin
 asm
  mov ax,$13
  int $10
 end;
end;
procedure settxtmode;
begin
 asm
  mov ax,$3
  int $10
 end;
end;
procedure calc_sine;
begin
 for i:=0 to 359 do
  begin
   sinus_t[i]:=trunc(sin(i*PI/180)*10000);
  end;
 move(sinus_t[0],sinus_t[360],90*sizeof(word));
end;
function sinus(a:integer):word;
begin
 while a<0 do inc(a,360);
 while a>=360 do dec(a,360);
 sinus:=sinus_t[a];
end;
function cosin(a:integer):word;
begin
 while a<0 do inc(a,360);
 while a>=360 do dec(a,360);
 cosin:=sinus_t[a+90];
end;
procedure calc_normal(p1,p2,p4:vertex;var pe:vertex);
var d1,d2:vertex;
begin
 d1.x:=p2.x-p1.x;d1.y:=p2.y-p1.y;d1.z:=p2.z-p1.z;
 d2.x:=p4.x-p1.x;d2.y:=p4.y-p1.y;d2.z:=p4.z-p1.z;
 pe.x:=d1.y*d2.z-d1.z*d2.y;
 pe.y:=d1.z*d2.x-d1.x*d2.z;
 pe.z:=d1.x*d2.y-d1.y*d2.x;
end;
procedure init_faces;
begin
 with punkte[0] do begin x:=20; y:=20; z:=0;end;
 with punkte[1] do begin x:=-20;y:=20; z:=0;end;
 with punkte[2] do begin x:=-20;y:=-20;z:=0;end;
 with punkte[3] do begin x:=20; y:=-20;z:=0;end;
 plane.p[1]:=0;plane.p[2]:=1;plane.p[3]:=2;plane.p[4]:=3;
 plane.visible:=false;
 calc_normal(punkte[0],punkte[1],punkte[3],plane.normal);
end;
procedure putpix(x,y:word;c:byte);
begin
 mem[$a000:y*320+x]:=c;
end;
procedure hline(x1,y1,x2:word;col:byte);
begin
 asm
  push es
  mov cx,x2
  sub cx,x1
  inc cx
  mov di,y1
  mov bx,di
  shl di,8
  shl bx,6
  add di,bx
  add di,x1
  mov ax,$a000
  mov es,ax
  mov al,col
  cld
  rep stosb
  pop es
 end;
end;
procedure bline(x1,y1,x2,y2:longint;col:byte);
var ac,c,x,y:word;delta,te:longint;
begin
 if (x1<=x2) then    {alle rechts von y-achse}
  begin
   if (y1<=y2) then  {alle unterhalb x-achse}
    begin
     if (y2-y1)<=(x2-x1) then
      begin
       {fall 1}
       if (x2-x1)<>0 then delta:=10000*(y2-y1) div (x2-x1) else delta:=0;
       c:=0;y:=y1;
       for x:=x1 to x2 do
        begin putpix(x,y,col);inc(c,delta);if c>=10000 then begin inc(y);dec(c,10000);end;end;
      end
     else
      begin
       {fall 3}
       if (y2-y1)<>0 then delta:=10000*(x2-x1) div (y2-y1)else delta:=0;c:=0;x:=x1;
       for y:=y1 to y2 do
        begin putpix(x,y,col);inc(c,delta);if c>=10000 then begin inc(x);dec(c,10000);end;end;
      end;
    end
   else
    begin
     if (y1-y2)<=(x2-x1) then
      begin
       {fall 2}
       if (x2-x1)<>0 then delta:=10000*(y1-y2) div (x2-x1);c:=0;y:=y1;
       for x:=x1 to x2 do
        begin putpix(x,y,col);inc(c,delta);if c>=10000 then begin dec(y);dec(c,10000);end;end;
      end
     else
      begin
       {fall 4}
       if (y1-y2)<>0 then delta:=10000*(x2-x1) div (y1-y2);c:=0;x:=x1;
       for y:=y1 downto y2 do
        begin putpix(x,y,col);inc(c,delta);if c>=10000 then begin inc(x);dec(c,10000);end;end;
      end;
    end;
  end
 else
  begin
   if (y1<=y2) then
    begin
     if (y2-y1)<=(x1-x2) then
      begin
       {fall 5}
       if (x1-x2)<>0 then delta:=10000*(y2-y1) div (x1-x2);c:=0;y:=y1;
       for x:=x1 downto x2 do
        begin putpix(x,y,col);inc(c,delta);if c>=10000 then begin inc(y);dec(c,10000);end;end;
      end
     else
      begin
       {fall 7}
       if (y2-y1)<>0 then delta:=10000*(x1-x2) div (y2-y1);c:=0;x:=x1;
       for y:=y1 to y2 do
        begin putpix(x,y,col);inc(c,delta);if c>=10000 then begin dec(x);dec(c,10000);end;end;
      end;
    end
   else
    begin
     if (y1-y2)<=(x1-x2) then
      begin
       {fall 6}
       if (x1-x2)<>0 then delta:=10000*(y1-y2) div (x1-x2);c:=0;y:=y1;
       for x:=x1 downto x2 do
        begin putpix(x,y,col);inc(c,delta);if c>=10000 then begin dec(y);dec(c,10000);end;end;
      end
     else
      begin
       {fall 8}
       if (y1-y2)<>0 then delta:=10000*(x1-x2) div (y1-y2);c:=0;x:=x1;
       for y:=y1 downto y2 do
        begin putpix(x,y,col);inc(c,delta);if c>=10000 then begin dec(x);dec(c,10000);end;end;
      end;
    end;
  end;
end;
procedure fillpoly(clear:boolean);
var col,pmax,pright,pleft:byte;
    psl,psr:word;
    pymax:integer;
    y,xl,xr,xer,xel,yer,yel,xdr,xdl,cr,cl,dr,dl:longint;
 procedure get_extremes;
 var dummy:byte;
 begin
  psl:=0;psr:=0;
  pymax:=punkte[plane.p[1]].ys;pmax:=1;
  for i:=2 to 4 do
   begin
    if punkte[plane.p[i]].ys>pymax then begin pymax:=punkte[plane.p[i]].ys;pmax:=i;end;
   end;
  pymax:=punkte[plane.p[pmax]].ys;
  if pmax=1 then begin pleft:=4;pright:=2;end;
  if pmax=2 then begin pleft:=1;pright:=3;end;
  if pmax=3 then begin pleft:=2;pright:=4;end;
  if pmax=4 then begin pleft:=3;pright:=1;end;
  xl:=punkte[plane.p[pmax]].xs;xr:=xl;

  xer:=punkte[plane.p[pright]].xs;yer:=punkte[plane.p[pright]].ys;
  xel:=punkte[plane.p[pleft]].xs; yel:=punkte[plane.p[pleft]].ys;

  cr:=0;cl:=0;xdr:=0;xdl:=0;
  if xr<=xer then begin dr:=0;if (pymax-yer)<>0 then xdr:=100000*(xer-xr) div (pymax-yer) else xdr:=0;end
   else begin dr:=1;if (pymax-yer)<>0 then xdr:=100000*(xr-xer) div (pymax-yer) else xdr:=0;end;
  if xl<=xel then begin dl:=0;if (pymax-yel)<>0 then xdl:=100000*(xel-xl) div (pymax-yel) else xdl:=0;end
  else begin dl:=1;if (pymax-yel)<>0 then xdl:=100000*(xl-xel) div (pymax-yel) else xdl:=0;end;

  if pymax=yer then xr:=xer;if pymax=yel then xl:=xel;
end;
procedure switch(var p1,p2:word);
var d:word;
begin
 d:=p1;p1:=p2;p2:=d;
end;
procedure switch_l(var p1,p2:longint);
var d:longint;
begin
 d:=p1;p1:=p2;p2:=d;
end;

begin
 get_extremes;
 if clear then col:=0 else if plane.visible then col:=15 else col:=1;
 y:=pymax;
 repeat
  inc(cr,xdr);while cr>=100000 do begin if dr=0 then inc(xr) else dec(xr);dec(cr,100000);end;
  inc(cl,xdl);while cl>=100000 do begin if dl=0 then inc(xl) else dec(xl);dec(cl,100000);end;
  if xl>xr then begin switch_l(xl,xr);hline(xl,y,xr,col);switch_l(xl,xr); end else hline(xl,y,xr,col);
  if (y=yer)and(pleft<>pright) then
     begin
      xr:=punkte[plane.p[pright]].xs;
      inc(pright);if pright=5 then pright:=1;
      cr:=0;xdr:=0;xer:=punkte[plane.p[pright]].xs;yer:=punkte[plane.p[pright]].ys;
      if xr<=xer then begin dr:=0;if (y-yer)<>0 then xdr:=100000*(xer-xr) div (y-yer) else xdr:=0;end
                 else begin dr:=1;if (y-yer)<>0 then xdr:=100000*(xr-xer) div (y-yer) else xdr:=0;end;
      if y=yer then xr:=xer;
      if y-1=yer then begin xdr:=0;xr:=xer;end;
     end;
  if (y=yel)and(pleft<>pright) then
     begin
      xl:=punkte[plane.p[pleft]].xs;
      dec(pleft);if pleft=0 then pleft:=4;
      cl:=0;xdl:=0;xel:=punkte[plane.p[pleft]].xs;yel:=punkte[plane.p[pleft]].ys;
      if xl<=xel then begin dl:=0;if (y-yel)<>0 then xdl:=100000*(xel-xl) div (y-yel) else xdl:=0;end
                 else begin dl:=1;if (y-yel)<>0 then xdl:=100000*(xl-xel) div (y-yel) else xdl:=0;end;
      if y=yel then xl:=xel;
      if y-1=yel then begin xdl:=0;xl:=xel;end;
     end;
  dec(y);
 until (xr=xl)and(pleft=pright);
end;


procedure drawpoly;
var col:byte;
begin
 {if plane.visible=false then exit;}
 if plane.visible then col:=15 else col:=1;
 bline(punkte[plane.p[1]].xs,punkte[plane.p[1]].ys,punkte[plane.p[2]].xs,punkte[plane.p[2]].ys,col);
 bline(punkte[plane.p[2]].xs,punkte[plane.p[2]].ys,punkte[plane.p[3]].xs,punkte[plane.p[3]].ys,col);
 bline(punkte[plane.p[3]].xs,punkte[plane.p[3]].ys,punkte[plane.p[4]].xs,punkte[plane.p[4]].ys,col);
 bline(punkte[plane.p[4]].xs,punkte[plane.p[4]].ys,punkte[plane.p[1]].xs,punkte[plane.p[1]].ys,col);
end;
procedure clearpoly;
begin
 {if plane.visible=false then exit;}
 bline(punkte[plane.p[1]].xs,punkte[plane.p[1]].ys,punkte[plane.p[2]].xs,punkte[plane.p[2]].ys,0);
 bline(punkte[plane.p[2]].xs,punkte[plane.p[2]].ys,punkte[plane.p[3]].xs,punkte[plane.p[3]].ys,0);
 bline(punkte[plane.p[3]].xs,punkte[plane.p[3]].ys,punkte[plane.p[4]].xs,punkte[plane.p[4]].ys,0);
 bline(punkte[plane.p[4]].xs,punkte[plane.p[4]].ys,punkte[plane.p[1]].xs,punkte[plane.p[1]].ys,0);
end;
procedure init_rot;
begin
 w1:=rota1;w2:=rota2;w3:=w1+w2;w4:=w1-w2;
 ps1:=sinus(w1);ps2:=sinus(w2);ps3:=sinus(w3);ps4:=sinus(w4);
 pc1:=cosin(w1);pc2:=cosin(w2);pc3:=cosin(w3);pc4:=cosin(w4);
 psc:=(ps3+ps4) div 2;
 pcs:=(ps3-ps4) div 2;
 pcc:=(pc4+pc3) div 2;
 pss:=(pc4-pc3) div 2;
end;
procedure rot_point(var p:vertex);
const r=0;distance=128;
begin
 p.xr:=(-p.x*ps1+p.y*pc1) div 10000;
 p.yr:=(-p.x*pcs-p.y*pss+p.z*pc2) div 10000;
 p.zr:=(-p.x*pcc-p.y*psc-p.z*ps2+r) div 10000;
 p.xs:=p.xr*distance div (distance+p.zr)+160;
 p.ys:=p.yr*distance div (distance+p.zr)+100;
end;
procedure vbl;
begin
 repeat until (port[$3da]and 8)=8;
 repeat until (port[$3da]and 8)=0;
end;

procedure chk_vis;
begin
 if plane.normal.zr>0 then plane.visible:=true else plane.visible:=false;
end;
procedure rotate_world;
begin
 fillpoly(true);
 inc(rota1,2);inc(rota2,3);
 if rota1>=360 then dec(rota1,360);
 if rota2>=360 then dec(rota2,360);
 if (rota1=240) and(rota2=120) then
  begin
   delay(0);
  end;
 init_rot;
 rot_point(plane.normal);chk_vis;
 for i:=0 to 3 do rot_point(punkte[i]);
 fillpoly(false);
 vbl;
end;



begin
 v:=44;
 calc_sine;init_faces;setgfxmode;rota1:=90+(v*2);rota2:=135+(v*3);
 init_rot;
 rot_point(plane.normal);chk_vis;
 for i:=0 to 3 do rot_point(punkte[i]);
 fillpoly(false);
 repeat
  rotate_world;
 until keypressed;
 settxtmode;
end.