unit emmunit;

interface

uses crt,dos;

const EMSError=-1;
      EMSErrorW=$FFFF;
      EMSFRAMEOfs0=$0000;
      EMSFRAMEOfs1=$4000;
      EMSFRAMEOfs2=$8000;
      EMSFRAMEOfs3=$C000;
      EMSFRAMEOfs:array[0..3]of word=($0000,$4000,$8000,$c000);

type EmsHandle=integer;

var regs:registers;
    EMSErrorcode:word;
    EMSISINSTALLED:boolean;

function IsEMSInstalled:boolean;
function EmsVersion:integer;
function EmsGetErrorText:string;

function EmsNumPages:integer;
function EmsFreePages:integer;
function EmsFrameSeg:word;
function EmsAlloc(Pages:Word):integer;
procedure EmsDeAlloc(Handle:Integer);
procedure EmsMap(Handle,LogP:Integer;PhysP:Byte);
procedure EmsMap4(Handle,lp1,lp2,lp3,lp4:Integer);
procedure EmsSaveMap(handle:integer);
procedure EmsRestoreMap(handle:integer);

implementation

function dec2hexstr(dec:word):string;
var wert,rest:word;stri:string;
begin
 wert:=dec;rest:=0;stri:='';
 repeat
  rest:=wert mod 16;wert:=wert div 16;
  if rest<10 then stri:=chr(rest+48)+stri else stri:=chr(rest-10+65)+stri;
 until wert=0;
 dec2hexstr:=stri;
end;
function IsEMSInstalled:boolean;
 type emmname=array[0..7]of char;emmnaptr=^emmname;
 const name:emmname ='EMMXXXX0';
 begin
  EMSErrorcode:=0;
  regs.ax:=$3567;msdos(regs);
  IsEMSInstalled:=(Emmnaptr(ptr(regs.es,10))^=Name);
 end;
function EmsNumPages:integer;
begin
 EMSErrorcode:=0;regs.ah:=$42;intr($67,regs);
 if regs.ah<>0 then
  begin EMSErrorcode:=regs.ah;EmsNumPages:=EMSError;end else EmsNumPages:=regs.dx;
end;
function EmsFreePages:integer;
begin
 EMSErrorcode:=0;regs.ah:=$42;intr($67,regs);
 if regs.ah<>0 then
  begin EMSErrorcode:=regs.ah;EmsFreePages:=EMSError;end else EmsFreePages:=regs.bx;
end;
function EmsFrameSeg:word;
begin
 EMSErrorcode:=0;regs.ah:=$41;intr($67,regs);
 if regs.ah<>0 then
  begin EMSErrorcode:=regs.ah;EmsFrameSeg:=EMSErrorW;end else EmsFrameSeg:=regs.bx;
end;
function EmsAlloc(Pages:Word):integer;
begin
 EMSErrorcode:=0;regs.ah:=$43;regs.bx:=pages;intr($67,regs);
 if regs.ah<>0 then
  begin EMSErrorcode:=regs.ah;EmsAlloc:=EMSError;end else EmsAlloc:=regs.dx;
end;
procedure EmsDeAlloc(Handle:Integer);
begin
 EMSErrorcode:=0;regs.ah:=$45;regs.dx:=handle;intr($67,regs);EMSErrorCode:=regs.ah;
end;
procedure EmsMap(Handle,LogP:Integer;PhysP:Byte);assembler;
asm
 mov EMSErrorcode,0
 mov ah,$44;mov al,physp;mov bx,logp;mov dx,handle;int $67;xchg al,ah
 mov EMSErrorcode,ax
end;
procedure EmsMap4(Handle,lp1,lp2,lp3,lp4:Integer);assembler;
asm
  mov EMSErrorcode,0
  mov ah,$44;mov al,0;mov bx,lp1;mov dx,handle;int $67;cmp ah,0;jne @fehler
  mov ah,$44;mov al,1;mov bx,lp2;mov dx,handle;int $67;cmp ah,0;jne @fehler
  mov ah,$44;mov al,2;mov bx,lp3;mov dx,handle;int $67;cmp ah,0;jne @fehler
  mov ah,$44;mov al,3;mov bx,lp4;mov dx,handle;int $67;cmp ah,0;jne @fehler
  jmp @ohnefehler
  @fehler:
   xchg ah,al
   mov EMSErrorcode,ax
  @ohnefehler:
end;
function EmsVersion:integer;
begin
 EMSErrorcode:=0;
 regs.ah:=$46;intr($67,regs);
 if regs.ah<>0 then
  begin EMSErrorcode:=regs.ah;EmsVersion:=EMSError;end
   else EmsVersion:=(regs.al and 15)+(regs.al shr 4)*10;
end;
procedure EmsSaveMap(handle:integer);
begin
 EMSErrorcode:=0;regs.ah:=$47;regs.dx:=handle;intr($67,regs);EmsErrorcode:=regs.ah;
end;
procedure EmsRestoreMap(handle:integer);
begin
 EMSErrorcode:=0;regs.ah:=$48;regs.dx:=handle;intr($67,regs);EmsErrorcode:=regs.ah;
end;
function EmsGetErrorText:string;
begin
 if EmsErrorcode=0 then EmsGetErrorText:='Alles OK' else
 if (EmsErrorcode<$80) or (EmsErrorcode>$8e) or (EmsErrorcode=$82) then EmsGetErrorText:='nicht definierter Code'
 else
  case EmsErrorcode of
   $80: EmsGetErrorText:='Fehler im EMS-Treiber!';
   $81: EmsGetErrorText:='Fehler in der EMS-Hardware!';
   $83: EmsGetErrorText:='Ungltiges EMM-Handle';
   $84: EmsGetErrorText:='Aufgerufene EMS-Funktion existiert nicht!';
   $85: EmsGetErrorText:='Keine freien EMS-Handles mehr verfgbar!';
   $86: EmsGetErrorText:='Fehler beim Sichern oder Restoren des Mappings!';
   $87: EmsGetErrorText:='Mehr Seiten angefordert, als physikalisch vorhanden!';
   $88: EmsGetErrorText:='Mehr Seiten angefordert, als noch frei sind!';
   $89: EmsGetErrorText:='Null Seiten angefordert!';
   $8a: EmsGetErrorText:='Logische Seite gehrt nicht zum Handle!';
   $8b: EmsGetErrorText:='Ungltige physikalische Seitennummer!';
   $8c: EmsGetErrorText:='Mapping-Speicherbereich ist voll!';
   $8d: EmsGetErrorText:='Sichern des Mapping wurde bereits durchgefhrt!';
   $8e: EmsGetErrorText:='Restoren ohne vorheriges Sichern versucht!';
  end;
end;

begin
 EMSISINSTALLED:=isemsinstalled;
end.

