UNIT introtpu;

INTERFACE

function _intro : boolean; { liefert true , wenn vollstndig durchlaufen
                                    false, wenn abgebrochen }


IMPLEMENTATION

USES crt,gfx,emmunit;

VAR virscr2, virscr3 :virtptr;
    vaddr2 , vaddr3  :word;

CONST FileName = 'Intro.DAT';
      startpic : array[1..3] of integer = ( 6844 , 19456 , 27034 );
      beenden  : boolean = false;
      pause    : boolean = false;

{Sternenflug}

const StarNo = 500; { 500 Sterne }

type Star3D = record
                x,y,z : integer;
              end;
     Star2D = record
                x,y : integer;
              end;
     Star2DArray = array[1..StarNo] of Star2D;

var Stars3D : array[1..StarNo] of Star3D;
    Stars2D : Star2DArray;
    Backup  : Star2DArray;
    ZAdd,n  : integer;

procedure InitStars;
var n : integer;
begin
  for n := 1 to StarNo do begin
    repeat
      Stars3D[n].x := random(640) - 320;
      Stars3D[n].y := random(400) - 200;
    until (Stars3D[n].x <> 0) and (Stars3D[n].y <> 0);
    Stars3D[n].z := random(StarNo);
  end;
end;

procedure Calc_2Dto3D;
var n : integer;
begin
  for n := 1 to StarNo do begin
    Stars2D[n].x := Stars3D[n].x * 128 div Stars3D[n].z + 160;
    Stars2D[n].y := Stars3D[n].y * 128 div Stars3D[n].z + 100;
  end;
end;

procedure DrawStars;
var n : integer;
begin
  for n := 1 to StarNo do
   if (Stars2D[n].x > 0) and (Stars2D[n].x < 320)
      and (Stars2D[n].y > 0) and (Stars2D[n].y < 200)
      and (Stars3D[n].z < 500)
          then mem[seg(virscr3^):Stars2D[n].y*320+Stars2D[n].x] :=
                                            63-Stars3D[n].z div 20;
end;

procedure ClearStars;
var n : integer;
begin
  for n := 1 to StarNo do
   if (Backup[n].x > 0) and (Backup[n].x < 320)
      and (Backup[n].y > 0) and (Backup[n].y < 200)
         then mem[seg(virscr3^):Backup[n].y*320+Backup[n].x] := 0;
end;

procedure MoveStars;
var n : integer;
begin
  for n := 1 to StarNo do begin
    inc(Stars3D[n].z,ZAdd);
    if Stars3D[n].z < 1 then inc(Stars3D[n].z,StarNo);
    if Stars3D[n].z > StarNo then dec(Stars3D[n].z,StarNo);
  end;
end;


{}
Procedure Init;
BEGIN
  setupvirtual;
  setmcga;
  getmem (virscr3,sizeof(virscr3^));
  getmem (virscr2,sizeof(virscr2^));
  vaddr3:=seg(virscr3^);
  vaddr2:=seg(virscr2^);
  cls (vaddr3,0);
  cls (vaddr2,0);
  cls (vaddr,0);
  loadPCX(0,FileName,pcx_,virScr);
END;

{}
Procedure Scale (x,y,w,h,origw,origh,source,dest:word); assembler;
  { This scales the picture to the size of w and h, and places the result
    at x , y. Origw and origh are the origional width and height of the
    bitmap. The bitmap must start at the beginning of a segment, with
    source being the segment value. The image is placed in screen at dest}
VAR jx,jy,depth,temp:word;
asm
  push  ds

  mov   ax,source
  mov   ds,ax
  mov   ax,dest
  mov   es,ax
  mov   depth,0
  dec   h

  xor   dx,dx
  mov   ax,origw
  shl   ax,6
  mov   bx,w
  div   bx
  shl   ax,2
  mov   jx,ax     { jx:=origw*256/w }

  xor   dx,dx
  mov   ax,origh
  shl   ax,6
  mov   bx,h
  div   bx
  shl   ax,2
  mov   jy,ax     { jy:=origh*256/h }

  xor   cx,cx
@Loop2 :          { vertical loop }
  push  cx
  mov   ax,depth
  add   ax,jy
  mov   depth,ax

  xor   dx,dx
  mov   ax,depth
  shr   ax,8
  mov   bx,origw
  mul   bx
  mov   temp,ax   { temp:=depth shr 8*origw;}


  mov   di,y
  add   di,cx
  mov   bx,di
  shl   di,8
  shl   bx,6
  add   di,bx
  add   di,x      { es:di = dest ... di=(loop1+y)*320+x }

  mov   cx,w
  xor   bx,bx
  mov   dx,jx
  mov   ax,temp
@Loop1 :          { horizontal loop }
  mov   si,bx
  shr   si,8
  add   si,ax     { ax = temp = start of line }

  movsb           { si=temp+(si shr 8) }
  add   bx,dx

  dec   cx
  jnz   @loop1    { horizontal loop }

  pop   cx
  inc   cx
  cmp   cx,h
  jl    @loop2    { vertical loop }

  pop   ds
end;

{}
Procedure Play;
VAR x, y, z, loop1, i :integer;
const time : integer = 85;
BEGIN
  randomize;            { Zufallsgenerator anwerfen }
  InitStars;            { Sternenarrays mit Werten fllen }
  ZAdd := -4;           { ZAdd initialisieren }
  z:=114;
  loop1:=1;
  for i:=1 to time do begin { erst mal fliegen }
    MoveStars;          { Sterne bewegen }
    Backup := Stars2D;  { Alte Sternpositionen sichern }
    Calc_2Dto3D;        { und neue berechnen }
    { WaitRetrace;        { Auf Retrace warten }
    ClearStars;         { Alte Sterne lschen }
    DrawStars;          { und neue zeichnen }
    if i<time-50 then begin
       delay(20);waitretrace; {knstliche verzgerung}
       flip (vaddr3, vga);
    end else
    begin
      dec (z,2);
      x:=16 shl 8 div z;
      y:=10 shl 8 div z; { Perspective transforms ... makes the zoom smoother }
      cls (vaddr2,0);
      scale (160-(x shr 1),100-(y shr 1),x,y,320,200,vaddr,vaddr2);
      copyflip (vaddr2,vaddr3,vga);
      inc(loop1);
    end;
    if keypressed then begin
                         readkey;
                         beenden:=true;
                         exit;
                        end;
  end;
END;

procedure part_1;
BEGIN
  init;
  play;
  setwhite;setblack;
  shutdown;
  freemem (virscr2,sizeof(virscr2^));
  freemem (virscr3,sizeof(virscr3^));
END;

{===========================================================================}
{                             P A R T   T W O                               }
{===========================================================================}

type TPCXHeader = record               { Header der PCX-Datei }
                    Manuf,Version,Encode,BitsPerPixel : byte;
                    X1,Y1,X2,Y2,Xres,Yres : integer;
                    Palette          : array[0..47] of byte;
                    VideoMode,Planes : byte;
                    BytesPerLine     : integer;
                    Reserved         : array[0..59] of byte;
                  end;
     PPCXPic = ^TPCXPic;
     TPCXPic = record
                 Header  : TPCXHeader;            { Der Header }
                 Palette : array[0..767] of byte; { Die Palette }
                 Pixels  : array[1..4] of integer;
                 { Das Bild, Screen 1-4 }
               end;

var PCX_ : TPCXPic;
    I    : longint;
    PCX  : string;
    name : 0..10;
    backupscr : pointer;
    namescr   : array[1..2] of pointer;
    mx, dirx,
    my, diry  : integer;
    EmsSeg: word;
    int_test: array[1..4] of integer;

const   dx : byte = 80;
        dy : byte = 100;

procedure SetModeX;assembler;
asm
  mov     ax,13h        { Zuerst den normalen Modus 13h per BIOS aktivieren }
  int     10h
  mov     dx,3C4h
  mov     al,4                         { TS-Register 4 anwhlen }
  out     dx,al
  inc     dx
  in      al,dx                        { Aktuellen Registerinhalt holen }
  and     al,0F7h                      { Bit 2 setzen, Bit 3 lschen }
  or      al,4
  out     dx,al                        { Werte zurckschreiben }
  dec     dx
  mov     ax,0F02h
  out     dx,ax                        { Alle Planes selektieren }
  mov     ax,0A000h                    { VGA-Segment nach ES }
  mov     es,ax
  xor     di,di
  xor     ax,ax
  mov     cx,0FFFFh
  cld
  rep     stosw                        { Bildschirm lschen }
  mov     dx,3D4h
  mov     al,14h                       { CRTC-Register 14h anwhlen }
  out     dx,al
  inc     dx
  in      al,dx                        { Aktuellen Registerinhalt holen }
  and     al,0BFh                      { Bit 6 lschen }
  out     dx,al
  dec     dx
  mov     al,17h                       { CRTC-Register 17h anwhlen }
  out     dx,al
  inc     dx
  in      al,dx
  or      al,40h                       { Bit 6 setzen }
  out     dx,al
end;

procedure XPutPixel(x,y:integer;col:byte);assembler;
asm
  mov     ax,0A000h                    { VGA-Segment nach ES }
  mov     es,ax
  mov     cx,x                         { X-Koord nach CX }
  and     cx,3                         { Plane bestimmen }
  mov     ax,1
  shl     ax,cl                        { Entsprechendes Bit setzen }
  mov     ah,al
  mov     dx,03C4h
  mov     al,2                         { Timing-Sequencer Reg. 2 anwhlen }
  out     dx,ax                        { Plane setzen }
  mov     ax,80                        { Pixel-Offset bestimmen }
  mul     y                            { Offset = y * 80 + x div 4 }
  mov     di,ax                        { y * 80 nach DI }
  mov     ax,x
  shr     ax,2                         { entspricht AX div 4 }
  add     di,ax                        { x div 4 dazuzhlen }
  mov     al,col                       { Farbe nach AL }
  mov     es:[di],al                   { Pixel setzen }
end;

procedure XSetStart(Adr:word);assembler;
asm
  mov     dx,3D4h
  mov     al,0Ch                       { CRTC-Register 0Ch }
  mov     ah,byte ptr Adr + 1          { Bits 15-8 abschicken }
  out     dx,ax
  mov     al,0Dh                       { CRTC-Register 0Dh }
  mov     ah,byte ptr Adr              { Bits 7-0 abschicken }
  out     dx,ax
end;

procedure XDouble;assembler;
asm
  mov     dx,3D4h                      { CRTC-Register 13h anwhlen }
  mov     ax,5013h                     { auf 80 setzen (doppelte Breite) }
  out     dx,ax
end;

procedure WaitRetrace;assembler;
asm
  mov     dx,3DAh
@l1:
  in      al,dx
  and     al,08h
  jz      @l1
@l2:
  in      al,dx
  and     al,08h
  jz      @l2
end;

{}
procedure LoadPCX320(FileName:string;var PCX:TPCXPic; ScrPtr : pointer;
                     no:byte ; Size: word );
          { Ldt PCX-Datei: 320 bytes per line}

var F            : file;
    Buf          : array[0..1024] of byte;
    BufPtr,Off   : word;
    Code,Count   : byte;

begin
  assign(F,FileName);
  reset(F,1);
  seek(F,startpic[no]);
  blockread(F,PCX.Header,sizeof(PCX.Header)); { Header einlesen }
  BufPtr := sizeof(Buf);
  Off := 0;                            { Offset in der PCX-Datei }
  while Off < Size do begin
    if BufPtr >= sizeof(Buf) then begin
      blockread(F,Buf,sizeof(Buf));    { Daten lesen }
      BufPtr := 0;
    end;
    Code := Buf[BufPtr];
    inc(BufPtr);
    if Code shr 6 = 3 then begin       { Dekomprimierung }
      Count := Code and 63;
      if BufPtr >= sizeof(Buf) then begin
        blockread(F,Buf,sizeof(Buf));
        BufPtr := 0;
      end;
      Code := Buf[BufPtr];
      inc(BufPtr);
      fillchar(mem[seg (ScrPtr^): ofs (ScrPtr^) +Off],Count,Code);
      inc(Off,Count);
    end
    else begin
      mem[seg (ScrPtr^): ofs (ScrPtr^) +Off] := Code;
      inc(Off);
    end;
  end;
  if BufPtr >= sizeof(Buf) then begin
    blockread(F,Buf,sizeof(Buf));
    BufPtr := 0;
  end;
  Code := Buf[BufPtr];
  inc(BufPtr);
  if Code = 12 then begin
    for Off := 0 to 767 do begin
      if BufPtr >= sizeof(Buf) then begin
        blockread(F,Buf,767-Off);
        BufPtr := 0;
      end;
      PCX.Palette[Off] := Buf[BufPtr];
      inc(BufPtr);
    end;
  end;
  close(F);
end;

{ Ldt 640*400 PCX-Datei }
procedure LoadPCX640(FileName:string);
var F                : file;
    Buf              : array[0..1024] of byte;
    BufPtr           : word;
    Off,Memoff,diff  : longint;
    Size             : longint;
    Code, Count, Scr : byte;
    test: word;  bed : byte;

begin
  bed:=1;
  assign(F,FileName);
  reset(F,1);
  seek(F,startpic[3]);
  blockread(F,Pcx_.Header,sizeof(Pcx_.Header));      { Header einlesen }
  for SCR:=1 to 4 do int_test[SCR]:=EmsAlloc(4);     { EMS belegen}
  emsmap4(int_test[1],0,1,2,3);                      { mappen }
  BufPtr := sizeof(Buf);
  Off := 0;                            { Offset in der PCX-Datei }
  Memoff:=0;
  Size:=640*400;
  while Off < Size do begin
    if BufPtr >= sizeof(Buf) then begin
      blockread(F,Buf,sizeof(Buf),test);    { Daten lesen }
      BufPtr := 0;
    end;
    Code := Buf[BufPtr];
    inc(BufPtr);
    if Code shr 6 = 3 then begin       { Dekomprimierung }
      Count := Code and 63;
      if BufPtr >= sizeof(Buf) then begin
        blockread(F,Buf,sizeof(Buf),test);
        BufPtr := 0;
      end;
      Code := Buf[BufPtr];
      inc(BufPtr);
      SCR:=trunc(off/64000)+1;
      if count+memoff>=64000 then
      begin
       fillchar(mem[EmsSeg:MemOff],64000-memoff,Code);
       emsmap4(int_test[scr+1],0,1,2,3);
       fillchar(mem[EmsSeg:0],Count-(64000-memoff),Code);
      end else
       fillchar(mem[EmsSeg:MemOff],Count,Code);
      inc(Off,Count);
      SCR:=trunc(off/64000)+1;
    {  if odd(trunc(OFF/1000)) then writeln('scr ',scr,'   mem ',memoff,'   off ',off,'   count ',count);
    }  case SCR of
           1 : diff:=0;
           2 : diff:=64000;
           3 : diff:=128000;
           4 : diff:=192000;
       end;
      MemOff:=Off-diff;
    end
    else begin
      mem[EmsSeg:MemOff] := Code;
      inc(Off);
      if memoff<63999 then inc(memoff) else
      begin
       memoff:=0;
       emsmap4(int_test[scr+1],0,1,2,3);
      end;
    end;
  end;
  if BufPtr >= sizeof(Buf) then begin
    blockread(F,Buf,sizeof(Buf),test);
    BufPtr := 0;
  end;
  Code := Buf[BufPtr];
  inc(BufPtr);
  if Code = 12 then begin
    for Off := 0 to 767 do begin
      if BufPtr >= sizeof(Buf) then begin
        blockread(F,Buf,767-Off,test);
        BufPtr := 0;
      end;
      Pcx_.Palette[Off] := Buf[BufPtr];
      inc(BufPtr);
    end;
  end;
  close(F);
end;

procedure ShowPCX;
var Memoff        : longint;
    Code, Pl, Scr : byte;
    x,y : integer;
begin
  setmodex;                            { Mode-X setzen }
  xdouble;                             { 160-Byte Modus einschalten }
  port[$3C8] := 0;                     { Palette schwarz setzen }
  for I := 0 to 767 do Port[$3C9] := 0;
  y:=0;
{ 1. scr holen}
  for scr:=1 to 4 do
  begin
    emsmap4(int_test[scr],0,1,2,3);
    x:=0;
    for MemOff:=0 to 63999 do
     begin
       xputpixel(x,y,mem[EmsSeg:MemOff]);
       inc(x);if x=320 then begin
                              inc(y);
                              x:=0;
                            end;
     end;
  end;
  for I := 0 to 767 do PCX_.Palette[I] := PCX_.Palette[I] shr 2;
end;

function fadeing(dc, typ : shortint; lc: byte) : integer;
          { dc = -1 fr dunkler, dc = +1 fr heller
            typ= 0 fr Farbpalette, = -1 fr Schwarz , = +1 fr Wei
            lc = LastColors (unvernderte Farben)}
var col1,col2,col3 : byte;
    counter, bed   : integer;
    bed1,bed2,bed3 : boolean;
    Palette : array[0..767] of byte;
begin
  if typ=-1 then for I := 0 to 767-3*lc do Palette[I] := 0;
  if typ=00 then for I := 0 to 767-3*lc do Palette[I] := PCX_.Palette[I];
  if typ=+1 then for I := 0 to 767-3*lc do Palette[I] := 63;
  bed:=lc;  counter:=0;
  for I:=0 to 255-lc do begin
    getPal(I,col1,col2,col3);
    bed1:=false; bed2:=false; bed3:=false;
    if col1 = Palette[counter] then bed1:=true else inc(col1,dc);
    if col2 = Palette[counter+1] then bed2:=true else inc(col2,dc);
    if col3 = Palette[counter+2] then bed3:=true else inc(col3,dc);
    inc(counter,3);
    pal(I,col1,col2,col3);
    if bed1 and bed2 and bed3 then inc(bed);
  end;
  fadeing:=bed;
end;

procedure paint(dx,dy:integer; name:byte);
 var no, col, count_x : byte;
     memof   : longint;
     memoff2 : integer;
 const memoff     : array[1..12] of longint = (0,15999,160,16160,32000,
                                               32160,0,16000,162,16160,
                                               48000,48160 );
 begin
   memof:=memoff[name];
   memoff2:=161;
   count_x:=1;
   case name of       { select namesrc}
        1..6 : no:=1;
        7..10: no:=2;
        11,12: no:=1;
   end;
   for memof:=memoff[name] to memoff[name]+15999 do begin
     col:=mem[seg(namescr[no]^):ofs(namescr[no]^)+memof];
     if (col>0) and (col<>255) then begin
                     mem[seg(backupscr^):ofs(backupscr^)+memoff2]:=col+248;
                     mem[seg(backupscr^):ofs(backupscr^)+memoff2+160]
                                                                 :=col+248;
                   end;
     inc(memoff2);
     if count_x=160 then begin
                           inc(memof,160);
                           inc(memoff2,160);
                           count_x:=0;
                         end;
     inc(count_x);
   end;
 end;

procedure backup2(coord_x,coord_y : integer);
 var Scr : 1..4; col , jump : byte;
     memoff, memoff_2     : longint;
     x1, y1 : integer;
     altscr: 1..4;
 begin
   memoff:=0;
   emsmap4(pcx_.pixels[(coord_y div 100)+1],0,1,2,3);
   for y1:=coord_y to coord_y+99 do begin
     altscr:=scr;
     scr:=1+(y1 div 100);
     if scr<>altscr then emsmap4(int_test[scr],0,1,2,3);
     for x1:=coord_x to coord_x+159 do begin
       col:=mem[EmsSeg:(y1 mod 100)*640+x1];
       mem[seg(backupscr^):ofs(backupscr^)+memoff]:=col;
       inc(memoff);
      end;
    end;
 end;

procedure sort_plane;
var viroff, memoff : integer;
begin
  getmem(virscr2,16000);
  memoff:=0;
  for viroff:=0 to 3999 do
  begin
    mem[seg(virscr2^):ofs(virscr2^)+virOff]:=
      mem[seg(backupscr^):ofs(backupscr^)+MemOff];
    mem[seg(virscr2^):ofs(virscr2^)+4000+virOff]:=
      mem[seg(backupscr^):ofs(backupscr^)+MemOff+1];
    mem[seg(virscr2^):ofs(virscr2^)+8000+virOff]:=
      mem[seg(backupscr^):ofs(backupscr^)+MemOff+2];
    mem[seg(virscr2^):ofs(virscr2^)+12000+virOff]:=
      mem[seg(backupscr^):ofs(backupscr^)+MemOff+3];
    inc(memoff,4);
  end;
  move(mem[seg(virscr2^):ofs(virscr2^)],
       mem[seg(backupscr^):ofs(backupscr^)],16000);
  freemem(virscr2,16000);
end;

procedure restore(coord_x,coord_y : integer; name : byte );
 var count, count_y, plane : byte;
     memoff : longint;
     off : integer;
 begin
   backup2(coord_x,(coord_y shr 1));
   if not pause then paint((coord_x),(coord_y),name);  { Namen darstellen }
   sort_plane;  { nach PlaneNo umsortieren zur schnelleren Darstellung }
   plane:=1;
   off:=0;
   memoff:=coord_y*80+(coord_x shr 2);
   waitretrace;
   XSetStart(my*160+mx);            { Neue Startadresse setzen }
   for count:=1 to 4 do
   begin
     asm
      mov     ah,plane                  { PlaneNo bergeben }
      mov     dx,03C4h
      mov     al,2                      { Timing-Sequencer Reg. 2 anwhlen }
      out     dx,ax                     { Plane setzen }
      shl  plane,1                      { nchste Plane anwhlen }
     end;
     for count_y:=0 to 99 do
     begin
        move(mem[seg(backupscr^):ofs(backupscr^)+off],
             mem[$A000:memoff+count_y*160],40);
        inc(off,40);
     end;
   end;;
 end;

procedure part_2;
const stop : boolean = false;
var   step : integer;
begin
  EmsSeg:=EmsFrameSeg;
  getmem(backupscr,16000);
  getmem(namescr[1],64000);
  getmem(namescr[2],32000);
  LoadPCX320(Filename,PCX_,namescr[1],1,64000);
  LoadPCX320(Filename,PCX_,namescr[2],2,32000);
  LoadPCX640(Filename);
  { PCX-Datei laden }
  ShowPCX;                             { Speicher 2 $A000 }
  name:=1;
  step:=0;
  mx := 1;                              { Startposition }
  my := 1;
  dirx := 1;
  diry := 1;
  repeat
    if (name<3) then if fadeing(1,0,0)<256 { fadeing in}
       then XSetStart(my*160+mx);    { Neue Startadresse setzen }
    inc(mx,dirx);                    { Bildausschnitt weiterbewegen }
    inc(my,diry);
    restore(4*mx+dx,2*my+dy,name);   { Bildausschnitt neu setzen }
    inc(step);
    if (mx = 80) or (mx = 1) then dirx := -dirx;
    if (my = 200) or (my = 1) then diry := -diry;
    { Richtung umkehren, wenn am Rand angekommen }
    if step=315 then pause:=true { leerlauf } else
        if (step mod 35 = 0 ) and (name<12)  then begin
                                                    inc(name);
                                                    pause:=false;
                                                  end;
    if name>10 then if fadeing(-1,-1,9)=256 then stop:=true;
  until stop or keypressed;
  if keypressed then begin
                       readkey;
                       beenden:=true;
                     end;
  for I:=1 to 4 do emsdealloc(int_test[I]);
  freemem(namescr[1],64000);
  freemem(namescr[2],32000);
  freemem(backupscr,16000);
  asm mov ax,3; int 10h end;
end;

function _intro : boolean;
begin
 part_1;
 if not beenden then part_2;
 if beenden=true then _intro:=false else _intro:=true;
end;

begin
end.
