program vesaview;

uses crt,dos,emmunit,file_ops,setup2u,viewer1u,voter_1,mousetpu;

{ntige types}
type red_book=record leer,min,sec,fra:byte;end;
type trackinfo=record audio:boolean;start,zeit,ende:red_book;end;
type farben=array[0..999]of byte;
     vesainfo_datablock0=record
       signa:array[0..3] of byte;major_v,minor_v:byte;hersteller:pointer;l_flag:array[0..1]of word;modis:pointer;
      end;
     vesainfo_freeblock0=array[0..255]of byte;
     vesainfo_datablock1=record
       modusflag:word;
       f_win1,f_win2:byte;
       granu,winsize,segm1,segm2:word;
       far_rout:pointer;
       byte_per_line,x_points,y_points:word;
       breit_matrix,hoehe_matrix,bit_planes,bit_per_point,anz_bloecke,speichermodell,groesse_bloecke:byte;
      end;
     font_typ=array[0..110,0..9,0..7]of byte;
     quad_type=record x1,y1,x2,y2:word;end;
     menu_button_type=record
                         anz:byte;
                         but:array[0..6,0..1]of string[38];
                         viewer:array[0..6]of byte;
                      end;
     menu_side_type=array[0..7] of menu_button_type;
     menu_text_type=array[0..6]of menu_side_type;
     list_entry=record name:string[12];addr,size:longint;end;

     cfg=record
       player_used:byte;
       soundcard:record
         card:byte;
         port:word;
         irq,dma:byte;
         rate:word;
        end;
      end;
     save_field=record
       player_cfg:cfg;used_vol:word;
       module:record
         mod_select:string[8];
         mod_dir:string[255];
         mod_status:byte;
        end;
       cd:record
         tracks:array[1..99]of trackinfo;
         playlist:record mode:byte;anz:byte;track:array[1..99]of byte;end;
         shuffle_on:boolean;
         program_on:boolean;
         introscan_on:boolean;
         introscan_art:byte;
         repeat_mode:byte;
         index:byte;
        end;
      end;
     block_type=array[0..325]of array[0..3]of byte;
     font_type=record
       table:array[0..255]of byte;
       data:font_typ;
      end;
     pageindi_type=array[0..1,0..22,0..59]of byte;
     opt_switch_type=array[0..1,0..19,0..19]of byte;
     timefont_type=array[0..10,0..14,0..8]of byte;
     tm_type=record a:menu_side_type;b:array[0..{3}5,0..1]of string[38];end;


{game-type/const}
type  gamefield=array[0..2,0..2]of byte;
const set_stone=0;
      exit_game=1;
      new_game=2;
      nothing=$ff;

      player_col=1;
      comp_col=2;

{ende game-type/const}


const bkg_pic='std_bacr.crp';
      side_pic:array[0..6]of string[12]=
       ('sidepic1.crp','sidepic5.crp','sidepic2.crp','sidepic3.crp','sidepic4.crp','sidepic6.crp','sidepic7.crp');
      red_add=10;green_add=3;blue_add=0;
      text_norm_col=40+192;
      text_mark_col=50+192;
      text_head_col=47+192;
      textside:array[0..6]of byte=(0,1,0,1,0,1,0);
      sm_left_char=166;
      sm_right_char=167;
      digits_zero=170;
      do_exit_menu=0;
      do_openclose_button=1;
      do_scroll_page_left=2;
      do_scroll_page_right=3;
      do_read_text=4;
      do_open_optmenu=5;
      do_options=6;
      do_voter=7;
      do_exit_menu_imm=8;
      do_open_game=9;
      do_search=10;
      do_nothing=$FFFF;

var regs:registers;
    debug_on:boolean;ft:text;
    menu_heap_start_ptr,menu_heap_start_ptr2:Pointer;
    i,x,y,handle,start:word;
    header:^farben;
    aktwin_byte,secwin_byte,granu_diff:byte;
    winstat,two_pages:word;
    aktwin_diff:longint;
    taste:char;
    aktpal,zielpal,origpal:^farben;
    modi_nr:byte;
    pb:^byte;
    datenbl:^vesainfo_datablock0;
    datenbl2:vesainfo_datablock1;
    p_datenblock:vesainfo_freeblock0;
    modi_liste:array[0..40] of word;
    modex_1,modex_2,modex_3,modex_4:byte;
    save_block,data_block:^block_type;
    blockmover_x:word;
    pagescroller_data:array[0..3,0..7,0..3] of byte;
    aktwin_side,aktpage,aktbut,aktsbut,submenu_active,optmenu_active:byte;
    font:^font_type;
    cutx,control_fkt:word;
    unmark_on:boolean;
    exit_addy:^byte;

    {packer-vars}

    packstring1,packstring2:string;
    lastpixel,aktpixel,aktwin_depack:byte;
    d_offset,d_segment:word;
    depack_ptr:pointer;
    fileseg,fileofs,packed_read:word;
    file_ptr:pointer;
    pixel_set,packed_size:longint;

    {mouse-vars}

    mouse,submouse:record
      altmx,altmy,mousex,mousey,mset:word;
     end;
    mousemoved:word;
    mouse_shape,backmouse:array[0..143]of byte;
    mousebut,altmbut,altmx,altmy,mousex,mousey,mousearea:word;
    event_status,mouseset:byte;
    button_pos:array[0..1,0..7]of quad_type;
    spec_but:array[0..7]of quad_type;
    button_dat:record firstbut,lastbut,butside,lm:byte;end;
    open_sm_kind,pageindi_set:byte;
    pageindi:^pageindi_type;
    options_switch:^opt_switch_type;
    time_font:^timefont_type;
    tm:^tm_type;
    text_2_read:record page,but,sbut:byte;end;
    alttime_set,time_set:record hour,min,sec:byte;end;
    clear_time_seg,clear_time_ofs:word;clear_time_ptr:array[0..99]of byte;

    {game-vars}

    emsseg:word;
    field:gamefield;
    gfx,gfy,feldwert,won,right_choice,modus,gameside:byte;
    board_cross,board_circle,board_orig,board_cr2,board_ci2,headline:emshandle;
    du:boolean;
    gamefont:array[0..9,0..52]of byte;
    games_won,altwon,games_lost,altlost,games_patt,altpatt,intell,altintell:word;

    {loader-vars}

    liste:file of list_entry;
    offset_add:longint;
    fileoffset:longint;
    entry:list_entry;entry_anz:word;
    filegroesse:longint;
    datafilehandle:word;

    {player-vars}

    setup:^save_field;
    f_setup:file of save_field;
    player:record
      module,altmodule:pointer;
      player_started:boolean;
      error_text:string;
     end;
    max_mod_size:longint;
    mark_them:array[0..10]of pointer;
    heap:pointer;
    alpha:array[0..255]of byte;
    savemap:array[0..8191]of byte;

const lamp_on=1;
      lamp_off=0;
var   lamp:record t,s:array[0..5]of byte;next:byte;end;

procedure setgranu_faktor(granu:word);far;external;
procedure moveaktwin(hw:word);far;external;
function  getwinbyte(x,y:word):byte;far;external;
function getaktwinbyte:byte;far;external;
procedure vputpixel(x,y,f:word);far;external;
function  vgetpixel(x,y:word):byte;far;external;
procedure vputpixel_woc(x,y,f:word);far;external;
function  vgetpixel_woc(x,y:word):byte;far;external;
procedure vputpixel_virt(x,y,f,segm:word);far;external;
function  vgetpixel_virt(x,y,segm:word):byte;far;external;
procedure vputblock(start,anz,segm,offs:word);far;external;
procedure vgetblock(start,anz,segm,offs:word);far;external;
procedure vputvirtblock(x,y,anz,segm,offs:word);far;external;
procedure vputvirtblock_trans(tc,x,y,anz,segm,offs:word);far;external;
procedure vgetvirtblock(x,y,anz,segm,offs:word);far;external;
procedure vcopy_woc(anz_dw,seg1,ofs1,seg2,ofs2:word);far;external;
procedure vcopy_screen_2_mem(anz_lines,ofs1,seg2,ofs2:word);far;external;
procedure vcopy_mem_2_screen(anz_lines,seg1,ofs1,ofs2:word);far;external;
procedure vcopy_mem_2_mem(anz_lines,seg1,ofs1,seg2,ofs2:word);far;external;
procedure vcopy_mem(anz_bytes,seg1,ofs1,seg2,ofs2:word);far;external;
procedure vcopy_s_and(anz_lines,seg1,ofs1,ofs2,ofs_m:word);far;external;
procedure vcopy_s_bkg(anz_lines,ofs1:word;col_dw:word);far;external;
procedure vputmouse(x,y,mp_seg,mp_ofs,bp_seg,bp_ofs:word);far;external;
procedure vclearmouse(x,y,bp_seg,bp_ofs:word);far;external;
procedure vscroll_mem(seg,ofs,anz,rot:word);far;external;

{$l vesaview.obj}
procedure clear_key_buffer;
var taste:char;
begin
 while keypressed do taste:=readkey;
end;
procedure write_debug(t:string;n:longint);
var lt:string;e:integer;
begin
 if not (debug_on) then exit;
 if n>0 then
  begin
   write(ft,t);
   str(n,lt);
   writeln(ft,lt);
  end
 else
  begin
   writeln(ft,t);
  end;
end;

procedure initdatafile(name:string);
begin
 datafilehandle:=openfile(name);
 if datafilehandle<>$ffff then readfile(datafilehandle,sizeof(offset_add),@offset_add);
 entry_anz:=offset_add div sizeof(entry);
end;
procedure deinitdatafile;
begin
 closefile(datafilehandle);
end;
procedure getoffset(name:string);
var i:byte;s:word;
begin
 seekfile(datafilehandle,0,4);s:=0;
 for i:=1 to length(name) do name[i]:=upcase(name[i]);
 repeat
  readfile(datafilehandle,sizeof(entry),@entry);inc(s);
  for i:=1 to length(entry.name) do entry.name[i]:=upcase(entry.name[i]);
 until (entry.name=name)or(s=entry_anz);
 if entry.name=name then
  begin
   fileoffset:=entry.addr+offset_add;
   filegroesse:=entry.size;
  end
 else
  begin
   textmode(co80);
   writeln('File nicht gefunden :',name);
   halt;
  end;
end;

procedure v_openfile(name:string);
begin
 initdatafile('data.dat');
 getoffset(name);
 seekfile(datafilehandle,0,fileoffset);
end;
procedure v_closefile;
begin
 deinitdatafile;
end;
procedure v_readfile(anz:word;po:pointer);
begin
 readfile(datafilehandle,anz,po);
end;
procedure v_readfile_p1(anz:word;po:pointer);
var locptr:pointer;
begin
 readfile(datafilehandle,anz,po);
 locptr:=ptr(seg(po^),ofs(po^)+anz);
 readfile(datafilehandle,1,locptr);
end;
procedure v_seekfile(pos:longint);
begin
 seekfile(datafilehandle,0,fileoffset+pos);
end;
function v_getfilesize(name:string):longint;
var d:longint;
begin
 d:=getfilepos(datafilehandle);
 seekfile(datafilehandle,0,4);
 for i:=1 to length(name) do name[i]:=upcase(name[i]);
 repeat
  readfile(datafilehandle,sizeof(entry),@entry);
  for i:=1 to length(entry.name) do entry.name[i]:=upcase(entry.name[i]);
 until entry.name=name;
 v_getfilesize:=entry.size;
 seekfile(datafilehandle,0,d);
end;

procedure get_modi(po:pointer);
var count:byte;pw:^word;
begin count:=0;repeat pw:=ptr(seg(po^),ofs(po^)+count);modi_liste[count div 2]:=pw^;inc(count,2);until pw^=$ffff;
 modi_nr:=count div 2;
end;
function get_granu_faktor(granu_kb:byte):byte;
var granu:word;count:byte;
begin
 if granu_kb=64 then get_granu_faktor:=16
 else
  begin
   granu:=granu_kb*1024;count:=0;
   if granu>1 then
    begin
     repeat asm shr granu,1;inc count;end;until granu=1;get_granu_faktor:=count;
    end else get_granu_faktor:=1;
  end;
end;

procedure get_Vesa_info;
begin
 datenbl:=addr(p_datenblock);regs.ah:=$4f;regs.al:=0;regs.es:=seg(p_datenblock);regs.di:=ofs(p_datenblock);intr($10,regs);
end;
procedure get_modi_info(modus:word);
begin
 regs.ah:=$4f;regs.al:=1;regs.cx:=modus;regs.es:=seg(datenbl2);regs.di:=ofs(datenbl2);intr($10,regs);
end;

function vesa_info1:boolean;
const liste:string[4]='VESA';
begin
 get_vesa_info;for i:=0 to 3 do if (chr(datenbl^.signa[i]))<>liste[i+1] then begin vesa_info1:=false;exit;end;
 get_modi(datenbl^.modis);vesa_info1:=true;
end;

procedure setwritemode(mode:byte);assembler;
asm
 mov dx,$3ce;mov ax,$0005;out dx,al;inc dx;in al,dx;
 mov ah,al;and ah,252;mov cl,mode;and cl,3;add ah,cl;dec dx;mov al,$05;out dx,ax;
end;
procedure setreadmode(mode:byte);assembler;
asm
 mov dx,$3ce;mov ax,$0005;out dx,al;inc dx;in al,dx;
 mov ah,al;and ah,247;mov cl,mode;and cl,1;shl cl,4;or ah,cl;dec dx;mov al,$05;out dx,ax;
end;

function check4vesa:boolean;
var du:boolean;
begin
 du:=false;
 if vesa_info1 then
  begin
   for i:=0 to modi_nr do
    if modi_liste[i]=$101 then begin get_modi_info($101);du:=true;
    if odd(datenbl2.f_win2) then two_pages:=1 else two_pages:=0;
   end;
  end;
 check4vesa:=du;
end;

procedure initvesamode;
begin
 if vesa_info1 then
  begin
   for i:=0 to modi_nr do if modi_liste[i]=$101 then get_modi_info($101);
   if odd(datenbl2.f_win2) then two_pages:=1 else two_pages:=0;
  end
 else begin writeln('Keine VESA-Karte gefunden!');halt;end;
 regs.ax:=$4f02;regs.bx:=$101;intr($10,regs);
 granu_diff:=get_granu_faktor(datenbl2.granu);
end;

procedure vbl;assembler;
asm
 mov dx,$3da
 @wait1:in al,dx;test al,$8;jnz @wait1
 @wait2:in al, dx;test al,$8;jz @wait2
end;

{mouse-routs}
{Beginn der Mausroutinen}
{$f+}
procedure new_event_handler;assembler;
asm
 pusha
 push ds
 push ax
 mov ax,seg mousebut
 mov ds,ax
 cmp event_status,2
 je @aktiv
 shl event_status,1
 mov ax,mousebut
 mov altmbut,ax
 mov mousex,cx;
 mov mousey,dx;
 mov mousebut,bx
 mov mousemoved,1
 shr event_status,1
 @aktiv:
 pop ax
 pop ds
 popa
end;
{$f-}

function get_event_adress:pointer;
begin
 get_event_adress:=addr(new_event_handler);
end;

procedure init_new_event_handler(addy:pointer);assembler;
asm
 pusha

 les dx,addy
 mov ax,$000c
 mov cx,31
 int $33
 popa
end;
procedure mouse_setpos(mx,my:word);assembler;
asm
 mov ax,4
 mov cx,mx
 mov dx,my
 int $33
 mov cx,mx
 mov mousex,cx
 mov cx,my
 mov mousey,cx
end;
procedure mouse_getpos;assembler;
asm
 mov ax,3
 int $33
 mov mousex,cx
 mov mousey,dx
end;
procedure initmousearea1;assembler;
asm
 mov ax,7;mov cx,0;mov dx,628;int $33                               {hoizontal}
 mov ax,8;mov cx,105;mov dx,468;int $33                             {vertikal}
 cmp mouse.mset,1
 je @init1
 mov ax,4;mov cx,320;mov mousex,cx;mov dx,120;mov mousey,dx;int $33 {mousepos}
 @init1:
 mov mousearea,0
end;
procedure initmousearea2(side:byte);assembler;
asm
 cmp side,0
 jne @rechte_seite
 mov ax,7;mov cx,327;mov dx,628;int $33                              {hoizontal}
 mov ax,8;mov cx,105;mov dx,419;int $33                              {vertikal}
 cmp mouse.mset,1
 je  @init1
 mov ax,4;mov cx,350;mov mousex,cx;mov dx,150;mov mousey,dx;int $33  {mousepos}
 @init1:
 mov mousearea,1
 jmp @ende_im2
 @rechte_seite:
  mov ax,7;mov cx,0;mov dx,302;int $33                                {hoizontal}
  mov ax,8;mov cx,105;mov dx,419;int $33                              {vertikal}
  cmp mouse.mset,1
  je  @init2
  mov ax,4;mov cx,288;mov mousex,cx;mov dx,150;mov mousey,dx;int $33  {mousepos}
  @init2:
  mov mousearea,1
 @ende_im2:
end;
procedure initmousearea(area,side:byte);
begin
 if area=0 then initmousearea1 else initmousearea2(side);
 if mouse.mset=1 then begin mouse.mset:=0;end;
end;

procedure plotmouse;
var x,y:word;b,m:byte;
begin
 if mouseset=1 then exit;
 mouseset:=1;
 altmx:=mousex;altmy:=mousey;
 m:=getwinbyte(altmx,altmy);
 if m=getwinbyte(altmx+11,altmy+11) then
  begin
   if getaktwinbyte<>m then moveaktwin(m);
   vputmouse(altmx,altmy,seg(mouse_shape),ofs(mouse_shape),seg(backmouse),ofs(backmouse));
  end
 else
  begin
   for y:=altmy to altmy+11 do for x:=altmx to altmx+11 do
    begin
     backmouse[(y-altmy)*12+(x-altmx)]:=vgetpixel(x,y);
     b:=mouse_shape[(y-altmy)*12+(x-altmx)];if b>0 then vputpixel(x,y,b);
    end;
  end;
end;
procedure clearmouse;
var x,y:word;m:byte;
begin
 if mouseset=0 then exit;
 mouseset:=0;
 m:=getwinbyte(altmx,altmy);
 if m=getwinbyte(altmx+11,altmy+11) then
  begin
   if m<>getaktwinbyte then moveaktwin(m);
   vclearmouse(altmx,altmy,seg(backmouse),ofs(backmouse));
  end
 else
  for y:=altmy to altmy+11 do for x:=altmx to altmx+11 do vputpixel(x,y,backmouse[(y-altmy)*12+(x-altmx)]);
end;

{ende der mouse-routs}

procedure setorigpal;
begin
 move(header^,aktpal^,1000);move(aktpal^,origpal^,1000);
 regs.ax:=$1012;regs.bx:=0;regs.cx:=256;regs.es:=seg(header^[0]);regs.dx:=ofs(header^[0]);intr($10,regs);
end;
procedure setblack;
begin
 fillchar(aktpal^,1000,0);
 regs.ax:=$1012;regs.bx:=0;regs.cx:=256;regs.es:=seg(aktpal^);regs.dx:=ofs(aktpal^);intr($10,regs);
end;
procedure make_bw(palptr:pointer;start,ende:word;art:byte);
const highest_color=20;
var locpal:^farben;i:byte;quer:byte;highest_grey,grey_diff,percent:byte;
begin
 if art=0 then
  begin locpal:=palptr;highest_grey:=0;
   for i:=start to ende do
    begin quer:=trunc(aktpal^[i*3]*0.3+aktpal^[i*3+1]*0.49+aktpal^[i*3+2]*0.21+0.5);
     if quer>highest_grey then highest_grey:=quer;fillchar(locpal^[i*3],3,quer);end;
  end
 else
  begin locpal:=palptr;highest_grey:=0;
   for i:=start to ende do
    begin quer:=trunc(locpal^[i*3]*0.3+locpal^[i*3+1]*0.49+locpal^[i*3+2]*0.21+0.5);
     if quer>highest_grey then highest_grey:=quer;fillchar(locpal^[i*3],3,quer);end;
  end;
 if highest_grey>highest_color then
  begin
   percent:=trunc(100*highest_color/highest_grey);
   for i:=start to ende do
    begin
     quer:=trunc(locpal^[i*3]*percent/100);
     locpal^[i*3+0]:=quer+red_add;locpal^[i*3+1]:=quer+green_add;locpal^[i*3+2]:=quer+blue_add;
    end;
  end;
end;

procedure setpal;assembler;
asm
 cli;mov cx,768;push ds;push si;lds si,aktpal;mov dx,$3c8;xor al,al;out dx,al;inc dx;rep outsb;pop si;pop ds;sti;
end;
procedure setcolor(c,r,g,b:byte);assembler;
asm
 mov dx,$3c8;mov al,c;out dx,al;inc dx;
 mov al,r;out dx,al;
 mov al,g;out dx,al;
 mov al,b;out dx,al;
end;
procedure setpal_z;assembler;
asm
 cli;
  mov cx,768;
  push ds;push si;
   lds si,zielpal;mov dx,$3c8;xor al,al;out dx,al;inc dx;rep outsb;
  pop si;pop ds;
 sti;
end;

procedure fade_to_step1(zielpal:pointer);
var pal1:^farben;diff:integer;
begin
 pal1:=zielpal;
 for i:=0 to 767 do
  begin
   diff:=pal1^[i]-aktpal^[i];
   if diff>=2 then inc(aktpal^[i],2)
   else if (0-diff)>=2 then dec(aktpal^[i],2)
   else aktpal^[i]:=pal1^[i];
  end;
 vbl;setpal;
end;
procedure fade_to_step1_s(zielpal:pointer;step:byte);
var pal1:^farben;diff:integer;
begin
 pal1:=zielpal;
 for i:=0 to 767 do
  begin
   diff:=pal1^[i]-aktpal^[i];
   if diff>=step then inc(aktpal^[i],step)
   else if (0-diff)>=step then dec(aktpal^[i],step)
   else aktpal^[i]:=pal1^[i];
  end;
 vbl;setpal;
end;
procedure fade_to_all(pa1:pointer;schritt:byte);
var fade_groesste,i,j:word;diff:integer;pal1:^farben;
begin
 fade_groesste:=64 div schritt;pal1:=pa1;
 for j:=0 to fade_groesste do
  begin
   for i:=0 to 767 do
    begin
     diff:=pal1^[i]-aktpal^[i];
     if diff>=schritt then inc(aktpal^[i],schritt)
     else if (0-diff)>=schritt then dec(aktpal^[i],schritt)
     else aktpal^[i]:=pal1^[i];
    end;
   vbl;setpal;
  end;
end;

procedure init_fadeout(start,ende:byte);
begin
 move(aktpal^,zielpal^,768);
 fillchar(zielpal^[start*3],(ende-start+1)*3,0);
end;

{game-rout}
procedure put_digit(x1,y1:word;d:byte);
const leer:array[0..6]of byte=(146,146,146,146,146,146,146);
var y:word;
begin
 moveaktwin(1);
 if d=$ff then
  for y:=y1 to y1+6 do vputvirtblock(x1,y,5,seg(leer),ofs(leer))
 else
  for y:=y1 to y1+6 do vputvirtblock(x1,y,5,seg(gamefont[d,(y-y1)*7]),ofs(gamefont[d,(y-y1)*7]));
end;
procedure putcount(x1,y1,c:word;d:byte);
var upline,x,y:word;m:byte;
begin
 m:=mouseset;if m>0 then clearmouse;
 if d=1 then upline:=1;if d=2 then upline:=10;if d=3 then upline:=100;if d=4 then upline:=1000;if d=5 then upline:=10000;
 y:=y1;x:=x1;
 while (c<upline) and (upline>1) do
  begin put_digit(x,y,$ff);inc(x,7);upline:=upline div 10;end;
 repeat
  put_digit(x,y,(c div upline));
  inc(x,7);c:=c mod upline;
  upline:=upline div 10;
 until upline=0;
 if m>0 then plotmouse;
end;

procedure show_headline;
var x,y:word;
begin
 if gameside=0 then
  begin
   moveaktwin(1);emsmap(headline,0,0);
   for y:=105 to 143 do vputvirtblock(0,y,313,emsseg,(y-105)*314);
   for y:=144 to 204 do vputvirtblock(0,y,313,emsseg,(39)*314);
   moveaktwin(2);
   for y:=205 to 306 do vputvirtblock(0,y,313,emsseg,(39)*314);
   vputvirtblock(0,307,127,emsseg,(39)*314);
   moveaktwin(3);
   vputvirtblock(128,307,185,emsseg,(39)*314);
  end;
 if gameside=1 then
  begin
   moveaktwin(1);emsmap(headline,0,0);
   for y:=105 to 143 do vcopy_woc(78,emsseg,(y-105)*320,$a000,1024+(y-104)*640+327);
   for y:=144 to 203 do vcopy_woc(78,emsseg,39*320,$a000,1024+(y-104)*640+327);
   vcopy_woc(48,emsseg,39*320,$a000,1024+(100)*640+327);
   moveaktwin(2);
   vcopy_woc(30,emsseg,39*320,$a000,0);
   for y:=205 to 306 do vcopy_woc(78,emsseg,39*320,$a000,128+(y-205)*640+327);
   moveaktwin(3);
   vcopy_woc(78,emsseg,39*320,$a000,192);
  end;
end;
procedure show_values;
begin
 vbl;
 if games_won<>altwon   then begin putcount(66+(gameside*327),132,games_won,5);altwon:=games_won;end;
 if games_lost<>altlost then begin putcount(176+(gameside*327),132,games_lost,5);altlost:=games_lost;end;
 if games_patt<>altpatt then begin putcount(274+(gameside*327),132,games_patt,5);altpatt:=games_patt;end;
 if intell<>altintell   then begin putcount(270+(gameside*327),119,intell,3);altintell:=intell;end;
end;

procedure initgamefont;
var x,y:word;
begin
 emsmap(headline,0,0);
 for y:=42 to 48 do vcopy_mem(6,emsseg,y*314+2, seg(gamefont[0,(y-42)*7]),ofs(gamefont[0,(y-42)*7]));
 for y:=42 to 48 do vcopy_mem(6,emsseg,y*314+9, seg(gamefont[1,(y-42)*7]),ofs(gamefont[1,(y-42)*7]));
 for y:=42 to 48 do vcopy_mem(6,emsseg,y*314+16,seg(gamefont[2,(y-42)*7]),ofs(gamefont[2,(y-42)*7]));
 for y:=42 to 48 do vcopy_mem(6,emsseg,y*314+23,seg(gamefont[3,(y-42)*7]),ofs(gamefont[3,(y-42)*7]));
 for y:=42 to 48 do vcopy_mem(6,emsseg,y*314+30,seg(gamefont[4,(y-42)*7]),ofs(gamefont[4,(y-42)*7]));
 for y:=42 to 48 do vcopy_mem(6,emsseg,y*314+37,seg(gamefont[5,(y-42)*7]),ofs(gamefont[5,(y-42)*7]));
 for y:=42 to 48 do vcopy_mem(6,emsseg,y*314+44,seg(gamefont[6,(y-42)*7]),ofs(gamefont[6,(y-42)*7]));
 for y:=42 to 48 do vcopy_mem(6,emsseg,y*314+51,seg(gamefont[7,(y-42)*7]),ofs(gamefont[7,(y-42)*7]));
 for y:=42 to 48 do vcopy_mem(6,emsseg,y*314+58,seg(gamefont[8,(y-42)*7]),ofs(gamefont[8,(y-42)*7]));
 for y:=42 to 48 do vcopy_mem(6,emsseg,y*314+65,seg(gamefont[9,(y-42)*7]),ofs(gamefont[9,(y-42)*7]));
end;


procedure show_gamefield;
var x,y,segm:word;m:byte;leer:array[0..9]of byte;
begin
 m:=mouseset;clearmouse;fillchar(leer,sizeof(leer),0);
 if gameside=0 then
  begin
   emsmap(board_orig,0,0);emsmap(board_orig,1,1);emsmap(board_orig,2,2);segm:=emsframeseg;
   moveaktwin(3);
      for y:=308 to 409 do vputvirtblock(0,y,313,segm,(y-308)*314);
   moveaktwin(4);
      for y:=410 to 430 do vputvirtblock(0,y,313,segm,(y-308)*314);
  end
 else if gameside=1 then
  begin
   emsmap(board_orig,0,0);emsmap(board_orig,1,1);emsmap(board_orig,2,2);segm:=emsframeseg;
   moveaktwin(3);
      for y:=308 to 408 do vputvirtblock(327,y,313,segm,(y-308)*314);
   vputvirtblock(327,409,56,segm,(101)*314);moveaktwin(4);vputvirtblock(384,409,256,segm,(101)*314+57);
   for y:=410 to 430 do vputvirtblock(327,y,313,segm,(y-308)*314);
  end;
 show_values;
 if m>1 then plotmouse;
end;

procedure initboards;
var segm,x,y:word;
begin
 asm cli;end;
 v_openfile('bset_1.crp');v_readfile(1,addr(header^));v_readfile(768,addr(header^));
    move(header^[128*3],zielpal^[128*3],64*3);v_seekfile(1001);
    board_orig:=emsalloc(3);segm:=emsframeseg;emsmap4(board_orig,0,1,2,0);
    v_readfile(16384,ptr(segm,emsframeofs[0]));
    v_readfile(16384,ptr(segm,emsframeofs[1]));
    v_readfile(5854,ptr(segm,emsframeofs[2]));v_closefile;

 v_openfile('bset_2.crp');v_seekfile(1001);
    board_cross:=emsalloc(2);segm:=emsframeseg;emsmap4(board_cross,0,1,0,0);
    v_readfile(16384,ptr(segm,emsframeofs[0]));
    v_readfile(13446,ptr(segm,emsframeofs[1]));v_closefile;
 v_openfile('bset_3.crp');v_seekfile(1001);
    board_cr2:=emsalloc(2);segm:=emsframeseg;emsmap4(board_cr2,0,1,0,0);
    v_readfile(16384,ptr(segm,emsframeofs[0]));
    v_readfile(13446,ptr(segm,emsframeofs[1]));v_closefile;
 v_openfile('bset_4.crp');v_seekfile(1001);
    board_circle:=emsalloc(2);segm:=emsframeseg;emsmap4(board_circle,0,1,0,0);
    v_readfile(16384,ptr(segm,emsframeofs[0]));
    v_readfile(13446,ptr(segm,emsframeofs[1]));v_closefile;
 v_openfile('bset_5.crp');v_seekfile(1001);
    board_ci2:=emsalloc(2);segm:=emsframeseg;emsmap4(board_ci2,0,1,0,0);
    v_readfile(16384,ptr(segm,emsframeofs[0]));
    v_readfile(13446,ptr(segm,emsframeofs[1]));v_closefile;
 v_openfile('bset_6.crp');v_seekfile(1001);
    headline:=emsalloc(2);segm:=emsframeseg;emsmap4(headline,0,1,0,0);
    v_readfile(15700,ptr(segm,0));v_closefile;
 asm sti;end;
 emsseg:=emsframeseg;
 initgamefont;
 show_headline;
 show_gamefield;
 fade_to_all(zielpal,3);{setpal_z;}
end;
procedure deinitboards;
begin
 init_fadeout(128,192);fade_to_all(zielpal,3);{setpal_z;}
 emsdealloc(board_cross);emsdealloc(board_circle);emsdealloc(board_orig);emsdealloc(board_ci2);emsdealloc(board_cr2);
 emsdealloc(headline);
end;

procedure plot_st_00;var x,y:word;
begin vbl;
 moveaktwin(3);for y:=0 to 21 do begin vcopy_woc(13,emsseg,(y+1)*314+72,$a000,1152+72+(gameside*320)+(y*640));end;end;
procedure plot_st_10;var x,y:word;
begin vbl;
 moveaktwin(3);for y:=0 to 21 do begin vcopy_woc(14,emsseg,(y+1)*314+130,$a000,1152+130+(gameside*320)+(y*640));end;end;
procedure plot_st_20;var x,y:word;
begin vbl;
 moveaktwin(3);for y:=0 to 21 do begin vcopy_woc(13,emsseg,(y+1)*314+189,$a000,1152+189+(gameside*320)+(y*640));end;end;
procedure plot_st_01;var x,y:word;
begin vbl;
 moveaktwin(3);for y:=0 to 27 do begin vcopy_woc(15,emsseg,(y+24)*314+59,$a000,1152+59+(gameside*320)+((y+23)*640));end;end;
procedure plot_st_11;var x,y:word;
begin vbl;
 moveaktwin(3);for y:=0 to 27 do begin vcopy_woc(17,emsseg,(y+24)*314+124,$a000,1152+124+(gameside*320)+((y+23)*640));end;end;
procedure plot_st_21;var x,y:word;
begin vbl;
 moveaktwin(3);for y:=0 to 27 do begin vcopy_woc(18,emsseg,(y+24)*314+185,$a000,1152+185+(gameside*320)+((y+23)*640));end;end;
procedure plot_st_02;var x,y:word;
begin vbl;
 moveaktwin(3);for y:=0 to 38 do begin vcopy_woc(18,emsseg,(y+56)*314+41,$a000,1152+41+(gameside*320)+((y+55)*640));end;end;
procedure plot_st_12;var x,y:word;
begin vbl;
 moveaktwin(3);for y:=0 to 38 do begin vcopy_woc(17,emsseg,(y+56)*314+118,$a000,1152+118+(gameside*320)+((y+55)*640));end;end;
procedure plot_st_22;var x,y:word;
begin vbl;
 moveaktwin(3);for y:=0 to 38 do begin vcopy_woc(21,emsseg,(y+56)*314+189,$a000,1152+189+(gameside*320)+((y+55)*640));end;end;
procedure plotstone(sx,sy,st:byte);
var m:byte;
begin
 m:=mouseset;if m>0 then clearmouse;
 if st=player_col then begin emsmap4(board_cross,0,1,0,0);end;
 if st=comp_col then begin emsmap4(board_circle,0,1,0,0);end;
 if sy=0 then begin if sx=0 then plot_st_00;if sx=1 then plot_st_10;if sx=2 then plot_st_20;end;
 if sy=1 then begin if sx=0 then plot_st_01;if sx=1 then plot_st_11;if sx=2 then plot_st_21;end;
 if sy=2 then begin if sx=0 then plot_st_02;if sx=1 then plot_st_12;if sx=2 then plot_st_22;end;
 if m>0 then plotmouse;
end;
procedure markwinner(st:byte;w1,w2,w3:word);
var m:byte;
begin
 asm cli;end;
 m:=mouseset;if m>0 then clearmouse;
 if st=player_col then begin emsmap4(board_cr2,0,1,0,0);end
 else {if st=comp_col then} begin emsmap4(board_ci2,0,1,0,0);end;
 if lo(w1)=0 then begin if hi(w1)=0 then plot_st_00;if hi(w1)=1 then plot_st_10;if hi(w1)=2 then plot_st_20;end;
 if lo(w1)=1 then begin if hi(w1)=0 then plot_st_01;if hi(w1)=1 then plot_st_11;if hi(w1)=2 then plot_st_21;end;
 if lo(w1)=2 then begin if hi(w1)=0 then plot_st_02;if hi(w1)=1 then plot_st_12;if hi(w1)=2 then plot_st_22;end;
 if lo(w2)=0 then begin if hi(w2)=0 then plot_st_00;if hi(w2)=1 then plot_st_10;if hi(w2)=2 then plot_st_20;end;
 if lo(w2)=1 then begin if hi(w2)=0 then plot_st_01;if hi(w2)=1 then plot_st_11;if hi(w2)=2 then plot_st_21;end;
 if lo(w2)=2 then begin if hi(w2)=0 then plot_st_02;if hi(w2)=1 then plot_st_12;if hi(w2)=2 then plot_st_22;end;
 if lo(w3)=0 then begin if hi(w3)=0 then plot_st_00;if hi(w3)=1 then plot_st_10;if hi(w3)=2 then plot_st_20;end;
 if lo(w3)=1 then begin if hi(w3)=0 then plot_st_01;if hi(w3)=1 then plot_st_11;if hi(w3)=2 then plot_st_21;end;
 if lo(w3)=2 then begin if hi(w3)=0 then plot_st_02;if hi(w3)=1 then plot_st_12;if hi(w3)=2 then plot_st_22;end;
 if m>0 then plotmouse;
 asm sti;end;
end;

procedure reset_gamefield;
begin
 modus:=nothing;
 for gfx:=0 to 2 do for gfy:=0 to 2 do field[gfx,gfy]:=0;
end;

function getstone(x,y:byte):byte;
begin
 getstone:=field[x,y];
end;
procedure setstone(x,y,st:byte);
begin
 field[x,y]:=st;
 plotstone(x,y,st);
end;
function setplayer(x,y,st:byte):boolean;
begin
 if getstone(x,y)=0 then
  begin field[x,y]:=st;plotstone(x,y,st);setplayer:=true;end else setplayer:=false;
end;

function zufall_w(range:word;po:pointer):word;
var frei,i,i2,ges:word;used:^word;
begin
 used:=po;frei:=0;
 for i:=1 to (2*range)-1 do
  begin
   if (used^ and i)=i then inc(frei);inc(i,i-1);
  end;
 if frei=0 then begin zufall_w:=0;exit;end;
 i2:=random(frei)+1;
 frei:=0;ges:=0;for i:=1 to (2*range)-1 do
  begin
   if (used^ and i)=i then inc(frei);
   inc(ges);
   if frei=i2 then begin zufall_w:=ges-1;exit;end
   else inc(i,i-1);
  end;
 zufall_w:=$FFFF;
end;


function testl(nbr:byte):boolean;
var erg:boolean;
    pc:byte;
const t=true;
      f=false;
begin
 pc:=player_col;
 if nbr=1 then begin if (getstone(0,0)<>pc)and(getstone(1,0)<>pc)and(getstone(2,0)<>pc) then erg:=t else erg:=f;end
 else if nbr=2 then begin if (getstone(0,1)<>pc)and(getstone(1,1)<>pc)and(getstone(2,1)<>pc) then erg:=t else erg:=f;end
 else if nbr=3 then begin if (getstone(0,2)<>pc)and(getstone(1,2)<>pc)and(getstone(2,2)<>pc) then erg:=t else erg:=f;end
 else if nbr=4 then begin if (getstone(0,0)<>pc)and(getstone(0,1)<>pc)and(getstone(0,2)<>pc) then erg:=t else erg:=f;end
 else if nbr=5 then begin if (getstone(1,0)<>pc)and(getstone(1,1)<>pc)and(getstone(1,2)<>pc) then erg:=t else erg:=f;end
 else if nbr=6 then begin if (getstone(2,0)<>pc)and(getstone(2,1)<>pc)and(getstone(2,2)<>pc) then erg:=t else erg:=f;end
 else if nbr=7 then begin if (getstone(0,0)<>pc)and(getstone(1,1)<>pc)and(getstone(2,2)<>pc) then erg:=t else erg:=f;end
 else if nbr=8 then begin if (getstone(0,2)<>pc)and(getstone(1,1)<>pc)and(getstone(2,0)<>pc) then erg:=t else erg:=f;end;
 testl:=erg;
end;
function check_if_won(col:byte):byte;
var c:byte;
begin
 c:=0;
  if getstone(0,0)=col then inc(c);if getstone(1,0)=col then inc(c);if getstone(2,0)=col then inc(c);
 if c=3 then begin check_if_won:=1;exit;end;c:=0;
  if getstone(0,1)=col then inc(c);if getstone(1,1)=col then inc(c);if getstone(2,1)=col then inc(c);
 if c=3 then begin check_if_won:=2;exit;end;c:=0;
  if getstone(0,2)=col then inc(c);if getstone(1,2)=col then inc(c);if getstone(2,2)=col then inc(c);
 if c=3 then begin check_if_won:=3;exit;end;c:=0;
  if getstone(0,0)=col then inc(c);if getstone(0,1)=col then inc(c);if getstone(0,2)=col then inc(c);
 if c=3 then begin check_if_won:=4;exit;end;c:=0;
  if getstone(1,0)=col then inc(c);if getstone(1,1)=col then inc(c);if getstone(1,2)=col then inc(c);
 if c=3 then begin check_if_won:=5;exit;end;c:=0;
  if getstone(2,0)=col then inc(c);if getstone(2,1)=col then inc(c);if getstone(2,2)=col then inc(c);
 if c=3 then begin check_if_won:=6;exit;end;c:=0;
  if getstone(0,0)=col then inc(c);if getstone(1,1)=col then inc(c);if getstone(2,2)=col then inc(c);
 if c=3 then begin check_if_won:=7;exit;end;c:=0;
  if getstone(2,0)=col then inc(c);if getstone(1,1)=col then inc(c);if getstone(0,2)=col then inc(c);
 if c=3 then begin check_if_won:=8;exit;end;
 check_if_won:=$FF;
end;
procedure showwinnerline(col:byte);
var line:byte;
begin
 line:=check_if_won(col);
 if line=1 then markwinner(col,$0000,$0100,$0200);
 if line=2 then markwinner(col,$0001,$0101,$0201);
 if line=3 then markwinner(col,$0002,$0102,$0202);
 if line=4 then markwinner(col,$0000,$0001,$0002);
 if line=5 then markwinner(col,$0100,$0101,$0102);
 if line=6 then markwinner(col,$0200,$0201,$0202);
 if line=7 then markwinner(col,$0000,$0101,$0202);
 if line=8 then markwinner(col,$0002,$0101,$0200);
end;

function check4win:word;
var c:byte;freepos:word;
begin
 c:=0;freepos:=0;
  if getstone(0,0)=comp_col then inc(c) else freepos:=$0000;
  if getstone(1,0)=comp_col then inc(c) else freepos:=$0100;
  if getstone(2,0)=comp_col then inc(c) else freepos:=$0200;
  if getstone(hi(freepos),lo(freepos))=player_col then c:=0;
 if c=2 then begin check4win:=freepos;exit;end;c:=0;
  if getstone(0,1)=comp_col then inc(c) else freepos:=$0001;
  if getstone(1,1)=comp_col then inc(c) else freepos:=$0101;
  if getstone(2,1)=comp_col then inc(c) else freepos:=$0201;
  if getstone(hi(freepos),lo(freepos))=player_col then c:=0;
 if c=2 then begin check4win:=freepos;exit;end;c:=0;
  if getstone(0,2)=comp_col then inc(c) else freepos:=$0002;
  if getstone(1,2)=comp_col then inc(c) else freepos:=$0102;
  if getstone(2,2)=comp_col then inc(c) else freepos:=$0202;
  if getstone(hi(freepos),lo(freepos))=player_col then c:=0;
 if c=2 then begin check4win:=freepos;exit;end;c:=0;
  if getstone(0,0)=comp_col then inc(c) else freepos:=$0000;
  if getstone(0,1)=comp_col then inc(c) else freepos:=$0001;
  if getstone(0,2)=comp_col then inc(c) else freepos:=$0002;
  if getstone(hi(freepos),lo(freepos))=player_col then c:=0;
 if c=2 then begin check4win:=freepos;exit;end;c:=0;
  if getstone(1,0)=comp_col then inc(c) else freepos:=$0100;
  if getstone(1,1)=comp_col then inc(c) else freepos:=$0101;
  if getstone(1,2)=comp_col then inc(c) else freepos:=$0102;
  if getstone(hi(freepos),lo(freepos))=player_col then c:=0;
 if c=2 then begin check4win:=freepos;exit;end;c:=0;
  if getstone(2,0)=comp_col then inc(c) else freepos:=$0200;
  if getstone(2,1)=comp_col then inc(c) else freepos:=$0201;
  if getstone(2,2)=comp_col then inc(c) else freepos:=$0202;
  if getstone(hi(freepos),lo(freepos))=player_col then c:=0;
 if c=2 then begin check4win:=freepos;exit;end;c:=0;
  if getstone(0,0)=comp_col then inc(c) else freepos:=$0000;
  if getstone(1,1)=comp_col then inc(c) else freepos:=$0101;
  if getstone(2,2)=comp_col then inc(c) else freepos:=$0202;
  if getstone(hi(freepos),lo(freepos))=player_col then c:=0;
 if c=2 then begin check4win:=freepos;exit;end;c:=0;
  if getstone(2,0)=comp_col then inc(c) else freepos:=$0200;
  if getstone(1,1)=comp_col then inc(c) else freepos:=$0101;
  if getstone(0,2)=comp_col then inc(c) else freepos:=$0002;
  if getstone(hi(freepos),lo(freepos))=player_col then c:=0;
 if c=2 then begin check4win:=freepos;exit;end;
 check4win:=$FFFF;
end;


function check4lost:word;
var c:byte;freepos:word;
begin
 c:=0;
  if getstone(0,0)=player_col then inc(c) else freepos:=$0000;
  if getstone(1,0)=player_col then inc(c) else freepos:=$0100;
  if getstone(2,0)=player_col then inc(c) else freepos:=$0200;
  if getstone(hi(freepos),lo(freepos))=comp_col then c:=0;
 if c=2 then begin check4lost:=freepos;exit;end;c:=0;
  if getstone(0,1)=player_col then inc(c) else freepos:=$0001;
  if getstone(1,1)=player_col then inc(c) else freepos:=$0101;
  if getstone(2,1)=player_col then inc(c) else freepos:=$0201;
  if getstone(hi(freepos),lo(freepos))=comp_col then c:=0;
 if c=2 then begin check4lost:=freepos;exit;end;c:=0;
  if getstone(0,2)=player_col then inc(c) else freepos:=$0002;
  if getstone(1,2)=player_col then inc(c) else freepos:=$0102;
  if getstone(2,2)=player_col then inc(c) else freepos:=$0202;
  if getstone(hi(freepos),lo(freepos))=comp_col then c:=0;
 if c=2 then begin check4lost:=freepos;exit;end;c:=0;
  if getstone(0,0)=player_col then inc(c) else freepos:=$0000;
  if getstone(0,1)=player_col then inc(c) else freepos:=$0001;
  if getstone(0,2)=player_col then inc(c) else freepos:=$0002;
  if getstone(hi(freepos),lo(freepos))=comp_col then c:=0;
 if c=2 then begin check4lost:=freepos;exit;end;c:=0;
  if getstone(1,0)=player_col then inc(c) else freepos:=$0100;
  if getstone(1,1)=player_col then inc(c) else freepos:=$0101;
  if getstone(1,2)=player_col then inc(c) else freepos:=$0102;
  if getstone(hi(freepos),lo(freepos))=comp_col then c:=0;
 if c=2 then begin check4lost:=freepos;exit;end;c:=0;
  if getstone(2,0)=player_col then inc(c) else freepos:=$0200;
  if getstone(2,1)=player_col then inc(c) else freepos:=$0201;
  if getstone(2,2)=player_col then inc(c) else freepos:=$0202;
  if getstone(hi(freepos),lo(freepos))=comp_col then c:=0;
 if c=2 then begin check4lost:=freepos;exit;end;c:=0;
  if getstone(0,0)=player_col then inc(c) else freepos:=$0000;
  if getstone(1,1)=player_col then inc(c) else freepos:=$0101;
  if getstone(2,2)=player_col then inc(c) else freepos:=$0202;
  if getstone(hi(freepos),lo(freepos))=comp_col then c:=0;
 if c=2 then begin check4lost:=freepos;exit;end;c:=0;
  if getstone(2,0)=player_col then inc(c) else freepos:=$0200;
  if getstone(1,1)=player_col then inc(c) else freepos:=$0101;
  if getstone(0,2)=player_col then inc(c) else freepos:=$0002;
  if getstone(hi(freepos),lo(freepos))=comp_col then c:=0;
 if c=2 then begin check4lost:=freepos;exit;end;
 check4lost:=$FFFF;
end;

function getoptipos:word;
label set_irgendwo;
var sf:gamefield;highest:byte;zf,erg:word;
begin
 right_choice:=random(101);
 if right_choice>intell then goto set_irgendwo;
 {mgliche lines errechnen}
  for gfy:=0 to 2 do for gfx:=0 to 2 do sf[gfx,gfy]:=0;
  if field[0,0]=0 then begin if testl(1) then inc(sf[0,0]);if testl(4) then inc(sf[0,0]);if testl(7) then inc(sf[0,0]);end;
  if field[1,0]=0 then begin if testl(1) then inc(sf[1,0]);if testl(5) then inc(sf[1,0]);end;
  if field[2,0]=0 then begin if testl(1) then inc(sf[2,0]);if testl(6) then inc(sf[2,0]);if testl(8) then inc(sf[2,0]);end;
  if field[0,1]=0 then begin if testl(2) then inc(sf[0,1]);if testl(4) then inc(sf[0,1]);end;
  if field[1,1]=0 then begin if testl(2) then inc(sf[1,1]);if testl(5) then inc(sf[1,1]);
                          if testl(7) then inc(sf[1,1]);if testl(8) then inc(sf[1,1]);end;
  if field[2,1]=0 then begin if testl(2) then inc(sf[2,1]);if testl(6) then inc(sf[2,1]);end;
  if field[0,2]=0 then begin if testl(3) then inc(sf[0,2]);if testl(4) then inc(sf[0,2]);if testl(8) then inc(sf[0,2]);end;
  if field[1,2]=0 then begin if testl(3) then inc(sf[1,2]);if testl(5) then inc(sf[1,2]);end;
  if field[2,2]=0 then begin if testl(3) then inc(sf[2,2]);if testl(6) then inc(sf[2,2]);if testl(7) then inc(sf[2,2]);end;
 {hchsten wert checken}
  highest:=0;
  for gfy:=0 to 2 do for gfx:=0 to 2 do if sf[gfx,gfy]>highest then highest:=sf[gfx,gfy];
 {mgliche stellen suchen}
  zf:=0;
  if sf[0,0]=highest then zf:=zf or 1; if sf[1,0]=highest then zf:=zf or 2;  if sf[2,0]=highest then zf:=zf or 4;
  if sf[0,1]=highest then zf:=zf or 8; if sf[1,1]=highest then zf:=zf or 16; if sf[2,1]=highest then zf:=zf or 32;
  if sf[0,2]=highest then zf:=zf or 64;if sf[1,2]=highest then zf:=zf or 128;if sf[2,2]=highest then zf:=zf or 256;
  if (zf>0)and(highest>0) then
   begin
    erg:=zufall_w(256,addr(zf));
    if erg=0 then getoptipos:=$0000;if erg=1 then getoptipos:=$0100;if erg=2 then getoptipos:=$0200;
    if erg=3 then getoptipos:=$0001;if erg=4 then getoptipos:=$0101;if erg=5 then getoptipos:=$0201;
    if erg=6 then getoptipos:=$0002;if erg=7 then getoptipos:=$0102;if erg=8 then getoptipos:=$0202;
   end
  else
   begin
    set_irgendwo:
    zf:=0;
    if field[0,0]=0 then zf:=zf or 1; if field[1,0]=0 then zf:=zf or 2;  if field[2,0]=0 then zf:=zf or 4;
    if field[0,1]=0 then zf:=zf or 8; if field[1,1]=0 then zf:=zf or 16; if field[2,1]=0 then zf:=zf or 32;
    if field[0,2]=0 then zf:=zf or 64;if field[1,2]=0 then zf:=zf or 128;if field[2,2]=0 then zf:=zf or 256;
    erg:=zufall_w(256,addr(zf));
    if erg=0 then getoptipos:=$0000;if erg=1 then getoptipos:=$0100;if erg=2 then getoptipos:=$0200;
    if erg=3 then getoptipos:=$0001;if erg=4 then getoptipos:=$0101;if erg=5 then getoptipos:=$0201;
    if erg=6 then getoptipos:=$0002;if erg=7 then getoptipos:=$0102;if erg=8 then getoptipos:=$0202;
   end;
end;

procedure logic_level2;
var setfield:word;
begin
 setfield:=getoptipos;
 setstone(hi(setfield),lo(setfield),comp_col);
end;

function exists_free_fields:boolean;
var count:byte;
begin
 count:=0;
 for gfy:=0 to 2 do for gfx:=0 to 2 do if field[gfx,gfy]=0 then inc(count);
 if count=0 then exists_free_fields:=false else exists_free_fields:=true;
end;

procedure logic_level1;
label schon_besetzt1,schon_besetzt2;
var winfield,lostfield:word;
begin
 if not(exists_free_fields) then exit;
 winfield:=check4win;
 if winfield<$ffff then
  begin
   right_choice:=random(101);
   if right_choice<=intell then
    begin
     if setplayer(hi(winfield),lo(winfield),comp_col) then begin end
      else goto schon_besetzt1;
    end else goto schon_besetzt1;
  end
 else
  begin
   schon_besetzt1:
   lostfield:=check4lost;
   if lostfield<$ffff then
    begin
     right_choice:=random(101);
     if right_choice<=intell then
      begin
       if setplayer(hi(lostfield),lo(lostfield),comp_col) then begin end
        else goto schon_besetzt2;
      end else goto schon_besetzt2;
    end
   else
    begin
     schon_besetzt2:
     logic_level2;
    end;
  end;
end;


procedure cutten(i:byte;point,pidx:pointer);
type font_du=array[0..9,0..639] of byte;
var po:^font_du;x,y:word;pb:^byte;
begin
 po:=point;pb:=pidx;
 for y:=0 to 9 do
  for x:=cutx to cutx+7 do
   font^.data[pb^,y,x-cutx]:=po^[y,x];
 font^.table[i]:=pb^;inc(pb^);
 inc(cutx,8);
end;

procedure initfont;
type font_du=array[0..9,0..639] of byte;
var po:font_du;index:byte;
begin
 index:=0;fillchar(font^.table,256,26); {alle aufs leerzeichen}
 v_seekfile(69249);v_readfile(6400,@po);cutx:=0;for i:=65 to 90 do cutten(i,@po,addr(index));cutten(32,@po,addr(index));
  cutten(126,@po,addr(index));cutten(127,@po,addr(index));cutten(155,@po,addr(index));cutten(156,@po,addr(index));
  cutten(227,@po,addr(index));cutten(254,@po,addr(index));
 v_seekfile(80769);v_readfile(6400,@po);cutx:=0;for i:=97 to 122 do cutten(i,@po,addr(index));
 for i:=48 to 57 do cutten(i,@po,addr(index));
 v_seekfile(92289);v_readfile(6400,@po);cutx:=0;
 cutten(46,@po,addr(index));cutten(44,@po,addr(index));cutten(33,@po,addr(index));
 cutten(63,@po,addr(index));cutten(34,@po,addr(index));cutten(sm_right_char,@po,addr(index));
 cutten(sm_left_char,@po,addr(index));cutten(142,@po,addr(index));cutten(153,@po,addr(index));cutten(154,@po,addr(index));
 cutten(132,@po,addr(index));cutten(148,@po,addr(index));cutten(129,@po,addr(index));cutten(225,@po,addr(index));
 cutten(43,@po,addr(index));cutten(45,@po,addr(index));cutten(47,@po,addr(index));cutten(42,@po,addr(index));
 cutten(40,@po,addr(index));cutten(41,@po,addr(index));cutten(91,@po,addr(index));cutten(93,@po,addr(index));
 cutten(61,@po,addr(index));cutten(35,@po,addr(index));cutten(64,@po,addr(index));cutten(59,@po,addr(index));
 cutten(58,@po,addr(index));cutten(39,@po,addr(index));
 cutten(92,@po,addr(index));
 cutten(21,@po,addr(index));
 cutten(38,@po,addr(index));
 cutten(36,@po,addr(index));
 cutten(37,@po,addr(index));

 cutten(62,@po,addr(index));cutten(60,@po,addr(index));cutten(94,@po,addr(index));cutten(95,@po,addr(index));
 cutten(124,@po,addr(index));
end;
procedure initpageindi;
var y:word;
begin
 for y:=225 to 247 do
  begin v_seekfile((longint(y)*640)+768+1);v_readfile(59,addr(pageindi^[0,y-225,0]));end;
 for y:=225 to 247 do
  begin v_seekfile((longint(y)*640)+768+62);v_readfile(59,addr(pageindi^[1,y-225,0]));end;
end;
procedure init_options_switch;
var y:word;
begin
 for y:=225 to 244 do
  begin v_seekfile((longint(y)*640)+768+122);v_readfile(20,addr(options_switch^[0,y-225,0]));end;
 for y:=225 to 244 do
  begin v_seekfile((longint(y)*640)+768+143);v_readfile(20,addr(options_switch^[1,y-225,0]));end;
end;

procedure inittimefont;
var buffer:array[0..98]of byte;y:word;i:byte;
begin
 for y:=206 to 220 do
  begin
   v_seekfile((longint(y)*640)+768);v_readfile(99,addr(buffer));
   for i:=0 to 10 do move(buffer[i*9],time_font^[i,(y-206),0],9);
  end;
end;

procedure putchar(x1,y1:word;i,farbe:byte);
var x,y:word;b:byte;
begin
 for y:=y1 to y1+9 do for x:=x1 to x1+7 do begin b:=font^.data[font^.table[i],y-y1,x-x1];if b>0 then vputpixel(x,y,farbe);end;
end;
procedure putchar_buffer(x1:word;i,farbe:byte;po:pointer);
var x,y:word;b:byte;locpo:pointer;
begin
 locpo:=addr(font^.data[font^.table[i]]);
 asm
  mov dl,farbe;push es;push ds;les di,po;add di,x1;lds si,locpo;mov ch,10;mov cl,8;
  @j1:
    lodsb;or al,al;je @nicht_setzen;mov al,dl;stosb;jmp @gesetzt;@nicht_setzen:;inc di;@gesetzt:
   dec cl;jne @j1
   mov cl,8;add di,312;dec ch;jne @j1
  pop ds;pop es
 end;
end;


procedure putchar_woc(x1,y1:word;i,farbe:byte);
var x,y:word;b:byte;
begin
 for y:=y1 to y1+9 do for x:=x1 to x1+7 do
  begin b:=font^.data[font^.table[i],y-y1,x-x1];if b>0 then vputpixel_woc(x,y,farbe);end;
end;
procedure putstring(x1,y1:word;text:string;farbe:byte);
var x,y,i:word;
begin
 for i:=1 to length(text) do putchar(x1+((i-1)*8),y1,ord(text[i]),farbe);
end;
procedure putstring_buffer(x1:word;text:string;farbe:byte;po:pointer);
var x,y,i:word;
begin
 for i:=1 to length(text) do putchar_buffer(x1+((i-1)*8),ord(text[i]),farbe,po);
end;
procedure putstring_woc(x1,y1:word;text:string;farbe:byte);
var x,y,i:word;
begin
 for i:=1 to length(text) do putchar_woc(x1+((i-1)*8),y1,ord(text[i]),farbe);
end;
procedure plot_button_text(butnum,butside:byte;te1,te2:string;farbe:byte);
var x,y,x1,x2,y1,y2,dx1,dx2:word;buffer:array[0..3200]of byte;
begin
 if getwinbyte(butside*320,108+butnum*38)=getwinbyte(butside*320+319,147+butnum*38) then
 begin
  moveaktwin(getwinbyte(butside*320,108+butnum*38));
  if length(te2)=0 then
   begin
    dx1:=length(te1)*8-1;x1:=(320-dx1) shr 1;y1:=108+butnum*38+15;
     for y:=y1 to y1+9 do vgetvirtblock(butside*320,y,319,seg(buffer[(y-y1)*320]),ofs(buffer[(y-y1)*320]));
     putstring_buffer(x1,te1,farbe,addr(buffer));
     for y:=y1 to y1+9 do vputvirtblock(butside*320,y,319,seg(buffer[(y-y1)*320]),ofs(buffer[(y-y1)*320]));
   end
  else
   begin
    dx1:=length(te1)*8-1;x1:=(320-dx1) shr 1;y1:=108+butnum*38+8;
     for y:=y1 to y1+9 do vgetvirtblock(butside*320,y,319,seg(buffer[(y-y1)*320]),ofs(buffer[(y-y1)*320]));
     putstring_buffer(x1,te1,farbe,addr(buffer));
     for y:=y1 to y1+9 do vputvirtblock(butside*320,y,319,seg(buffer[(y-y1)*320]),ofs(buffer[(y-y1)*320]));
    dx2:=length(te2)*8-1;x2:=(320-dx2) shr 1;y2:=108+butnum*38+22;
     for y:=y2 to y2+9 do vgetvirtblock(butside*320,y,319,seg(buffer[(y-y2)*320]),ofs(buffer[(y-y2)*320]));
     putstring_buffer(x2,te2,farbe,addr(buffer));
     for y:=y2 to y2+9 do vputvirtblock(butside*320,y,319,seg(buffer[(y-y2)*320]),ofs(buffer[(y-y2)*320]));
   end;
 end
 else
 begin
  if length(te2)=0 then
  begin
   dx1:=length(te1)*8-1;x1:=(320-dx1) shr 1;if butside=1 then inc(x1,320);y1:=108+butnum*38+15;putstring(x1,y1,te1,farbe);
  end
  else
  begin
   dx1:=length(te1)*8-1;x1:=(320-dx1) shr 1;if butside=1 then inc(x1,320);y1:=108+butnum*38+8;putstring(x1,y1,te1,farbe);
   dx2:=length(te2)*8-1;x2:=(320-dx2) shr 1;if butside=1 then inc(x2,320);y2:=108+butnum*38+22;putstring(x2,y2,te2,farbe);
  end;
 end
end;
procedure plot_button_text_u(butnum,butside:byte;te1,te2:string;farbe:byte);
var x,y,x1,x2,y1,y2,dx1,dx2:word;buffer:array[0..3600]of byte;
begin
 if getwinbyte(butside*320,108+butnum*38)=getwinbyte(butside*320+319,147+butnum*38) then
 begin
  moveaktwin(getwinbyte(butside*320,108+butnum*38));
  if length(te2)=0 then
   begin
    dx1:=length(te1)*8-1;x1:=(320-dx1) shr 1;y1:=108+butnum*38+15;
     for y:=y1 to y1+9 do vgetvirtblock(butside*320,y,319,seg(buffer[(y-y1)*320]),ofs(buffer[(y-y1)*320]));
     putstring_buffer(x1+321,te1,0,addr(buffer));putstring_buffer(x1,te1,farbe,addr(buffer));
     for y:=y1 to y1+9 do vputvirtblock(butside*320,y,319,seg(buffer[(y-y1)*320]),ofs(buffer[(y-y1)*320]));
   end
  else
   begin
    dx1:=length(te1)*8-1;x1:=(320-dx1) shr 1;y1:=108+butnum*38+8;
     for y:=y1 to y1+9 do vgetvirtblock(butside*320,y,319,seg(buffer[(y-y1)*320]),ofs(buffer[(y-y1)*320]));
     putstring_buffer(x1+321,te1,0,addr(buffer));putstring_buffer(x1,te1,farbe,addr(buffer));
     for y:=y1 to y1+9 do vputvirtblock(butside*320,y,319,seg(buffer[(y-y1)*320]),ofs(buffer[(y-y1)*320]));
    dx2:=length(te2)*8-1;x2:=(320-dx2) shr 1;y2:=108+butnum*38+22;
     for y:=y2 to y2+9 do vgetvirtblock(butside*320,y,319,seg(buffer[(y-y2)*320]),ofs(buffer[(y-y2)*320]));
     putstring_buffer(x2+321,te2,0,addr(buffer));putstring_buffer(x2,te2,farbe,addr(buffer));
     for y:=y2 to y2+9 do vputvirtblock(butside*320,y,319,seg(buffer[(y-y2)*320]),ofs(buffer[(y-y2)*320]));
   end;
 end
 else
 begin
  if length(te2)=0 then
  begin
   dx1:=length(te1)*8-1;x1:=(320-dx1) shr 1;if butside=1 then inc(x1,320);y1:=108+butnum*38+15;
   putstring(x1+1,y1+1,te1,0);putstring(x1,y1,te1,farbe);
  end
  else
  begin
   dx1:=length(te1)*8-1;x1:=(320-dx1) shr 1;if butside=1 then inc(x1,320);y1:=108+butnum*38+8;
   putstring(x1+1,y1+1,te1,0);putstring(x1,y1,te1,farbe);
   dx2:=length(te2)*8-1;x2:=(320-dx2) shr 1;if butside=1 then inc(x2,320);y2:=108+butnum*38+22;
   putstring(x2+1,y2+1,te2,0);putstring(x2,y2,te2,farbe);
  end;
 end
end;


procedure plot_sm_indi_u(butnum,side,col:byte);
var x1,y1:word;
begin
 y1:=108+butnum*38+15;
 if side=0 then
  begin putchar(294+1,y1+1,sm_right_char,0);putchar(294,y1,sm_right_char,col);end
 else
  begin putchar(336+1,y1+1,sm_left_char,0);putchar(336,y1,sm_left_char,col);end;
end;



procedure putchar_2ems(x1,y1:word;i,farbe:byte;segm:word);
var x,y:word;b:byte;
begin
 for y:=y1 to y1+9 do for x:=x1 to x1+7 do
  begin b:=font^.data[font^.table[i],y-y1,x-x1];if b>0 then vputpixel_virt(x,y,segm,farbe);end;
end;
procedure putstring_2ems(x1,y1:word;text:string;farbe:byte;segm:word);
var x,y,i:word;
begin
 for i:=1 to length(text) do putchar_2ems(x1+((i-1)*8),y1,ord(text[i]),farbe,segm);
end;
procedure plot_button_text_2ems(butnum:byte;te1,te2:string;farbe:byte;piccihandle:word);
var x1,x2,y1,y2,dx1,dx2:word;segm:word;
begin
 segm:=emsframeseg;
 if butnum<5 then emsmap4(piccihandle,0,1,2,3) else emsmap4(piccihandle,4,5,6,7);
 if length(te2)=0 then
  begin
   dx1:=length(te1)*8-1;x1:=(320-dx1) shr 1;y1:=3+butnum*38+15;
   putstring_2ems(x1+1,y1+1,te1,0,segm);
   putstring_2ems(x1,y1,te1,farbe,segm);
  end
 else
 begin
  dx1:=length(te1)*8-1;x1:=(320-dx1) shr 1;y1:=3+butnum*38+8;
  dx2:=length(te2)*8-1;x2:=(320-dx2) shr 1;y2:=3+butnum*38+22;
  putstring_2ems(x1+1,y1+1,te1,0,segm);putstring_2ems(x2+1,y2+1,te2,0,segm);
  putstring_2ems(x1,y1,te1,farbe,segm);putstring_2ems(x2,y2,te2,farbe,segm);
 end;
end;
procedure plot_sm_indi_2ems(butnum,side,col:byte;hdl:emshandle);
var x1,y1:word;
begin
 if butnum<5 then emsmap4(hdl,0,1,2,3) else emsmap4(hdl,4,5,6,7);
 y1:=3+butnum*38+15;
 if side=0 then
  begin putchar_2ems(6,y1+1,sm_left_char,0,emsframeseg);putchar_2ems(5,y1,sm_left_char,col,emsframeseg);end
 else
  begin putchar_2ems(307,y1+1,sm_right_char,0,emsframeseg);putchar_2ems(306,y1,sm_right_char,col,emsframeseg);end;
end;



procedure plotpic(name:string;mode_activate:byte);
var i:byte;y:word;
begin
 if mode_activate=1 then initvesamode;
 v_openfile(name);v_readfile_p1(767,addr(header^[0]));setblack;
 moveaktwin(0);v_readfile_p1(65535,ptr($a000,0));
 moveaktwin(1);v_readfile_p1(65535,ptr($a000,0));
 moveaktwin(2);v_readfile_p1(65535,ptr($a000,0));
 moveaktwin(3);v_readfile_p1(65535,ptr($a000,0));
 moveaktwin(4);v_readfile_p1(45056,ptr($a000,0));
 initfont;
 inittimefont;
 initpageindi;
 init_options_switch;
 v_closefile;
end;
procedure pure_plotpic(name:string;mode_activate:byte);
var i:byte;y:word;
begin
 if mode_activate=1 then initvesamode;
 v_openfile(name);v_readfile_p1(767,addr(header^[0]));setblack;
 moveaktwin(0);v_readfile_p1(65535,ptr($a000,0));
 moveaktwin(1);v_readfile_p1(65535,ptr($a000,0));
 moveaktwin(2);v_readfile_p1(65535,ptr($a000,0));
 moveaktwin(3);v_readfile_p1(65535,ptr($a000,0));
 moveaktwin(4);v_readfile_p1(45056,ptr($a000,0));
 v_closefile;
end;
procedure initvars_wo_pic(name:string);
var i:byte;y:word;
begin
 v_openfile(name);v_readfile_p1(767,addr(header^[0]));
 initfont;
 inittimefont;
 initpageindi;
 init_options_switch;
 v_closefile;
end;

procedure setplane_2_write(plane:byte);assembler;  {werte zwischen 0-15}
 asm mov al,$02;mov ah,plane;mov dx,$3c4;out dx,ax end;
procedure setplane_2_read(plane:byte);assembler;   {werte zwischen 0-3}
 asm mov al,$04;mov ah,plane;mov dx,$3ce;out dx,ax end;

procedure showsegment;
var y:word;
begin
 if aktwin_side=0 then
  begin
   if aktwin_depack=0 then
    begin
     moveaktwin(1);for y:=105 to 204 do vputvirtblock(0,y,313,d_segment,(y-105)*314);
     moveaktwin(2);for y:=205 to 306 do vputvirtblock(0,y,313,d_segment,(y-105)*314);
     vputvirtblock(0,307,127,d_segment,(202)*314);moveaktwin(3);vputvirtblock(128,307,185,d_segment,(202)*314+128);
     for y:=308 to 312 do vputvirtblock(0,y,313,d_segment,(y-105)*314);
     vputvirtblock(0,313,223,d_segment,(208)*314);
    end
   else if aktwin_depack=1 then
    begin
     moveaktwin(3);vputvirtblock(224,313,88,d_segment,0);
     for y:=314 to 409 do vputvirtblock(0,y,313,d_segment,(y-314)*314+90);
     moveaktwin(4);for y:=410 to 430 do vputvirtblock(0,y,313,d_segment,(y-314)*314+90);
    end;
   inc(aktwin_depack);
  end
 else
  if aktwin_side=1 then
  begin
   if aktwin_depack=0 then
    begin
     moveaktwin(1);for y:=105 to 203 do vputvirtblock(327,y,313,d_segment,(y-105)*314);
     vputvirtblock(327,204,184,d_segment,(99)*314);moveaktwin(2);vputvirtblock(512,204,128,d_segment,(99)*314+185);
     for y:=205 to 306 do vputvirtblock(327,y,313,d_segment,(y-105)*314);
     moveaktwin(3);for y:=307 to 312 do vputvirtblock(327,y,313,d_segment,(y-105)*314);
     vputvirtblock(327,313,223,d_segment,(208)*314);
    end
   else if aktwin_depack=1 then
    begin
     moveaktwin(3);vputvirtblock(551,313,88,d_segment,0);
     for y:=314 to 408 do vputvirtblock(327,y,313,d_segment,(y-314)*314+90);
     vputvirtblock(327,409,56,d_segment,(95)*314+90);moveaktwin(4);vputvirtblock(384,409,255,d_segment,(95)*314+147);
     for y:=410 to 430 do vputvirtblock(327,y,313,d_segment,(y-314)*314+90);
    end;
   inc(aktwin_depack);
  end;
end;
procedure plot_ems_to_pic(aktwin_side:byte;handle:emshandle);
var y:word;d_segment:word;
begin
 d_segment:=emsframeseg;
 if aktwin_side=0 then
  begin
   emsmap4(handle,0,1,2,3);
    moveaktwin(1);for y:=105 to 204 do vputvirtblock(0,y,313,d_segment,(y-105)*314);
    moveaktwin(2);for y:=205 to 306 do vputvirtblock(0,y,313,d_segment,(y-105)*314);
    vputvirtblock(0,307,127,d_segment,(202)*314);moveaktwin(3);vputvirtblock(128,307,185,d_segment,(202)*314+128);
    for y:=308 to 312 do vputvirtblock(0,y,313,d_segment,(y-105)*314);
    vputvirtblock(0,313,223,d_segment,(208)*314);
   emsmap4(handle,4,5,6,7);
    moveaktwin(3);vputvirtblock(224,313,88,d_segment,0);
    for y:=314 to 409 do vputvirtblock(0,y,313,d_segment,(y-314)*314+90);
    moveaktwin(4);for y:=410 to 430 do vputvirtblock(0,y,313,d_segment,(y-314)*314+90);
  end
 else
  if aktwin_side=1 then
   begin
    emsmap4(handle,0,1,2,3);
     moveaktwin(1);for y:=105 to 203 do vputvirtblock(327,y,312,d_segment,(y-105)*314);
     vputvirtblock(327,204,184,d_segment,(99)*314);
     moveaktwin(2);vputvirtblock(512,204,127,d_segment,(99)*314+185);
     for y:=205 to 306 do vputvirtblock(327,y,312,d_segment,(y-105)*314);
     moveaktwin(3);for y:=307 to 312 do vputvirtblock(327,y,312,d_segment,(y-105)*314);
     vputvirtblock(327,313,223,d_segment,(208)*314);
    emsmap4(handle,4,5,6,7);
     moveaktwin(3);vputvirtblock(551,313,88,d_segment,0);
     for y:=314 to 408 do vputvirtblock(327,y,312,d_segment,(y-314)*314+90);
     vputvirtblock(327,409,57,d_segment,(95)*314+90);moveaktwin(4);vputvirtblock(384,409,255,d_segment,(95)*314+147);
     for y:=410 to 430 do vputvirtblock(327,y,312,d_segment,(y-314)*314+90);
   end;
end;


procedure readpackedfile;
begin
 if packed_size>65536 then begin v_readfile_p1(65535,file_ptr);packed_read:=65535;dec(packed_size,65535);end
 else
  if packed_size>0 then begin v_readfile_p1(packed_size-1,file_ptr);packed_read:=packed_size;dec(packed_size,packed_size);end;
 fileofs:=0;
 if packed_size=0 then v_closefile;
end;
procedure readvfile(size:word;po:pointer);
var po2,po3:^byte;i:word;dummy:byte;
begin
 po2:=po;
 for i:=1 to size do
  begin
   po3:=ptr(fileseg,fileofs);
   dummy:=po3^;
   po2^:=dummy;
   inc(fileofs);if fileofs=packed_read+1 then readpackedfile;
   po2:=ptr(seg(po2^),ofs(po2^)+1);
  end;
end;

procedure depack1;
begin
 asm
  push es;mov ax,d_segment;mov es,ax;mov di,d_offset;lea si,packstring1;lodsb;xor ch,ch;mov cl,al;rep movsb;mov d_offset,di;
  pop es
 end;
 inc(pixel_set,length(packstring1));if d_offset=0 then showsegment; {da war der overflow schon}
end;

procedure depack2;
var counter:byte;
begin
 asm
  push es;mov ax,d_segment;mov es,ax;mov di,d_offset;lea si,packstring2;lodsb;xor ch,ch;and al,127;mov cl,al;lodsb;rep stosb;
  mov d_offset,di;pop es
 end;
 inc(pixel_set,(ord(packstring2[0]) and 127));if d_offset=0 then showsegment; {da war der overflow schon}
end;

procedure depackfile(name:string;po:pointer;start_pic:byte;count_pic:word);
label packart1,packart2,endetest;
var status:boolean;t1:byte;farb_ptr:^farben;farb_array:farben;packart:byte;depackhandle:emshandle;
begin
 farb_ptr:=po; aktwin_depack:=0;
 v_openfile(name);packed_size:=v_getfilesize(name)-1001;
 v_readfile(1,addr(packart));v_readfile(1000,addr(farb_array));
 move(farb_array[word(start_pic)*3],farb_ptr^[word(start_pic)*3],(word(count_pic)*3));
 if packart=0 then
  begin
   depackhandle:=emsalloc(4);emsmap4(depackhandle,0,1,2,3);d_segment:=emsframeseg;d_offset:=0;
   depack_ptr:=ptr(d_segment,d_offset);
   getmem(file_ptr,65535);fileseg:=seg(file_ptr^);fileofs:=ofs(file_ptr^);
   readpackedfile;pixel_set:=0;
   repeat
    goto endetest;
    packart1:depack1;goto endetest;
    packart2:depack2;
    endetest:
     if pixel_set<102364 then
      begin
       readvfile(1,addr(t1));
       if t1>127 then begin packstring2[0]:=chr(t1);readvfile(1,addr(packstring2[1]));end
        else begin packstring1[0]:=chr(t1);readvfile(t1,addr(packstring1[1]));end;
       if t1>127 then goto packart2 else goto packart1;
      end;
   until pixel_set>=102364;
   if d_offset>0 then begin inc(d_offset,3);showsegment;end;
   emsdealloc(depackhandle);freemem(file_ptr,65535);
  end
 else
  begin
   depackhandle:=emsalloc(4);emsmap4(depackhandle,0,1,2,3);d_segment:=emsframeseg;d_offset:=0;
   depack_ptr:=ptr(d_segment,d_offset);
   repeat
    if packed_size>65536 then begin v_readfile_p1(65535,depack_ptr);dec(packed_size,65536);end
     else if packed_size>0 then begin v_readfile_p1(packed_size-1,depack_ptr);dec(packed_size,packed_size);end;
    if packed_size=0 then v_closefile;
    showsegment;
   until packed_size=0;
   emsdealloc(depackhandle);
  end;
end;

procedure depack1_2ems(handle:emshandle;po:pointer);
var aktwin_ems:^byte;
begin
 aktwin_ems:=po;
 asm
  push es;mov ax,d_segment;mov es,ax;mov di,d_offset;lea si,packstring1;lodsb;xor ch,ch;mov cl,al;rep movsb;mov d_offset,di;
  pop es
 end;
 inc(pixel_set,length(packstring1));if d_offset=0 then
  begin emsmap4(handle,aktwin_ems^,aktwin_ems^+1,aktwin_ems^+2,aktwin_ems^+3);inc(aktwin_ems^,4);end;
end;

procedure depack2_2ems(handle:emshandle;po:pointer);
var counter:byte;aktwin_ems:^byte;
begin
 aktwin_ems:=po;
 asm
  push es;mov ax,d_segment;mov es,ax;mov di,d_offset;lea si,packstring2;lodsb;xor ch,ch;and al,127;mov cl,al;lodsb;rep stosb;
  mov d_offset,di;pop es
 end;
 inc(pixel_set,(ord(packstring2[0]) and 127));if d_offset=0 then
  begin emsmap4(handle,aktwin_ems^,aktwin_ems^+1,aktwin_ems^+2,aktwin_ems^+3);inc(aktwin_ems^,4);end;
end;


procedure depackfile_2ems(name:string;po:pointer;start_pic:byte;count_pic:word;handle:emshandle);
label packart1,packart2,endetest;
var status:boolean;t1:byte;farb_ptr:^farben;farb_array:farben;packart:byte;aktwin_ems:byte;
begin
 farb_ptr:=po; aktwin_depack:=0;
 asm cli;end;
 emsmap4(handle,0,1,2,3);aktwin_ems:=4;
 v_openfile(name);packed_size:=v_getfilesize(name)-1001;
 v_readfile(1,addr(packart));v_readfile(1000,addr(farb_array));
 move(farb_array[word(start_pic)*3],farb_ptr^[word(start_pic)*3],(word(count_pic)*3));
 if packart=0 then
  begin
   d_segment:=emsframeseg;d_offset:=0;depack_ptr:=ptr(d_segment,d_offset);
   getmem(file_ptr,65535);  fileseg:=seg(file_ptr^);    fileofs:=ofs(file_ptr^);
   readpackedfile;pixel_set:=0;
   repeat
    goto endetest;
    packart1:depack1_2ems(handle,addr(aktwin_ems));goto endetest;
    packart2:depack2_2ems(handle,addr(aktwin_ems));
    endetest:
     if pixel_set<102364 then
      begin
       readvfile(1,addr(t1));
       if t1>127 then begin packstring2[0]:=chr(t1);readvfile(1,addr(packstring2[1]));end
        else begin packstring1[0]:=chr(t1);readvfile(t1,addr(packstring1[1]));end;
       if t1>127 then goto packart2 else goto packart1;
      end;
   until pixel_set>=102364;
   if d_offset>0 then begin inc(d_offset,3);end;
   freemem(file_ptr,65535);
  end
 else
  begin
   d_segment:=emsframeseg;d_offset:=0;depack_ptr:=ptr(d_segment,d_offset);emsmap4(handle,0,1,2,3);
   repeat
    if packed_size>65536 then begin v_readfile_p1(65535,depack_ptr);dec(packed_size,65536);end
    else if packed_size>0 then begin v_readfile_p1(packed_size-1,depack_ptr);dec(packed_size,packed_size);end;
    emsmap4(handle,aktwin_ems,aktwin_ems+1,aktwin_ems+2,aktwin_ems+3);inc(aktwin_ems,4);
    if packed_size=0 then v_closefile;
   until packed_size=0;
  end;
 asm sti;end;
end;


procedure scroll_left(startx:word);
 var offs:word;lo:longint;sy1,sy2,sy3,sy4,li1,li2,li3,li4:word;
begin
 asm cli;end;
 if startx+316>=512      then begin sy1:=105;sy2:=204;sy3:=307;sy4:=409;li1:=99;li2:=103;li3:=102;li4:=22;end
 else if startx+316>=384 then begin sy1:=105;sy2:=205;sy3:=307;sy4:=409;li1:=100;li2:=102;li3:=102;li4:=22;end
 else if startx+316>=128 then begin sy1:=105;sy2:=205;sy3:=307;sy4:=410;li1:=100;li2:=102;li3:=103;li4:=21;end
 else                         begin sy1:=105;sy2:=205;sy3:=308;sy4:=410;li1:=100;li2:=103;li3:=102;li4:=21;end;
 moveaktwin(1);lo:=sy1*640+startx-(1*65536)+316;offs:=word(lo);
  vcopy_screen_2_mem(li1,offs,seg(save_block^[0]),ofs(save_block^[0]));
 moveaktwin(2);lo:=sy2*640+startx-(2*65536)+316;offs:=word(lo);
  vcopy_screen_2_mem(li2,offs,seg(save_block^[li1]),ofs(save_block^[li1]));
 moveaktwin(3);lo:=sy3*640+startx-(3*65536)+316;offs:=word(lo);
  vcopy_screen_2_mem(li3,offs,seg(save_block^[li1+li2]),ofs(save_block^[li1+li2]));
 moveaktwin(4);lo:=sy4*640+startx-(4*65536)+316;offs:=word(lo);
  vcopy_screen_2_mem(li4,offs,seg(save_block^[li1+li2+li3]),ofs(save_block^[li1+li2+li3]));

 vbl;
 moveaktwin(1);lo:=sy1*640+startx-(1*65536)+316;offs:=word(lo);
  vcopy_mem_2_screen(li1,seg(data_block^[0]),ofs(data_block^[0]),offs);
 moveaktwin(2);lo:=sy2*640+startx-(2*65536)+316;offs:=word(lo);
  vcopy_mem_2_screen(li2,seg(data_block^[li1]),ofs(data_block^[li1]),offs);
 moveaktwin(3);lo:=sy3*640+startx-(3*65536)+316;offs:=word(lo);
  vcopy_mem_2_screen(li3,seg(data_block^[li1+li2]),ofs(data_block^[li1+li2]),offs);
 moveaktwin(4);lo:=sy4*640+startx-(4*65536)+316;offs:=word(lo);
  vcopy_mem_2_screen(li4,seg(data_block^[li1+li2+li3]),ofs(data_block^[li1+li2+li3]),offs);

 if startx-4>=512      then begin sy1:=105;sy2:=204;sy3:=307;sy4:=409;li1:=99;li2:=103;li3:=102;li4:=22;end
 else if startx-4>=384 then begin sy1:=105;sy2:=205;sy3:=307;sy4:=409;li1:=100;li2:=102;li3:=102;li4:=22;end
 else if startx-4>=128 then begin sy1:=105;sy2:=205;sy3:=307;sy4:=410;li1:=100;li2:=102;li3:=103;li4:=21;end
 else                       begin sy1:=105;sy2:=205;sy3:=308;sy4:=410;li1:=100;li2:=103;li3:=102;li4:=21;end;
 moveaktwin(1);lo:=sy1*640+startx-(1*65536)-4;offs:=word(lo);
  vcopy_mem_2_screen(li1,seg(save_block^[0]),ofs(save_block^[0]),offs);
 moveaktwin(2);lo:=sy2*640+startx-(2*65536)-4;offs:=word(lo);
  vcopy_mem_2_screen(li2,seg(save_block^[li1]),ofs(save_block^[li1]),offs);
 moveaktwin(3);lo:=sy3*640+startx-(3*65536)-4;offs:=word(lo);
  vcopy_mem_2_screen(li3,seg(save_block^[li1+li2]),ofs(save_block^[li1+li2]),offs);
 moveaktwin(4);lo:=sy4*640+startx-(4*65536)-4;offs:=word(lo);
  vcopy_mem_2_screen(li4,seg(save_block^[li1+li2+li3]),ofs(save_block^[li1+li2+li3]),offs);
 asm sti;end;
end;

procedure scroll_right(startx:word);
 var offs:word;lo:longint;sy1,sy2,sy3,sy4,li1,li2,li3,li4:word;
begin
 asm cli;end;
 if startx>=512      then begin sy1:=105;sy2:=204;sy3:=307;sy4:=409;li1:=99;li2:=103;li3:=102;li4:=22;end
 else if startx>=384 then begin sy1:=105;sy2:=205;sy3:=307;sy4:=409;li1:=100;li2:=102;li3:=102;li4:=22;end
 else if startx>=128 then begin sy1:=105;sy2:=205;sy3:=307;sy4:=410;li1:=100;li2:=102;li3:=103;li4:=21;end
 else                     begin sy1:=105;sy2:=205;sy3:=308;sy4:=410;li1:=100;li2:=103;li3:=102;li4:=21;end;
 moveaktwin(1);lo:=sy1*640+startx-(1*65536);offs:=word(lo);
  vcopy_screen_2_mem(li1,offs,seg(save_block^[0]),ofs(save_block^[0]));
 moveaktwin(2);lo:=sy2*640+startx-(2*65536);offs:=word(lo);
  vcopy_screen_2_mem(li2,offs,seg(save_block^[li1]),ofs(save_block^[li1]));
 moveaktwin(3);lo:=sy3*640+startx-(3*65536);offs:=word(lo);
  vcopy_screen_2_mem(li3,offs,seg(save_block^[li1+li2]),ofs(save_block^[li1+li2]));
 moveaktwin(4);lo:=sy4*640+startx-(4*65536);offs:=word(lo);
  vcopy_screen_2_mem(li4,offs,seg(save_block^[li1+li2+li3]),ofs(save_block^[li1+li2+li3]));

 vbl;
 moveaktwin(1);lo:=sy1*640+startx-(1*65536);offs:=word(lo);
  vcopy_mem_2_screen(li1,seg(data_block^[0]),ofs(data_block^[0]),offs);
 moveaktwin(2);lo:=sy2*640+startx-(2*65536);offs:=word(lo);
  vcopy_mem_2_screen(li2,seg(data_block^[li1]),ofs(data_block^[li1]),offs);
 moveaktwin(3);lo:=sy3*640+startx-(3*65536);offs:=word(lo);
  vcopy_mem_2_screen(li3,seg(data_block^[li1+li2]),ofs(data_block^[li1+li2]),offs);
 moveaktwin(4);lo:=sy4*640+startx-(4*65536);offs:=word(lo);
  vcopy_mem_2_screen(li4,seg(data_block^[li1+li2+li3]),ofs(data_block^[li1+li2+li3]),offs);

 if startx+320>=512      then begin sy1:=105;sy2:=204;sy3:=307;sy4:=409;li1:=99;li2:=103;li3:=102;li4:=22;end
 else if startx+320>=384 then begin sy1:=105;sy2:=205;sy3:=307;sy4:=409;li1:=100;li2:=102;li3:=102;li4:=22;end
 else if startx+320>=128 then begin sy1:=105;sy2:=205;sy3:=307;sy4:=410;li1:=100;li2:=102;li3:=103;li4:=21;end
 else                         begin sy1:=105;sy2:=205;sy3:=308;sy4:=410;li1:=100;li2:=103;li3:=102;li4:=21;end;
 moveaktwin(1);lo:=sy1*640+startx-(1*65536)+320;offs:=word(lo);
  vcopy_mem_2_screen(li1,seg(save_block^[0]),ofs(save_block^[0]),offs);
 moveaktwin(2);lo:=sy2*640+startx-(2*65536)+320;offs:=word(lo);
  vcopy_mem_2_screen(li2,seg(save_block^[li1]),ofs(save_block^[li1]),offs);
 moveaktwin(3);lo:=sy3*640+startx-(3*65536)+320;offs:=word(lo);
  vcopy_mem_2_screen(li3,seg(save_block^[li1+li2]),ofs(save_block^[li1+li2]),offs);
 moveaktwin(4);lo:=sy4*640+startx-(4*65536)+320;offs:=word(lo);
  vcopy_mem_2_screen(li4,seg(save_block^[li1+li2+li3]),ofs(save_block^[li1+li2+li3]),offs);
 asm sti;end;
end;
procedure xtrude_li_data(handle:emshandle;startx:word);
var li1,li2,start2:word;
begin
 if startx>=256 then begin li1:=204;li2:=122;start2:=startx-256;end
 else                begin li1:=205;li2:=121;start2:=startx+64;end;
 emsmap4(handle,0,1,2,3);vcopy_mem_2_mem(li1,emsframeseg,startx,seg(data_block^[0]),ofs(data_block^[0]));
 emsmap4(handle,4,5,6,7);vcopy_mem_2_mem(li2,emsframeseg,start2,seg(data_block^[li1]),ofs(data_block^[li1]));
end;

procedure splitview(zeile:word);
begin
 asm
  mov cx,zeile;mov bx,cx;mov dx,$3d4;mov al,7;out dx,al;inc dx;in al,dx;and al,239;shr cx,4;and cl,16;or al,cl;out dx,al
  dec dx;mov al,9;out dx,al;inc dx;in al,dx;and al,191;shr bl,3;and bl,64;or al,bl;out dx,al
  dec dx;mov al,$18;out dx,al;inc dx;mov ax,zeile;out dx,al
 end;
end;

procedure setstart(row:word);assembler;
 asm
  pusha;mov cx,row;mov dx,$03d4;mov al,$0d;out dx,al;inc dx;mov al,cl;out dx,al
  dec dx;mov al,$0c;out dx,al;inc dx;mov al,ch;out dx,al;popa
end;

procedure pagescroll_del(startx:word);
 var offs:word;lo:longint;sy1,sy2,sy3,sy4,li1,li2,li3,li4:word;
begin
 asm cli;end;
 if startx>=512      then begin sy1:=105;sy2:=204;sy3:=307;sy4:=409;li1:=99;li2:=103;li3:=102;li4:=22;end
 else if startx>=384 then begin sy1:=105;sy2:=205;sy3:=307;sy4:=409;li1:=100;li2:=102;li3:=102;li4:=22;end
 else if startx>=128 then begin sy1:=105;sy2:=205;sy3:=307;sy4:=410;li1:=100;li2:=102;li3:=103;li4:=21;end
 else                     begin sy1:=105;sy2:=205;sy3:=308;sy4:=410;li1:=100;li2:=103;li3:=102;li4:=21;end;
 moveaktwin(1);lo:=sy1*640+startx-(1*65536);offs:=word(lo);
  vcopy_s_bkg(li1,offs,0);
 moveaktwin(2);lo:=sy2*640+startx-(2*65536);offs:=word(lo);
  vcopy_s_bkg(li2,offs,0);
 moveaktwin(3);lo:=sy3*640+startx-(3*65536);offs:=word(lo);
  vcopy_s_bkg(li3,offs,0);
 moveaktwin(4);lo:=sy4*640+startx-(4*65536);offs:=word(lo);
  vcopy_s_bkg(li4,offs,0);
 asm sti;end;
end;

procedure init_button_pos;
begin
 button_pos[0,0].x1:=10;  button_pos[0,0].y1:=108;button_pos[0,0].x2:=319;button_pos[0,0].y2:=147;
 button_pos[0,1].x1:=10;  button_pos[0,1].y1:=148;button_pos[0,1].x2:=319;button_pos[0,1].y2:=187;
 button_pos[0,2].x1:=10;  button_pos[0,2].y1:=188;button_pos[0,2].x2:=319;button_pos[0,2].y2:=227;
 button_pos[0,3].x1:=10;  button_pos[0,3].y1:=228;button_pos[0,3].x2:=319;button_pos[0,3].y2:=267;
 button_pos[0,4].x1:=10;  button_pos[0,4].y1:=268;button_pos[0,4].x2:=319;button_pos[0,4].y2:=307;
 button_pos[0,5].x1:=10;  button_pos[0,5].y1:=308;button_pos[0,5].x2:=319;button_pos[0,5].y2:=347;
 button_pos[0,6].x1:=10;  button_pos[0,6].y1:=348;button_pos[0,6].x2:=319;button_pos[0,6].y2:=387;
 button_pos[0,7].x1:=10;  button_pos[0,7].y1:=388;button_pos[0,7].x2:=319;button_pos[0,7].y2:=427;

 button_pos[1,0].x1:=320;button_pos[1,0].y1:=108;button_pos[1,0].x2:=619;button_pos[1,0].y2:=147;
 button_pos[1,1].x1:=320;button_pos[1,1].y1:=148;button_pos[1,1].x2:=619;button_pos[1,1].y2:=187;
 button_pos[1,2].x1:=320;button_pos[1,2].y1:=188;button_pos[1,2].x2:=619;button_pos[1,2].y2:=227;
 button_pos[1,3].x1:=320;button_pos[1,3].y1:=228;button_pos[1,3].x2:=619;button_pos[1,3].y2:=267;
 button_pos[1,4].x1:=320;button_pos[1,4].y1:=268;button_pos[1,4].x2:=619;button_pos[1,4].y2:=307;
 button_pos[1,5].x1:=320;button_pos[1,5].y1:=308;button_pos[1,5].x2:=619;button_pos[1,5].y2:=347;
 button_pos[1,6].x1:=320;button_pos[1,6].y1:=348;button_pos[1,6].x2:=619;button_pos[1,6].y2:=387;
 button_pos[1,7].x1:=320;button_pos[1,7].y1:=388;button_pos[1,7].x2:=619;button_pos[1,7].y2:=427;

 spec_but[0].x1:=20 ;spec_but[0].x2:=68 ;spec_but[0].y1:=450;spec_but[0].y2:=472;
 spec_but[1].x1:=80 ;spec_but[1].x2:=128;spec_but[1].y1:=450;spec_but[1].y2:=472;
 spec_but[2].x1:=140;spec_but[2].x2:=188;spec_but[2].y1:=450;spec_but[2].y2:=472;
 spec_but[3].x1:=200;spec_but[3].x2:=248;spec_but[3].y1:=450;spec_but[3].y2:=472;
 spec_but[4].x1:=260;spec_but[4].x2:=308;spec_but[4].y1:=450;spec_but[4].y2:=472;
 spec_but[5].x1:=320;spec_but[5].x2:=368;spec_but[5].y1:=450;spec_but[5].y2:=472;
 spec_but[6].x1:=380;spec_but[6].x2:=428;spec_but[6].y1:=450;spec_but[6].y2:=472;
 spec_but[7].x1:=458;spec_but[7].x2:=477;spec_but[7].y1:=452;spec_but[7].y2:=471;
end;
procedure init_opti_button;
begin
 tm^.b[0,0]:='Das Specials-Menu im CREAM';tm^.b[0,1]:='';
 tm^.b[1,0]:='Der OPTIONS-Screen';        tm^.b[1,1]:='fuer Eure Einstellungen';
 tm^.b[2,0]:='Der VOTER-Screen';          tm^.b[2,1]:='fuer Eure Meinungen';
 {tm^.b[3,0]:='Der Such-Screen';           tm^.b[3,1]:='falls ihr einen Text sucht';}
 tm^.b[3,0]:='Der EXIT-TO-DOS-Button';    tm^.b[3,1]:='fuer dringende Notfaelle';
end;


procedure plot_but_u(but:byte);
begin
 if (submenu_active=0)and(optmenu_active=0) then
  begin
   plot_button_text_u(but,textside[aktpage],tm^.a[but].but[0,0],tm^.a[but].but[0,1],text_norm_col);
   if tm^.a[but].anz>0 then plot_sm_indi_u(but,textside[aktpage],text_norm_col);
  end
 else
  begin
   plot_button_text_u(but,textside[aktpage],tm^.a[but].but[0,0],tm^.a[but].but[0,1],text_norm_col);
   if tm^.a[but].anz>0 then plot_sm_indi_u(but,textside[aktpage],text_norm_col);
  end;
end;



procedure get_time;assembler;
asm
 mov dx,$70;mov al,10;out dx,al;inc dx;in al,dx;shr al,7;or al,al;jne @binaer;

 mov al,time_set.hour;mov alttime_set.hour,al
 mov al,time_set.min ;mov alttime_set.min,al
 mov al,time_set.sec ;mov alttime_set.sec,al

 mov dx,$70;mov al,0;out dx,al;inc dx;in al,dx;mov time_set.sec,al
 mov dx,$70;mov al,2;out dx,al;inc dx;in al,dx;mov time_set.min,al
 mov dx,$70;mov al,4;out dx,al;inc dx;in al,dx;mov time_set.hour,al
 mov dx,$70;mov al,11;out dx,al;inc dx;in al,dx;shr al,2;and al,1
 or al,al
 jne @binaer
 mov al,time_set.sec;mov bl,al;and bl,$0f;shr al,4;mov dl,10;mul dl;add al,bl;mov time_set.sec,al
 mov al,time_set.min;mov bl,al;and bl,$0f;shr al,4;mov dl,10;mul dl;add al,bl;mov time_set.min,al
 mov al,time_set.hour;mov bl,al;and bl,$0f;shr al,4;mov dl,10;mul dl;add al,bl;mov time_set.hour,al
 @binaer:
end;
procedure show_time_dotti(stat:byte);
begin
 if stat=0 then
  begin
   vputpixel_woc(607,458,36);vputpixel_woc(607,460,36);
   vputpixel_woc(606,459,36);vputpixel_woc(608,459,36);
   vputpixel_woc(607,459,36);

   vputpixel_woc(607,464,36);vputpixel_woc(607,466,36);
   vputpixel_woc(606,465,36);vputpixel_woc(608,465,36);
   vputpixel_woc(607,465,36);
  end
 else
  begin
   vputpixel_woc(607,458,40);vputpixel_woc(607,460,40);
   vputpixel_woc(606,459,40);vputpixel_woc(608,459,40);
   vputpixel_woc(607,459,44);

   vputpixel_woc(607,464,40);vputpixel_woc(607,466,40);
   vputpixel_woc(606,465,40);vputpixel_woc(608,465,40);
   vputpixel_woc(607,465,44);
  end;
end;



procedure show_time_digit(pos,c:byte);
var x1,y1,y:word;
begin
 if pos=0 then begin x1:=584;y1:=455;end;
 if pos=1 then begin x1:=595;y1:=455;end;
 if pos=2 then begin x1:=611;y1:=455;end;
 if pos=3 then begin x1:=622;y1:=455;end;
 for y:=y1 to y1+14 do vputvirtblock(x1,y,8,seg(time_font^[c,(y-y1)]),ofs(time_font^[c,(y-y1)]));
end;
procedure show_time_value(pos,val:byte);
begin
 moveaktwin(4);
 if pos=0 then
  begin
   if val<10 then begin show_time_digit(0,10);show_time_digit(1,val);end
   else begin show_time_digit(0,val div 10);show_time_digit(1,val mod 10);end;
  end;
 if pos=1 then
  begin
   if val<10 then begin show_time_digit(2,0);show_time_digit(3,val);end
   else begin show_time_digit(2,val div 10);show_time_digit(3,val mod 10);end;
  end;
end;
procedure show_time;
label exit;
var y:word;t:byte;
begin
 get_time;
 if alttime_set.sec=time_set.sec then goto exit;
  t:=mouseset;if t>0 then clearmouse;
  moveaktwin(4);
  show_time_dotti(time_set.sec and 1);
 if alttime_set.min=time_set.min then goto exit;
  show_time_value(1,time_set.min);
 if alttime_set.hour=time_set.hour then goto exit;
  show_time_value(0,time_set.hour);
 exit:
 if t>0 then plotmouse;
end;
procedure show_time_imm;
var y:word;t:byte;
begin
 get_time;
 t:=mouseset;if t>0 then clearmouse;
 moveaktwin(4);
 show_time_dotti(time_set.sec and 1);
 show_time_value(0,time_set.hour);
 show_time_value(1,time_set.min);
 if t>0 then plotmouse;
end;

procedure movemouse;assembler;
asm
 cmp mousemoved,0
 je @exitmovemouse
 mov mousemoved,0
 call vbl
 call clearmouse
 call show_time
 call plotmouse
 jmp @exit
 @exitmovemouse:
 call show_time
 @exit:
end;

procedure initmouse;assembler;
asm
 mov ax,0
 int $33
 mov ax,$21
 int $33
 mov mousebut,0
 mov mouseset,0
 mov mousemoved,0
end;
function ismouseinstalled:boolean;
begin
 regs.ax:=0;intr($33,regs);
 if regs.ax=$ffff then ismouseinstalled:=true else ismouseinstalled:=false;
end;

procedure initmousesys;
begin
 initmouse;initmouse;initmousearea(0,0);
 init_new_event_handler(get_event_adress);
 mouse_getpos;
end;
procedure read_pointer_data;
begin
 v_openfile('pfeil2.crp');
 v_readfile(144,addr(mouse_shape));
 v_closefile;
end;

procedure secmousepos;
begin
 mouse.altmx:=altmx;
 mouse.altmy:=altmy;
 mouse.mousex:=mousex;
 mouse.mousey:=mousey;
end;
procedure resmousepos;
begin
 altmx:=mouse.altmx;
 altmy:=mouse.altmy;
 mousex:=mouse.mousex;
 mousey:=mouse.mousey;
 mouse.mset:=1;
 mouse_setpos(mouse.mousex,mouse.mousey);
end;

{Ende der Mausroutinen}


{game_main_routs}

procedure game_control_keyboard;
var valid:byte;
begin
 repeat
  valid:=0;
  taste:=readkey;
  if taste='q' then begin modus:=exit_game;              valid:=1;end;
  if ord(taste)=27 then begin modus:=exit_game;          valid:=1;end;
  if taste='+' then begin if intell<100 then begin inc(intell);show_values;end;valid:=1;end;
  if taste='-' then begin if intell>1   then begin dec(intell);show_values;end;valid:=1;end;
  if taste='n' then begin modus:=new_game;               valid:=1;end;
  if taste='7' then begin modus:=set_stone;gfx:=0;gfy:=0;valid:=1;end;
  if taste='8' then begin modus:=set_stone;gfx:=1;gfy:=0;valid:=1;end;
  if taste='9' then begin modus:=set_stone;gfx:=2;gfy:=0;valid:=1;end;
  if taste='4' then begin modus:=set_stone;gfx:=0;gfy:=1;valid:=1;end;
  if taste='5' then begin modus:=set_stone;gfx:=1;gfy:=1;valid:=1;end;
  if taste='6' then begin modus:=set_stone;gfx:=2;gfy:=1;valid:=1;end;
  if taste='1' then begin modus:=set_stone;gfx:=0;gfy:=2;valid:=1;end;
  if taste='2' then begin modus:=set_stone;gfx:=1;gfy:=2;valid:=1;end;
  if taste='3' then begin modus:=set_stone;gfx:=2;gfy:=2;valid:=1;end;
  if modus=set_stone then if getstone(gfx,gfy)>0 then modus:=nothing;
  if valid=0 then begin while keypressed do taste:=readkey;valid:=1;taste:=#0;end;
 until valid=1;
end;
procedure game_control_mouse;
var mx,my:word;
begin
 movemouse;
 if mousebut=2 then begin modus:=exit_game;end;
 if mousebut=1 then
  begin
   mx:=mousex-(gameside*327);my:=mousey;mousebut:=0;
   if (mx>3)and(mx<102)and(my>117)and(my<127)then begin modus:=new_game;end;
   if (mx>107)and(mx<206)and(my>117)and(my<127)then begin modus:=exit_game;end;
   if (mx>291)and(mx<301)and(my>117)and(my<127)then begin if intell>1 then begin dec(intell);show_values;end;end;
   if (mx>300)and(mx<310)and(my>117)and(my<127)then begin if intell<100 then begin inc(intell);show_values;end;end;

   if (mx>69) and(mx<123)and(my>309)and(my<329)then begin modus:=set_stone;gfx:=0;gfy:=0;end;
   if (mx>126)and(mx<183)and(my>309)and(my<329)then begin modus:=set_stone;gfx:=1;gfy:=0;end;
   if (mx>186)and(mx<240)and(my>309)and(my<329)then begin modus:=set_stone;gfx:=2;gfy:=0;end;
   if (mx>55) and(mx<116)and(my>328)and(my<364)then begin modus:=set_stone;gfx:=0;gfy:=1;end;
   if (mx>122)and(mx<187)and(my>328)and(my<364)then begin modus:=set_stone;gfx:=1;gfy:=1;end;
   if (mx>192)and(mx<253)and(my>328)and(my<364)then begin modus:=set_stone;gfx:=2;gfy:=1;end;
   if (mx>39) and(mx<109)and(my>363)and(my<407)then begin modus:=set_stone;gfx:=0;gfy:=2;end;
   if (mx>116)and(mx<193)and(my>363)and(my<407)then begin modus:=set_stone;gfx:=1;gfy:=2;end;
   if (mx>199)and(mx<269)and(my>363)and(my<407)then begin modus:=set_stone;gfx:=2;gfy:=2;end;
   if modus=set_stone then if getstone(gfx,gfy)>0 then modus:=nothing;
  end;
end;
procedure react_4_event;
begin
 if modus=set_stone then begin du:=setplayer(gfx,gfy,player_col);modus:=nothing;end;
 if (modus<>exit_game) and (modus<>new_game) then
  begin
   won:=0;modus:=nothing;
   if check_if_won(player_col)<$ff then begin won:=player_col;end
    else begin logic_level1;if check_if_won(comp_col)<$ff then begin won:=comp_col;end;end;
   if won=player_col then inc(games_won) else if won=comp_col then inc(games_lost);
   if (won=0) and (not(exists_free_fields)) then inc(games_patt);
  end;
end;

procedure init_game;
begin
 initmousearea(1,1-gameside);
 games_won:=0;games_lost:=0;games_patt:=0;intell:=100;
 altwon:=1;   altlost:=1;   altpatt:=1;   altintell:=1;
 emsseg:=emsframeseg;initboards;modus:=nothing;show_values;
end;
procedure deinit_game;
begin
 deinitboards;
 initmousearea(0,0);
end;

procedure game_main(side:byte);
label enter_new_game;
begin
 gameside:=side;
 init_game;
 repeat
  enter_new_game:
  reset_gamefield;show_gamefield;
  repeat
   if exists_free_fields then
    if keypressed then game_control_keyboard else game_control_mouse;
   won:=0;if modus<>nothing then react_4_event;
  until (won>0) or (not(exists_free_fields)) or (modus=exit_game)or (modus=new_game);
  if modus=new_game then goto enter_new_game;
  if modus<>exit_game then
   begin
    if won>0 then showwinnerline(won);
    repeat movemouse;until keypressed or(mousebut>0);
    if keypressed then taste:=readkey;
    if (taste='q')or(ord(taste)=27) then modus:=exit_game;taste:=chr(0);
    if mousebut>0 then repeat movemouse;until mousebut=0;
   end;
 until modus=exit_game;
 deinit_game;clearmouse;
end;
{ende game_main_routs}

procedure showpageindi;
var x1,y:word;mo:byte;
begin
 mo:=mouseset;if mo>0 then clearmouse;
 if pageindi_set>0 then exit;
 pageindi_set:=aktpage+1;
 x1:=spec_but[aktpage].x1;
 moveaktwin(4);
 for y:=450 to 472 do vputvirtblock_trans(0,x1,y,58,seg(pageindi^[1,(y-450),0]),ofs(pageindi^[1,(y-450),0]));
 if mo>0 then plotmouse;
end;
procedure showpageindi_p(p:byte);
var x1,y:word;mo:byte;
begin
 mo:=mouseset;if mo>0 then clearmouse;
 x1:=spec_but[p].x1;
 moveaktwin(4);
 for y:=450 to 472 do vputvirtblock_trans(0,x1,y,58,seg(pageindi^[1,(y-450),0]),ofs(pageindi^[1,(y-450),0]));
 if mo>0 then plotmouse;
end;
procedure clearpageindi;
var x1,y:word;mo:byte;
begin
 mo:=mouseset;if mo>0 then clearmouse;
 if pageindi_set=0 then exit;
 x1:=spec_but[pageindi_set-1].x1;
 pageindi_set:=0;
 moveaktwin(4);
 for y:=450 to 472 do vputvirtblock_trans(0,x1,y,58,seg(pageindi^[0,(y-450),0]),ofs(pageindi^[0,(y-450),0]));
 if mo>0 then plotmouse;
end;
procedure clearpageindi_p(p:byte);
var x1,y:word;mo:byte;
begin
 mo:=mouseset;if mo>0 then clearmouse;
 x1:=spec_but[p].x1;
 moveaktwin(4);
 for y:=450 to 472 do vputvirtblock_trans(0,x1,y,58,seg(pageindi^[0,(y-450),0]),ofs(pageindi^[0,(y-450),0]));
 if mo>0 then plotmouse;
end;

procedure show_options_on;
var x1,y:word;mo:byte;
begin
 mo:=mouseset;if mo>0 then clearmouse;
 x1:=spec_but[7].x1;
 moveaktwin(4);
 for y:=452 to 471 do vputvirtblock(x1,y,19,seg(options_switch^[0,(y-452),0]),ofs(options_switch^[0,(y-452),0]));
 if mo>0 then plotmouse;
end;
procedure show_options_off;
var x1,y:word;mo:byte;
begin
 mo:=mouseset;if mo>0 then clearmouse;
 x1:=spec_but[7].x1;
 moveaktwin(4);
 for y:=452 to 471 do vputvirtblock(x1,y,19,seg(options_switch^[1,(y-452),0]),ofs(options_switch^[1,(y-452),0]));
 if mo>0 then plotmouse;
end;


procedure shownextpage;
var x:word;
begin
 x:=0;
 cd_timer_not_allowed;
 clearpageindi;showpageindi;
 move(origpal^[0],zielpal^[0],768);
 aktwin_side:=1-textside[aktpage];depackfile(side_pic[aktpage],zielpal,64,128);
 aktwin_side:=textside[aktpage];depackfile(bkg_pic,zielpal,192,64);
 for x:=0 to 7 do plot_but_u(x);
 button_dat.firstbut:=0;button_dat.lastbut:=7;button_dat.butside:=textside[aktpage];button_dat.lm:=$FF;
 fade_to_all(zielpal,4);{setpal_z;}
 blockmover_x:=0;
 cd_timer_allowed;
end;
procedure showfirstpage;
var x:word;
begin
 init_button_pos;
 cd_timer_not_allowed;
 clearpageindi;showpageindi;
 x:=0;
 aktwin_side:=1-textside[aktpage];depackfile(side_pic[aktpage],addr(header^),64,128);
 aktwin_side:=textside[aktpage];depackfile(bkg_pic,addr(header^),192,64);
 for x:=0 to 7 do plot_but_u(x);
 button_dat.firstbut:=0;button_dat.lastbut:=7;button_dat.butside:=textside[aktpage];button_dat.lm:=$FF;
 cd_timer_allowed;
 blockmover_x:=320;
end;

procedure showfirstpage_w_sm;
var x:word;
begin
 x:=0;init_button_pos;
 cd_timer_not_allowed;
 clearpageindi;showpageindi;
 if open_sm_kind=0 then
  begin
   aktwin_side:=textside[aktpage];depackfile(side_pic[aktpage],addr(header^),64,128);
   aktwin_side:=1-textside[aktpage];depackfile(bkg_pic,addr(header^),192,64);
   button_dat.firstbut:=1;button_dat.lastbut:=tm^.a[aktbut].anz;button_dat.butside:=1-textside[aktpage];button_dat.lm:=$FF;
   plot_button_text_u(0,button_dat.butside,tm^.a[aktbut].but[0,0],tm^.a[aktbut].but[0,1],text_norm_col);
   for i:=1 to tm^.a[aktbut].anz do
    plot_button_text_u(i,button_dat.butside,tm^.a[aktbut].but[i,0],tm^.a[aktbut].but[i,1],text_norm_col);
  end
 else
  begin
   aktwin_side:=1-textside[aktpage];depackfile(side_pic[aktpage],addr(header^),64,128);
   aktwin_side:=textside[aktpage];depackfile(bkg_pic,addr(header^),192,64);
   make_bw(addr(header^),64,191,1);
   button_dat.butside:=textside[aktpage];
   if submenu_active=1 then
    begin
     submenu_active:=0;for x:=0 to 7 do plot_but_u(x);submenu_active:=1;end
    else for x:=0 to 7 do plot_but_u(x);
   button_dat.firstbut:=1;button_dat.lastbut:=tm^.a[aktbut].anz;button_dat.butside:=1-textside[aktpage];button_dat.lm:=$FF;
   plot_button_text_u(0,button_dat.butside,tm^.a[aktbut].but[0,0],tm^.a[aktbut].but[0,1],text_norm_col);
   for i:=1 to tm^.a[aktbut].anz do
    plot_button_text_u(i,button_dat.butside,tm^.a[aktbut].but[i,0],tm^.a[aktbut].but[i,1],text_norm_col);
  end;
 cd_timer_allowed;
end;

procedure tag_button(but,sbut,pos,side:byte);
begin
 if (submenu_active=0)and(optmenu_active=0) then
  begin
   plot_button_text(pos,side,tm^.a[but].but[sbut,0],tm^.a[but].but[sbut,1],text_mark_col);
   if (sbut=0)and(tm^.a[but].anz>0) then plot_sm_indi_u(pos,side,text_mark_col);
  end
 else
  begin
   plot_button_text(pos,side,tm^.a[but].but[sbut,0],tm^.a[but].but[sbut,1],text_mark_col);
   if (sbut=0)and(tm^.a[but].anz>0) then plot_sm_indi_u(pos,side,text_mark_col);
  end;
end;
procedure tag_opt_button(but,side:byte);
begin
 if (submenu_active=0)and(optmenu_active=0) then
  plot_button_text(but,side,tm^.b[but,0],tm^.b[but,1],text_mark_col)
 else
  plot_button_text(but,side,tm^.b[but,0],tm^.b[but,1],text_mark_col);
end;
procedure untag_button(but,sbut,pos,side:byte);
begin
 if (submenu_active=0)and(optmenu_active=0) then
  begin
   plot_button_text(pos,side,tm^.a[but].but[sbut,0],tm^.a[but].but[sbut,1],text_norm_col);
   if (sbut=0)and(tm^.a[but].anz>0) then plot_sm_indi_u(pos,side,text_norm_col);
  end
 else
  begin
   plot_button_text(pos,side,tm^.a[but].but[sbut,0],tm^.a[but].but[sbut,1],text_norm_col);
   if (sbut=0)and(tm^.a[but].anz>0) then plot_sm_indi_u(pos,side,text_norm_col);
  end;
end;
procedure untag_opt_button(but,side:byte);
begin
 if (submenu_active=0)and(optmenu_active=0) then
  plot_button_text(but,side,tm^.b[but,0],tm^.b[but,1],text_norm_col)
 else
  plot_button_text(but,side,tm^.b[but,0],tm^.b[but,1],text_norm_col);
end;
procedure mark_button(pos:byte);
begin
 if optmenu_active=1 then
  begin
   if button_dat.lm<>pos then
    begin
     vbl;clearmouse;
     if button_dat.lm<$ff then untag_opt_button(button_dat.lm,1-textside[aktpage]);
     tag_opt_button(pos,1-textside[aktpage]);button_dat.lm:=pos;plotmouse;aktbut:=pos;
    end;
  end
 else
  begin
  if submenu_active=0 then
  begin
   if button_dat.lm<>pos then
    begin
     vbl;clearmouse;
     if button_dat.lm<$ff then untag_button(button_dat.lm,0,button_dat.lm,textside[aktpage]);
     tag_button(pos,0,pos,textside[aktpage]);button_dat.lm:=pos;plotmouse;aktbut:=pos;aktsbut:=0;
    end;
  end
 else if submenu_active=1 then
  begin
   if button_dat.lm<>pos then
    begin
     vbl;clearmouse;
     if button_dat.lm<$ff then untag_button(aktbut,button_dat.lm,button_dat.lm,1-textside[aktpage]);
     tag_button(aktbut,pos,pos,1-textside[aktpage]);button_dat.lm:=pos;plotmouse;aktsbut:=pos;
    end;
  end;
 end;
end;
procedure unmark_button;
begin
 if optmenu_active=1 then
  begin
   if button_dat.lm<>$ff then
    begin
     vbl;clearmouse;
     untag_opt_button(button_dat.lm,1-textside[aktpage]);
     button_dat.lm:=$ff;plotmouse;
    end;
  end
 else
  begin
  if submenu_active=0 then
  begin
   if button_dat.lm<>$ff then
    begin
     vbl;clearmouse;
     untag_button(button_dat.lm,0,button_dat.lm,textside[aktpage]);
     button_dat.lm:=$ff;plotmouse;
    end;
  end
 else
  begin
   if button_dat.lm<>$ff then
    begin
     vbl;clearmouse;
     untag_button(aktbut,button_dat.lm,button_dat.lm,1-textside[aktpage]);
     button_dat.lm:=$ff;plotmouse;
    end;
  end;
  end;
end;
function chkmpos_quad(quad:quad_type;mx,my:word):boolean;
begin
 if (mx>=quad.x1)and(mx<=quad.x2)and(my>=quad.y1)and(my<=quad.y2) then chkmpos_quad:=true else chkmpos_quad:=false;
end;
function chkmpos_two(quad:quad_type;mwert,dir:word):boolean;
begin {dir=0 x-werte; dir=1 y-werte}
 if dir=0 then begin if (mwert>=quad.x1)and(mwert<=quad.x2) then chkmpos_two:=true else chkmpos_two:=false;end
  else begin if (mwert>=quad.y1)and(mwert<=quad.y2) then chkmpos_two:=true else chkmpos_two:=false;end;
end;

procedure plot_sm_but_2ems(sbut,but:byte;handle:emshandle);
begin
 plot_button_text_2ems(sbut,tm^.a[but].but[sbut,0],tm^.a[but].but[sbut,1],text_norm_col,handle);
end;

procedure plot_sm_hdr_2ems(handle:emshandle);
begin
 plot_button_text_2ems(0,tm^.a[aktbut].but[0,0],tm^.a[aktbut].but[0,1],text_head_col,handle);
end;

procedure plot_m_but_2ems(pos:byte;handle:emshandle);
begin
 plot_button_text_2ems(pos,tm^.a[pos].but[0,0],tm^.a[pos].but[0,1],text_norm_col,handle);
 if tm^.a[pos].anz>0 then plot_sm_indi_2ems(pos,1-textside[aktpage],text_norm_col,handle);
end;

procedure open_submenu(butnum:byte);
var bkghandle:emshandle;direct:byte;
begin
 unmark_button;clearmouse;
 mouse.mset:=0;cd_timer_not_allowed;
 submouse.mousex:=mousex;submouse.mousey:=mousey;
 submouse.altmx:=altmx;submouse.altmy:=altmy;
 button_dat.firstbut:=1;button_dat.lastbut:=tm^.a[butnum].anz;button_dat.lm:=$FF;
 if textside[aktpage]=0 then blockmover_x:=320 else blockmover_x:=0;
 if open_sm_kind=1 then direct:=2 else begin if blockmover_x=320 then direct:=0 else direct:=1;end;
 if direct=0 then
  begin
   bkghandle:=emsalloc(8);mousebut:=0;depackfile_2ems(bkg_pic,zielpal,192,64,bkghandle);
   plot_sm_hdr_2ems(bkghandle);
   for i:=1 to tm^.a[butnum].anz do plot_sm_but_2ems(i,butnum,bkghandle);

   blockmover_x:=320;
   repeat
    xtrude_li_data(bkghandle,blockmover_x-4);
    scroll_left(blockmover_x);dec(blockmover_x,4);
   until blockmover_x=0;
   if button_dat.butside=0 then button_dat.butside:=1 else button_dat.butside:=0;
   emsdealloc(bkghandle);
  end
 else if direct=1 then
  begin
   bkghandle:=emsalloc(8);mousebut:=0;depackfile_2ems(bkg_pic,zielpal,192,64,bkghandle);
   plot_sm_hdr_2ems(bkghandle);
   for i:=1 to tm^.a[butnum].anz do plot_sm_but_2ems(i,butnum,bkghandle);
   blockmover_x:=0;
   repeat
    xtrude_li_data(bkghandle,blockmover_x);
    scroll_right(blockmover_x);inc(blockmover_x,4);
   until blockmover_x=320;
   if button_dat.butside=0 then button_dat.butside:=1 else button_dat.butside:=0;
   emsdealloc(bkghandle);
  end
 else if direct=2 then
  begin
   move(origpal^,zielpal^,768);make_bw(zielpal,64,191,0);fade_to_all(zielpal,2);{setpal_z;}
   if button_dat.butside=0 then button_dat.butside:=1 else button_dat.butside:=0;
   plot_button_text_u(0,button_dat.butside,tm^.a[butnum].but[0,0],tm^.a[butnum].but[0,1],text_head_col);
   for i:=1 to tm^.a[butnum].anz do
    plot_button_text_u(i,button_dat.butside,tm^.a[butnum].but[i,0],tm^.a[butnum].but[i,1],text_norm_col);
  end;
 cd_timer_allowed;
end;
procedure open_spec_menu;
var bkghandle:emshandle;direct:byte;
begin
 mouse.mset:=0;
 cd_timer_not_allowed;
 submouse.mousex:=mousex;submouse.mousey:=mousey;
 submouse.altmx:=altmx;submouse.altmy:=altmy;
 unmark_button;clearmouse;optmenu_active:=1;show_options_on;
 button_dat.firstbut:=1;button_dat.lastbut:=3;button_dat.lm:=$FF;
 initmousearea(1,button_dat.butside);
 if textside[aktpage]=0 then blockmover_x:=320 else blockmover_x:=0;
 if open_sm_kind=1 then direct:=2 else begin if blockmover_x=320 then direct:=0 else direct:=1;end;
 if direct=0 then
  begin
   bkghandle:=emsalloc(8);mousebut:=0;depackfile_2ems(bkg_pic,zielpal,192,64,bkghandle);
   plot_button_text_2ems(0,tm^.b[0,0],tm^.b[0,1],text_head_col,bkghandle);
   for i:=1 to 4 do plot_button_text_2ems(i,tm^.b[i,0],tm^.b[i,1],text_norm_col,bkghandle);
   blockmover_x:=320;
   repeat
    xtrude_li_data(bkghandle,blockmover_x-4);
    scroll_left(blockmover_x);dec(blockmover_x,4);
   until blockmover_x=0;
   if button_dat.butside=0 then button_dat.butside:=1 else button_dat.butside:=0;
   emsdealloc(bkghandle);
  end
 else if direct=1 then
  begin
   bkghandle:=emsalloc(8);mousebut:=0;depackfile_2ems(bkg_pic,zielpal,192,64,bkghandle);
   plot_button_text_2ems(0,tm^.b[0,0],tm^.b[0,1],text_head_col,bkghandle);
   for i:=1 to 4 do plot_button_text_2ems(i,tm^.b[i,0],tm^.b[i,1],text_norm_col,bkghandle);
   blockmover_x:=0;
   repeat
    xtrude_li_data(bkghandle,blockmover_x);
    scroll_right(blockmover_x);inc(blockmover_x,4);
   until blockmover_x=320;
   if button_dat.butside=0 then button_dat.butside:=1 else button_dat.butside:=0;
   emsdealloc(bkghandle);
  end
 else if direct=2 then
  begin
   move(origpal^,zielpal^,768);make_bw(zielpal,64,191,0);fade_to_all(zielpal,2);{setpal_z;}
   if button_dat.butside=0 then button_dat.butside:=1 else button_dat.butside:=0;
   plot_button_text_u(0,button_dat.butside,tm^.b[0,0],tm^.b[0,1],text_head_col);
   for i:=1 to 3 do plot_button_text_u(i,button_dat.butside,tm^.b[i,0],tm^.b[i,1],text_norm_col);
  end;
 cd_timer_allowed;
end;


procedure close_submenu;
var bkghandle:emshandle;direct:byte;
begin
 mouse.mset:=0;
 cd_timer_not_allowed;
 if unmark_on then unmark_button else unmark_on:=true;
 if optmenu_active=1 then show_options_off;
 clearmouse;
 button_dat.firstbut:=0;button_dat.lastbut:=7;button_dat.lm:=$FF;
 if textside[aktpage]=1 then blockmover_x:=320 else blockmover_x:=0;
 if open_sm_kind=1 then direct:=2 else begin if blockmover_x=320 then direct:=0 else direct:=1;end;
 if direct=0 then
  begin
   bkghandle:=emsalloc(8);{mousebut:=0;}depackfile_2ems(bkg_pic,zielpal,192,64,bkghandle);
   for i:=0 to 7 do plot_m_but_2ems(i,bkghandle);
   blockmover_x:=320;
   repeat xtrude_li_data(bkghandle,blockmover_x-4);scroll_left(blockmover_x);dec(blockmover_x,4);until blockmover_x=0;
   if button_dat.butside=0 then button_dat.butside:=1 else button_dat.butside:=0;
   emsdealloc(bkghandle);
  end
 else if direct=1 then
  begin
   bkghandle:=emsalloc(8);{mousebut:=0;}depackfile_2ems(bkg_pic,zielpal,192,64,bkghandle);
   for i:=0 to 7 do plot_m_but_2ems(i,bkghandle);
   blockmover_x:=0;
   repeat xtrude_li_data(bkghandle,blockmover_x);scroll_right(blockmover_x);inc(blockmover_x,4);until blockmover_x=320;
   if button_dat.butside=0 then button_dat.butside:=1 else button_dat.butside:=0;
   emsdealloc(bkghandle);
  end
 else if direct=2 then
  begin
   move(origpal^,zielpal^,768);
   bkghandle:=emsalloc(8);{mousebut:=0;}altmbut:=2;
   depackfile_2ems(side_pic[aktpage],zielpal,64,128,bkghandle);
   plot_ems_to_pic(button_dat.butside,bkghandle);fade_to_all(zielpal,2);{setpal_z;}
   if button_dat.butside=0 then button_dat.butside:=1 else button_dat.butside:=0;
   emsdealloc(bkghandle);
  end;
 cd_timer_allowed;
 mousex:=submouse.mousex;mousey:=submouse.mousey;
 altmx:=submouse.altmx;altmy:=submouse.altmy;
 mouse.mset:=0;
 initmousearea(0,0);
 mouse_setpos(submouse.mousex,submouse.mousey);
 aktsbut:=0;optmenu_active:=0;
end;

procedure load_menu_data(side:byte);
var h:word;
begin
 {h:=openfile('menudata.crd');seekfile(h,0,side*sizeof(menu_side_type));readfile(h,sizeof(menu_side_type),addr(tm^.a));
 closefile(h);}
 v_openfile('menusys.dat');v_seekfile(side*sizeof(menu_side_type));v_readfile(sizeof(menu_side_type),addr(tm^.a));
 v_closefile;
end;
procedure init_lamp(time:byte);
var rtime,m:byte;s,lt:byte;
begin
 rtime:=time;lt:=1;
 for i:=0 to 5 do
  begin
   m:=rtime-(5-i);m:=m div 6*(i+1);
   s:=random(m div 2)+(m div 2)+1;
   dec(rtime,s);inc(s,lt);
   lt:=s;lamp.t[i]:=s;
   if odd(i) then lamp.s[i]:=lamp_off else lamp.s[i]:=lamp_on;
  end;
 lamp.next:=0;
end;


procedure scroll_page_left;
var blockmover:integer;colfadeout,newpage:byte;
begin
 cd_timer_not_allowed;
 clearmouse;{init_lamp(31);clearpageindi;}
 mouse.mset:=0;
 init_fadeout(64,255);vbl;pagescroll_del(632);pagescroll_del(636);
 blockmover:=632;colfadeout:=32;
 {newpage:=aktpage;inc(newpage);if newpage=6 then newpage:=0 else if newpage=$ff then newpage:=5;}
 repeat
  dec(blockmover,12);
  {if (lamp.next<6)and(32-colfadeout=lamp.t[lamp.next]) then
   begin
    if lamp.s[lamp.next]=lamp_on then showpageindi_p(newpage) else clearpageindi_p(newpage);
    inc(lamp.next);
   end;}
  if colfadeout>0 then begin fade_to_step1(zielpal);dec(colfadeout);end;
  if blockmover>327 then begin pagescroll_del(blockmover);pagescroll_del(blockmover+4);pagescroll_del(blockmover+8);end;
 until colfadeout=0;
 inc(aktpage);if aktpage=7 then aktpage:=0 else if aktpage=$ff then aktpage:=6;
 load_menu_data(aktpage);
 shownextpage;mouse_setpos(625,mousey);plotmouse;
 cd_timer_allowed;
end;
function get_spec_but(x:word):byte;
begin
 for i:=0 to 6 do
  if (x>=spec_but[i].x1)and(x<=spec_but[i].x2) then begin get_spec_but:=i;exit;end;
 get_spec_but:=$ff
end;


procedure scroll_page_mid(new_page:byte);
var blockmover:integer;colfadeout:byte;
begin
 cd_timer_not_allowed;
 clearmouse;init_lamp(31);clearpageindi;
 mouse.mset:=0;
 init_fadeout(64,255);vbl;pagescroll_del(309);pagescroll_del(327);
 blockmover:=312;colfadeout:=32;
 repeat
  dec(blockmover,4);
  if (lamp.next<6)and(32-colfadeout=lamp.t[lamp.next]) then
   begin
    if lamp.s[lamp.next]=lamp_on then showpageindi_p(new_page) else clearpageindi_p(new_page);
    inc(lamp.next);
   end;
  if colfadeout>0 then begin fade_to_step1(zielpal);dec(colfadeout);end;
  pagescroll_del(blockmover);pagescroll_del(636-blockmover);
 until colfadeout=0;
 aktpage:=new_page;load_menu_data(aktpage);shownextpage;{mouse_setpos(320,mousey);}plotmouse;
 cd_timer_allowed;
end;

procedure scroll_page_right;
var blockmover:integer;colfadeout,newpage:byte;
begin
 cd_timer_not_allowed;
 clearmouse;{init_lamp(31);clearpageindi;}
 mouse.mset:=0;
 init_fadeout(64,255);vbl;pagescroll_del(0);pagescroll_del(4);pagescroll_del(8);
 blockmover:=0;colfadeout:=32;
 {newpage:=aktpage;dec(newpage);if newpage=6 then newpage:=0 else if newpage=$ff then newpage:=5;}
 repeat
  inc(blockmover,12);
  {if (lamp.next<6)and(32-colfadeout=lamp.t[lamp.next]) then
   begin
    if lamp.s[lamp.next]=lamp_on then showpageindi_p(newpage) else clearpageindi_p(newpage);
    inc(lamp.next);
   end;}
  if colfadeout>0 then begin fade_to_step1(zielpal);dec(colfadeout);end;
  if blockmover<307 then begin pagescroll_del(blockmover);pagescroll_del(blockmover+4);pagescroll_del(blockmover+8);end;
 until colfadeout=0;
 dec(aktpage);if aktpage=7 then aktpage:=0 else if aktpage=$ff then aktpage:=6;
 load_menu_data(aktpage);
 shownextpage;mouse_setpos(5,mousey) ;plotmouse;
 cd_timer_allowed;
end;
procedure clear_stripe_top(sy:word;po:pointer);
var y:word;
begin
 for y:=sy to sy+3 do
  begin
   if y=102 then
    begin moveaktwin(0);vcopy_woc(64,seg(po^),ofs(po^),$a000,65280);moveaktwin(1);vcopy_woc(96,seg(po^),ofs(po^),$a000,0);end
   else if y>102 then begin moveaktwin(1);vcopy_woc(160,seg(po^),ofs(po^),$a000,y*640-65536);end
   else begin moveaktwin(0);vcopy_woc(160,seg(po^),ofs(po^),$a000,(y*640));end;
  end;
end;
procedure clear_stripe_bot(sy:word;po:pointer);
var y:word;
begin
 moveaktwin(4);vcopy_woc(160,seg(po^),ofs(po^),$a000,(sy*640)-262144);
end;

procedure clear_page_mid;
var area_black:array[0..639]of byte;po:pointer;y1,y2:word;
    blockmover:integer;colfadeout:byte;
begin
 clearmouse;
 init_fadeout(64,255);vbl;pagescroll_del(316);pagescroll_del(320);
 fillchar(area_black,640,0);
 blockmover:=320;colfadeout:=32;
 repeat
  dec(blockmover,8);
  if colfadeout>0 then begin fade_to_step1(zielpal);dec(colfadeout);end else blockmover:=0;
  pagescroll_del(blockmover);pagescroll_del(blockmover-4);pagescroll_del(636-blockmover);pagescroll_del(640-blockmover);
 until colfadeout=0;
 po:=addr(area_black);
 init_fadeout(0,64);colfadeout:=32;
 y1:=101;y2:=431;
 repeat
  clear_stripe_top(y1,po);dec(y1,4);clear_stripe_bot(y2,po);inc(y2);
  fade_to_step1(zielpal);dec(colfadeout);
 until colfadeout=0;
 {setpal_z;}
end;
procedure clear_page_mid_search;
var area_black:array[0..639]of byte;po:pointer;y1,y2:word;
    blockmover:integer;colfadeout:byte;
begin
 clearmouse;
 init_fadeout(64,255);vbl;pagescroll_del(316);pagescroll_del(320);
 fillchar(area_black,640,0);
 blockmover:=320;colfadeout:=32;
 repeat
  dec(blockmover,8);
  if colfadeout>0 then begin fade_to_step1(zielpal);dec(colfadeout);end else blockmover:=0;
  pagescroll_del(blockmover);pagescroll_del(blockmover-4);pagescroll_del(636-blockmover);pagescroll_del(640-blockmover);
 until colfadeout=0;

end;

procedure control_mouse;
var button,bc:byte;
begin
 if (mousey>104) and (mousey<422) then
  begin
   if (mousex>620) and (mousebut=1)   then
    begin mousebut:=0;control_fkt:=do_scroll_page_left;mousebut:=0;exit;end
   else if (mousex<9) and (mousebut=1) then
    begin mousebut:=0;control_fkt:=do_scroll_page_right;mousebut:=0;exit;end;

   bc:=0;
   if (submenu_active=0)and(optmenu_active=0) then
    if (chkmpos_two(button_pos[1-button_dat.butside,0],mousex,0))and(mousebut=1) then control_fkt:=do_open_optmenu;
   if (mousebut=2)and(altmbut=0) then control_fkt:=do_exit_menu;
   for button:=button_dat.firstbut to button_dat.lastbut do
    if chkmpos_quad(button_pos[button_dat.butside,button],mousex,mousey) then
     begin
      mark_button(button);inc(bc);
      if mousebut=1 then control_fkt:=do_openclose_button;
     end;
   if bc=0 then unmark_button;
  end
 else if button_dat.lm<>$ff then unmark_button;
 if altmbut=mousebut then exit;
 if (mousebut=2)and(control_fkt<>do_open_game){and((mousey>=422)or(submenu_active=1))}and(altmbut=0) then
   control_fkt:=do_exit_menu;
 if (mousey>=spec_but[0].y1)and(mousey<=spec_but[0].y2)and(mousebut=1) then
  begin
   bc:=get_spec_but(mousex);
   if (bc<$ff)and(bc<>aktpage) then scroll_page_mid(bc);
  end;
 if (mousey>=spec_but[7].y1)and(mousey<=spec_but[7].y2)and(mousebut=1) then
  if (mousex>=spec_but[7].x1)and(mousex<=spec_but[7].x2) then
   begin
    control_fkt:=do_open_optmenu;
   end;
end;

procedure control_keyboard;
var m:byte;
begin
 taste:=readkey;
 if taste=' ' then control_fkt:=do_openclose_button
 else if ord(taste)=13 then control_fkt:=do_openclose_button
 else if taste='q' then control_fkt:=do_exit_menu
 else if ord(taste)=27 then control_fkt:=do_exit_menu
 else if taste='1' then begin if aktpage<>0 then scroll_page_mid(0);end
 else if taste='2' then begin if aktpage<>1 then scroll_page_mid(1);end
 else if taste='3' then begin if aktpage<>2 then scroll_page_mid(2);end
 else if taste='4' then begin if aktpage<>3 then scroll_page_mid(3);end
 else if taste='5' then begin if aktpage<>4 then scroll_page_mid(4);end
 else if taste='6' then begin if aktpage<>5 then scroll_page_mid(5);end
 else if taste='7' then begin if aktpage<>6 then scroll_page_mid(6);end
 else if ord(taste)=0 then
  begin
  if keypressed then
   begin
    taste:=readkey;
    if ord(taste)=68 then begin control_fkt:=do_open_optmenu;end;
    if ord(taste)=75 then
     begin
      if submenu_active=0 then control_fkt:=do_scroll_page_right
      else if submenu_active=1 then control_fkt:=do_exit_menu;
     end;
    if ord(taste)=77 then
     begin
      if submenu_active=0 then control_fkt:=do_scroll_page_left
      else if submenu_active=1 then control_fkt:=do_exit_menu;
     end;
    if ord(taste)=80 then
     begin
      if button_dat.lm=$ff then
       begin
        m:=mouseset;if m>0 then clearmouse;
        mouse_setpos(30+(button_dat.butside*320),122+button_dat.firstbut*38);
        if m>0 then plotmouse;
        control_mouse;
       end
      else
       begin
        m:=mouseset;if m>0 then clearmouse;
        if button_dat.lm+1>button_dat.lastbut then mouse_setpos(30+(button_dat.butside*320),122+button_dat.firstbut*38)
         else mouse_setpos(30+(button_dat.butside*320),122+((button_dat.lm+1)*38));
        if m>0 then plotmouse;
        control_mouse;
       end;
     end;
    if ord(taste)=72 then
     begin
      if button_dat.lm=$ff then
       begin
        m:=mouseset;if m>0 then clearmouse;
        mouse_setpos(30+(button_dat.butside*320),122+button_dat.lastbut*38);
        if m>0 then plotmouse;
        control_mouse;
       end
      else
       begin
        m:=mouseset;if m>0 then clearmouse;
        if button_dat.lm-1<button_dat.firstbut then mouse_setpos(30+(button_dat.butside*320),122+button_dat.lastbut*38)
         else mouse_setpos(30+(button_dat.butside*320),122+((button_dat.lm-1)*38));
        if m>0 then plotmouse;
        control_mouse;
       end;
     end;
   end;
  end;
end;



procedure submenu_kernel;
var m:byte;
begin
 submenu_active:=1;
 initmousearea(1,1-button_dat.butside);
 plotmouse;
 control_fkt:=do_nothing;
 repeat
  movemouse;if keypressed then control_keyboard else control_mouse;
  if control_fkt=do_openclose_button then
   begin
    if length(tm^.a[aktbut].but[aktsbut,0])>0 then
     begin control_fkt:=do_read_text;with text_2_read do begin page:=aktpage;but:=aktbut;sbut:=aktsbut;end;end
    else begin mousebut:=0;control_fkt:=do_nothing;end;
   end;
 until (control_fkt=do_exit_menu)or(control_fkt=do_read_text);
 if (control_fkt=do_read_text) then
  if (text_2_read.page=5)and(text_2_read.but=6)and(text_2_read.sbut=5)then control_fkt:=do_open_game;
 if control_fkt=do_open_game then
    begin
     cd_timer_not_allowed;
     m:=mouseset;clearmouse;
     aktwin_side:=1-textside[aktpage];depackfile(side_pic[aktpage],zielpal,64,128);
     init_fadeout(128,192);fade_to_all(zielpal,3);{setpal_z;}
     cd_timer_allowed;
     game_main(button_dat.butside);
     control_fkt:=do_exit_menu;
     unmark_on:=false;
    end;
 if control_fkt=do_exit_menu then
  begin
   close_submenu;
   control_fkt:=do_nothing;
  end;
 taste:=chr(0);{mousebut:=0;}
 submenu_active:=0;
end;


procedure menu_kernel;
label rein_ins_sm;
var m:byte;
begin
 if submenu_active=1 then goto rein_ins_sm;
 aktsbut:=0;
 plotmouse;
 repeat
  movemouse;if keypressed then control_keyboard else control_mouse;
  if control_fkt=do_openclose_button then
   begin
    if optmenu_active=0 then begin
     if tm^.a[aktbut].anz>0 then
      begin
       if button_dat.lm<>$ff then begin open_submenu(aktbut);rein_ins_sm:submenu_kernel;end
       else control_fkt:=do_nothing;
      end
     else
      begin
       if length(tm^.a[aktbut].but[aktsbut,0])>0 then
        begin control_fkt:=do_read_text;text_2_read.page:=aktpage;text_2_read.but:=aktbut;text_2_read.sbut:=aktsbut;end
       else begin mousebut:=0;control_fkt:=do_nothing;end;
      end;
     end
    else
     begin
      text_2_read.page:=aktpage;text_2_read.but:=0;text_2_read.sbut:=0;
      if button_dat.lm=1 then control_fkt:=do_options
      else if button_dat.lm=2 then control_fkt:=do_voter
      {else if button_dat.lm=3 then control_fkt:=do_search}
      else if button_dat.lm=3 then control_fkt:=do_exit_menu_imm;
     end;
   end;
  if control_fkt=do_scroll_page_left then
   begin scroll_page_left;control_fkt:=do_nothing;end;
  if control_fkt=do_scroll_page_right then
   begin scroll_page_right;control_fkt:=do_nothing;end;
  if control_fkt=do_open_optmenu then
   begin open_spec_menu;control_fkt:=do_nothing;end;
  if (control_fkt=do_exit_menu)and(optmenu_active=1) then
   begin close_submenu;control_fkt:=do_nothing;end;
 until (taste='q')or(control_fkt=do_exit_menu)or(control_fkt=do_read_text)or(control_fkt=do_exit_menu_imm)
  or (control_fkt=do_options)or(control_fkt=do_voter)or(control_fkt=do_search);
end;

procedure read_player_infos;
begin
 assign(f_setup,'player.cfg');
 {$i-}
 reset(f_setup);
 {$i+}
 if ioresult<>0 then setup^.player_cfg.player_used:=0
 else begin read(f_setup,setup^);close(f_setup);end;
end;
{$f+}
procedure init_player(mode:byte);
begin
 if mode=0 then
  begin
   if setup^.player_cfg.player_used=1 then
     mp_init_player(addr(player.player_started),addr(setup^),addr(player.module),addr(player.error_text),max_mod_size);
   if setup^.player_cfg.player_used=2 then
     cd_init_player(addr(player.player_started),addr(setup^));
  end
 else
  begin
   if (setup^.player_cfg.player_used=1)and(mode=1) then
     mp_init_player(addr(player.player_started),addr(setup^),addr(player.module),addr(player.error_text),max_mod_size);
   if (setup^.player_cfg.player_used=2)and(mode=2) then
     cd_init_player(addr(player.player_started),addr(setup^));
  end;
end;
procedure deinit_player(mode:byte);
begin
 if mode=0 then
  begin
   if setup^.player_cfg.player_used=1 then
     mp_deinit_player(addr(player.player_started),addr(player.module));
   if setup^.player_cfg.player_used=2 then
     cd_deinit_player(addr(player.player_started));
  end
 else
  begin
   if (setup^.player_cfg.player_used=1)and(mode=1) then
     mp_deinit_player(addr(player.player_started),addr(player.module));
   if (setup^.player_cfg.player_used=2)and(mode=2) then
     cd_deinit_player(addr(player.player_started));
  end;
end;
{$f-}
function check4hd:boolean;
begin
 regs.ah:=$19;intr($21,regs);if regs.al>1 then check4hd:=true else check4hd:=false;
end;
function get_addy(text:string):pointer;
var co,co2:byte;teilseg,teilofs:word;teil:string[6];du:integer;
begin
 if length(text)<>11 then begin get_addy:=nil;exit;end;
 teil:=copy(text,1,5);val(teil,teilseg,du);inc(co);
 teil:=copy(text,7,5);val(teil,teilofs,du);
 get_addy:=ptr(teilseg,teilofs);
end;

procedure mark_them_all(art:byte);
begin
 if art=0 then
  begin
   mark_them[0]:=setup;
   mark_them[1]:=time_font;
   mark_them[2]:=font;
   mark_them[3]:=pageindi;
   mark_them[4]:=tm;
   mark_them[5]:=save_block;
   mark_them[6]:=data_block;
   mark_them[7]:=header;
   mark_them[8]:=aktpal;
   mark_them[9]:=zielpal;
   mark_them[10]:=origpal;
  end
 else
  begin
   mark_them[1]:=time_font;
   mark_them[2]:=font;
   mark_them[3]:=pageindi;
  end;
end;
procedure release_them_all(art:byte);
begin
 if art=0 then
  begin
   setup:=mark_them[0];
   time_font:=mark_them[1];
   font:=mark_them[2];
   pageindi:=mark_them[3];
   tm:=mark_them[4];
   save_block:=mark_them[5];
   data_block:=mark_them[6];
   header:=mark_them[7];
   aktpal:=mark_them[8];
   zielpal:=mark_them[9];
   origpal:=mark_them[10];
  end
 else
  begin
   time_font:=mark_them[1];
   font:=mark_them[2];
   pageindi:=mark_them[3];
  end;
end;

procedure init_dynamic_vars(mode:byte);
begin
 if mode=0 then
  begin
   new(time_font);
   new(font);new(pageindi);new(options_switch);
   new(tm);
   new(save_block);new(data_block);
   new(header);new(origpal);new(zielpal);new(aktpal);
  end;
 if mode=1 then
  begin
   new(time_font);new(font);new(pageindi);new(options_switch);
  end;
 if mode=2 then
  begin
   new(setup);
  end;
 if mode=255 then
  begin
   new(tm);
   new(time_font);new(font);
   new(pageindi);new(options_switch);
   new(save_block);new(data_block);
   new(header);new(origpal);new(zielpal);new(aktpal);
  end;
end;
procedure deinit_dynamic_vars(mode:byte);
begin
 if mode=0 then
  begin
   dispose(aktpal);dispose(zielpal);dispose(origpal);dispose(header);
   dispose(data_block);dispose(save_block);
   dispose(tm);
   dispose(options_switch);dispose(pageindi);dispose(font);
   dispose(time_font);
   dispose(setup);
  end;
 if mode=1 then
  begin
   dispose(options_switch);dispose(pageindi);dispose(font);
   dispose(time_font);
  end;
 if mode=255 then
  begin
   dispose(aktpal);dispose(zielpal);dispose(origpal);dispose(header);
   dispose(data_block);dispose(save_block);
   dispose(tm);
   dispose(options_switch);dispose(pageindi);dispose(font);
   dispose(time_font);
  end;
end;
function wait4twosecs:boolean;
var i:byte;m:word;
begin
 i:=0;
 repeat
  delay(100);
  m:=mousebut;
  inc(i);
 until keypressed or(m>0)or(i=40);
 if not(keypressed)and (not(m>0)) then wait4twosecs:=false else wait4twosecs:=true;
end;

procedure intro;
var i:byte;m:word;
begin
 initmousesys;
 pure_plotpic('intro.crp',1);
 move(header^,zielpal^,768);
 i:=0;
 repeat
  fade_to_step1_s(zielpal,1);
  inc(i);
  m:=mousebut;
 until (i=64)or(m>0)or(keypressed);
 if (keypressed)or(m>0) then
  begin
   while keypressed do taste:=readkey;
   mousebut:=0;
   initmouse;initmouse;
   exit;
  end;
 setpal_z;
 if wait4twosecs then begin while keypressed do taste:=readkey;mousebut:=0;initmouse;initmouse;exit;end;
 init_fadeout(0,255);fade_to_all(zielpal,4);setpal_z;
end;
procedure extro;
var i:byte;m:word;
begin
 randomize;initmousesys;

 pure_plotpic('extro.crp',1);
 move(header^,zielpal^,768);
 i:=0;repeat fade_to_step1_s(zielpal,1);inc(i);m:=mousebut;until (i=64)or(m>0)or(keypressed);
 if (keypressed)or(m>0) then begin while keypressed do taste:=readkey;mousebut:=0;initmouse;initmouse;exit;end;
 {setpal_z;}
 if wait4twosecs then begin while keypressed do taste:=readkey;mousebut:=0;initmouse;initmouse;exit;end;
 init_fadeout(0,255);fade_to_all(zielpal,4);{setpal_z;}
 initmouse;initmouse;
end;

procedure getfontaccess;
const seqregs:array[1..4]of word=($0100,$0402,$0704,$0300);
      gcregs:array[1..3]of word=($0204,$0005,$0406);
var i:byte;
begin
 asm cli end;
 for i:=1 to 4 do portw[$3c4]:=seqregs[i];
 for i:=1 to 3 do portw[$3ce]:=gcregs[i];
 asm sti end;
end;
procedure releasefontaccess;
const seqregs:array[1..4]of word=($0100,$0302,$0304,$0300);
      gcregs:array[1..3]of word=($0004,$1005,$0e06);
var i:byte;
begin
 asm cli end;
 for i:=1 to 4 do portw[$3c4]:=seqregs[i];
 for i:=1 to 3 do portw[$3ce]:=gcregs[i];
 asm sti end;
end;

procedure create_alpha;
var rseed,i:byte;
begin
 rseed:=random(256);for i:=0 to 255 do begin rseed:=rseed*36421+1;alpha[i]:=rseed;end;
end;

procedure clear_font;
const andmap:array[0..7]of byte=($7f,$bf,$df,$ef,$f7,$fb,$fd,$fe);
var map:array[0..255,0..31]of byte;
    i,j,k,c,wert,divwert,modwert:byte;
    addy:^byte;
    w:word;
begin
 asm
  mov ah,2
  mov bh,0
  mov dh,25
  mov dl,0
  int $10
 end;    {setze cursor-pos}
 getfontaccess;
 for w:=0 to 8191 do savemap[w]:=mem[$a000:w];
 for i:=0 to 255 do for j:=0 to 31 do map[i,j]:=255;
 create_alpha;
 for i:=0 to 15 do
  begin
   if i>0 then for j:=0 to 31 do map[i,j]:=map[i-1,j];
   for k:=0 to 15 do
    begin
     wert:=alpha[i*16+k];divwert:=wert div 8;modwert:=wert mod 8;
     map[i,divwert]:=map[i,divwert] and andmap[modwert];
    end;
  end;
 getfontaccess;
 for i:=0 to 15 do
  begin
   vbl;
   for c:=0 to 255 do
    for j:=0 to 31 do
     mem[$a000:c*32+j]:=mem[$a000:c*32+j] and map[i,j];
  end;
 releasefontaccess;
end;
procedure restore_font;
var w:word;
begin
 getfontaccess;
 for w:=0 to 8191 do mem[$a000:w]:=savemap[w];
 releasefontaccess;
end;


procedure init_menu_system(art:byte);
begin
 if art=0 then
  begin
   if get_proz<7 then
    begin
     writeln('Neuen Prozessor kaufen!!! :-) Luft nmlich erst ab 386er.');halt;
    end;
   if not(check4hd) then
    begin
     writeln('Bitte von HD starten!');halt;
    end;
   if not(check4vesa) then
    begin
     writeln('Keine VESA-Karte gefunden! Bitte UNIVBE installieren und erneut versuchen!');
     halt;
    end;
   if not(emsisinstalled) then
    begin
     writeln('Bitte EMM386 installieren!');halt;
    end;
   if emsfreepages<40 then
    begin
     writeln('Keinen freien EMS-Speicher gefunden!');halt;
    end;
   if not(ismouseinstalled) then
    begin
     writeln('Keine Maus gefunden! Bitte Treiber/Maus installieren.');halt;
    end;

   clear_key_buffer;
   mark(menu_heap_start_ptr);
   init_dynamic_vars(2);
   read_player_infos;
   if setup^.player_cfg.player_used=0 then
    begin
     {if memavail<120000 then
      begin
       writeln('Zuwenig RAM frei! ',memavail-120000:10,' Bytes mehr bentigt!');halt;
      end;}
    end
   else
    begin
     {if memavail<170000 then
      begin
       writeln('Zuwenig RAM frei! ',memavail-170000:10,' Bytes mehr bentigt!');halt;
      end;}
    end;

   randomize;
   clear_font;
   cd_stop_poss_player;
    write_debug('',0);write_debug('MEM vor Player: ',memavail);write_debug('EMS vor Player: ',emsfreepages);
     init_player(0);player.altmodule:=player.module;
     cd_timer_not_allowed;
    write_debug('MEM nach Player: ',memavail);write_debug('EMS nach Player: ',emsfreepages);
   mark(menu_heap_start_ptr2);
   init_dynamic_vars(0);
   clear_key_buffer;
   intro;
   open_sm_kind:=1;
   aktpage:=0;aktbut:=0;aktsbut:=0;submenu_active:=0;pageindi_set:=0;mouseset:=0;mouse.mset:=0;
   unmark_on:=true;

   plotpic('mainpic2.crp',1);load_menu_data(aktpage);init_opti_button;optmenu_active:=0;
   cd_timer_allowed;
   control_fkt:=do_nothing;
   showfirstpage;setorigpal;fillchar(data_block^,1304,0);
   randomize;
   initmousesys;read_pointer_data;
   clear_time_seg:=seg(clear_time_ptr);clear_time_ofs:=ofs(clear_time_ptr);
   fillchar(clear_time_ptr,100,4);
   show_time_imm;
  end
 else if art=1 then
  begin
   init_dynamic_vars(0);read_player_infos;
   aktpage:=0;aktbut:=0;aktsbut:=0;submenu_active:=0;pageindi_set:=0;mouseset:=0;mouse.mset:=0;
   initmousesys;read_pointer_data;
   aktpage:=text_2_read.page;aktbut:=text_2_read.but;aktsbut:=text_2_read.sbut;
   pageindi_set:=0;mouseset:=0;
   cd_timer_not_allowed;
   if aktsbut=0 then
    begin
     submenu_active:=0;plotpic('mainpic2.crp',0);load_menu_data(aktpage);
     control_fkt:=do_nothing;showfirstpage;setorigpal;fillchar(data_block^,1304,0);
    end
   else
    begin
     submenu_active:=1;plotpic('mainpic2.crp',0);load_menu_data(aktpage);control_fkt:=do_nothing;
     showfirstpage_w_sm;
     setorigpal;
     fillchar(data_block^,1304,0);
    end;
   cd_timer_allowed;
   randomize;
   initmousesys;read_pointer_data;resmousepos;
   show_time_imm;
  end
 else if art=2 then
  begin
   init_dynamic_vars(0);read_player_infos;
   aktpage:=0;aktbut:=0;aktsbut:=0;submenu_active:=0;pageindi_set:=0;mouseset:=0;mouse.mset:=0;
   aktpage:=text_2_read.page;aktbut:=text_2_read.but;aktsbut:=text_2_read.sbut;
   pageindi_set:=0;mouseset:=0;
   cd_timer_not_allowed;
   if aktsbut=0 then
    begin
     submenu_active:=0;plotpic('mainpic2.crp',1);load_menu_data(aktpage);
     control_fkt:=do_nothing;showfirstpage;setorigpal;
    end
   else
    begin
     submenu_active:=1;plotpic('mainpic2.crp',1);load_menu_data(aktpage);
     control_fkt:=do_nothing;showfirstpage_w_sm;setorigpal;
    end;
   cd_timer_allowed;
   randomize;
   initmousesys;read_pointer_data;resmousepos;
   show_time_imm;
  end
 else if art=3 then
  begin
   init_dynamic_vars(0);{release_them_all(1);}
   open_sm_kind:=1;
   aktpage:=text_2_read.page;aktbut:=text_2_read.but;aktsbut:=text_2_read.sbut;
   pageindi_set:=0;mouseset:=0;unmark_on:=true;
   cd_timer_not_allowed;
   if aktsbut=0 then
    begin
     submenu_active:=0;plotpic('mainpic2.crp',1);load_menu_data(aktpage);
     control_fkt:=do_nothing;showfirstpage;setorigpal;
    end
   else
    begin
     submenu_active:=1;plotpic('mainpic2.crp',1);load_menu_data(aktpage);
     control_fkt:=do_nothing;showfirstpage_w_sm;setorigpal;
    end;
   cd_timer_allowed;
   init_opti_button;
   control_fkt:=do_nothing;
   fillchar(data_block^,1304,0);
   randomize;
   initmousesys;read_pointer_data;
   clear_time_seg:=seg(clear_time_ptr);clear_time_ofs:=ofs(clear_time_ptr);
   fillchar(clear_time_ptr,100,4);
   show_time_imm;
   {unpause_mod_player;}
  end;
 if art=4 then
  begin
   mark(menu_heap_start_ptr);
   init_dynamic_vars(2);
   read_player_infos;init_player(0);player.altmodule:=player.module;
   mark(menu_heap_start_ptr2);
   init_dynamic_vars(0);
   {mark_them_all(0);}
   open_sm_kind:=1;
   aktpage:=text_2_read.page;aktbut:=0;aktsbut:=0;submenu_active:=0;pageindi_set:=0;mouseset:=0;mouse.mset:=0;
   unmark_on:=true;
   cd_timer_not_allowed;
   plotpic('mainpic2.crp',1);load_menu_data(aktpage);init_opti_button;optmenu_active:=0;
   cd_timer_allowed;
   control_fkt:=do_nothing;
   showfirstpage;setorigpal;fillchar(data_block^,1304,0);
   randomize;
   initmousesys;read_pointer_data;
   clear_time_seg:=seg(clear_time_ptr);clear_time_ofs:=ofs(clear_time_ptr);
   fillchar(clear_time_ptr,100,4);
   show_time_imm;
  end;
end;
procedure deinit_menu_system(art:byte);
begin
 optmenu_active:=0;secmousepos;
 if art=0 then
  begin
   deinit_player(0);
   init_fadeout(0,255);fade_to_all(zielpal,2);{setpal_z;}
   extro;
   regs.ax:=3;intr($10,regs);
   initmouse;initmouse;
   {release_them_all(0);}
   deinit_dynamic_vars(0);
   {release(menu_heap_start_ptr);}
   restore_font;
  end
 else if art=1 then
  begin
   if mouseset>0 then clearmouse;initmouse;initmouse;
   deinit_dynamic_vars(0);
  end
 else if art=2 then
  begin
   deinit_player(0);
   setblack;
   if mouseset>0 then clearmouse;initmouse;initmouse;
   deinit_dynamic_vars(0);
  end
 else if art=3 then
  begin
   if mouseset>0 then clearmouse;
   initmouse;initmouse;
   {pause_mod_player;}
   {mark_them_all(1);}deinit_dynamic_vars(255);
  end;
end;

procedure textreader;
var name:string[8];p:pointer;
begin
 name:=chr(text_2_read.page+ord('1'))+chr(text_2_read.but+ord('1'))+chr(text_2_read.sbut+ord('0'));
 cd_timer_not_allowed;
 clear_page_mid;
 deinit_menu_system(3);
  viewer1_main(1,name,cd_get_addy_timer_allowed);
  control_fkt:=do_nothing;mousebut:=0;
 init_menu_system(3);
 cd_timer_allowed;
end;

procedure voter;
begin
 cd_timer_not_allowed;
 clear_page_mid;
 deinit_menu_system(3);
  write_debug('voter in: ',memavail);
   creamvoter(cd_get_addy_timer_allowed);
  write_debug('voter out: ',memavail);
 init_menu_system(3);
 control_fkt:=do_nothing;mousebut:=0;
 cd_timer_allowed;
end;
procedure searcher;
begin
 control_fkt:=do_nothing;
 {cd_timer_not_allowed;}
 {clear_page_mid_search;}
 repeat until keypressed;while keypressed do taste:=readkey;
 {textreader2;}

end;

begin
 debug_on:=false;if debug_on then begin assign(ft,'debug.txt');rewrite(ft);end;
 max_mod_size:=5000000;
 write_debug('Mod-size:',max_mod_size);
 init_menu_system(0);
 write_debug('Menu:',memavail);

 control_fkt:=do_nothing;taste:=chr(0);
 {cd_timer_not_allowed;}
 repeat
  clear_key_buffer;
  menu_kernel;
  if control_fkt=do_read_text then begin textreader;clear_key_buffer; end;
  if control_fkt=do_voter     then begin voter;clear_key_buffer;end;
  if control_fkt=do_search    then begin searcher;clear_key_buffer;end;
  if control_fkt=do_options   then
   begin
    deinit_menu_system(2);
     write_debug('setup in: ',memavail);
      release(menu_heap_start_ptr);
       setup_main(0,max_mod_size);
      release(menu_heap_start_ptr);
     write_debug('setup out: ',memavail);
    init_menu_system(4);clear_key_buffer;
   end;
 until (control_fkt=do_exit_menu)or(control_fkt=do_exit_menu_imm);
 write_debug('EMS vor deinit: ',emsfreepages);
 deinit_menu_system(0);
 write_debug('EMS nach deinit: ',emsfreepages);
 if debug_on then close(ft);
end.


