program nCream_Voter;
{$M 12000,0,100000}
uses
  Crt, Dos, Graph;

var
  GraphDriver : integer;  { The Graphics device driver }
  GraphMode   : integer;  { The Graphics mode value }
  MaxX, MaxY  : word;     { The maximum resolution of the screen }
  ErrorCode   : integer;  { Reports any graphics errors }
  MaxColor    : word;     { The maximum color value available }

var
  AutoDetectPointer : pointer;

{$F+}
function DetectVGA256 : integer;
var
  DetectedDriver : integer;
  SuggestedMode  : integer;
begin
  DetectGraph(DetectedDriver, SuggestedMode);
  if (DetectedDriver = EGA) or (DetectedDriver = VGA) then
  begin
   DetectVGA256 := 2;
  end
  else
    DetectVGA256 := grError; { Couldn't detect hardware }
end; { DetectVGA256 }
{$F-}

procedure Initialize; { SVGA 800x600x256 mit SVGA256.BGI }
var
  PathToDriver   : string;
  UseWhichDriver : integer;
begin
  DirectVideo := False;
  PathToDriver := '';
  UseWhichDriver:=0;
  if (UseWhichDriver=0) then
  begin
    AutoDetectPointer := @DetectVGA256;   { Point to detection routine }
    GraphDriver := InstallUserDriver('SVGA256', AutoDetectPointer);
  end;
  GraphDriver := Detect;
  InitGraph(GraphDriver, GraphMode, PathToDriver);
  ErrorCode := GraphResult;
  if ErrorCode <> grOK then Halt(1);
  MaxColor := GetMaxColor;  { Get the maximum allowable drawing color }
  MaxX := GetMaxX;          { Get screen resolution values }
  MaxY := GetMaxY;
end; { Initialize }

function Int2Str(L : LongInt) : string;
var
  S : string;
begin
  Str(L, S);
  Int2Str := S;
end; { Int2Str }


{$F+}
 {$L vesapcx4.obj} PROCEDURE ShowPCX800(DateiName : STRING); EXTERNAL;
{$F-}
procedure Hintergrund;
begin
 asm mov ax,4f02h; mov bx,101h; int 10h; end;
 showpcx800('neu-3.pcx');
end;

{
#############################################################################
###########################     M  A  U  S     ##############################
#############################################################################
}

type quad_type=record x1,y1,x2,y2:word;end;

var regs:registers;

    mousemoved:word;
    mouse_shape,backmouse:array[0..143]of byte;
    mousebut,altmx,altmy,mousex,mousey,mousearea:word;
    event_status,mouseset:byte;

    button:array[0..6]of quad_type;

procedure read_mouse;
var pfeil_datei: text;
    pufferstr  : string[12];
    poz ,code  : integer;
    z ,zy      : byte;
begin
  z:=0;
  assign(Pfeil_datei,'mouse.pfl');
  reset(pfeil_datei);
  for zy:=0 to 11 do begin
    readln(Pfeil_datei,pufferstr);
    for poz:=1 to 12 do begin
      val(copy(pufferstr,poz,1),mouse_shape[z],code);
      inc(z);
    end;
  end;
  close(pfeil_datei);
end;


procedure vbl;assembler;
asm
 mov dx,$3da
 @wait1:in al,dx;test al,$8;jnz @wait1
 @wait2:in al, dx;test al,$8;jz @wait2
end;

{mouse-routs}
{Beginn der Mausroutinen}
{$f+}
procedure new_event_handler;assembler;
asm
 pusha
 push ds
 push ax
 mov ax,seg mousebut
 mov ds,ax
 cmp event_status,2
 je @aktiv
 shl event_status,1
 mov mousex,cx
 mov mousey,dx
 mov mousebut,bx
 mov mousemoved,1
 shr event_status,1
 @aktiv:
 pop ax
 pop ds
 popa
end;
{$f-}

function get_event_adress:pointer;
begin
 get_event_adress:=addr(new_event_handler);
end;

procedure init_new_event_handler(addy:pointer);assembler;
asm
 pusha
 les dx,addy
 mov ax,$000c
 mov cx,127
 int $33
 popa
end;

procedure mouse_setpos(mx,my:word);assembler;
asm
 mov ax,4
 mov cx,mx
 mov dx,my
 int $33
 mov cx,mx
 mov mousex,cx
 mov cx,my
 mov mousey,cx
end;

procedure mouse_getpos;assembler;
asm
 mov ax,3
 int $33
 mov mousex,cx
 mov mousey,dx
end;

procedure akt_m_back;
var  z     : Byte;
     zy,zx : integer;
begin
 z:=0;
 for zy:=altmy to altmy+11 do
  for zx:=altmx to altmx+11 do begin
     backmouse[z]:=getpixel(zx,zy);inc(z);
  end;
end;

procedure plotmouse2;
var  z,col : Byte;
     zy,zx : integer;
begin
 z:=0;col:=130;
 altmx:=mousex;
 altmy:=mousey;
 for zy:=altmy to altmy+11 do
  for zx:=altmx to altmx+11 do
    begin
      backmouse[z]:=getpixel(zx,zy);
      if mouse_shape[z]>0 then putpixel(zx,zy,col);
      inc(z);
    end;
end;

procedure clearmouse2;
var  z     : byte;
     zx,zy : integer;
begin
 z:=0;
 for zy:=altmy to altmy+11 do
  for zx:=altmx to altmx+11 do begin
    putpixel(zx,zy,backmouse[z]);
    inc(z);
  end;
end;

procedure movemouse;assembler;
asm
 cmp mousemoved,0
 je @exit
 mov mousemoved,0
 call vbl
 call clearmouse2
 call plotmouse2
 jmp @exit
 @exit:
end;

procedure initmouse;assembler;
asm
 mov ax,0
 int $33
 mov ax,$21
 int $33
 mov ax,7
 mov cx,0
 mov dx,628
 int $33                             {hoizontal}
 mov ax,8
 mov cx,0
 mov dx,468
 int $33                             {vertikal}
 mov mousebut,0
 mov mousemoved,0
end;

procedure initbutton;
begin
 button[0].x1:=565;button[0].y1:=143;button[0].x2:=635;button[0].y2:=164;
 button[1].x1:=565;button[1].y1:=201;button[1].x2:=635;button[1].y2:=222;
 button[2].x1:=565;button[2].y1:=259;button[2].x2:=635;button[2].y2:=280;
 button[3].x1:=565;button[3].y1:=317;button[3].x2:=635;button[3].y2:=338;
 button[4].x1:=565;button[4].y1:=375;button[4].x2:=635;button[4].y2:=396;
 button[5].x1:=533;button[5].y1:=085;button[5].x2:=550;button[5].y2:=098;
 button[6].x1:=533;button[6].y1:=099;button[6].x2:=550;button[6].y2:=113;
end;

procedure initmousesys;
begin
 read_mouse;
 initmouse;
 init_new_event_handler(get_event_adress);
 akt_m_back;
end;

{Ende der Mausroutinen}

function chkmpos_quad(quad:quad_type;mx,my:word):boolean;
begin
 if (mx>=quad.x1)and(mx<=quad.x2)and(my>=quad.y1)and(my<=quad.y2)
  then chkmpos_quad:=true else chkmpos_quad:=false;
end;

function chkmpos_two(quad:quad_type;mwert,dir:word):boolean;
begin {dir=0 x-werte; dir=1 y-werte}
 if dir=0 then begin if (mwert>=quad.x1)and(mwert<=quad.x2) then chkmpos_two:=true else chkmpos_two:=false;end
  else begin if (mwert>=quad.y1)and(mwert<=quad.y2) then chkmpos_two:=true else chkmpos_two:=false;end;
end;



{
#############################################################################
###########################    E D I T O R     ##############################
#############################################################################
}



var  VoteString : array[1..10,1..5]of string[47];
     them,platz : integer;  { VoteString[them,platz] }
     zaehler    : byte;
     CharNo     : integer;
     ch1,ch2    : String[1];
     ueberspringen: boolean;

var  DateiName    : String[13];
     Datei        : Text;
     Escape,saved : boolean;
     Abbruch      : boolean;
     P1,P2,P3           : Pointer;
     Size1,Size2,Size3  : word;
     t_ah,t_al    : byte;

const thema :array[1..10] of string[45] =(
             'BESTes BUCH',
             'BEGABTester AUTOR',
             'EMPFEHLENSWERTeste Zeitschrift',
             'INTERESSANTestes DISKMAGazin',
             'COOLstes DEMO',
             'BESTe DEMO-Crew',
             'MELODIStes LIED/BESTEs Musikstck',
             'GENIALster INTERPRET / GUTste Gruppe',
             'BESTes GAME',
             'SCHLECHTester Film');

      X_POS :array[1..5] of byte =( 0, 0, 0, 0, 0 );
      X_out :integer=148;
      Y_out :integer=130;
      vy    :integer=09;
      schwarz  :byte=00;
      weiss    :byte=130;
      gelb     :byte=16;
      gruen    :byte=2;
      grau     :byte=239;
      rot      :byte=5;
      pink     :byte=1;{ob Pink, oder nicht Pink, das IST die Markierfarbe}
      orange   :byte=1;
      blau     :byte=145;
      Back_blue:byte=139;

      pressed: byte=0;

{ EDITOR AB HIER ::::::>>>>>>>>}


procedure tastenabfrage;assembler; { erweiterter ReadKey ( F11, F12 ) }
 asm
  mov ah,1
  int 16h
  jnz @exit
  mov pressed,1
  mov t_ah, al { SteuerScan 0=F-Tasten, 204=EditBlock; ...; sonst ASCII}
  @exit:
 end;


function u(wert: integer):integer;
begin
 u:=trunc(wert*0.8);
end;


function Neu_x: integer;
 begin
   neu_x:=350-(trunc((8*length(votestring[them,platz]))/2));
 end;

procedure SetBlack(CharNo:integer);
 begin
   SetColor(schwarz);
   outtextxy(neu_x+(CharNo-1)*8,y_out+u(25)+u(50)*platz,'');
   SetColor(weiss);
 end;

procedure SetChar(CharNo:integer);
 var char1 : char;
 begin
   if (charNo>length(votestring[them,platz]))or
      (VoteString[them,platz][charno]=#32) then char1:='_'
   else char1:=VoteString[Them,Platz][charNo];
   outtextxy(neu_x+(CharNo-1)*8,y_out+u(25)+u(50)*platz,char1);
   SetColor(weiss);
 end;

procedure saveback1(x,y,dx,dy:integer);
 begin
   clearmouse2;
   Size1 := ImageSize(x, y, x+dx, y+dy);
   GetMem(P1, Size1);   { Allocate memory on heap }
   GetImage(x, y, x+dx, y+dy, P1^);
 end;

procedure getback1(x,y:integer);
 begin
   clearmouse2;
   PutImage(x, y, P1^, NormalPut);
   akt_m_back;
 end;

procedure saveback2(x,y,dx,dy:integer);
 begin
   clearmouse2;
   Size2 := ImageSize(x, y, x+dx, y+dy);
   GetMem(P2, Size2);   { Allocate memory on heap }
   GetImage(x, y, x+dx, y+dy, P2^);
 end;

procedure getback2(x,y:integer);
 begin
   clearmouse2;
   PutImage(x, y, P2^, NormalPut);
   akt_m_back;
 end;

procedure saveback3(x,y,dx,dy:integer);
 begin
   clearmouse2;
   Size3 := ImageSize(x, y, x+dx, y+dy);
   GetMem(P3, Size3);   { Allocate memory on heap }
   GetImage(x, y, x+dx, y+dy, P3^);
 end;

procedure getback3(x,y:integer);
 begin
   clearmouse2;
   PutImage(x, y, P3^, NormalPut);
   akt_m_back;
 end;

procedure viewHelpScreen;
 label label1;
 const x:integer=140;
       y:integer=397;
 begin
 ch1[1]:=#255;ch2[1]:=#255;mousebut:=0;
 if CharNo<=length(VoteString[them,platz]) then
   SetColor(weiss) else SetColor(schwarz);
  setChar(charno);
  saveback1(120,390,500,100);
  setcolor(grau);
  clearmouse2;
  OutTextXY(x,y+0,'HILFE:');setcolor(weiss);
  OutTextXY(x,y+10,'Dieser Editor ist eine komfortab`le Hilfe beim');
  OutTextXY(x,y+20,'ausfllen Deines VoteSheets. Er erstellt durch');
  OutTextXY(x,y+30,'[F2] eine *.VOT-Datei, welche Ihr uns gerne');
  OutTextXY(x,y+40,'schicken knnt. Nostalgiker knnen die');
  OutTextXY(x,y+50,'VOTE.TXT-Datei natrlich auch auf herkmmliche');
  OutTextXY(x,y+60,'Weise ausfllen.');
  OutTextXY(x,y+70,'                                     Weiter mit [ENTER]');
  akt_m_back;
  repeat movemouse until keypressed or (mousebut>0);
  if mousebut=2 then goto label1;
  if keypressed then ch1[1]:=readkey;
  if ch1[1]=#27 then goto label1;
  if ch1[1]=#0 then ch2[1]:=readkey;
  ch1[1]:=#255;ch2[1]:=#255;mousebut:=0;
  getback1(120,390);
  setcolor(grau);
  clearmouse2;
  OutTextXY(x,y+0,'TastaturBelegung:');setcolor(weiss);
  OutTextXY(x,y+10,'[F1].......... dieser Hilfebildschirm');
  OutTextXY(x,y+20,'[F2].......... SAVE');
  OutTextXY(x,y+30,'[F3].......... LOAD');
  OutTextXY(x,y+40,'[Einfg]....... Tauscht aktuellen Platz mit ?');
  OutTextXY(x,y+50,'[Entf]........ wie gewohnt');
  OutTextXY(x,y+60,'[Backspace]... wie gewohnt');
  OutTextXY(x,y+70,'                                     Weiter mit [ENTER]');
  akt_m_back;
  repeat movemouse until keypressed or (mousebut>0);
  if mousebut=2 then goto label1;
  if keypressed then ch1[1]:=readkey;
  if ch1[1]=#27 then goto label1;
  if ch1[1]=#0 then ch2[1]:=readkey;
  ch1[1]:=#255;ch2[1]:=#255;mousebut:=0;
  getback1(120,390);
  setcolor(grau);
  clearmouse2;
  OutTextXY(x,y+0,'TastaturBelegung (Fortsetzung):');setcolor(weiss);
  OutTextXY(x,y+10,'[Pos1],[Ende]. wie gewohnt');
  OutTextXY(x,y+20,'[Bild hoch]... letztes Thema');
  OutTextXY(x,y+30,'[Bild runter]. nchstes Thema');
  OutTextXY(x,y+40,'[Esc]......... zurck zum CREAM-MAGAZIN');
  OutTextXY(x,y+50,'[Pfeiltasten]. gewohnte Funktion');
  OutTextXY(x,y+60,'[Enter]....... Platz,bzw. Thema erhhen');
  OutTextXY(x,y+70,'                                     Weiter mit [ENTER]');
  akt_m_back;
  repeat movemouse until keypressed or (mousebut>0);
  if mousebut=2 then goto label1;
  if keypressed then ch1[1]:=readkey;
  if ch1[1]=#27 then goto label1;
  if ch1[1]=#0 then ch2[1]:=readkey;
  ch1[1]:=#255;ch2[1]:=#255;mousebut:=0;
  getback1(120,390);
  setcolor(grau);
  clearmouse2;
  OutTextXY(x,y+0,'Anmerkungen:');setcolor(weiss);
  OutTextXY(x,y+10,'Load.......... Es knnen auch *.TXT-Dateien geladen');
  OutTextXY(x,y+20,'               werden, wenn diese Endung eingegeben wird');
  OutTextXY(x,y+30,'Save.......... durch die Eingabe der Dateiendung');
  OutTextXY(x,y+40,'               `.TXT` wird eine TEXT-Datei erstellt, ');
  OutTextXY(x,y+50,'               welche ihr spter auch wieder mit');
  OutTextXY(x,y+60,'               diesem Editor einlesen knnt');
  OutTextXY(x,y+70,'                                     Weiter mit [ENTER]');
  akt_m_back;
  repeat movemouse until keypressed or (mousebut>0);
  if mousebut=2 then goto label1;
  if keypressed then ch1[1]:=readkey;
  if ch1[1]=#27 then goto label1;
  if ch1[1]=#0 then ch2[1]:=readkey;
  ch1[1]:=#255;ch2[1]:=#255;mousebut:=0;
  getback1(120,390);
  setcolor(grau);
  clearmouse2;
  OutTextXY(x,y+0,'Anmerkungen (Fortsetzung):');setcolor(weiss);
  OutTextXY(x,y+10,'Einf.......... Tauscht den aktuellen Platz mit dem');
  OutTextXY(x,y+20,'               nachfolgend anzugebenen; der Cursor');
  OutTextXY(x,y+30,'               springt danach in die ERSTE Zeile des');
  OutTextXY(x,y+40,'               aktuellen Themas');
  OutTextXY(x,y+50,'Esc........... Auch jetzt besteht noch die Mglichkeit,');
  OutTextXY(x,y+60,'               Eueren VoteShit abzuspeichern...');
  OutTextXY(x,y+70,'                                     Weiter mit [ENTER]');
  akt_m_back;
  repeat movemouse until keypressed or (mousebut>0);
  if mousebut=2 then goto label1;
  if keypressed then ch1[1]:=readkey;
  if ch1[1]=#27 then goto label1;
  if ch1[1]=#0 then ch2[1]:=readkey;
  ch1[1]:=#255;ch2[1]:=#255;mousebut:=0;
  getback1(120,390);
  setcolor(grau);
  clearmouse2;
  OutTextXY(x,y+0,'Abschlieende Bemerkung:');setcolor(weiss);
  OutTextXY(x,y+10,'Wenn Ihr uns den VoteSheet per Fax schicken wollt, dann');
  OutTextXY(x,y+20,'bitte im TXT-Format ( man beachte auch die Vote.TXT');
  OutTextXY(x,y+30,'Datei). Wer aber den Weg der DF whlt, um uns zu er-');
  OutTextXY(x,y+40,'reichen, sollte das *.VOT-Format nutzen (natrlich ist');
  OutTextXY(x,y+50,'uns `*.TXT` auch lieb).');
  OutTextXY(x,y+70,'                          zurck zum Editor mit [ENTER]');
  akt_m_back;
  repeat movemouse until keypressed or (mousebut>0);
  if mousebut=2 then goto label1;
  if keypressed then ch1[1]:=readkey;
  if ch1[1]=#27 then goto label1;
  if ch1[1]=#0 then ch2[1]:=readkey;
  ch1[1]:=#255;ch2[1]:=#255;mousebut:=0;
label1:
  getback1(120,390);
  ch1[1]:=#255;ch2[1]:=#255;mousebut:=0;
  SetColor(pink);
  SetChar(CharNo);
  FreeMem(P1,Size1);P1:=NIL;
 end;

procedure plaetze_1to5;
 var  PlatzTXT     : string[10];
 const vx: byte=2;
 begin
  setcolor(schwarz);
  OuttextXY(320,93,'');     {\ }
  OuttextXY(500,200,'');    { >= Fehler im Bild beheben!!!}
                                {/ }
  OuttextXY(320+vx,85,'');
  SetColor(gelb);platzTXT:='';
  for platz:=1 to 5 do begin
   str(platz,PlatzTXT);PlatzTXT:=PlatzTXT+'.Platz:';
   outtextxy(320+vx+x_pos[platz],y_out+u(50)*platz,PlatzTXT);
  end;
 end;

procedure neues_thema(them:byte);
 var zeile,spalte : integer;
     VonZehn      : string[10];
 begin
  clearmouse2;
  SetColor(schwarz);
  for zaehler:=1 to 5 do
   for spalte:=1 to 49 do
    OutTextXY(x_out+X_POS[zaehler]+spalte*8,y_out+u(25)+u(50)*zaehler,'');
  OutTextXY(U(310),U(110),'');
  OutTextXY(190,98,'');
  setColor(gruen);
  str(them,VonZehn);VonZehn:=VonZehn+' von 10';
  OutTextXY(U(390),U(110),VonZehn);
  OutTextXY((U(428)-(8*trunc(length(thema[them])/2))),98,thema[them]);
  SetColor(weiss);
  for Platz:=1 to 5 do begin
   if length(VoteString[them,Platz])>1 then begin
    Outtextxy(neu_x,y_out+U(25)+U(50)*platz,VoteString[them,platz]);
    CharNo:=length(VoteString[them,Platz])+1;
    Ch1[1]:=VoteString[them,Platz][CharNo];
    setBlack(CharNo);
   end;
  end;
  akt_m_back;
  platz:=1;
  CharNo:=length(VoteString[them,Platz])+1;
  SetColor(pink);
  setchar(charno);
 end;

function enter_DateiNamen:string;
 var Aktueller_DateiName:string;
     CharNoDat:byte;
 begin
  Abbruch:=false;
  if CharNo<=length(VoteString[them,platz]) then
   SetColor(weiss) else SetColor(schwarz);
  setChar(charno);
  saveback2(410,112+vy,104,10);
  CharNoDat:=0;
  Aktueller_Dateiname:='Voteshit.vot';
  clearmouse2;
  OutTextXY(240,U(140)+vy,'Aktueller Dateiname: ');
  setColor(gruen);
  OutTextXY(410,U(140)+vy,Aktueller_Dateiname);
  SetColor(weiss);
  outTextXY(U(300),U(153)+vy,'[ENTER] wenn O.K.,');
  outTextXY(U(364),u(165)+vy,' sonst Dateinamen eingeben!');
  akt_m_back;
  repeat movemouse until keypressed or (mousebut=2);
  if keypressed then CH2[1]:=readkey else ch2[1]:=#27;
  if Ch2[1]<>#13 then begin
   Aktueller_DateiName:='';
   if ( Ch2[1] >#31 ) and ( Ch2[1] < #255 ) then
     Aktueller_Dateiname:=''+ch2[1];inc(CharNoDat);
   if ch2[1]=#27 then begin
     Abbruch:=true;Ch2[1]:=#13;
     Aktueller_Dateiname:='xxx.xxx';
     exit;
   end;
   while ch2[1]<>#13 do begin
    getback2(410,112+vy);
    SetColor(gruen);
    OutTextXY(410,u(140)+vy,Aktueller_Dateiname);
    repeat movemouse until keypressed or (mousebut=2);
    if keypressed then CH2[1]:=readkey else ch2[1]:=#27;
    if CH2[1]=#27 then begin
     Abbruch:=true;Ch2[1]:=#13;
     Aktueller_Dateiname:='xxx.xxx';
    end;
    if ( Ch2[1] >#31 ) and ( Ch2[1] < #255 )
    and ( length(Aktueller_DateiName)<12 )
    and ( ( (CharNoDat) < (POS('.',Aktueller_DateiName)+3) )
     or ( (POS('.',Aktueller_DateiName)=0 ) ) ) then Begin
     inc(CharNoDat);
     Insert(Ch2[1],Aktueller_DateiName,CharNoDat);
    end;
    if (CharNoDat=8)and(Ch2[1]<>#08)
    and(POS('.',Aktueller_DateiName)=0) then begin
     inc(CharNoDat);
     Insert('.',Aktueller_DateiName,CharNoDat);
    end;
    if ch2[1]=#08 then begin
     delete(Aktueller_DateiName,CharNoDat,1);
     if charnoDat>0 then dec(charnodat);
    end;
   end;
  end;
  SetColor(weiss);
  if POS('.',Aktueller_DateiName)=0 then
   Aktueller_DateiName:=Aktueller_DateiName+'.vot';
  enter_DateiNamen:=Aktueller_Dateiname;
 end;

procedure Fehlermeldung(zaehler:byte);
 var Fehler:String;
 begin
  fehler:='';
  case zaehler of
     1: Fehler:='Dateiname ungltig';
   2,3: Fehler:='Datei nicht gefunden';
     5: Fehler:='Dateizugriff verweigert';
     0: exit;
  end;
  saveBack3(410,122+vy,180,10);
  SetColor(rot);
  clearmouse2;
  OutTextXY(410,122+vy,fehler);
  akt_m_back;
  repeat movemouse until keypressed or (mousebut>0);
  if keypressed then Ch1[1]:=readkey;
  Ch1[1]:=#255;CH2[1]:=#255;
  mousebut:=0;
  getback3(410,122+vy);
  Freemem(P3,size3);p3:=nil;
  SetColor(pink);
  SetChar(CharNo);
 end;

Procedure Load_txt;
 var PufferString:string;
     gefunden,fehler:integer;
     anzahl:integer;
     typ   :byte; { Bei Editor-txt-Datei 7, sonst 1}
 label label1;
 begin
  them:=0;
  assign(Datei,DateiName);
  {$i-}
  Reset(Datei);
  {$i+}
  fehler:=IOresult;
  if fehler=0 then begin
   while not EOF(Datei) do begin
    inc(them);
    repeat
     Readln(Datei,PufferString);
     gefunden:=POS('1.',Pufferstring);
     if Pos('Platz:',Pufferstring)<>0 then typ:=7 else Typ:=1;
    until (gefunden<>0)or EOF(Datei);
    if EOF(Datei) then goto Label1;
    anzahl:=length(PufferString)-gefunden-typ;
    VoteString[them,1]:=Copy(PufferString,gefunden+typ+2,Anzahl);
    repeat
     Readln(Datei,PufferString);
     gefunden:=POS('2.',Pufferstring);
     if Pos('Platz:',Pufferstring)<>0 then typ:=7 else Typ:=1;
    until (gefunden<>0)or EOF(Datei);
    if EOF(Datei) then goto Label1;
    anzahl:=length(PufferString)-gefunden-typ;
    VoteString[them,2]:=Copy(PufferString,gefunden+typ+2,Anzahl);
    repeat
     Readln(Datei,PufferString);
     gefunden:=POS('3.',Pufferstring);
     if Pos('Platz:',Pufferstring)<>0 then typ:=7 else Typ:=1;
    until (gefunden<>0)or EOF(Datei);
    if EOF(Datei) then goto Label1;
    anzahl:=length(PufferString)-gefunden-typ;
    VoteString[them,3]:=Copy(PufferString,gefunden+typ+2,Anzahl);
    repeat
     Readln(Datei,PufferString);
     gefunden:=POS('4.',Pufferstring);
     if Pos('Platz:',Pufferstring)<>0 then typ:=7 else Typ:=1;
    until (gefunden<>0)or EOF(Datei);
    if EOF(Datei) then goto Label1;
    anzahl:=length(PufferString)-gefunden-typ;
    VoteString[them,4]:=Copy(PufferString,gefunden+typ+2,Anzahl);
    repeat
     Readln(Datei,PufferString);
     gefunden:=POS('5.',Pufferstring);
     if Pos('Platz:',Pufferstring)<>0 then typ:=7 else Typ:=1;
    until (gefunden<>0)or EOF(Datei);
    if EOF(Datei) then goto Label1;
    anzahl:=length(PufferString)-gefunden-typ;
    VoteString[them,5]:=Copy(PufferString,gefunden+typ+2,Anzahl);
   end;
label1:
   close(Datei);
  end else begin
       Fehlermeldung(fehler);
       getBack2(410,112+vy);
       Freemem(P2,size2);p2:=nil;
  end;
 end;

Procedure Load;
 var fehler:integer;
 label label1;
 begin
   saveback1(160,112+vy,400,40);
   setcolor(orange);
   clearmouse2;
   OuttextXY(U(200),U(150)+vy,'LOAD:');
   akt_m_back;
label1:
   DateiName:=enter_dateinamen;
   if not abbruch then begin
    if (DateiName='') or (POS(' ',DateiName)<>0 )or (POS('.',DateiName)=1)
     then begin
      fehlermeldung(1);
      getBack2(410,112+vy);
      Freemem(P2,size2);p2:=nil;
      goto label1;
     end;
    if (POS('.TXT',Dateiname)<>0)or(POS('.txt',Dateiname)<>0) then Load_TXT
    else begin
    {$i-}
     assign(Datei,DateiName);
     if IOResult=2 then begin
       Fehlermeldung(2);
       getBack2(410,112+vy);
       Freemem(P2,size2);p2:=nil;
       goto label1;
     end;
     Reset(Datei);
     fehler:=IOresult;
    {$i+}
     if fehler=0 then begin
      for Them:=1 to 10 do
       for Platz:=1 to 5 do
        Readln(Datei,VoteString[Them,Platz]);
      close(Datei);
      them:=1;
     end else begin
       Fehlermeldung(fehler);
       getBack2(410,112+vy);
       Freemem(P2,size2);p2:=nil;
       goto label1;
     end;
    end;
   end;
   them:=1;
   neues_thema(them);
   ch1[1]:=#255;ch2[1]:=#255;
   getback1(160,112+vy);
   freemem(P1,Size1);P1:=NIL;
   saved:=true; { da ja noch keine nderungen gemacht wurden}
 end;

procedure Save_As_TextFile;
 var DS: string[80];
     Dummy_Them, Dummy_Platz : byte;
 begin

Writeln(Datei,'                           -=  V O T E S H E E T =-');
Writeln(Datei);
Writeln(Datei,'                        -= fr  CREAM issue II =-');
Writeln(Datei,'             -=  (dem Diskmag fr Coding, Panne und Begrbnis) =-');
Writeln(Datei);
Writeln(Datei);
for dummy_them:=1 to 10 do begin
  writeln(Datei,'                     ',Thema[dummy_them]);
  DS:='                     ';
  for zaehler:=1 to length(thema[dummy_them]) do insert('-',DS,22);
  Writeln(Datei,DS);
  Writeln(Datei);
  for dummy_platz:=1 to 5 do begin
    writeln(Datei,'             ',dummy_platz,'.Platz: ',VoteString[dummy_them,dummy_platz]);
  end;
  writeln(Datei);
end;
Writeln(Datei);
Writeln(Datei,'        Schon fertig ! Diesen Votesheet, vielleicht mit ein paar');
Writeln(Datei,'        Laber/Biete-Suche-Anzis, entweder an:');
Writeln(Datei);
Writeln(Datei,'        COCTAIL                oder an        HAWKE');
Writeln(Datei,'        Oliver Fritsch                        Michael Hempel');
Writeln(Datei,'        Heiterblickallee 67                   Hartriegelstr.11');
Writeln(Datei,'        04329 Leipzig                         04329 Leipzig');
writeln(Datei);
Writeln(Datei,'        Wer will kann auch faxen machen, und zwar an die Nummer');
Writeln(Datei,'                           0341/3062-458...');
Writeln(Datei,'                        Tausendmal - DANKE!!!');
Writeln(Datei);
Writeln(Datei,'         P.S.: Natrlich geht`s auch per E-Mail:');
Writeln(Datei,'               Addy im FidoNet : Ingo Berthold @ 2:249/500.06');
Writeln(Datei,'               InterNet Addy   : WIR91DSH@STUDSERV.UNI-LEIPZIG.DE');
writeln(Datei);
writeln(Datei);
writeln(Datei,'       diese Datei wurde mit dem CREAM-Vote-Sheet-Editor erstellt');
saved:=true;
end; { ENDE der Procedure Save_as_TextFile }

procedure Save;
 var fehler:integer;
     dummy_them,dummy_platz:byte;
 label label1;
 begin
   saveback1(160,112+vy,400,50);
   setcolor(orange);
   clearmouse2;
   OuttextXY(160,U(150)+vy,'SAVE:');
   akt_m_back;
label1:
   DateiName:=Enter_DateiNamen;
  if not abbruch then begin
   if (DateiName='')or(POS(' ',DateiName)<>0 )or (POS('.',DateiName)=1)
    then begin
     FehlerMeldung(1);
     getBack2(410,112+vy);
     Freemem(P2,size2);p2:=nil;
     goto label1;
    end;
    If FSearch(DateiName,'')<>'' then begin
     SetColor(rot);
     saveBack3(410,122+vy,180,10);
     OutTextXY(410,122+vy,'berschreiben? (j/n)');
     repeat
       ch1[1]:=readkey;
     until ( UpCase(Ch1[1])='N' )or( UpCase(CH1[1])='J' );
     getBack3(410,122+vy);
     freemem(P3,SIZE3);p3:=nil;
     getback2(410,112+vy);
     SetColor(weiss);
    end else CH1[1]:='J';
    if UpCase(CH1[1])='J' then begin
     Assign(Datei,DateiName);
     {$i-}
     Rewrite(Datei);
     {$i+}
     fehler:=IOresult;
     if fehler<>0 then Fehlermeldung(fehler)
     else begin
      if (Pos('.TXT',DateiName)<>0)or(Pos('.txt',DateiName)<>0)
       then Save_as_TextFile
      else for Dummy_Them:=1 to 10 do
           for Dummy_Platz:=1 to 5 do
           Writeln(Datei,VoteString[Dummy_Them,Dummy_Platz]);
      close(Datei);
      saved:=true;
     end;
    end else goto Label1;
  end;
  freemem(P2,Size2);p2:=nil;
  SetColor(pink);ch1[1]:=#255;
  SetChar(CharNo);SetColor(weiss);
  getback1(160,112+vy);
  freemem(P1,Size1);
  p1:=NIL;
 end;

procedure Plaetze_Tauschen;
 var ausgabe:string;
     pla    :string[2];
     ok     :boolean;
     buffer :string;
     code   :integer;
     neuer_platz:integer;
 const i: byte=50;
 begin
   SetColor(schwarz);
   if (CharNo<=length(VoteString[them,platz]))
    and (VoteString[them,platz][charno]<>#32)
     then SetColor(weiss);
   SetChar(CharNo);
   str(platz,pla);
   ausgabe:='Tausche Platz '+pla+' mit Platz:';
   OutTextXY(U(250+i),U(450)+vy,ausgabe);SetColor(pink);
   outTextXY(450,U(450)+vy,'_');SetColor(schwarz);
   repeat Ch1[1]:=readkey until ((ch1[1]>#48)and(Ch1[1]<#54)) or (CH1[1]=#27);
   outTextXY(450,U(450)+vy,'');SetColor(pink);
   OutTextXY(450,U(450)+vy,ch1[1]);delay(50);SetColor(schwarz);
   OutTextXY(U(250+i),U(450)+vy,'');
   SetColor(weiss);
   if ch1[1]=#27 then begin ch1[1]:=#255; exit; end;
   val(ch1[1],neuer_platz,code);
   buffer:=VoteString[them,neuer_platz];
   voteString[them,neuer_platz]:=VoteString[them,platz];
   VoteString[them,platz]:=buffer;
   neues_thema(them);
   ch1[1]:=#255;saved:=false;
 end;

procedure kopieren;
 var ausgabe:string;
     pla    :string[2];
     ok     :boolean;
     code   :integer;
     neuer_platz:integer;
 const i: byte=50;
 begin
   SetColor(schwarz);
   if (CharNo<=length(VoteString[them,platz]))
    and (VoteString[them,platz][charno]<>#32)
     then SetColor(weiss);
   SetChar(CharNo);
   str(platz,pla);
   ausgabe:='Kopiere Platz '+pla+' zu Platz:';
   OutTextXY(U(250+i),U(450)+vy,ausgabe);SetColor(pink);
   outTextXY(450,U(450)+vy,'_');SetColor(schwarz);
   repeat Ch1[1]:=readkey until ((ch1[1]>#48)and(Ch1[1]<#54)) or (CH1[1]=#27);
   outTextXY(450,U(450)+vy,'');SetColor(pink);
   OutTextXY(450,U(450)+vy,ch1[1]);delay(50);SetColor(schwarz);
   OutTextXY(U(250+i),U(450)+vy,'');
   SetColor(weiss);
   if ch1[1]=#27 then begin ch1[1]:=#255; exit; end;
   val(ch1[1],neuer_platz,code);
   voteString[them,neuer_platz]:=VoteString[them,platz];
   neues_thema(them);
   ch1[1]:=#255;saved:=false;
 end;

procedure exitsequenz;
 begin
  mousebut:=0;
  if CharNo<=length(VoteString[them,platz]) then
   SetColor(weiss) else SetColor(schwarz);
  setChar(charno);
  clearmouse2;
  saveback1(160,112+vy,400,40);
  setcolor(rot);
  OutTextXY(U(280),112+vy,'Editor wirklich beenden? (j/n) :');
  akt_m_back;mousemoved:=1;
  repeat
   repeat movemouse until keypressed or(mousebut=2);
   if keypressed then Ch1[1]:=readkey else ch1[1]:='N';
  until (UpCase(Ch1[1])='J')or(Upcase(CH1[1])='N');
  SetColor(weiss);
  OutTextXY(486,112+vy,CH1[1]);
  if UpCase(Ch1[1])='N' then
  begin
   getback1(160,112+vy);
   freemem(P1,Size1);P1:=nil;
   SetColor(pink);ch1[1]:=#255;
   SetChar(CharNo);SetColor(weiss);
   mousebut:=0;
   exit;
  end;
  setcolor(rot);
  if not saved then begin
   OutTextXY(U(280),125+vy,'vor Verlassen speichern? (j/n) :');
   repeat
    repeat movemouse until keypressed or(mousebut=2);
    if keypressed then Ch1[1]:=readkey else ch1[1]:='N';
   until (UpCase(Ch1[1])='J')or(Upcase(CH1[1])='N');
   getBack1(160,112+vy);
   freemem(P1,Size1);p1:=nil;
   if UpCase(Ch1[1])='J' then begin Save;saved:=true;end;
  end else begin
   getBack1(160,112+vy);
   freemem(P1,Size1);p1:=nil;
  end;
  Ch1[1]:=#255;
  Escape:=true;
  mousebut:=0;
 end;

procedure Buttons(m,n:byte);
 var i:byte;
     cbuff: char;
 const f1:byte=63;
       f2:byte=140;
      x:integer=565;
      y:integer=90;
      Aktions: Array[1..10] of string=
      ('HilfeĿ',
       'SaveĿ',
       'LoadĿ',
       'Tauschen',
       'BeendenĿ',
       '[F1]',
       '[F2]',
       '[F3]',
       '[INS]',
       '[ESC]');
 begin
  if m=0 then begin
   if n=0 then begin
    setcolor(f1);
    for i:=1 to 5 do OuttextXY(x,y+i*U(73),Aktions[i]);
    for i:=6 to 10 do OuttextXY(x,y+08+(i-5)*U(73),Aktions[i]);
   end else begin;
    repeat
     clearmouse2;
     SetColor(schwarz);
     if (CharNo<=length(VoteString[them,platz]))
      and (VoteString[them,platz][charno]<>#32)
       then SetColor(weiss);
     SetChar(CharNo);
     setcolor(f1);
     for i:=1 to 5 do OuttextXY(x,y+i*U(73),Aktions[i]);
     for i:=6 to 10 do OuttextXY(x,y+08+(i-5)*U(73),Aktions[i]);
     setcolor(f2);
     OuttextXY(x,y+n*U(73),Aktions[n]);
     OuttextXY(x,y+08+n*U(73),Aktions[5+n]);
     mouse_setpos(x+40,y+n*U(73)+05);
     plotmouse2;
     cbuff:=#255;
      repeat until keypressed or (mousebut>0);
      if mousebut=2 then cbuff:=#27;
      if keypressed then cbuff:=readkey;
      if cbuff=#9 then begin if n<5 then inc(n) else n:=1; end;
      if (cbuff=#32) or (cbuff=#13)or (mousebut=1)then
       case n of
       5: begin ch1[1]:=#27;end;
       3: load;
       2: save;
       4: Plaetze_tauschen;
       1: ViewHelpScreen;
       end;
    until (cbuff=#13) or (cbuff=#32) or (cbuff=#27)or(mousebut>0);
    if cbuff=#27 then begin
     ch1[1]:=#255;
     clearmouse2;
     mouse_setpos(320,240);
     plotmouse2;
    end;
    mousebut:=0;
    setcolor(f1);
    OuttextXY(x,y+n*U(73),Aktions[n]);
    OuttextXY(x,y+08+n*U(73),Aktions[5+n]);
    if n<>4 then ueberspringen:=true;
    clearmouse2;
   end;
  end else begin
   setcolor(f2);
   OuttextXY(x,y+m*U(73),Aktions[m]);
   OuttextXY(x,y+08+m*U(73),Aktions[5+m]);
   mousemoved:=1;
  end;
 end;

function pos_kon:byte;
var i: integer;
begin
  pos_kon:=0;
  if (mousex>565) and (mousex<635) then
   for i:=1 to 5 do begin
     if (mousey>(90+i*58)) and (mousey<(106+i*58)) then pos_kon:=i;
   end;
end;

procedure control_mouse;
var but:byte;zeile,mx,my:word;
    i : integer;
begin
 mx:=altmx;my:=altmy;but:=255;
 for i:=0 to 6 do if chkmpos_quad(button[i],mx,my) then but:=i;
 if but=255 then
  begin
   if mousebut=2 then exitsequenz; {exit}
   mousebut:=0;exit;
  end;
  if but=0 then {F1}
  begin
    viewhelpscreen;
    ueberspringen:=true;
  end;
 if but=1 then  {F2}
  begin
    save;
    ueberspringen:=true;
  end;
 if but=2 then
  begin
    load;
    ueberspringen:=true;
  end;
 if but=3 then
  begin
    plaetze_tauschen;
  end;
 if but=4 then
  begin
    exitsequenz;
    ueberspringen:=true;
  end;
 if but=5 then
  begin
   if them <10 then inc(them) else them:=1;
   neues_Thema(them);
   ueberspringen:=true;
  end;
 if but=6 then
  begin
    if them >1 then dec(them) else them:=10;
    neues_Thema(them);
    ueberspringen:=true;
  end;
 mousebut:=0;
end;


label label1;

procedure eingabe;
 var y,x:integer;
 begin
  platz:=1;
  Them:=1;                   { Variablen auf AusgangsWerte setzen}
  CharNo:=1;
  Escape:=false;
  saved:=true;
  ueberspringen:=false;
  plaetze_1to5;
  neues_Thema(them);         { Editor in Ausgangssituation}
  mousebut:=0;
  mouse_setpos(320,240);
  mouse_getpos;
  plotmouse2;
  while not Escape do begin  { Escape wird erst nach exitsequenz true}
   movemouse;
   {while (mousebut=0) and (not keypressed) do movemouse;}
   if mousebut>0 then control_mouse;
   if pos_kon>0 then buttons(pos_kon,0) else Buttons(0,0);
   if keypressed then begin
    ch1:=readkey;
    if Ch1[1]=#9 then Buttons(0,1);
    if ch1[1]=#0 then begin
     ch2:=readkey;
     case ch2[1] of
      #72 : begin {Pfeil hoch}
             SetColor(schwarz);
             if (CharNo<=length(VoteString[them,platz]))
              and (VoteString[them,platz][charno]<>#32)
               then SetColor(weiss);
             SetChar(CharNo);
             if platz >1 then dec(platz) else platz:=5;
             CharNo:=length(VoteString[Them,Platz])+1;
             SetColor(pink);
             SetChar(CharNo);
             ueberspringen:=true;
            end;
      #80 : begin {Pfeil runter}
             SetColor(schwarz);
             if (CharNo<=length(VoteString[them,platz]))
              and (VoteString[them,platz][charno]<>#32)
                then SetColor(weiss);
             SetChar(CharNo);
             if platz <5 then inc(platz) else platz:=1;
             CharNo:=length(VoteString[Them,Platz])+1;
             SetColor(pink);
             SetChar(CharNo);
             ueberspringen:=true;
            end;
      #75 : begin {Pfeil links}
             if CharNo>1 then begin
              if CharNo<=length(VoteString[Them,Platz])then begin
               if VoteString[them,platz][charno]=#32 then
               SetColor(schwarz) else SetColor(weiss);
               SetChar(CharNo);
              end else begin
               SetBlack(CharNo);
              end;
              dec(CharNo);
              SetColor(pink);
              SetChar(CharNo);
             end else CharNo:=1;
             ueberspringen:=true;
            end;
      #77 : begin {Pfeil rechts}
             if CharNo <= length(VoteString[them,platz]) then begin
              if VoteString[them,platz][charno]=#32 then
               SetColor(schwarz) else SetColor(weiss);
              SetChar(CharNo);
              inc(CharNo);
              SetColor(pink);
              SetChar(CharNo);
             end else CharNo:=length(VoteString[them,platz])+1;
             ueberspringen:=true;
            end;
      #71 : begin {POS 1}
              if VoteString[them,platz][charno]=#32 then
               SetColor(schwarz) else SetColor(weiss);
              SetChar(CharNo);
              if charNo=length(VoteString[Them,Platz])+1 then begin
               SetBlack(CharNo);
              end;
              SetColor(pink);
              CharNo:=1;
              SetChar(charNo);
              ueberspringen:=true;
            end;
      #79 : begin {END}
              if VoteString[them,platz][charno]=#32 then
               SetColor(schwarz) else SetColor(weiss);
              SetChar(charNo);
              SetColor(pink);
              CharNo:=length(VoteString[Them,Platz])+1;
              SetChar(CharNo);
              ueberspringen:=true;
            end;
      #73 : begin {Page up}
              if them >1 then dec(them) else them:=10;
              neues_Thema(them);
              ueberspringen:=true;
            end;
      #81 : begin {Page down}
              if them <10 then inc(them) else them:=1;
              neues_Thema(them);
              ueberspringen:=true;
            end;
      #82 : begin {EINFG}
              Plaetze_Tauschen;
              ueberspringen:=false;
            end;
      #83 : begin {ENTF}
             if charNo<=length(VoteString[Them,Platz]) then begin
              delete(VoteString[Them,Platz],CharNo,1);
              for zaehler:=CharNo to Length(VoteString[Them,Platz]) do begin
               SetColor(schwarz);
               outtextxy(x_out+X_POS[Platz]+zaehler*8,y_out+U(25)+U(50)*platz,'');
               SetColor(weiss);
               SetChar(zaehler);
              end;
              SetBlack(zaehler);
              SetColor(pink);
              SetChar(CharNo);
              ch2[1]:=#83;
              ueberspringen:=false;
              end;
            end;
      #59 : begin
              ViewHelpScreen;
              ch2[1]:=#59;
              ueberspringen:=true;
            end;
      #60 : Save;
      #61 : Load;
      #63 : begin
              kopieren;
              ueberspringen:=false;
            end;
     end; {Case Ch2[1] of ...}
    end;  {if Ch1[1]=#0 then begin...}
    case Ch1[1] of
     #08 : begin
            if CharNo>1 then begin
             dec(CharNo);
             delete(VoteString[Them,Platz],CharNo,1);
            end else CharNo:=1;
            ueberspringen:=false;
           end;
     #13 : begin {Enter; selbe Funktion wie [Pfeil runter], aber mit blttern}
             if Platz=5 then begin
              if them <10 then inc(them) else them:=1;
              neues_Thema(them);
             end else begin
              SetColor(schwarz);
              if (CharNo<=length(VoteString[them,platz]))
               and (VoteString[them,platz][charno]<>#32)
                then SetColor(weiss);
              SetChar(CharNo);
              inc(platz);
              CharNo:=length(VoteString[Them,Platz])+1;
              SetColor(pink);
              SetChar(CharNo);
             ch1[1]:=#13;
            end;
            ueberspringen:=true;
           end;
     #27 : exitsequenz; {ESC}
    end; {Case Ch1 of ...}
   if ( ord(Ch1[1]) > 31 ) and ( Ord(Ch1[1]) < 255 )
   and (length(VoteString[them,platz])<47)then
    begin
       Insert(Ch1[1],VoteString[Them,Platz],CharNo);
       inc(CharNo);  { aktuelle ZeichenNummer im String setzen }
       ueberspringen:=false;
    end;
 { __AUSGABE DES AKTUELLEN VOTESTRINGS=====>=>=>=>=>=>=>=>=>=>=>=>=>=>=>}
    clearmouse2;
    if not ueberspringen then
     begin
      setcolor(schwarz);  { alte Eingabe berschreiben! }
      outtextxy(X_OUT+X_POS[Platz],y_out+U(25)+U(50)*platz,
       '');
      setcolor(weiss);    { aktuallisierte Eingabe ausgeben }
      outtextxy(neu_x,y_out+U(25)+U(50)*platz,
       votestring[them,platz]);
      saved:=false; { Votesheet wurde seit letzter Speicherung verndert}
     end;
    ueberspringen:=false;
    SetColor(pink);
    SetChar(CharNo);
    akt_m_back;mousemoved:=1;
 { __ENDE AUSGABE DES AKTUELLEN VOTESTRINGS=<=<=<=<=<=<=<=<=<=<=<=<=<=<=}
   end; { keypressed? }
  end;{Ende While-Schleife}

 end;



begin { Main Part }
  ClrScr;
  Initialize; { SVGA 800x600x256 }
  Hintergrund;
  initbutton;
  initmousesys;
  Buttons(0,0);
  eingabe;
  closegraph;
end.


{
#############################################################################
######################### Der Hilfe-Text (nochmal) ##########################
#############################################################################




 HILFE TEXTE:
  load:  ACHTUNG: #keine Endung bedeutet das '.VOT' automatisch
                   ergnzt wird

  save   ACHTUNG: #keine Endung bedeutet das '.VOT' automatisch
                   ergnzt wird
                  #mit der Endung '.TXT' wird der VoteSheet in
                   eine Text-Datei ausgegeben, die dieser Editor
                   nicht wieder einlesen kann!

  ViewHelpScreen: Dieser Editor ist eine Komfortable Hilfe beim
                  ausfllen Deines VoteSheets. Er erstellt durch
                  [F2] eine '*.VOT'-Datei, welche Ihr uns gerne
                  schicken knnt. Nostalgiker knnen die
                  'VOTE.TXT'-Datei natrlich auch auf herkmmliche
                  Weise ausfllen.

                  TastaturBelegung:

                  [F1].......... dieser Hilfebildschirm
                  [F2].......... SAVE
                  [F3].......... LOAD
                  [Einfg]....... Tauscht aktuellen Platz mit ?
                  [Entf]........ wie gewohnt
                  [Backspace]... wie gewohnt
                  [Pos1],[Ende]. wie gewohnt
                  [Bild hoch]... letztes Thema
                  [Bild runter]. nchstes Thema
                  [Esc]......... zurck zum HOTMAG
                  [Pfeiltasten]. gewohnte Funktion
                  [Enter]....... Platz,bzw. Thema erhhen

                  Bemerkungen:

                  Load.......... Es knnen keine '.TXT'-Dateien geladen
                                 werden
                  Save.......... durch die Eingabe von der Dateiendung
                                 '.TXT' wird die Ausgabe in eine TEXT-
                                 Datei geschrieben, welche spter nicht
                                 mehr mit DIESEM Editor gelesen werden
                                 kann
                  Einf.......... Tauscht den aktuellen Platz mit dem
                                 nachfolgend angegebenen; der Cursor
                                 springt danach in die ERSTE Zeile des
                                 aktuellen Themas
                  Esc........... wenn seit der Abspeicherung eine nderung
                                 erfolgte, besteht die Mglichkeit, den
                                 VoteSheet auch jetzt noch abzuspeichern

                  Abschlieende Bemerkung:

                  Wenn Ihr uns den VoteSheet per Fax schicken wollt, dann
                  bitte im TXT-Format ( man beachte auch die 'Vote.TXT'
                  Datei). Wer aber den Weg der DF whlt, um uns zu erreichen
                  sollte das '.VOT'-Format nutzen (natrlich ist uns
                  TXT auch lieb).

}
