unit v_file;

interface

type list_entry=record name:string[12];addr,size:longint;end;
var liste:file of list_entry;
    fileoffset:longint;
    entry:list_entry;
    entry_anz:word;
    filegroesse:longint;
    datafilehandle:word;
    datensatz,olddatensatz:string[20];
    offset_add:longint;
    datafile_opened:boolean;

procedure deinitdatafile;
procedure initdatafile;
procedure initdatensatz(s1:string);
procedure initolddatensatz;
procedure getoffset(name:string);
procedure v_openfile(name:string);
procedure v_closefile;
procedure v_readfile(anz:word;po:pointer);
procedure v_readfile_p1(anz:word;po:pointer);
procedure v_readfile_text(po:pointer);
procedure v_seekfile(pos:longint);
function v_getfilesize(name:string):longint;
function v_eof:boolean;
function v_file_exists(name:string):boolean;


implementation

uses file_ops;

procedure deinitdatafile;
begin
 if datafile_opened=false then exit;
 closefile(datafilehandle);
 datafile_opened:=false;
end;
procedure initdatafile;
begin
 if datafile_opened=true then deinitdatafile;
 datafilehandle:=openfile(datensatz);
 if datafilehandle<>$ffff then
  begin
   readfile(datafilehandle,sizeof(offset_add),@offset_add);
   entry_anz:=offset_add div sizeof(entry);
   datafile_opened:=true;
  end;
end;

procedure initdatensatz(s1:string);
begin
 if datafile_opened then deinitdatafile;
 olddatensatz:=datensatz;
 datensatz:=s1;
 initdatafile;
end;
procedure initolddatensatz;
begin
 if datafile_opened then deinitdatafile;
 datensatz:=olddatensatz;
 initdatafile;
end;
procedure getoffset(name:string);
var i:byte;s:word;
begin
 if not(datafile_opened) then initdatafile;
 seekfile(datafilehandle,0,4);s:=0;
 for i:=1 to length(name) do name[i]:=upcase(name[i]);
 repeat
  readfile(datafilehandle,sizeof(entry),@entry);inc(s);
  for i:=1 to length(entry.name) do entry.name[i]:=upcase(entry.name[i]);
 until (entry.name=name)or(s=entry_anz);
 if entry.name=name then
  begin
   fileoffset:=entry.addr+offset_add;
   filegroesse:=entry.size;
  end
 else
  begin
   asm
    mov ax,$3
    int $10
   end;
   writeln('File nicht gefunden :',name);
   halt;
  end;
end;

procedure v_openfile(name:string);
begin
 initdatafile;
 if datafile_opened then
  begin
   getoffset(name);
   seekfile(datafilehandle,0,fileoffset);
  end;
end;
procedure v_closefile;
begin
 deinitdatafile;
end;
procedure v_readfile(anz:word;po:pointer);
 begin readfile(datafilehandle,anz,po);end;
procedure v_readfile_p1(anz:word;po:pointer);
 var locptr:pointer;
 begin readfile(datafilehandle,anz,po);locptr:=ptr(seg(po^),ofs(po^)+anz);readfile(datafilehandle,1,locptr);end;
procedure v_readfile_text(po:pointer);
 var locstr:^string;
 begin
  locstr:=po;
  readfile(datafilehandle,1,@(locstr^[0]));
  readfile(datafilehandle,ord(locstr^[0]),@(locstr^[1]));
 end;
procedure v_seekfile(pos:longint);
begin
 seekfile(datafilehandle,0,fileoffset+pos);
end;
function v_getfilesize(name:string):longint;
var d,i:longint;
begin
 d:=getfilepos(datafilehandle);
 seekfile(datafilehandle,0,4);
 for i:=1 to length(name) do name[i]:=upcase(name[i]);
 repeat
  readfile(datafilehandle,sizeof(entry),@entry);
  for i:=1 to length(entry.name) do entry.name[i]:=upcase(entry.name[i]);
 until entry.name=name;
 v_getfilesize:=entry.size;
 seekfile(datafilehandle,0,d);
end;
function v_eof:boolean;
var pos:longint;
begin
 pos:=getfilepos(datafilehandle);
 if pos>=filegroesse+fileoffset then v_eof:=true else v_eof:=false;
end;
function v_file_exists(name:string):boolean;
var i:byte;s:word;
begin
 seekfile(datafilehandle,0,4);s:=0;
 for i:=1 to length(name) do name[i]:=upcase(name[i]);
 repeat
  readfile(datafilehandle,sizeof(entry),@entry);inc(s);
  for i:=1 to length(entry.name) do entry.name[i]:=upcase(entry.name[i]);
 until (entry.name=name)or(s=entry_anz);
 if entry.name=name then
  begin
   v_file_exists:=true;
  end
 else
  begin
   v_file_exists:=false;
  end;
end;

begin
end.