/*
 * Newton's method for reciprocals.
 *
 * Skal98.
 * Pascal.Massimino@ens.fr
 *************************************/

extern float Newton_Div( float );
float FDiv_Seed[256];       // Starting value

/////////////////////////////////////////////////////////////////////////

void Build_Tab( )
{
   int i;
   float xo, x1, x2, Seed;
   unsigned char *Xo;

   // (float)0xFFFFFFFF == NaN

   Xo = (unsigned char *)&xo;

   for( i=0; i<256; ++i )
   {
      Xo[3] = i;

      Xo[0] = Xo[1] = Xo[2] = 0x00;    // min
      x1 = *(float *)Xo;
      Xo[0] = Xo[1] = Xo[2] = 0xFF;    // max
      x2 = *(float *)Xo;

      if ( x1==0.0 && x2==0.0 ) Seed = 0.0;
      else Seed = 3.0 / ( 1.0*x1 + 2.0*x2 );
      
      // printf( "x1=%e x2=%e Seed=%e\n", x1, x2, Seed );

      FDiv_Seed[i] = Seed;
   }
}

///////////////////////////////////////////////////////////////////////

float Newton_Div( float Base )
{
   int i, S;
   float x, dx;

   S = ( *(unsigned int *)&Base )>>24;
   x = FDiv_Seed[S];

   i = 10;     // monitor 10 iterations

   while( i-- )
   {
      dx = x*( 1.0 - Base*x );
      x += dx;
      printf( "step #%d: \t  dx = %e  \t x=%e\n", i, dx, x );
   }
   return( x );
}


void main( int argc, char **argv )
{
   float a;

   Build_Tab( );

   if ( argc<2 || !strcmp( argv[1], "-h") )
      printf( "Usage: %s [float_to_take_reciprocal_of]\n", argv[0] );
   else
   {
      sscanf( argv[1], "%f", &a );

      printf( " Base: %e\n", a );
      printf( " => What ought to be found: %e\n\n", 1.0/a );
      a = Newton_Div( a );
      printf( " Final result: %e\n", a );
   }
   exit( 0 );
}

///////////////////////////////////////////////////////////////////////
