{ (C) Victor Rafael Rivarola }

PROGRAM Checkers;

  USES

    Crt;

  CONST

    ChipChar    = #1;
    QueenChar   = #2;
    RedPlayer   = True;
    BlackPlayer = False;

  TYPE

    ColorType = (Red, Black, Neither);

    ContainsType

              = (Chip, Queen, Nothing);

    BoxType   = RECORD

                  CenterX,CenterY : Byte;
                  Color           : ColorType;
                  Contains        : ContainsType;

                END;

    BoardType = ARRAY[1..8, 1..8] OF BoxType;

    RemainingType

              = ARRAY[BlackPlayer..RedPlayer] OF RECORD

                  Chips,
                  Queens : Byte;

                END;

    StatType  = RECORD

                  GamesPlayed,
                  RedWon,
                  BlackWon,
                  Ties            : Byte;

                END;

    GameResultType

              = (RedWins, BlackWins, Tie, KeepPlaying);

    TokenType = RECORD

                  X,Y : Byte;

                END;

  VAR

    Stats     : StatType;
    Ch        : Char;

  { ******************** }
  { Display Instructions }
  { ******************** }

  PROCEDURE DisplayInstructions;

    VAR

      Ch : Char;

    BEGIN

      ClrScr;
      Writeln('WELCOME TO CHECKER''S');
      Writeln('====================');
      Writeln;
      Writeln(' This  is  a two player game only (sorry, but I cannot play).');
      Writeln('To  play,  simply  choose the options in the menus and answer');
      Writeln('the questions as they appear on the screen.');
      Writeln;
      Writeln(' The Red player always starts.  I keep statistics on how many');
      Writeln('games  were  played,  how  many games the Red player won, how');
      Writeln('many  games  the Black player won, and how many ties.  I will');
      Writeln('tell you the results of this analysis as soon as you are done');
      Writeln('gaming.');
      Writeln;
      Writeln(' During the game, you will see the following symbols: ');
      Writeln;
      Writeln('':26,'Chip    : ',ChipChar);
      Writeln('':26,'Queen   : ',QueenChar);
      Writeln;
      Writeln(' These symbols will appear in the color  of  the  player  who');
      Writeln('owns them.');
      Writeln;
      Write  ('Press a key to see your options...');

      Ch := ReadKey;

      ClrScr;
      Writeln('CHECKER''S : MAIN OPTIONS');
      Writeln('========================');
      Writeln;
      Writeln(' 1. Move      : This  allows  you to move a chip or a queen.');
      Writeln('                Menus  will  appear allowing to you to chose');
      Writeln('                one  of  your chips or queens and the proper');
      Writeln('                direction   to  move  it.   Note:  Once  you');
      Writeln('                chose  a  chip or queen, you have to move it');
      Writeln('                or  make  it  jump.  If  you chose a chip or');
      Writeln('                queen  that  is "stuck", your only option is');
      Writeln('                to surrender!');
      Writeln;
      Writeln(' 2. Jump      : This allows you to jump with a queen or chip');
      Writeln('                The same rules that apply to move also apply');
      Writeln('                to  jump,  including the inability to change');
      Writeln('                the  chosen  chip or queen.  Once you make a');
      Writeln('                legal  jump,  you''ll be asked if you want to');
      Writeln('                jump  again, even if it''s illegal for you in');
      Writeln('                this particular turn.  Both  players  should');
      Writeln('                agree on whether or not a queen can  jump in');
      Writeln('                the same turn that it changes into a  queen.');
      Writeln('                If not, no should always be chosen  in  that');
      Writeln('                case.');
      Writeln;
      Write('Press any key to see more...');
      Ch := ReadKey;

      ClrScr;
      Writeln('CHECKER''S : MAIN OPTIONS');
      Writeln('========================');
      Writeln;
      Writeln(' 3. Surrender : If  you  are tired or have no choice, choose');
      Writeln('                this.   The  game will be over,  It''s a loss');
      Writeln('                for you');
      Writeln;
      Writeln(' 4. Tie       : If your oponent agrees to it, a tie might be');
      Writeln('                declared.');
      Writeln;
      Write('PRESS ANY KEY TO PLAY...');
      Ch := ReadKey;

    END;

  { ********** }
  { Init Board }
  { ********** }

  PROCEDURE  InitBoard(VAR Board     : BoardType;
                       VAR Remaining : RemainingType);

    VAR

      I, J : Byte;

    BEGIN

{$IFDEF Debug}

      Remaining[ RedPlayer   ].Chips  :=  0;
      Remaining[ RedPlayer   ].Queens :=  1;
      Remaining[ BlackPlayer ].Chips  :=  0;
      Remaining[ BlackPlayer ].Queens :=  1;

{$ELSE}

      Remaining[ RedPlayer   ].Chips  := 12;
      Remaining[ RedPlayer   ].Queens :=  0;
      Remaining[ BlackPlayer ].Chips  := 12;
      Remaining[ BlackPlayer ].Queens :=  0;

{$ENDIF}

      FOR I:=1 TO 8 DO

        FOR J :=1 TO 8 DO

          IF Odd(I+J) THEN

            BEGIN

              Board[I,J].CenterX := (I-1)*7 + Round(7/2);
              Board[I,J].CenterY := (J-1)*3 + Round(3/2);

{$IFDEF Debug}

              IF (I=1) AND (J=2) THEN

                BEGIN

                  Board[1,2].Contains := Queen;
                  Board[1,2].Color    := Red;

                END

              ELSE

                IF (I=3) AND (J=4) THEN

                  BEGIN

                    Board[3,4].Contains := Queen;
                    Board[3,4].Color    := Black;

                  END

                ELSE

                  BEGIN

                    Board[I,J].Contains := Nothing;
                    Board[I,J].Color    := Neither;

                  END;

{$ELSE}

              CASE I OF

                1,2,3 : BEGIN

                          Board[I,J].Color    := Red;
                          Board[I,J].Contains := Chip;

                        END;

                4,5   : BEGIN

                          Board[I,J].Color    := Neither;
                          Board[I,J].Contains := Nothing;

                        END;

                6,7,8 : BEGIN

                          Board[I,J].Color    := Black;
                          Board[I,J].Contains := Chip;

                        END;
               END;

{$ENDIF}

            END;

    END;

  { ************* }
  { Dialog Window }
  { ************* }

  PROCEDURE DialogWindow;

    BEGIN

      TextColor(Crt.Blue);
      TextBackground(Crt.Green);

      Window(58,7,79,15);

      ClrScr;

    END;

  { ************ }
  { Whole Screen }
  { ************ }

  PROCEDURE WholeScreen;

    BEGIN

      Window(1,1,80,25);

    END;

  { ************* }
  { Display Board }
  { ************* }

  PROCEDURE  DisplayBoard(Board : BoardType; Token : TokenType);

    VAR

      I, J, K : Byte;
      Spaces  : String[7];

    BEGIN

      WholeScreen;

      TextBackground(Blue);

      ClrScr;

                {1234567}
      Spaces := '       ';

      FOR I:=1 TO 8 DO

        FOR J:=1 TO 8 DO

          BEGIN

            IF Odd(I+J) THEN

              TextBackground(Crt.White)

            ELSE

              TextBackground(Crt.Black);

            FOR K:=1 TO 3 DO

              BEGIN

                GotoXY( ((I-1)*7+1), ((J-1)*3+K) );
                Write(Spaces);

              END;

            WITH Board[I,J] DO

              IF Odd(I+J) AND Not(Contains=Nothing) THEN

                BEGIN

                  GotoXY( CenterX,CenterY );

                  IF Color = Red THEN

                    IF (I=Token.X) AND (J=Token.Y) THEN

                      TextColor(Crt.Red+Crt.Blink)

                    ELSE

                      TextColor(Crt.Red)

                  ELSE

                    IF (I=Token.X) AND (J=Token.Y) THEN

                      TextColor(Crt.Black+Crt.Blink)

                    ELSE

                    TextColor(Crt.Black);

                  IF Contains = Chip THEN

                    Write(ChipChar)

                  ELSE

                    Write(QueenChar);

                END;


          END;

    END;

  { ********** }
  { GameIsOver }
  { ********** }

  FUNCTION GameIsOver(Remaining : RemainingType) :Boolean;

    BEGIN

      GameIsOver := False;

      IF (Remaining[RedPlayer].Chips  = 0) AND
         (Remaining[RedPlayer].Queens = 0) THEN

         GameIsOver := True;

      IF (Remaining[BlackPlayer].Chips  = 0) AND
         (Remaining[BlackPlayer].Queens = 0) THEN

         GameIsOver := True;

    END;

  { ******************** }
  { Choose Chip Or Queen }
  { ******************** }


  PROCEDURE ChooseChipOrQueen( VAR Board         : BoardType;
                               VAR Token         : TokenType;
                                   CurrentPlayer : Boolean);

    CONST

      A = 'A';
      Z = 'Z';

    VAR

      I,J          : Byte;
      LastChip     : Char;
      LastQueen    : Byte;
      Answer       : Char;
      ChipArray    : ARRAY[A..Z] OF TokenType;
      QueenArray   : ARRAY[1..9] OF TokenType;
      CurrentColor : ColorType;

    BEGIN

      LastChip  := Pred('A');
      LastQueen :=         0;

      IF CurrentPlayer = RedPlayer THEN

        BEGIN

          TextColor(Crt.Red);
          CurrentColor := Red;

        END

      ELSE

        BEGIN

          TextColor(Crt.Black);
          CurrentColor := Black;

        END;

      TextBackground(Crt.White);

      WholeScreen;

      FOR I := 1 TO 8 DO

        FOR J := 1 TO 8 DO

          IF Odd(I+J) THEN

            IF Board[I,J].Color = CurrentColor THEN

              IF Board[I,J].Contains = Chip THEN

                WITH Board[I,J] DO

                  BEGIN

                    Inc(LastChip);

                    GotoXY(CenterX, CenterY);
                    Write(LastChip);

                    ChipArray[LastChip].X := I;
                    ChipArray[LastChip].Y := J;

                  END

              ELSE

                WITH Board[I,J] DO

                  BEGIN

                    Inc(LastQueen);

                    GotoXY(CenterX, CenterY);
                    Write(LastQueen);

                    QueenArray[LastQueen].X := I;
                    QueenArray[LastQueen].Y := J;

                  END;

      DialogWindow;

      IF CurrentPlayer=RedPlayer THEN

        Writeln('PLAYER: RED')

      ELSE

        Writeln('PLAYER: BLACK');

      Writeln;

      Writeln('Chip  = Letter');
      Writeln('Queen = Number');
      Writeln;
      Write  ('Choose One ');

      REPEAT

        Answer := UpCase(ReadKey);

      UNTIL Answer IN ['A'..LastChip, '1'..Chr(Ord('0')+LastQueen)];

      Writeln(Answer);

      IF Answer IN ['A'..LastChip] THEN

        Token := ChipArray[Answer]

      ELSE

        Token := QueenArray[Ord(Answer)-Ord('0')];

    END;

  { ********* }
  { Move Chip }
  { ********* }

  FUNCTION MoveChip( VAR Board     : BoardType;
                     VAR Token     : TokenType;
                         Player    : Boolean;
                     VAR Remaining : RemainingType) : Boolean;

    VAR

      Direction    : ShortInt;
      CurrentColor : ColorType;
      Target       : Byte;
      T            : TokenType;
      Answer       : Char;

    BEGIN

      T := Token;

      IF Player=RedPlayer THEN

        BEGIN

          CurrentColor := Red;
          Target       :=  8;
          Direction    := +1;

        END

      ELSE

        BEGIN

          CurrentColor := Black;
          Target       :=  1;
          Direction    := -1;

        END;

      DialogWindow;

      Writeln('Choose Direction:');
      Writeln;
      Writeln('1. Up');
      Writeln('2. Down');
      Writeln;
      Write  ('Your Choice? ');

      REPEAT

        Answer := ReadKey;

      UNTIL (Answer='1') OR (Answer='2');

      IF Answer='1' THEN

        Dec(T.Y)

      ELSE

        Inc(T.Y);

      T.X := T.X + Direction;

      IF (( T.X > 0) AND (T.X < 9))         AND
         (( T.Y > 0) AND (T.Y < 9))         AND

          (Board[T.X,T.Y].Contains=Nothing) THEN

        BEGIN

          Board[T.X,T.Y].Contains := Chip;
          Board[T.X,T.Y].Color    := CurrentColor;

          Board[Token.X,Token.Y].Contains := Nothing;
          Board[Token.X,Token.Y].Color    := Neither;

          Token := T;

          IF T.X = Target THEN

            BEGIN

              Dec(Remaining[Player].Chips);
              Inc(Remaining[Player].Queens);

              Board[T.X,T.Y].Contains := Queen;

            END;

          MoveChip := True;

        END

      ELSE

        MoveChip := False;

    END;

  { ********** }
  { Move Queen }
  { ********** }

  FUNCTION MoveQueen( VAR Board  : BoardType;
                      VAR Token  : TokenType;
                          Player : Boolean ) : Boolean;

    VAR

      T      : TokenType;
      Answer : Char;

    BEGIN

      T := Token;

      DialogWindow;

      IF Player = RedPlayer THEN

        Writeln('PLAYER : RED')

      ELSE

        Writeln('PLAYER : BLACK');

      Writeln;

      Writeln('1. Up Right.');
      Writeln('2. Up Left.');
      Writeln('3. Down Right');
      Writeln('4. Down Left');

      REPEAT

        Answer := ReadKey;

      UNTIL Answer IN ['1'..'4'];

      CASE Answer OF

        '1' : BEGIN

                Inc(T.X);
                Dec(T.Y);

              END;

        '2' : BEGIN

                Dec(T.X);
                Dec(T.Y);

              END;

        '3' : BEGIN

                Inc(T.X);
                Inc(T.Y);

              END;

        '4' : BEGIN

                Dec(T.X);
                Inc(T.Y);

              END;

      END;

      IF ( (T.X>0) AND (T.X<9)               ) AND
         ( (T.Y>0) AND (T.Y<9)               ) AND
         ( Board[T.X,T.Y].Contains = Nothing ) THEN

        BEGIN

          Board[T.X,T.Y].Contains := Queen;
          Board[T.X,T.Y].Color    := Board[Token.X,Token.Y].Color;

          Board[Token.X,Token.Y].Contains := Nothing;
          Board[Token.X,Token.Y].Color    := Neither;

          MoveQueen := True;

        END

      ELSE

        MoveQueen := False;

    END;

  { ****************** }
  { Move Chip Or Queen }
  { ****************** }

  FUNCTION MoveChipOrQueen( VAR Board     : BoardType;
                            VAR Token     : TokenType;
                                Player    : Boolean;
                            VAR Remaining : RemainingType ) : Boolean;

    BEGIN

      IF Board[Token.X,Token.Y].Contains = Chip THEN

        MoveChipOrQueen := MoveChip(Board,Token,Player,Remaining)

      ELSE

        MoveChipOrQueen := MoveQueen(Board,Token,Player);

    END;

  { ************** }
  { Jump with Chip }
  { ************** }

  FUNCTION JumpWithChip( VAR Board     : BoardType;
                         VAR Token     : TokenType;
                             Player    : Boolean;
                         VAR Remaining : RemainingType) : Boolean;

    VAR

      HDir,VDir   : ShortInt;
      Target      : Byte;
      T1,T2       : TokenType;
      Answer      : Char;
      OtherPlayer : ColorType;

    BEGIN

      IF Player=RedPlayer THEN

        BEGIN

          HDir        := +1;
          Target      :=  8;
          OtherPlayer := Black;

        END

      ELSE

        BEGIN

          HDir        := -1;
          Target      :=  1;
          OtherPlayer := Red;

        END;

      DialogWindow;

      IF Player=RedPlayer THEN

        Writeln('PLAYER : RED')

      ELSE

        Writeln('PLAYER : BLACK');

      Writeln;

      Writeln('1. Up');
      Writeln('2. Down');
      Writeln;
      Write  ('Your Choice? ');

      REPEAT

        Answer := ReadKey;

      UNTIL Answer IN ['1'..'2'];

      IF Answer = '1' THEN

        VDir := -1

      ELSE

        VDir := +1;

      T1.X := Token.X + HDir;
      T1.Y := Token.Y + VDir;

      T2.X := T1.X    + HDir;
      T2.Y := T1.Y    + VDir;

      IF ( (T2.X>0) AND (T2.X<9)                     AND
           (T2.Y>0) AND (T2.Y<9)                     AND
           (Board[T2.X,T2.Y].Contains = Nothing) )   AND
         ( (T1.X>0) AND (T1.X<9)                     AND
           (T1.Y>0) AND (T1.Y<9)                     AND
           (Board[T1.X,T1.Y].Color = OtherPlayer) )  THEN

        BEGIN

          IF Board[T1.X,T1.Y].Contains = Chip THEN

            Dec(Remaining[Not(Player)].Chips)

          ELSE

            Dec(Remaining[Not(Player)].Queens);

          Board[T1.X,T1.Y].Contains := Nothing;
          Board[T1.X,T1.Y].Color    := Neither;

          Board[T2.X,T2.Y].Contains := Chip;
          Board[T2.X,T2.Y].Color    := Board[Token.X,Token.Y].Color;

          Board[Token.X,Token.Y].Contains := Nothing;
          Board[Token.X,Token.Y].Color    := Neither;

          Token := T2;

          IF T2.X = Target THEN

            BEGIN

              Board[T2.X,T2.Y].Contains := Queen;
              Dec(Remaining[Player].Chips);
              Inc(Remaining[Player].Queens);

            END;

          JumpWithChip := True;

        END

      ELSE

        JumpWithChip := False;

    END;

  { *************** }
  { Jump with Queen }
  { *************** }

  FUNCTION JumpWithQueen( VAR Board     : BoardType;
                          VAR Token     : TokenType;
                              Player    : Boolean;
                          VAR Remaining : RemainingType) : Boolean;

    VAR

      T1,T2       : TokenType;
      OtherPlayer : ColorType;
      Answer      : Char;

    BEGIN

      T1 := Token;
      T2 := Token;

      DialogWindow;

      IF Player = RedPlayer THEN

        BEGIN

          OtherPlayer := Black;
          Write('PLAYER : RED');

        END

      ELSE

        BEGIN

          Writeln('PLAYER : BLACK');
          OtherPlayer := Red;

        END;

      Writeln;
      Writeln('1. Up Right');
      Writeln('2. Up Left');
      Writeln('3. Down Right');
      Writeln('4. Down Left');
      Writeln;
      Write  ('Your Choice? ');

      REPEAT

        Answer := ReadKey;

      UNTIL Answer IN ['1'..'4'];

      CASE Answer OF

        '1' : BEGIN

                T1.X := T1.X + 1;
                T1.Y := T1.Y - 1;

                T2.X := T2.X + 2;
                T2.Y := T2.Y - 2;

              END;

        '2' : BEGIN

                T1.X := T1.X - 1;
                T1.Y := T1.Y - 1;

                T2.X := T2.X - 2;
                T2.Y := T2.Y - 2;

              END;

        '3' : BEGIN

                T1.X := T1.X + 1;
                T1.Y := T1.Y + 1;

                T2.X := T2.X + 2;
                T2.Y := T2.Y + 2;

              END;

        '4' : BEGIN

                T1.X := T1.X - 1;
                T1.Y := T1.Y + 1;

                T2.X := T2.X - 2;
                T2.Y := T2.Y + 2;

              END;

      END;

      IF ( (T1.X>0) AND (T1.X<9) AND (T1.Y>0) AND (T1.Y<9) ) AND
         ( (T2.X>0) AND (T2.X<9) AND (T2.Y>0) AND (T2.y<9) ) AND
         ( Board[T1.X,T1.Y].Color    = OtherPlayer         ) AND
         ( Board[T2.X,T2.Y].Contains = Nothing             ) THEN

        BEGIN

          IF Board[T1.X,T1.Y].Contains = Chip THEN

            Dec(Remaining[Not(Player)].Chips)

          ELSE

            Dec(Remaining[Not(Player)].Queens);

          Board[T1.X,T1.Y].Contains := Nothing;
          Board[T1.X,T1.Y].Color    := Neither;

          Board[T2.X,T2.Y].Contains := Queen;
          Board[T2.X,T2.Y].Color    := Board[Token.X,Token.Y].Color;

          Board[Token.X,Token.Y].Contains := Nothing;
          Board[Token.X,Token.Y].Color    := Neither;

          Token := T2;

          JumpWithQueen := True;

        END

      ELSE

        JumpWithQueen := False;

    END;

  { *********************** }
  { Jump with Chip or Queen }
  { *********************** }

  FUNCTION JumpWithChipOrQueen( VAR Board     : BoardType;
                                VAR Token     : TokenType;
                                    Player    : Boolean;
                                VAR Remaining : RemainingType) : Boolean;

    BEGIN

      IF Board[Token.X,Token.Y].Contains = Chip THEN

        JumpWithChipOrQueen := JumpWithChip(Board,Token,Player,Remaining)

      ELSE

        JumpWithChipOrQueen := JumpWithQueen(Board,Token,Player,Remaining);

   END;

  { *********** }
  { Make a Turn }
  { *********** }

  FUNCTION MakeATurn( VAR Board         : BoardType;
                          CurrentPlayer : Boolean;
                      VAR Remaining     : RemainingType) : GameResultType;
    VAR

      Legal,
      JumpAgain,
      NoTokenChosen,
      MultipleJump  : Boolean;
      Answer        : Char;
      Token         : TokenType;

    BEGIN

      DialogWindow;

      Legal         := False;
      NoTokenChosen := True;

      MakeATurn     := KeepPlaying;

      Token.X       := 2;
      Token.Y       := 2;

      REPEAT

        DialogWindow;

        ClrScr;

        IF CurrentPlayer = RedPlayer THEN

          Writeln('PLAYER : RED')

        ELSE

          Writeln('PLAYER : BLACK');

        Writeln;

        Writeln('1. Move');
        Writeln('2. Jump');
        Writeln('3. Surrender');
        Writeln('4. Tie');
        Writeln('5. See Instructions');
        Writeln;
        Write  ('Choose Option : ');

        REPEAT

          Answer := ReadKey;

        UNTIL Answer IN ['1'..'5'];

        Write(Answer);

        CASE Answer OF

          '1' : BEGIN { Move }

                  IF NoTokenChosen THEN

                    BEGIN

                      ChooseChipOrQueen(Board, Token, CurrentPlayer);
                      DisplayBoard(Board,Token);
                      NoTokenChosen := False;

                    END;

                  Legal := MoveChipOrQueen( Board,
                                            Token,
                                            CurrentPlayer,
                                            Remaining);

                  MakeATurn := KeepPlaying;

                END;

          '2' : BEGIN { Jump }

                  IF NoTokenChosen THEN

                    BEGIN

                      ChooseChipOrQueen(Board, Token, CurrentPlayer);
                      DisplayBoard(Board,Token);
                      NoTokenChosen := False;

                    END;

                  MultipleJump := False;

                  JumpAgain := False;

                  REPEAT

                    Legal := JumpWithChipOrQueen( Board,
                                                  Token,
                                                  CurrentPlayer,
                                                  Remaining);

                    DisplayBoard(Board,Token);

                    IF Legal THEN

                      BEGIN

                        IF GameIsOver(Remaining) THEN

                          IF CurrentPlayer=RedPlayer THEN

                            MakeATurn := RedWins

                          ELSE

                            MakeATurn := BlackWins

                        ELSE

                          BEGIN

                            DialogWindow;

                            IF CurrentPlayer=RedPlayer THEN

                              Writeln('PLAYER : RED')

                            ELSE

                              Writeln('PLAYER : BLACK');

                            Writeln;
                            Write('Jump Again? (Y/N) ');

                            REPEAT

                              Answer := UpCase(ReadKey);

                            UNTIL Answer IN ['Y','N'];

                            JumpAgain := Answer = 'Y';

                            IF JumpAgain THEN

                            MultipleJump := True;

                          END

                      END

                    ELSE

                      JumpAgain := False;

                  UNTIL Not(JumpAgain);

                  IF MultipleJump THEN Legal := True;

                END;

          '3' : BEGIN { Surrender }

                  DialogWindow;

                  IF CurrentPlayer=RedPlayer THEN

                    BEGIN

                      MakeATurn := BlackWins;
                      Writeln('PLAYER : RED');

                    END

                  ELSE

                    BEGIN

                      MakeATurn := RedWins;
                      Writeln('PLAYER : BLACK');

                    END;

                  Writeln;
                  Write('Are you sure? (Y/N) ');

                  REPEAT

                    Answer := UpCase(ReadKey);

                  UNTIL Answer IN ['Y','N'];

                  IF Answer = 'Y' THEN

                    Legal := True

                  ELSE

                    MakeATurn := KeepPlaying;

                END;

          '4' : BEGIN { Tie }

                  ClrScr;

                  Writeln('  Is there a mutual');
                  Write  ('agreement? ');

                  REPEAT

                    Answer := UpCase(ReadKey);

                  UNTIL Answer IN ['Y','N'];

                  IF Answer='Y' THEN

                    BEGIN

                      Legal     := True;
                      MakeATurn := Tie;

                    END

                  ELSE

                    Legal := False;

                END;

          '5' : BEGIN

                  TextColor(Crt.White);
                  TextBackground(Crt.Black);
                  WholeScreen;
                  DisplayInstructions;
                  DisplayBoard(Board,Token);
                  DialogWindow;

                END;

        END;

      UNTIL Legal;

      WholeScreen;

    END;

  { ********* }
  { Play Game }
  { ********* }

  PROCEDURE PlayGame(VAR Stat : StatType);

    VAR

      Board         : BoardType;
      GameNotOver   : Boolean;
      Remaining     : RemainingType;
      GameResult    : GameResultType;
      CurrentPlayer : Boolean;
      Ch            : Char;
      Token         : TokenType;

    BEGIN

      InitBoard(Board,Remaining);

      GameNotOver   := True;
      CurrentPlayer := RedPlayer;

      Token.X       := 2;
      Token.Y       := 2;

      REPEAT

        DisplayBoard(Board,Token);

        TextColor(Crt.White);
        TextBackground(Crt.Black);

        GameResult := MakeATurn(Board,CurrentPlayer,Remaining);

        CurrentPlayer := Not(CurrentPlayer);

      UNTIL GameResult <> KeepPlaying;

      TextColor(Crt.White);
      TextBackground(Crt.Black);

      ClrScr;

      CASE GameResult OF

        RedWins   : BEGIN

                      Write('The red player won. ');
                      Ch := ReadKey;

                      Inc(Stat.GamesPlayed);
                      Inc(Stat.RedWon);

                    END;

        BlackWins : BEGIN

                      Write('The Black player won. ');
                      Ch := ReadKey;

                      Inc(Stat.GamesPlayed);
                      Inc(Stat.BlackWon);

                    END;

        Tie       : BEGIN

                      Write('There was a tie. ');
                      Ch := ReadKey;

                      Inc(Stat.GamesPlayed);
                      Inc(Stat.Ties);

                    END;

      END;

    END;

  { ********** }
  { Play Again }
  { ********** }

  FUNCTION PlayAgain(VAR Stats : StatType) : Boolean;

    VAR

      Ch : Char;

    BEGIN

      PlayGame(Stats);
      TextColor(Crt.White);
      TextBackground(Crt.Black);
      ClrScr;
      Write('Do you want to play again? (Y/N) ');

      REPEAT

        Ch := UpCase(ReadKey);

      UNTIL Ch IN ['Y','N'];

      PlayAgain := Ch = 'Y';

    END;

  { ***************** }
  { Report Statistics }
  { ***************** }

  PROCEDURE ReportStatistics(Stat : StatType);

    VAR

      Ch : Char;

    BEGIN

      ClrScr;
      Writeln('Games Played     : ',Stat.GamesPlayed);
      Writeln('Red won          : ',Stat.RedWon);
      Writeln('Black won        : ',Stat.BlackWon);
      Writeln('Ties             : ',Stat.Ties);

      Ch := ReadKey;

    END;


  { ************ }
  { Main Program }
  { ************ }

  BEGIN

    TextColor(Crt.White);
    TextBackground(Crt.Black);

    ClrScr;
    Write('Hi! Do you want Instructions? (Y/N) ');

    REPEAT

      Ch := UpCase(ReadKey);

    UNTIL Ch IN ['Y','N'];

    IF Ch = 'Y' THEN

      DisplayInstructions;

    WITH Stats DO

      BEGIN

        GamesPlayed := 0;
        RedWon      := 0;
        BlackWon    := 0;
        Ties        := 0;

      END;

    WHILE  PlayAgain(Stats) DO

      { Nothing };

    ReportStatistics(Stats);

  END.
