;Programm: Mousboot.asm
;Funktion: Mausgesteuerter Programmabbruch
;Sprache: MASM ab 5.0 , TASM ab 1.0
;Autor: Holger Genz
;(c)1991 DMV Widurch GmBH & Co.KG
; Konstantendeklarationen
CR      equ 13
LF      equ 10
lpress  equ 0010b ;linke Maustaste
rpress  equ 1000b ;rechte Maustaste
actMask equ lpress or rpress ;Maske
code    segment
        org 100h
assume  CS:code,DS:code,ES:nothing
; Installationsroutine
mouseboot: jmp install
; Aktionsroutine wird vom Maustreiber
; aufgerufen, wenn eine der in actMask
; spezifizerten Aktionen erfolgt ist.
; AX enthlt dann die Ereignismaske mit
; der tatschlich erfolgten Aktion
mousehole: test AX,lpress ;linke Maustaste ?
           jnz pend  ;ja: beenden
           test AX,rpress ;rechte Maustaste?
           jnz cboot ;ja: Systemstart
           retf ;zur Sicherheit
; Versuche das laufende Programm zu beenden
pend: call reInit
      mov AX,04c77h ;-> Errorlevel 77h
      int 21h
; Reinitialisiere den Maustreiber und
; setze die Adresse der Aktionsroutine
reInit: xor AX,AX
        int 33h
setRoutine: mov DX,CS
            mov ES,DX ; Aktroutine: ES,DX
            mov DX,Offset mousehole
            mov CX,actMask ; Aktionsmaske
            mov AX,12
            int 33h
            ret
; fhre Systemstart durch
cboot: mov AX,40h
       mov DS,AX
       mov AX,1234h
       mov BX,72h
       mov [BX],AX
       jmp CS:bootaddr
; residente Daten
bootaddr dd 0ffff0000h ; Sprung -> Systemstart
; Installationsroutine
install:  mov DX,CS ; COM -> also DS:=CS
          mov DS,DX
; berprfe Existenz eines Maustreibers
          xor AX,AX
          int 33h
          inc AX
          jnz errout
; Maustreiber-Aktionsroutine installieren
; wie im residenten Teil
          call SetRoutine
; Installationsmeldung ausgeben
          mov DX, Offset MsgGreet
          mov AH,9
          int 21h
; residenten Programmteil reservieren
; und zurck zum DOS
          mov DX,Offset install
          int 27h
; Fehlermeldung ausgeben
errout:   mov DX, Offset MsgNoMouse
          mov AH,9
          int 21h
; Programm ohne Installation verlassen
          mov AX,4c04h
          int 21h
; nichtresidente Daten
MsgGreet db CR,LF,'mouseboot v 1.0,   (C) 1991 DOS International',CF,LF,'$'
MsgNoMouse db CR,LF,'mouseboot nicht installiert --- kein Maustreiber gefunden',CR,LF,'$'
; Ende des Codesegments
code ends
     end mouseboot


